/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.api.entity.model;

import com.ovopark.paas.api.entity.dao.TraingingDataSet;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.Date;
import javax.validation.constraints.NotBlank;
import javax.validation.constraints.NotNull;
import org.apache.commons.lang3.ObjectUtils;
import org.hibernate.validator.constraints.Length;
import org.springframework.beans.BeanUtils;
import org.springframework.lang.NonNull;

public class TrainingDataSetModel {
    private Integer id;
    private Integer enterpriseId;
    @Length(max=10, message="\u6570\u636e\u96c6\u540d\u79f0\u6700\u591a10\u4e2a\u5b57\u7b26")
    @NotBlank(message="\u6570\u636e\u96c6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @Length(max=10, message="\u6570\u636e\u96c6\u540d\u79f0\u6700\u591a10\u4e2a\u5b57\u7b26") @NotBlank(message="\u6570\u636e\u96c6\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String dataSetName;
    @NotNull(message="\u6570\u636e\u96c6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u6570\u636e\u96c6\u7c7b\u578b\u4e0d\u80fd\u4e3a\u7a7a") Integer dataSetType;
    @Length(max=10, message="\u7248\u672c\u4fe1\u606f\u6700\u591a10\u4e2a\u5b57\u7b26")
    private @Length(max=10, message="\u7248\u672c\u4fe1\u606f\u6700\u591a10\u4e2a\u5b57\u7b26") String version;
    @NotNull(message="\u6807\u6ce8\u6240\u7528\u6a21\u7248\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a")
    private @NotNull(message="\u6807\u6ce8\u6240\u7528\u6a21\u7248\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a") Integer markTemplate;
    private Integer importStatus;
    private Integer pictureNum;
    private Double markPercentage;
    private Integer markNum;
    private String createBy;
    private Date createTime;
    private String modifyBy;
    private Date modifyTime;

    public static TrainingDataSetModel transFrom(@NonNull TraingingDataSet ds) {
        TrainingDataSetModel model = new TrainingDataSetModel();
        BeanUtils.copyProperties((Object)ds, (Object)model);
        if (ObjectUtils.allNotNull((Object[])new Object[]{ds.getMarkNum(), ds.getPictureNum()}) && ds.getPictureNum() > 0 && ds.getMarkNum() > 0) {
            model.setMarkPercentage(Double.valueOf(BigDecimal.valueOf(Double.valueOf(ds.getMarkNum().intValue()) / Double.valueOf(ds.getPictureNum().intValue())).setScale(2, RoundingMode.HALF_DOWN).multiply(BigDecimal.valueOf(100L)).toString()));
        }
        return model;
    }

    public Integer getId() {
        return this.id;
    }

    public Integer getEnterpriseId() {
        return this.enterpriseId;
    }

    public String getDataSetName() {
        return this.dataSetName;
    }

    public Integer getDataSetType() {
        return this.dataSetType;
    }

    public String getVersion() {
        return this.version;
    }

    public Integer getMarkTemplate() {
        return this.markTemplate;
    }

    public Integer getImportStatus() {
        return this.importStatus;
    }

    public Integer getPictureNum() {
        return this.pictureNum;
    }

    public Double getMarkPercentage() {
        return this.markPercentage;
    }

    public Integer getMarkNum() {
        return this.markNum;
    }

    public String getCreateBy() {
        return this.createBy;
    }

    public Date getCreateTime() {
        return this.createTime;
    }

    public String getModifyBy() {
        return this.modifyBy;
    }

    public Date getModifyTime() {
        return this.modifyTime;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public void setEnterpriseId(Integer enterpriseId) {
        this.enterpriseId = enterpriseId;
    }

    public void setDataSetName(String dataSetName) {
        this.dataSetName = dataSetName;
    }

    public void setDataSetType(Integer dataSetType) {
        this.dataSetType = dataSetType;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setMarkTemplate(Integer markTemplate) {
        this.markTemplate = markTemplate;
    }

    public void setImportStatus(Integer importStatus) {
        this.importStatus = importStatus;
    }

    public void setPictureNum(Integer pictureNum) {
        this.pictureNum = pictureNum;
    }

    public void setMarkPercentage(Double markPercentage) {
        this.markPercentage = markPercentage;
    }

    public void setMarkNum(Integer markNum) {
        this.markNum = markNum;
    }

    public void setCreateBy(String createBy) {
        this.createBy = createBy;
    }

    public void setCreateTime(Date createTime) {
        this.createTime = createTime;
    }

    public void setModifyBy(String modifyBy) {
        this.modifyBy = modifyBy;
    }

    public void setModifyTime(Date modifyTime) {
        this.modifyTime = modifyTime;
    }

    public String toString() {
        return "TrainingDataSetModel(id=" + this.getId() + ", enterpriseId=" + this.getEnterpriseId() + ", dataSetName=" + this.getDataSetName() + ", dataSetType=" + this.getDataSetType() + ", version=" + this.getVersion() + ", markTemplate=" + this.getMarkTemplate() + ", importStatus=" + this.getImportStatus() + ", pictureNum=" + this.getPictureNum() + ", markPercentage=" + this.getMarkPercentage() + ", markNum=" + this.getMarkNum() + ", createBy=" + this.getCreateBy() + ", createTime=" + this.getCreateTime() + ", modifyBy=" + this.getModifyBy() + ", modifyTime=" + this.getModifyTime() + ")";
    }
}

