/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.api.exception;

import com.ovopark.paas.api.exception.OpenPaasErrorCode;
import org.apache.commons.lang3.StringUtils;

public class OpenPaasException
extends RuntimeException {
    private int errCode;
    private String errMsg;

    public OpenPaasException() {
    }

    public OpenPaasException(String message, Throwable cause) {
        super(message, cause);
        this.errMsg = message;
    }

    public OpenPaasException(String message) {
        super(message);
        this.errMsg = message;
    }

    public OpenPaasException(Throwable cause) {
        super(cause);
    }

    public OpenPaasException(int errCode, String errMsg) {
        super(errCode + ":" + errMsg);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public OpenPaasException(int errCode, String errMsg, Throwable cause) {
        super(errCode + ":" + errMsg, cause);
        this.errCode = errCode;
        this.errMsg = errMsg;
    }

    public OpenPaasException(OpenPaasErrorCode cloudWatchErrorCode, String errorMsg) {
        StringBuilder strBuilder = new StringBuilder();
        strBuilder.append(cloudWatchErrorCode.getErrorText());
        if (StringUtils.isNotEmpty((CharSequence)errorMsg)) {
            strBuilder.append(":").append(errorMsg);
        }
        this.errCode = cloudWatchErrorCode.getErrorCode();
        this.errMsg = strBuilder.toString();
    }

    public OpenPaasException(OpenPaasErrorCode cloudWatchErrorCode) {
        super(cloudWatchErrorCode.getErrorText());
        this.errCode = cloudWatchErrorCode.getErrorCode();
        this.errMsg = cloudWatchErrorCode.getErrorText();
    }

    public int getErrCode() {
        return this.errCode;
    }

    public String getErrMsg() {
        return this.errMsg;
    }
}

