/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.api.constant;

import org.apache.commons.lang3.StringUtils;

public enum DeployTypeEnum {
    CLOUD(1, "000", "\u4e91\u7aef", ""),
    A1(2, "100", "\u677f\u7aef-A1\u5e73\u53f0", "A1"),
    NVR(3, "200", "\u677f\u7aef-Dolphin1-A\u5e73\u53f0", "Dolphin1"),
    PC4i(4, "300", "\u677f\u7aef-PC4i\u5e73\u53f0", ""),
    PC8_B(5, "301", "\u677f\u7aef-PC8-B\u5e73\u53f0", ""),
    ROBOT(6, "800", "\u677f\u7aef-T1\u5e73\u53f0", "");

    private final Integer code;
    private final String algoCode;
    private final String name;
    private final String device;

    private DeployTypeEnum(Integer code, String algoCode, String name, String device) {
        this.code = code;
        this.algoCode = algoCode;
        this.name = name;
        this.device = device;
    }

    public Integer getCode() {
        return this.code;
    }

    public String getName() {
        return this.name;
    }

    public String getAlgoCode() {
        return this.algoCode;
    }

    public static String getName(Integer code) {
        if (code == null) {
            return null;
        }
        for (DeployTypeEnum deployTypeEnum : DeployTypeEnum.values()) {
            if (!deployTypeEnum.code.equals(code)) continue;
            return deployTypeEnum.getName();
        }
        return null;
    }

    public static String getNameByDevice(String device) {
        if (StringUtils.isBlank((CharSequence)device)) {
            return null;
        }
        for (DeployTypeEnum deployTypeEnum : DeployTypeEnum.values()) {
            if (!StringUtils.isNotEmpty((CharSequence)deployTypeEnum.device) || !device.contains(deployTypeEnum.device)) continue;
            return deployTypeEnum.getAlgoCode();
        }
        return null;
    }
}

