/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.api.entity.model;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.ovopark.paas.api.entity.dao.PaasCmsPermission;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import javax.validation.constraints.NotBlank;
import org.hibernate.validator.constraints.Length;

public class PermissionModel
implements Serializable {
    private Integer id;
    @Length(max=120, message="\u6743\u9650\u540d\u79f0\u6700\u591a120\u4e2a\u5b57\u7b26")
    @NotBlank(message="\u6743\u9650\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a")
    private @Length(max=120, message="\u6743\u9650\u540d\u79f0\u6700\u591a120\u4e2a\u5b57\u7b26") @NotBlank(message="\u6743\u9650\u540d\u79f0\u4e0d\u80fd\u4e3a\u7a7a") String permissionName;
    @NotBlank(message="\u6743\u9650URI\u4e0d\u80fd\u4e3a\u7a7a")
    @Length(max=120, message="\u6743\u9650URI\u6700\u591a120\u5b57\u7b26")
    private @NotBlank(message="\u6743\u9650URI\u4e0d\u80fd\u4e3a\u7a7a") @Length(max=120, message="\u6743\u9650URI\u6700\u591a120\u5b57\u7b26") String permissionOperateUri;
    private Integer parentPermissionId;
    private PermissionModel parent;
    private List<PermissionModel> children;
    private boolean selected;
    @JsonIgnore
    private Boolean hasDeleted;
    @JsonIgnore
    private List<PermissionModel> expandedChildren = new ArrayList<PermissionModel>();

    public Boolean getHasDeleted() {
        return this.hasDeleted;
    }

    public void setHasDeleted(Boolean hasDeleted) {
        this.hasDeleted = hasDeleted;
    }

    public Boolean hasChild() {
        return CollectionUtils.isNotEmpty(this.children) && this.children != null;
    }

    public List<PermissionModel> expand() {
        this.expandedChildren.clear();
        this.expandedChildren.add(this);
        this.expandChildren(this);
        return this.expandedChildren;
    }

    private void expandChildren(PermissionModel permissionModel) {
        if (Boolean.TRUE.equals(permissionModel.hasChild())) {
            permissionModel.getChildren().forEach(this::expandChildren);
            this.expandedChildren.addAll(permissionModel.getChildren());
        }
    }

    public void initChildren() {
        this.children = new ArrayList<PermissionModel>();
    }

    public boolean isSelected() {
        return this.selected;
    }

    public void setSelected(boolean selected) {
        this.selected = selected;
    }

    public void addChild(PermissionModel permissionModel) {
        if (this.children == null) {
            this.children = new ArrayList<PermissionModel>();
        }
        this.children.add(permissionModel);
    }

    public PermissionModel getParent() {
        return this.parent;
    }

    public void setParent(PermissionModel parent) {
        this.parent = parent;
    }

    public List<PermissionModel> getChildren() {
        return this.children;
    }

    public void setChildren(List<PermissionModel> children) {
        this.children = children;
    }

    public Integer getId() {
        return this.id;
    }

    public void setId(Integer id) {
        this.id = id;
    }

    public String getPermissionName() {
        return this.permissionName;
    }

    public void setPermissionName(String permissionName) {
        this.permissionName = permissionName;
    }

    public String getPermissionOperateUri() {
        return this.permissionOperateUri;
    }

    public void setPermissionOperateUri(String permissionOperateUri) {
        this.permissionOperateUri = permissionOperateUri;
    }

    public Integer getParentPermissionId() {
        return this.parentPermissionId;
    }

    public void setParentPermissionId(Integer parentPermissionId) {
        this.parentPermissionId = parentPermissionId;
    }

    public PaasCmsPermission transformToDao() {
        PaasCmsPermission paasCmsPermission = new PaasCmsPermission();
        paasCmsPermission.setId(this.getId());
        paasCmsPermission.setParentPermissionId(this.getParentPermissionId());
        paasCmsPermission.setPermissionName(this.getPermissionName());
        paasCmsPermission.setPermissionOperateUri(this.getPermissionOperateUri());
        return paasCmsPermission;
    }
}

