/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.api.common.builder.impl;

import com.ovopark.paas.api.common.builder.AlgoRightVersionChainBuilder;
import com.ovopark.paas.api.constant.AlgoTypeEnum;
import com.ovopark.paas.api.entity.vo.AiOpenVersionNewVersionVO;
import com.ovopark.paas.api.entity.vo.AlgoEnterpriseRightVO;
import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;

public class AlgoRightVersionChainProcessBuilder
extends AlgoRightVersionChainBuilder {
    @Override
    public AlgoRightVersionChainBuilder buildDefault(int num, int year) {
        this.rightVersionChain.setNum(num);
        this.rightVersionChain.setYears(year);
        this.rightVersionChain.setRowStatus(1);
        this.rightVersionChain.setStatus(1);
        return this;
    }

    @Override
    public AlgoRightVersionChainBuilder buildNewVersion(AiOpenVersionNewVersionVO newVersion) {
        this.rightVersionChain.setVersion(newVersion.getVersion());
        if (newVersion.getIsDevice().booleanValue()) {
            this.rightVersionChain.setAlgoType(AlgoTypeEnum.Hardware.getCode());
        } else {
            this.rightVersionChain.setAlgoType(AlgoTypeEnum.Soft.getCode());
        }
        this.rightVersionChain.setDeployType(newVersion.getDeployType());
        this.rightVersionChain.setChannel(newVersion.getChannel());
        this.rightVersionChain.setUpdateTime(newVersion.getDeployTime());
        return this;
    }

    @Override
    public AlgoRightVersionChainBuilder buildUser(OvoparkUserInfoEntity userInfo) {
        this.rightVersionChain.setUserId((long)userInfo.getId());
        this.rightVersionChain.setPhone(userInfo.getMobilePhone());
        this.rightVersionChain.setCreateBy(userInfo.getUserName());
        this.rightVersionChain.setUpdateBy(userInfo.getUserName());
        return this;
    }

    @Override
    public AlgoRightVersionChainBuilder buildConfig(AlgoEnterpriseRightVO algoEnterpriseRight, String topic) {
        this.rightVersionChain.setAiTopic(topic);
        this.rightVersionChain.setAlgoCode(algoEnterpriseRight.getAlgoCode());
        this.rightVersionChain.setEnterpriseId(algoEnterpriseRight.getEnterpriseId());
        return this;
    }
}

