/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.api.entity;

public class HttpResponseEntity<T> {
    private static final Integer SUCCESS_CODE = 0;
    private static final Integer COMMON_ERROR_CODE = 1;
    private int code;
    private String message;
    private T data;
    private Boolean isError;
    private String requestId;

    public int getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public T getData() {
        return this.data;
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof HttpResponseEntity)) {
            return false;
        }
        HttpResponseEntity other = (HttpResponseEntity)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getCode() != other.getCode()) {
            return false;
        }
        Boolean this$isError = this.getIsError();
        Boolean other$isError = other.getIsError();
        if (this$isError == null ? other$isError != null : !((Object)this$isError).equals(other$isError)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        return !(this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId));
    }

    protected boolean canEqual(Object other) {
        return other instanceof HttpResponseEntity;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getCode();
        Boolean $isError = this.getIsError();
        result = result * 59 + ($isError == null ? 43 : ((Object)$isError).hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        return result;
    }

    public String toString() {
        return "HttpResponseEntity(code=" + this.getCode() + ", message=" + this.getMessage() + ", data=" + this.getData() + ", isError=" + this.getIsError() + ", requestId=" + this.getRequestId() + ")";
    }

    public static final class Builder<T> {
        private int code;
        private String message;
        private String requestId;
        private Boolean isError;
        private T Data;

        private Builder() {
        }

        public static Builder call() {
            return new Builder();
        }

        public Builder<T> success() {
            this.code = SUCCESS_CODE;
            this.requestId = "";
            this.isError = Boolean.FALSE;
            this.message = "\u6210\u529f";
            this.Data = null;
            return this;
        }

        public Builder<T> success(T data) {
            this.code = SUCCESS_CODE;
            this.requestId = "";
            this.isError = Boolean.FALSE;
            this.message = "\u6210\u529f";
            this.Data = data;
            return this;
        }

        public Builder<T> error(String codename) {
            this.code = COMMON_ERROR_CODE;
            this.requestId = "";
            this.isError = Boolean.TRUE;
            this.message = codename;
            this.Data = null;
            return this;
        }

        public Builder<T> error(Integer errorCode, String codename) {
            this.code = errorCode;
            this.requestId = "";
            this.isError = Boolean.TRUE;
            this.message = codename;
            this.Data = null;
            return this;
        }

        public Builder<T> error(Integer errorCode, String codename, T data) {
            this.code = errorCode;
            this.requestId = "";
            this.isError = Boolean.TRUE;
            this.message = codename;
            this.Data = data;
            return this;
        }

        public HttpResponseEntity<T> build() {
            HttpResponseEntity<T> response = new HttpResponseEntity<T>();
            response.setCode(this.code);
            response.setMessage(this.message);
            response.setRequestId("");
            response.setIsError(this.isError);
            response.setData(this.Data);
            return response;
        }
    }
}

