/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.config;

import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;

public class RequestContext
extends ConcurrentHashMap<String, Object> {
    private static final String USER_INFO_KEY = "userInfo";
    private static final ThreadLocal<RequestContext> THREAD_LOCAL = ThreadLocal.withInitial(RequestContext::new);

    public static RequestContext getCurrentContext() {
        return THREAD_LOCAL.get();
    }

    public void unSet() {
        THREAD_LOCAL.remove();
    }

    public OvoparkUserInfoEntity getUserInfo() {
        Object obj = this.get(USER_INFO_KEY);
        if (Objects.nonNull(obj)) {
            return (OvoparkUserInfoEntity)obj;
        }
        return null;
    }

    public void setUserInfo(OvoparkUserInfoEntity userInfo) {
        if (userInfo != null) {
            this.put(USER_INFO_KEY, userInfo);
        }
    }

    public String getToken() {
        return this.get("token") + "";
    }

    public void setToken(String token) {
        this.put("token", token);
    }
}

