/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.service.impl;

import com.ovopark.open.feign.DeviceAlgoFeignClient;
import com.ovopark.open.paasclient.DeviceClient;
import com.ovopark.open.service.DeviceClientService;
import com.ovopark.paas.api.entity.DeviceRequest;
import com.ovopark.paas.api.entity.DeviceRvcInfoEntity;
import com.ovopark.paas.api.entity.HttpResponseEntity;
import com.ovopark.paas.api.entity.RealGG;
import com.ovopark.paas.api.entity.Response;
import com.ovopark.paas.api.entity.bo.OutLineDeviceBo;
import com.ovopark.paas.api.entity.bo.SetFlipDirectionBo;
import com.ovopark.paas.api.entity.dto.DeviceStatusDTO;
import com.ovopark.paas.api.entity.vo.DeviceStatusPojo;
import com.ovopark.paas.api.entity.vo.Fr3GetFlipStatusVo;
import com.ovopark.paas.api.entity.vo.GetDeviceVideoRvcVo;
import com.ovopark.paas.api.entity.vo.GetFlipDirectionInfoVo;
import com.ovopark.paas.api.entity.vo.NewGetDeviceListVo;
import com.ovopark.paas.api.entity.vo.SearchDeviceVo;
import com.ovopark.paas.core.service.DeviceService;
import com.ovopark.paas.core.utils.CommonUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;

@Service
public class DeviceServiceImpl
implements DeviceService {
    @Autowired(required=false)
    private DeviceClient deviceClient;
    @Autowired
    private DeviceAlgoFeignClient deviceAlgoFeignClient;
    @Autowired
    private DeviceClientService deviceClientService;
    @Autowired
    private CommonUtil commonUtil;

    @Override
    public Response<String> getDepartName(DeviceRequest deviceRequest, String ticket) {
        Integer groupId = this.commonUtil.getGroupId(ticket, null, null);
        String response = this.deviceClient.getDepartName(ticket, "G_" + groupId, deviceRequest.getDeptName());
        if (response == null) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u83b7\u53d6\u95e8\u5e97\u4fe1\u606f\u5931\u8d25").build();
        }
        return Response.Builder.call().success(response).build();
    }

    @Override
    public Response<Map> getMaxAndCurrentDeviceCount(DeviceRequest deviceRequest, String ticket) {
        List<DeviceStatusPojo> deviceListVo = this.getDeviceListVoByDepId(deviceRequest, ticket);
        HashMap<String, Number> map = new HashMap<String, Number>(16);
        if (!CollectionUtils.isEmpty(deviceListVo)) {
            map.put("ipcCurrentCount", deviceListVo.stream().filter(deviceStatusPojo -> deviceStatusPojo.getOnline() == 1).count());
            map.put("ipcCountLimit", deviceListVo.size());
        }
        return Response.Builder.call().success(map).build();
    }

    @Override
    public Response<SearchDeviceVo> searchDevice(DeviceRequest deviceRequest, String ticket) {
        HttpResponseEntity response = this.deviceAlgoFeignClient.searchDevice(ticket, deviceRequest.getMac());
        if (response == null || response.getCode() != 0 || response.getData() == null) {
            String msg = response != null && StringUtils.isNotEmpty((CharSequence)response.getMessage()) ? response.getMessage() : "\u67e5\u8be2\u8bbe\u5907\u5931\u8d25";
            return Response.Builder.call().error(Integer.valueOf(1003), msg).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    public Response<Object> outLineDevice(OutLineDeviceBo deviceRequest, String ticket) {
        HttpResponseEntity result = this.deviceAlgoFeignClient.outLineDevice(ticket, deviceRequest);
        if (result == null || result.getCode() != 0) {
            String msg = result != null && StringUtils.isNotEmpty((CharSequence)result.getMessage()) ? result.getMessage() : "\u8bbe\u5907\u9000\u7f51\u5931\u8d25";
            return Response.Builder.call().error(Integer.valueOf(1003), msg).build();
        }
        return Response.Builder.call().success((String)result.getData()).build();
    }

    @Override
    public Response<Object> registDevice(DeviceRequest deviceRequest, String ticket) {
        HttpResponseEntity response = this.deviceAlgoFeignClient.registDevice(ticket, deviceRequest);
        if (response == null || response.getCode() != 0) {
            String msg = response != null && StringUtils.isNotEmpty((CharSequence)response.getMessage()) ? response.getMessage() : "\u8bbe\u5907\u5165\u7f51\u5931\u8d25";
            return Response.Builder.call().error(Integer.valueOf(1003), msg).build();
        }
        return Response.Builder.call().success((String)response.getData()).build();
    }

    private List<DeviceStatusPojo> getDeviceListVoByDepId(DeviceRequest deviceRequest, String ticket) {
        RealGG response = this.deviceAlgoFeignClient.newGetDeviceList(ticket, deviceRequest.getDepId(), Integer.valueOf(0), Integer.valueOf(0));
        if (response == null || response.getData() == null) {
            return new ArrayList<DeviceStatusPojo>();
        }
        return ((NewGetDeviceListVo)response.getData()).getData();
    }

    @Override
    public Response<GetFlipDirectionInfoVo> getFlipDirection(String token, Integer deviceStatusId) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return Response.Builder.call().error(Integer.valueOf(1001), "\u83b7\u53d6token\u5931\u8d25").build();
        }
        if (deviceStatusId == null) {
            return Response.Builder.call().error(Integer.valueOf(1002), "\u8bf7\u786e\u8ba4\u9700\u8981\u8bbe\u7f6e\u7684\u8bbe\u5907\u4fe1\u606f").build();
        }
        HttpResponseEntity deviceInfo = this.deviceAlgoFeignClient.findById(deviceStatusId);
        if (deviceInfo == null || deviceInfo.getCode() != 0 || deviceInfo.getData() == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u83b7\u53d6\u8bbe\u5907\u578b\u53f7\u5931\u8d25").build();
        }
        DeviceStatusDTO device = (DeviceStatusDTO)deviceInfo.getData();
        GetFlipDirectionInfoVo response = new GetFlipDirectionInfoVo();
        if (device.getDeviceType().equals("Dolphin1-A")) {
            HttpResponseEntity result = this.deviceClientService.getFlipDirection(token, deviceStatusId);
            if (result == null || result.getCode() != 0 || result.getData() == null) {
                return Response.Builder.call().error(Integer.valueOf(1004), result.getMessage()).build();
            }
            response.setDirection((Integer)result.getData());
        } else {
            HttpResponseEntity result = this.deviceAlgoFeignClient.fr3GetFlipStatus(token, deviceStatusId);
            if (result == null || result.getCode() != 0 || result.getData() == null) {
                return Response.Builder.call().error(Integer.valueOf(1005), result.getMessage()).build();
            }
            response.setFlipStatus(((Fr3GetFlipStatusVo)result.getData()).getFlipStatus());
        }
        return Response.Builder.call().success((Object)response).build();
    }

    @Override
    public Response setFlipDirection(String token, SetFlipDirectionBo request) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return Response.Builder.call().error(Integer.valueOf(1001), "\u83b7\u53d6token\u5931\u8d25").build();
        }
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), "\u83b7\u53d6token\u5931\u8d25").build();
        }
        if (request.getDeviceStatusId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1002), "\u8bf7\u786e\u8ba4\u9700\u8981\u8bbe\u7f6e\u7684\u8bbe\u5907\u4fe1\u606f").build();
        }
        if (request.getDirection() == null && request.getFlipStatus() == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u8bf7\u786e\u8ba4\u9700\u8981\u8bbe\u7f6e\u7684\u753b\u9762\u7ffb\u8f6c\u72b6\u6001").build();
        }
        HttpResponseEntity deviceInfo = this.deviceAlgoFeignClient.findById(request.getDeviceStatusId());
        if (deviceInfo == null || deviceInfo.getCode() != 0 || deviceInfo.getData() == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u83b7\u53d6\u8bbe\u5907\u578b\u53f7\u5931\u8d25").build();
        }
        DeviceStatusDTO device = (DeviceStatusDTO)deviceInfo.getData();
        if (device.getDeviceType().equals("Dolphin1-A")) {
            HttpResponseEntity result = this.deviceClientService.setFlipDirection(token, request.getDeviceStatusId(), request.getDirection());
            if (result == null || result.getCode() != 0) {
                return Response.Builder.call().error(Integer.valueOf(1004), "\u8bbe\u7f6e\u753b\u9762\u7ffb\u8f6c\u72b6\u6001\u5931\u8d25").build();
            }
        } else {
            Fr3GetFlipStatusVo param = new Fr3GetFlipStatusVo();
            param.setDeviceStatusId(request.getDeviceStatusId());
            param.setFlipStatus(request.getFlipStatus());
            HttpResponseEntity result = this.deviceAlgoFeignClient.fr3SetFlipStatus(token, param);
            if (result == null || result.getCode() != 0) {
                return Response.Builder.call().error(Integer.valueOf(1004), "\u8bbe\u7f6e\u753b\u9762\u7ffb\u8f6c\u72b6\u6001\u5931\u8d25").build();
            }
        }
        return Response.Builder.call().success().build();
    }

    @Override
    public Response<GetDeviceVideoRvcVo> getDeviceVideoRvc(String token, Integer devicesVideoId) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return Response.Builder.call().error(Integer.valueOf(1001), "\u83b7\u53d6token\u5931\u8d25").build();
        }
        if (devicesVideoId == null) {
            return Response.Builder.call().error(Integer.valueOf(1002), "\u7f3a\u5c11\u89c6\u9891id").build();
        }
        HttpResponseEntity response = this.deviceAlgoFeignClient.getRvc(token, devicesVideoId);
        if (response == null || response.getCode() != 0 || response.getData() == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u83b7\u53d6\u5b9e\u65f6\u89c6\u9891\u4fe1\u606f\u5931\u8d25").build();
        }
        GetDeviceVideoRvcVo result = new GetDeviceVideoRvcVo();
        result.setSupportFlip(((DeviceRvcInfoEntity)response.getData()).getSupportFlip());
        return Response.Builder.call().success((Object)result).build();
    }
}

