/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.ovopark.open.feign.DeviceAlgoFeignClient;
import com.ovopark.open.paasclient.DeviceAlgoClient;
import com.ovopark.open.paasclient.DeviceClient;
import com.ovopark.open.paasclient.WdzWechatClient;
import com.ovopark.open.service.DeviceClientService;
import com.ovopark.paas.api.constant.AlgoTypeEnum;
import com.ovopark.paas.api.constant.CheckTypeEnum;
import com.ovopark.paas.api.constant.ModelTypeEnum;
import com.ovopark.paas.api.constant.RowStatusEnum;
import com.ovopark.paas.api.entity.AlgoDetailConfigsEntity;
import com.ovopark.paas.api.entity.AlgoStatusEntity;
import com.ovopark.paas.api.entity.DeviceAlgoConfigEntity;
import com.ovopark.paas.api.entity.DeviceAlgoStatusEntity;
import com.ovopark.paas.api.entity.HttpResponseEntity;
import com.ovopark.paas.api.entity.ModelDetailEntity;
import com.ovopark.paas.api.entity.ModelVersionDetailEntity;
import com.ovopark.paas.api.entity.RealGG;
import com.ovopark.paas.api.entity.Response;
import com.ovopark.paas.api.entity.bo.GetDepartmentListByAlgoBo;
import com.ovopark.paas.api.entity.bo.GetDepartmentListByDeviceStatusIdsBo;
import com.ovopark.paas.api.entity.bo.NewGetDeviceByMacBo;
import com.ovopark.paas.api.entity.bo.NewGetDeviceListBo;
import com.ovopark.paas.api.entity.bo.SetAlgoAlgoActivBo;
import com.ovopark.paas.api.entity.bo.SetAlgoDetailConfigEntityBo;
import com.ovopark.paas.api.entity.bo.SetAlgoListBo;
import com.ovopark.paas.api.entity.bo.SwitchingDeviceAlgoStatusBo;
import com.ovopark.paas.api.entity.bo.UpgradeDeviceVo;
import com.ovopark.paas.api.entity.dao.AlgoVersionInfoDao;
import com.ovopark.paas.api.entity.dao.DeviceAlgoRelationInfoDao;
import com.ovopark.paas.api.entity.dao.UpgradeRecordDao;
import com.ovopark.paas.api.entity.model.AlgoCodeModel;
import com.ovopark.paas.api.entity.model.GetDeviceAlgoStatusFromDevModel;
import com.ovopark.paas.api.entity.query.SnapshotAlgoQuery;
import com.ovopark.paas.api.entity.query.SnapshotAlgoQueryBatch;
import com.ovopark.paas.api.entity.vo.AlgoListEntity;
import com.ovopark.paas.api.entity.vo.DepartmentsInfoVo;
import com.ovopark.paas.api.entity.vo.DeviceStatusInfoEntity;
import com.ovopark.paas.api.entity.vo.DeviceStatusPojo;
import com.ovopark.paas.api.entity.vo.GetAlgoAlgoConfigVo;
import com.ovopark.paas.api.entity.vo.GetDepartmentListByDeviceStatusIdsVo;
import com.ovopark.paas.api.entity.vo.GetDepartmentsVo;
import com.ovopark.paas.api.entity.vo.GetEnterpriseListVo;
import com.ovopark.paas.api.entity.vo.GetMyInfoVo;
import com.ovopark.paas.api.entity.vo.GetSelectDepByUserIdVo;
import com.ovopark.paas.api.entity.vo.NewGetDeviceListVo;
import com.ovopark.paas.api.entity.vo.NewGetMyInfoVo;
import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import com.ovopark.paas.api.entity.vo.SetAlgoDetailConfigVo;
import com.ovopark.paas.api.exception.OpenPaasException;
import com.ovopark.paas.core.config.RequestContext;
import com.ovopark.paas.core.service.CommonClientService;
import com.ovopark.paas.core.service.NewDeviceService;
import com.ovopark.paas.core.utils.CommonUtil;
import com.ovopark.paas.core.utils.MessageUtils;
import com.ovopark.paas.core.utils.PageUtils;
import com.ovopark.paas.repository.paas.mapper.AlgoVersionInfoMapper;
import com.ovopark.paas.repository.paas.mapper.DeviceAlgoRelationInfoMapper;
import com.ovopark.paas.repository.paas.mapper.UpgradeRecordMapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class NewDeviceServiceImpl
implements NewDeviceService {
    private static final Logger logger = LoggerFactory.getLogger(NewDeviceServiceImpl.class);
    @Autowired
    private DeviceClientService deviceClientService;
    @Autowired
    private CommonUtil commonUtil;
    @Autowired(required=false)
    private WdzWechatClient wdzWechatClient;
    @Autowired(required=false)
    private DeviceAlgoRelationInfoMapper deviceAlgoRelationInfoMapper;
    @Autowired
    private CommonClientService commonClientService;
    @Autowired(required=false)
    private DeviceClient deviceClient;
    @Autowired(required=false)
    private UpgradeRecordMapper upgradeRecord;
    @Autowired(required=false)
    private AlgoVersionInfoMapper algoVersionInfoMapper;
    @Autowired(required=false)
    private DeviceAlgoClient deviceAlgoClient;
    @Autowired
    private DeviceAlgoFeignClient deviceAlgoFeignClient;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public Response<NewGetMyInfoVo> getMyInfo(String authorization) {
        RealGG response = this.deviceClientService.getMyInfo(authorization);
        if (response == null || response.getCode() != 0 || response.getData() == null || ((GetMyInfoVo)response.getData()).getData() == null) {
            String msg = response != null && StringUtils.isNotEmpty((CharSequence)response.getCodename()) ? response.getCodename() : "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55";
            return Response.Builder.call().error(Integer.valueOf(1002), msg).build();
        }
        GetMyInfoVo userInfo = (GetMyInfoVo)response.getData();
        NewGetMyInfoVo result = new NewGetMyInfoVo();
        result.setIsSuper(userInfo.getIsSuper());
        result.setEmail(userInfo.getData().getEmail());
        result.setGroupId(userInfo.getData().getGroupId());
        result.setGroupName(userInfo.getData().getGroupName());
        result.setMobilePhone(userInfo.getData().getMobilePhone());
        result.setNationalCode(userInfo.getData().getNationalCode());
        result.setShowName(userInfo.getData().getShowName());
        result.setUserName(userInfo.getData().getUserName());
        result.setUserId(userInfo.getData().getId());
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<List<GetEnterpriseListVo>> getEnterpriseList(String ticket) {
        RealGG response = this.deviceClient.getEnterpriseList(ticket);
        if (response == null || response.getCode() != 0 || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            String msg = response != null && StringUtils.isNotEmpty((CharSequence)response.getCodename()) ? response.getCodename() : "\u83b7\u53d6\u4f01\u4e1a\u4fe1\u606f\u5931\u8d25\uff01";
            return Response.Builder.call().error(Integer.valueOf(1002), msg).build();
        }
        List list = (List)response.getData();
        return Response.Builder.call().success((Object)list).build();
    }

    @Override
    public Response<GetDepartmentsVo> getDepartments(String ticket, Integer enterpriseId, String depName) {
        OvoparkUserInfoEntity userInfo = this.commonUtil.getUserInfo(ticket);
        if (userInfo == null) {
            return Response.Builder.call().error(Integer.valueOf(1002), "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25").build();
        }
        HttpResponseEntity response = this.deviceClient.getSelectDepByUserId(ticket, enterpriseId, userInfo.getId(), depName);
        if (response == null || response.getCode() != 0) {
            String msg = response != null && StringUtils.isNotEmpty((CharSequence)response.getMessage()) ? response.getMessage() : "\u83b7\u53d6\u95e8\u5e97\u5931\u8d25";
            return Response.Builder.call().error(Integer.valueOf(1002), msg).build();
        }
        GetDepartmentsVo result = new GetDepartmentsVo();
        if (CollectionUtils.isNotEmpty((Collection)((Collection)response.getData()))) {
            ArrayList<DepartmentsInfoVo> list = new ArrayList<DepartmentsInfoVo>();
            DepartmentsInfoVo model = new DepartmentsInfoVo();
            for (GetSelectDepByUserIdVo item : (List)response.getData()) {
                model = new DepartmentsInfoVo();
                model.setId(item.getId());
                model.setName(item.getName());
                list.add(model);
            }
            result.setRows(list);
        }
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<Map> newGetDeviceList(String ticket, NewGetDeviceListBo request) {
        RealGG response = this.deviceClientService.newGetDeviceList(ticket, request.getDepId());
        if (response == null || response.getCode() != 0 || response.getData() == null) {
            String msg = response != null && StringUtils.isNotEmpty((CharSequence)response.getCodename()) ? response.getCodename() : "\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762";
            return Response.Builder.call().error(Integer.valueOf(1004), msg).build();
        }
        List<DeviceStatusPojo> list = new ArrayList<DeviceStatusPojo>();
        if (CollectionUtils.isEmpty((Collection)((NewGetDeviceListVo)response.getData()).getData())) {
            return Response.Builder.call().success().build();
        }
        Integer algoId = CollectionUtils.isNotEmpty((Collection)request.getAlgoIds()) ? (Integer)request.getAlgoIds().get(0) : null;
        Integer modelId = request.getModelId();
        List<String> algoCodeList = this.commonClientService.getAlgoCodeByOther(algoId, modelId);
        if (StringUtils.isNotEmpty((CharSequence)request.getAlgoCode())) {
            algoCodeList.add(request.getAlgoCode());
        }
        algoCodeList = algoCodeList.stream().filter(m -> !this.commonUtil.getMarkInfo((String)m).equals("000")).distinct().collect(Collectors.toList());
        for (DeviceStatusPojo item : ((NewGetDeviceListVo)response.getData()).getData()) {
            item.setParentFlag(Integer.valueOf(1));
            if (CollectionUtils.isNotEmpty((Collection)item.getDeviceStatusList())) {
                for (DeviceStatusPojo devInfo : item.getDeviceStatusList()) {
                    devInfo.setParentFlag(Integer.valueOf(0));
                }
            }
            char[] abilityArrays = item.getExtendCapacity().toCharArray();
            if (CollectionUtils.isNotEmpty((Collection)item.getDeviceStatusList()) && request.getIsLeveling() != null && request.getIsLeveling().compareTo(1) == 0 && (abilityArrays.length < 45 || Integer.valueOf(String.valueOf(abilityArrays[44])).compareTo(0) == 0)) {
                for (DeviceStatusPojo devInfo : item.getDeviceStatusList()) {
                    list.add(devInfo);
                }
                continue;
            }
            if (abilityArrays.length >= 45 && Integer.valueOf(String.valueOf(abilityArrays[44])).compareTo(1) == 0) {
                item.setDeviceStatusList(new ArrayList());
            }
            if (item.getLatestVersion().equals(item.getVersion())) {
                item.setNeedUpgrade(false);
            } else {
                item.setNeedUpgrade(true);
            }
            list.add(item);
        }
        list = this.getDevAlgoInfo(ticket, list, algoCodeList, request.getDeviceTypes());
        return Response.Builder.call().success((Object)PageUtils.getDeviceListPage(request.getPageNumber(), request.getPageSize(), list)).build();
    }

    @Override
    public Response<Map> newGetDeviceByMac(String ticket, NewGetDeviceByMacBo request) {
        RealGG response = this.deviceClientService.getDeviceByMac(ticket, request.getMac(), request.getParentFlag());
        if (response == null || response.getCode() != 0 || response.getData() == null) {
            String msg = response != null && StringUtils.isNotEmpty((CharSequence)response.getCodename()) ? response.getCodename() : "\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u5237\u65b0\u9875\u9762";
            return Response.Builder.call().error(Integer.valueOf(1004), msg).build();
        }
        List<DeviceStatusPojo> devList = Arrays.asList((DeviceStatusPojo)response.getData());
        devList = this.getDevAlgoInfo(ticket, devList, null, null);
        return Response.Builder.call().success((Object)PageUtils.getDeviceListPage(1, 10, devList)).build();
    }

    private List<DeviceStatusPojo> getDevAlgoInfo(String token, List<DeviceStatusPojo> list, List<String> algoCodes, List<String> deviceTypes) {
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<DeviceStatusPojo>();
        }
        List<Integer> ids = list.stream().map(m -> m.getId()).collect(Collectors.toList());
        List sonList = list.stream().filter(m -> CollectionUtils.isNotEmpty((Collection)m.getDeviceStatusList())).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(sonList)) {
            ArrayList newSonList = new ArrayList();
            for (DeviceStatusPojo devInfo : sonList) {
                newSonList.addAll(devInfo.getDeviceStatusList());
            }
            if (CollectionUtils.isNotEmpty(newSonList)) {
                List sonIds = newSonList.stream().map(m -> m.getId()).collect(Collectors.toList());
                ids.addAll(sonIds);
            }
        }
        LambdaQueryWrapper wapper = new LambdaQueryWrapper();
        wapper.in(DeviceAlgoRelationInfoDao::getDeviceId, ids);
        wapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)1);
        List allDevAlgoList = this.deviceAlgoRelationInfoMapper.selectList((Wrapper)wapper);
        ArrayList<ModelDetailEntity> modelHasBind = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)allDevAlgoList)) {
            SnapshotAlgoQueryBatch queryBatchList = new SnapshotAlgoQueryBatch();
            ArrayList<SnapshotAlgoQuery> algoQueryList = new ArrayList<SnapshotAlgoQuery>();
            for (DeviceAlgoRelationInfoDao deviceAlgoRelationInfoDao : allDevAlgoList) {
                SnapshotAlgoQuery query = new SnapshotAlgoQuery();
                query.setEnterpriseId(Long.valueOf(deviceAlgoRelationInfoDao.getGroupId().intValue()));
                query.setAlgoCode(this.commonUtil.getCodeInfo(deviceAlgoRelationInfoDao.getAlgoCode()));
                algoQueryList.add(query);
            }
            queryBatchList.setList(algoQueryList);
            modelHasBind = this.commonClientService.getModelDetailByAlgoCode(queryBatchList);
        }
        List<Object> deviceModelSupportList = new ArrayList();
        deviceModelSupportList = ids.size() > 1 ? this.commonClientService.getDeviceAlgoFromDMS(token, ids) : this.commonClientService.getDeviceAlgoStatusFromDev(token, ids);
        ArrayList<DeviceStatusPojo> result = new ArrayList<DeviceStatusPojo>();
        for (DeviceStatusPojo item : list) {
            if (CollectionUtils.isNotEmpty(algoCodes)) {
                List supportAlgoList = deviceModelSupportList.stream().filter(m -> m.getDeviceStatusId().compareTo(item.getId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(supportAlgoList)) continue;
                boolean flag = false;
                GetDeviceAlgoStatusFromDevModel supportAlgo = (GetDeviceAlgoStatusFromDevModel)supportAlgoList.get(0);
                if (CollectionUtils.isNotEmpty((Collection)supportAlgo.getAlgoStatusList())) {
                    List codes = supportAlgo.getAlgoStatusList().stream().map(m -> m.getAlgoCode()).collect(Collectors.toList());
                    codes.retainAll(algoCodes);
                    if (CollectionUtils.isNotEmpty(codes)) {
                        flag = true;
                    }
                }
                if (!flag) continue;
            }
            if (CollectionUtils.isNotEmpty(deviceTypes) && !deviceTypes.contains(item.getDeviceType())) continue;
            this.getDeviceAlgoDetail(item, allDevAlgoList, modelHasBind, deviceModelSupportList);
            if (CollectionUtils.isEmpty((Collection)item.getDeviceStatusList())) {
                result.add(item);
                continue;
            }
            for (DeviceStatusPojo devInfo : item.getDeviceStatusList()) {
                this.getDeviceAlgoDetail(devInfo, allDevAlgoList, modelHasBind, deviceModelSupportList);
            }
            result.add(item);
        }
        return result;
    }

    private void getDeviceAlgoDetail(DeviceStatusPojo deviceDetail, List<DeviceAlgoRelationInfoDao> allDevAlgoList, List<ModelDetailEntity> modelList, List<GetDeviceAlgoStatusFromDevModel> deviceModelSupportList) {
        deviceDetail.setEndInfo("\u6c38\u4e45");
        deviceDetail.setBindCount(Integer.valueOf(0));
        ArrayList<AlgoListEntity> resultAlgoListVo = new ArrayList<AlgoListEntity>();
        if (CollectionUtils.isEmpty(allDevAlgoList)) {
            deviceDetail.setAlgoList(resultAlgoListVo);
            return;
        }
        List devAlgoList = allDevAlgoList.stream().filter(m -> m.getDeviceId().compareTo(deviceDetail.getId()) == 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(devAlgoList)) {
            deviceDetail.setAlgoList(resultAlgoListVo);
            return;
        }
        for (DeviceAlgoRelationInfoDao devAlgoInfo : devAlgoList) {
            if (CollectionUtils.isEmpty(modelList)) continue;
            String algoCode = devAlgoInfo.getAlgoCode();
            if (StringUtils.isNotEmpty((CharSequence)algoCode) && algoCode.length() > 21) {
                algoCode = algoCode.substring(0, 21);
            }
            String finalAlgoCode = algoCode;
            List details = modelList.stream().filter(m -> m.getAlgoCode().equals(finalAlgoCode)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(details)) continue;
            AlgoListEntity algoVo = new AlgoListEntity();
            ModelDetailEntity detail = (ModelDetailEntity)details.get(0);
            algoVo.setServiceId(devAlgoInfo.getId());
            algoVo.setAlgoCode(devAlgoInfo.getAlgoCode());
            algoVo.setIsPackage(devAlgoInfo.getOrderType());
            algoVo.setIsGoods(Integer.valueOf(detail.getModelType().compareTo(ModelTypeEnum.Special.getCode()) == 0 ? 0 : detail.getIsGoods()));
            algoVo.setAlgoPackageId(detail.getGoodsId());
            algoVo.setGoodsId(detail.getGoodsId());
            algoVo.setId(detail.getId());
            algoVo.setGoodsName(detail.getModelName());
            algoVo.setImg(detail.getImg());
            algoVo.setAlgoDescribe(detail.getRemark());
            algoVo.setRemark(detail.getRemark());
            algoVo.setAlgoVersion(devAlgoInfo.getAlgoVersion());
            algoVo.setSkuId(devAlgoInfo.getSkuId());
            algoVo.setAlgoName(detail.getModelEnglishName());
            algoVo.setNeedUpgrade(Boolean.valueOf(false));
            algoVo.setExpire(this.format.format(devAlgoInfo.getExpire()));
            algoVo.setEnable(Integer.valueOf(1));
            algoVo.setIsRun(Integer.valueOf(0));
            algoVo.setDownloadStatus(Integer.valueOf(0));
            algoVo.setLastAlgoVersion(this.commonClientService.getNewVersionByRight(devAlgoInfo.getGroupId(), finalAlgoCode));
            if (CollectionUtils.isNotEmpty((Collection)detail.getVersionList()) && CollectionUtils.isNotEmpty(deviceModelSupportList)) {
                List deviceSupportList = deviceModelSupportList.stream().filter(m -> m.getDeviceStatusId().compareTo(devAlgoInfo.getDeviceId()) == 0).collect(Collectors.toList());
                if (detail.getCheckType().compareTo(CheckTypeEnum.Hardware.getCode()) == 0 && CollectionUtils.isNotEmpty(deviceSupportList)) {
                    GetDeviceAlgoStatusFromDevModel deviceSupport = (GetDeviceAlgoStatusFromDevModel)deviceSupportList.get(0);
                    List modelSupportList = deviceSupport.getAlgoStatusList().stream().filter(m -> m.getAlgoCode().equals(finalAlgoCode)).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(modelSupportList)) {
                        if (((AlgoStatusEntity)modelSupportList.get(0)).getStatus() == null || ((AlgoStatusEntity)modelSupportList.get(0)).getDownloadStatus() == null) {
                            List statusList;
                            if (deviceDetail.getDeviceAlgorithmStatusList() != null && CollectionUtils.isNotEmpty(statusList = deviceDetail.getDeviceAlgorithmStatusList().stream().filter(m -> StringUtils.isNotEmpty((CharSequence)m.getAlgoCode()) && m.getAlgoCode().contains(finalAlgoCode)).collect(Collectors.toList()))) {
                                DeviceAlgoStatusEntity statusInfo = (DeviceAlgoStatusEntity)statusList.get(0);
                                algoVo.setIsRun(statusInfo.getStatus());
                                algoVo.setDownloadStatus(statusInfo.getDownloadStatus());
                            }
                        } else {
                            algoVo.setIsRun(((AlgoStatusEntity)modelSupportList.get(0)).getStatus());
                            algoVo.setDownloadStatus(((AlgoStatusEntity)modelSupportList.get(0)).getDownloadStatus());
                        }
                    }
                } else if (detail.getCheckType().compareTo(CheckTypeEnum.Soft.getCode()) == 0) {
                    algoVo.setLastAlgoVersion(((ModelVersionDetailEntity)detail.getVersionList().get(0)).getVersion());
                }
                algoVo.setNeedUpgrade(Boolean.valueOf(!algoVo.getAlgoVersion().equals(algoVo.getLastAlgoVersion())));
            }
            resultAlgoListVo.add(algoVo);
        }
        deviceDetail.setAlgoList(resultAlgoListVo);
    }

    @Override
    public Response<String> newSetAlgoList(String ticket, SetAlgoListBo request) {
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), MessageUtils.getMessage("code_param_des_fail"), MessageUtils.getMessage("code_fail")).build();
        }
        if (request.getServiceId() == null && (request.getDeviceStatusId() == null || StringUtils.isEmpty((CharSequence)request.getAlgoEnglishName()))) {
            if (request.getServiceId() == null) {
                return Response.Builder.call().error(Integer.valueOf(1004), MessageUtils.getMessage("code_lack_device_algo"), MessageUtils.getMessage("code_fail")).build();
            }
            return Response.Builder.call().error(Integer.valueOf(1005), MessageUtils.getMessage("code_lack_device_or_algo"), MessageUtils.getMessage("code_fail")).build();
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        if (request.getServiceId() != null) {
            queryWrapper.eq(DeviceAlgoRelationInfoDao::getId, (Object)request.getServiceId());
        } else {
            queryWrapper.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)request.getDeviceStatusId());
            queryWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoCode, (Object)request.getAlgoEnglishName());
        }
        queryWrapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
        DeviceAlgoRelationInfoDao bindInfo = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectOne((Wrapper)queryWrapper);
        if (bindInfo == null) {
            return Response.Builder.call().error(Integer.valueOf(1008), MessageUtils.getMessage("code_device_algo_bind"), MessageUtils.getMessage("code_fail")).build();
        }
        OvoparkUserInfoEntity userInfo = this.commonUtil.getUserInfo(ticket);
        Response<String> result = this.insertUpdateAlgoConfigQueue(request.getServiceId(), bindInfo, userInfo, ticket);
        return result;
    }

    @Override
    public Response<Integer> upgradeDevice(String token, UpgradeDeviceVo request) {
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1002), "\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25").build();
        }
        if (request.getDeviceinfoId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u83b7\u53d6\u8bbe\u5907\u4fe1\u606f\u5931\u8d25").build();
        }
        Integer result = this.deviceClientService.upgradeDevice(token, request);
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<String> insertUpdateAlgoConfigQueue(Integer serviceId, DeviceAlgoRelationInfoDao relationInfo, OvoparkUserInfoEntity userInfo, String token) {
        DeviceAlgoRelationInfoDao bindInfo = relationInfo;
        if (bindInfo == null || bindInfo.getId() == null) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(DeviceAlgoRelationInfoDao::getId, (Object)serviceId);
            wrapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
            bindInfo = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectOne((Wrapper)wrapper);
            if (bindInfo == null || bindInfo.getAlgoType().compareTo(1) != 0) {
                return Response.Builder.call().success((Object)MessageUtils.getMessage("code_device_upgrade"), MessageUtils.getMessage("code_success")).build();
            }
            if (bindInfo.getDeviceId() == null || bindInfo.getDeviceId().compareTo(0) <= 0) {
                return Response.Builder.call().error(Integer.valueOf(1010), MessageUtils.getMessage("code_get_device_info_fail"), MessageUtils.getMessage("code_fail")).build();
            }
        }
        LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
        queryWrapper.eq(UpgradeRecordDao::getServiceId, (Object)bindInfo.getId());
        queryWrapper.eq(UpgradeRecordDao::getStatus, (Object)1);
        queryWrapper.eq(UpgradeRecordDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
        List list = this.upgradeRecord.selectList((Wrapper)queryWrapper);
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            return Response.Builder.call().success((Object)MessageUtils.getMessage("code_upgrading_not_repeat"), MessageUtils.getMessage("code_success")).build();
        }
        if (!this.commonClientService.isHaveAlgoCodePermission(bindInfo.getGroupId(), bindInfo.getAlgoCode()).booleanValue()) {
            return Response.Builder.call().error(Integer.valueOf(1013), MessageUtils.getMessage("code_right_close"), MessageUtils.getMessage("code_fail")).build();
        }
        SnapshotAlgoQueryBatch queryBatch = new SnapshotAlgoQueryBatch();
        ArrayList<SnapshotAlgoQuery> queryList = new ArrayList<SnapshotAlgoQuery>();
        SnapshotAlgoQuery algoQuery = new SnapshotAlgoQuery();
        algoQuery.setAlgoCode(bindInfo.getAlgoCode());
        algoQuery.setEnterpriseId(Long.valueOf(bindInfo.getGroupId().intValue()));
        queryList.add(algoQuery);
        queryBatch.setList(queryList);
        List<ModelDetailEntity> modelDetailEntityList = this.commonClientService.getModelDetailByAlgoCode(queryBatch);
        if (modelDetailEntityList == null || modelDetailEntityList.isEmpty()) {
            throw new OpenPaasException(MessageUtils.getMessage("code_get_new_algo_fail"));
        }
        String newVersion = this.commonClientService.getNewVersionByRight(bindInfo.getGroupId(), bindInfo.getAlgoCode());
        if (StringUtils.isEmpty((CharSequence)newVersion)) {
            throw new OpenPaasException(MessageUtils.getMessage("code_get_new_algo_fail"));
        }
        ModelDetailEntity modelDetail = modelDetailEntityList.get(0);
        List versionList = modelDetail.getVersionList().stream().filter(item -> item.getVersion().equals(newVersion)).collect(Collectors.toList());
        if (versionList.isEmpty()) {
            throw new OpenPaasException(MessageUtils.getMessage("code_get_new_algo_fail"));
        }
        ModelVersionDetailEntity newVersionFilter = (ModelVersionDetailEntity)versionList.get(0);
        bindInfo.setAlgoVersion(newVersionFilter.getVersion());
        if (bindInfo.getAlgoType().compareTo(AlgoTypeEnum.Hardware.getCode()) == 0) {
            SetAlgoAlgoActivBo param = new SetAlgoAlgoActivBo();
            param.setDeviceStatusId(bindInfo.getDeviceId());
            param.setDeviceType(bindInfo.getDeviceType());
            ArrayList<DeviceAlgoConfigEntity> configList = new ArrayList<DeviceAlgoConfigEntity>();
            DeviceAlgoConfigEntity configModel = new DeviceAlgoConfigEntity();
            configModel.setModelName(modelDetail.getModelName());
            configModel.setAlgoName(this.commonUtil.getCodeInfo(newVersionFilter.getAlgoCode()));
            configModel.setModelVersion(newVersionFilter.getVersion());
            configModel.setModelDownloadUrl(newVersionFilter.getAddress());
            Long fulLife = bindInfo.getExpire() != null ? Long.valueOf(Math.abs(bindInfo.getExpire().getTime()) / 1000L) : 0L;
            configModel.setUsefulLife(fulLife);
            configList.add(configModel);
            param.setConfigList(configList);
            Response<List<AlgoCodeModel>> response = this.commonClientService.setAlgoAlgoActive("", param);
            if (response == null || response.getCode() != 0) {
                UpgradeRecordDao model = new UpgradeRecordDao();
                model.setServiceId(bindInfo.getId());
                model.setGroupId(bindInfo.getGroupId());
                model.setDeviceId(bindInfo.getDeviceId());
                model.setMac(bindInfo.getMac());
                model.setStatus(Integer.valueOf(1));
                model.setMsg(MessageUtils.getMessage("code_to_upgrade"));
                model.setPhone(userInfo.getMobilePhone());
                model.setCreateBy(userInfo.getUserName());
                model.setUpdateBy(userInfo.getUserName());
                model.setIsPersonal(bindInfo.getIsPersonal());
                model.setUserId(bindInfo.getUserId());
                int row = this.upgradeRecord.insert((Object)model);
                if (row < 1) {
                    return Response.Builder.call().success((Object)MessageUtils.getMessage("code_config_algo_fail"), MessageUtils.getMessage("code_success")).build();
                }
            }
        }
        bindInfo.setUpdateBy(userInfo.getUserName());
        int row = this.deviceAlgoRelationInfoMapper.updateById((Object)bindInfo);
        if (row <= 0) {
            return Response.Builder.call().error(MessageUtils.getMessage("code_device_save_fail"), MessageUtils.getMessage("code_fail")).build();
        }
        return Response.Builder.call().success((Object)MessageUtils.getMessage("code_upgrading"), MessageUtils.getMessage("code_success")).build();
    }

    @Override
    public Response<List<GetDepartmentListByDeviceStatusIdsVo>> getDepartmentListByAlgo(String ticket, GetDepartmentListByAlgoBo request) {
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25").build();
        }
        if (StringUtils.isEmpty((CharSequence)request.getAlgoCode())) {
            return Response.Builder.call().error(Integer.valueOf(1005), "\u7f3a\u5c11\u7b97\u6cd5\u6a21\u578b\u4fe1\u606f").build();
        }
        Integer groupId = this.commonUtil.getGroupId(ticket, null, request.getGroupId());
        if (groupId == null) {
            return Response.Builder.call().error(Integer.valueOf(1006), "\u672a\u80fd\u83b7\u53d6\u5230\u4f01\u4e1a\u4fe1\u606f").build();
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.in(DeviceAlgoRelationInfoDao::getAlgoCode, new Object[]{request.getAlgoCode()});
        wrapper.eq(DeviceAlgoRelationInfoDao::getGroupId, (Object)groupId);
        wrapper.eq(DeviceAlgoRelationInfoDao::getAlgoType, (Object)AlgoTypeEnum.Hardware.getCode());
        wrapper.ne(DeviceAlgoRelationInfoDao::getDeviceId, (Object)0);
        wrapper.ge(DeviceAlgoRelationInfoDao::getExpire, (Object)this.format.format(new Date()));
        wrapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
        List list = this.deviceAlgoRelationInfoMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Response.Builder.call().error(Integer.valueOf(1008), "\u672a\u80fd\u67e5\u5230\u8be5\u7b97\u6cd5\u914d\u7f6e\u4fe1\u606f\uff0c\u8bf7\u6838\u5b9e").build();
        }
        List ids = list.stream().map(m -> (int)m.getDeviceId()).collect(Collectors.toList());
        GetDepartmentListByDeviceStatusIdsBo params = new GetDepartmentListByDeviceStatusIdsBo();
        params.setGroupId(groupId);
        params.setGetAiNvrChildListFlag(Integer.valueOf(1));
        params.setDeviceStatusIdList(ids);
        HttpResponseEntity result = this.deviceAlgoFeignClient.getDepartmentListByDeviceStatusIds(ticket, params);
        if (result == null || result.getIsError().booleanValue() || result.getCode() != 0 || result.getData() == null) {
            String info = result != null && StringUtils.isNotEmpty((CharSequence)result.getMessage()) ? result.getMessage() : "\u83b7\u53d6\u95e8\u5e97\u53ca\u8bbe\u5907\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u786e\u8ba4\u7b97\u6cd5\u914d\u7f6e\u4fe1\u606f\uff0c\u518d\u91cd\u8bd5\uff01";
            return Response.Builder.call().error(Integer.valueOf(1009), info).build();
        }
        List devlist = (List)result.getData();
        for (GetDepartmentListByDeviceStatusIdsVo item : devlist) {
            ArrayList<DeviceStatusInfoEntity> infos = new ArrayList<DeviceStatusInfoEntity>();
            for (DeviceStatusInfoEntity devItem : item.getDeviceStatusList()) {
                if (StringUtils.isNotEmpty((CharSequence)devItem.getAlgoName()) && request.getAlgoCode().equals(devItem.getAlgoName())) {
                    infos.add(devItem);
                    continue;
                }
                if (!CollectionUtils.isNotEmpty((Collection)devItem.getAlgoCodeList()) || !devItem.getAlgoCodeList().contains(request.getAlgoCode())) continue;
                infos.add(devItem);
            }
            item.setDeviceStatusList(infos);
        }
        devlist = devlist.stream().filter(m -> CollectionUtils.isNotEmpty((Collection)m.getDeviceStatusList())).collect(Collectors.toList());
        return Response.Builder.call().success(devlist).build();
    }

    @Override
    public Response switchingDeviceAlgoStatus(SwitchingDeviceAlgoStatusBo request) {
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1001), "\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25").build();
        }
        if (request.getDeviceStatusId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1002), "\u8bf7\u9009\u62e9\u4fee\u6539\u8bbe\u5907").build();
        }
        if (request.getModelId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u8bf7\u9009\u62e9\u7b97\u6cd5").build();
        }
        String token = RequestContext.getCurrentContext().getToken();
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        query.eq(DeviceAlgoRelationInfoDao::getModelId, (Object)request.getModelId());
        query.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)request.getDeviceStatusId());
        query.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
        query.ge(DeviceAlgoRelationInfoDao::getExpire, (Object)this.format.format(new Date()));
        List relationList = this.deviceAlgoRelationInfoMapper.selectList((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)relationList)) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u8be5\u8bbe\u5907\u6ca1\u6709\u8be5\u7b97\u6cd5\u6743\u76ca").build();
        }
        AlgoVersionInfoDao versionInfo = (AlgoVersionInfoDao)this.algoVersionInfoMapper.selectById((Serializable)((DeviceAlgoRelationInfoDao)relationList.get(0)).getVersionId());
        if (versionInfo == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), "\u67e5\u65e0\u8be5\u7b97\u6cd5\u7248\u672c").build();
        }
        HttpResponseEntity algoSupportResult = this.deviceAlgoFeignClient.getDeviceAlgoSupportList(token, request.getDeviceStatusId());
        if (algoSupportResult == null || algoSupportResult.getCode() != 0 || CollectionUtils.isEmpty((Collection)((Collection)algoSupportResult.getData()))) {
            return Response.Builder.call().error(Integer.valueOf(1006), "\u8be5\u8bbe\u5907\u672a\u80fd\u67e5\u8be2\u5230\u652f\u6301\u7684\u7b97\u6cd5\u4fe1\u606f\uff0c\u8bf7\u786e\u8ba4\u9009\u62e9\u7684\u8bbe\u5907").build();
        }
        Long nowTimestamp = LocalDateTime.now().toEpochSecond(ZoneOffset.of("+8"));
        List supportList = ((List)algoSupportResult.getData()).stream().filter(m -> m.getAlgoName().equals(this.commonUtil.getCodeInfo(versionInfo.getAlgoCode())) && m.getCanUseFlag().compareTo(1) == 0 && m.getActivateFlag().compareTo(1) == 0 && m.getUsefulLife().compareTo(nowTimestamp) >= 0).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(supportList)) {
            return Response.Builder.call().error(Integer.valueOf(1007), "\u8be5\u7b97\u6cd5\u5df2\u8fc7\u671f").build();
        }
        HttpResponseEntity algoDetailResult = this.deviceAlgoFeignClient.getAlgoDetailConfig(token, request.getDeviceStatusId());
        if (algoDetailResult == null || algoDetailResult.getData() == null || ((GetAlgoAlgoConfigVo)algoDetailResult.getData()).getConfig() == null) {
            return Response.Builder.call().error(Integer.valueOf(1008), "\u83b7\u53d6\u8bbe\u5907\u914d\u7f6e\u6587\u4ef6\u5931\u8d25").build();
        }
        List algoConfigList = ((GetAlgoAlgoConfigVo)algoDetailResult.getData()).getConfig().getAlgoConfigs();
        Boolean isMatch = algoConfigList.stream().anyMatch(m -> m.getAlgoName().equals(this.commonUtil.getCodeInfo(versionInfo.getAlgoCode())));
        if (!isMatch.booleanValue()) {
            return Response.Builder.call().error(Integer.valueOf(1009), "\u8be5\u7b97\u6cd5\u4e0d\u5b58\u5728\u4e8e\u8bbe\u5907\u914d\u7f6e\u6587\u4ef6\u4e2d").build();
        }
        for (AlgoDetailConfigsEntity item : algoConfigList) {
            if (item.getAlgoName().equals(this.commonUtil.getCodeInfo(versionInfo.getAlgoCode()))) {
                item.setEnable(Integer.valueOf(1));
                continue;
            }
            item.setEnable(Integer.valueOf(0));
        }
        SetAlgoDetailConfigEntityBo param = new SetAlgoDetailConfigEntityBo();
        param.setDeviceStatusId(((GetAlgoAlgoConfigVo)algoDetailResult.getData()).getDeviceStatusId());
        SetAlgoDetailConfigEntityBo.ConfigInfo config = new SetAlgoDetailConfigEntityBo.ConfigInfo();
        config.setAlgoConfigs(algoConfigList);
        config.setDrawEnable(((GetAlgoAlgoConfigVo)algoDetailResult.getData()).getConfig().getDrawEnable());
        param.setConfig(config);
        HttpResponseEntity result = this.deviceAlgoFeignClient.setAlgoDetailConfig("1", param);
        if (result == null || result.getCode() != 0 || result.getData() == null || (((SetAlgoDetailConfigVo)result.getData()).getData() == null || !((SetAlgoDetailConfigVo)result.getData()).getData().getErrno().equals("200000")) && !((SetAlgoDetailConfigVo)result.getData()).getErrno().equals("200000")) {
            Integer code = result != null && result.getData() == null && StringUtils.isNotEmpty((CharSequence)((SetAlgoDetailConfigVo)result.getData()).getErrno()) ? Integer.valueOf(((SetAlgoDetailConfigVo)result.getData()).getErrno()) : (result != null && result.getData() == null && ((SetAlgoDetailConfigVo)result.getData()).getData() != null && StringUtils.isNotEmpty((CharSequence)((SetAlgoDetailConfigVo)result.getData()).getData().getErrno()) ? Integer.valueOf(((SetAlgoDetailConfigVo)result.getData()).getData().getErrno()) : 1010);
            String msg = result != null && result.getData() == null && StringUtils.isNotEmpty((CharSequence)((SetAlgoDetailConfigVo)result.getData()).getMsg()) ? ((SetAlgoDetailConfigVo)result.getData()).getMsg() : (result != null && result.getData() == null && ((SetAlgoDetailConfigVo)result.getData()).getData() != null && StringUtils.isNotEmpty((CharSequence)((SetAlgoDetailConfigVo)result.getData()).getData().getMsg()) ? ((SetAlgoDetailConfigVo)result.getData()).getData().getMsg() : "\u4fdd\u5b58\u8bbe\u5907\u914d\u7f6e\u4fe1\u606f\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5");
            return Response.Builder.call().error(code, msg).build();
        }
        return Response.Builder.call().success().build();
    }
}

