/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.open.service.DeviceClientService;
import com.ovopark.paas.api.constant.CategoryNameEnum;
import com.ovopark.paas.api.constant.CheckTypeEnum;
import com.ovopark.paas.api.entity.AlgoLikeCountEntity;
import com.ovopark.paas.api.entity.GetOLUCTokenEntity;
import com.ovopark.paas.api.entity.HttpResponseEntity;
import com.ovopark.paas.api.entity.ModelDetailEntity;
import com.ovopark.paas.api.entity.ModelVersionDetailEntity;
import com.ovopark.paas.api.entity.OlucPage;
import com.ovopark.paas.api.entity.Response;
import com.ovopark.paas.api.entity.bo.GetGoodsListBo;
import com.ovopark.paas.api.entity.dao.AlgoLikeInfoDao;
import com.ovopark.paas.api.entity.vo.GetAlgoDetailVo;
import com.ovopark.paas.api.entity.vo.GetAlgoDevVo;
import com.ovopark.paas.api.entity.vo.GetAlgoListVo;
import com.ovopark.paas.api.entity.vo.GetAlgoListVoWithPackage;
import com.ovopark.paas.api.entity.vo.GetDeviceDetailVo;
import com.ovopark.paas.api.entity.vo.GetDeviceListVo;
import com.ovopark.paas.api.entity.vo.GetGoodsDetailVo;
import com.ovopark.paas.api.entity.vo.GetGoodsListVo;
import com.ovopark.paas.api.entity.vo.GetOtherAlgoVo;
import com.ovopark.paas.api.entity.vo.IsLikeGoodVo;
import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import com.ovopark.paas.core.service.CommonClientService;
import com.ovopark.paas.core.service.OlucService;
import com.ovopark.paas.core.utils.CommonUtil;
import com.ovopark.paas.repository.paas.mapper.AlgoLikeInfoMapper;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Service;

@Service
public class OlucServiceImpl
implements OlucService {
    private static final Logger logger = LoggerFactory.getLogger(OlucServiceImpl.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private AlgoLikeInfoMapper algoLikeInfoMapper;
    @Autowired
    private CommonUtil commonUtil;
    @Autowired
    private CommonClientService commonClientService;
    @Autowired
    private DeviceClientService deviceClientService;

    @Override
    public Response<IPage<GetAlgoListVo>> getAlgoList(String ticket, Integer pageNumber, Integer pageSize) {
        Page result = new Page();
        OvoparkUserInfoEntity userInfo = this.commonUtil.getUserInfo(ticket);
        if (userInfo == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u83b7\u53d6\u7528\u6237\u5931\u8d25").build();
        }
        GetOLUCTokenEntity userRequest = new GetOLUCTokenEntity();
        userRequest.setUserId(userInfo.getId());
        userRequest.setUserName(userInfo.getUserName());
        userRequest.setPhone(userInfo.getMobilePhone());
        String token = this.commonUtil.getOLUCToken(userRequest);
        GetGoodsListBo request = new GetGoodsListBo();
        request.setPageNumber(pageNumber);
        request.setPageSize(pageSize);
        request.setCategoryName(CategoryNameEnum.Algo.getName());
        HttpResponseEntity<OlucPage<GetGoodsListVo>> goodsListResult = this.commonClientService.getGoodsDetailList(token, request);
        if (goodsListResult == null || goodsListResult.getData() == null || ((OlucPage)goodsListResult.getData()).getTotal() <= 0) {
            return Response.Builder.call().success((Object)result).build();
        }
        if (goodsListResult.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1004), goodsListResult.getMessage()).build();
        }
        List list = ((OlucPage)goodsListResult.getData()).getRecords();
        List ids = list.stream().map(GetGoodsListVo::getGoodsId).collect(Collectors.toList());
        List likeList = this.algoLikeInfoMapper.getLikeCountList(ids);
        List likeInfoList = new ArrayList();
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userRequest.getUserId())).eq((Object)"row_status", (Object)1);
        likeInfoList = this.algoLikeInfoMapper.selectList((Wrapper)wrapper);
        ArrayList<GetAlgoListVo> resultList = new ArrayList<GetAlgoListVo>();
        GetAlgoListVo model = new GetAlgoListVo();
        for (GetGoodsListVo item : list) {
            List countInfo;
            List isLike;
            model = new GetAlgoListVo();
            model.setEnterpriseId(item.getEnterpriseId());
            model.setGoodsId(item.getGoodsId());
            model.setGoodsSkuId((Integer)item.getGoodsSkuIdList().get(0));
            model.setGoodsName(item.getGoodsName());
            model.setImg(item.getImg());
            model.setPrice(item.getPrice());
            model.setDescription(item.getDescription());
            model.setReleaseTime(item.getReleaseTime());
            model.setAlgoUpdateTime(item.getAlgoUpdateTime());
            model.setIsSupport(item.getIsSupport());
            if (CollectionUtils.isNotEmpty((Collection)item.getLabels())) {
                List labels = item.getLabels().stream().map(m -> m.getName()).collect(Collectors.toList());
                model.setLabels(labels);
            } else {
                model.setLabels(new ArrayList());
            }
            if (CollectionUtils.isNotEmpty(likeInfoList) && CollectionUtils.isNotEmpty(isLike = likeInfoList.stream().filter(m -> m.getAlgoId().compareTo(item.getGoodsId()) == 0).collect(Collectors.toList()))) {
                model.setIsLike(Integer.valueOf(1));
            }
            if (CollectionUtils.isNotEmpty((Collection)likeList) && CollectionUtils.isNotEmpty(countInfo = likeList.stream().filter(m -> m.getAlgoId().compareTo(item.getGoodsId()) == 0).collect(Collectors.toList()))) {
                model.setLikeCount(((AlgoLikeCountEntity)countInfo.get(0)).getNum());
            }
            if (model.getIsLike() == null) {
                model.setIsLike(Integer.valueOf(0));
            }
            if (model.getLikeCount() == null) {
                model.setLikeCount(Integer.valueOf(0));
            }
            resultList.add(model);
        }
        result.setTotal((long)((OlucPage)goodsListResult.getData()).getTotal().intValue());
        result.setSize((long)((OlucPage)goodsListResult.getData()).getSize().intValue());
        result.setRecords(resultList);
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<GetAlgoListVoWithPackage> getAlgoListWithPackage(String ticket, Integer pageNumber, Integer pageSize) {
        GetAlgoListVoWithPackage result = new GetAlgoListVoWithPackage();
        String token = this.commonUtil.getToken(ticket);
        GetGoodsListBo request = new GetGoodsListBo();
        request.setPageNumber(pageNumber);
        request.setPageSize(pageSize);
        request.setCategoryName(CategoryNameEnum.Algo.getName());
        HttpResponseEntity<OlucPage<GetGoodsListVo>> goodsListResult = this.commonClientService.getGoodsDetailList(token, request);
        if (goodsListResult == null || goodsListResult.getData() == null || ((OlucPage)goodsListResult.getData()).getTotal() <= 0) {
            return Response.Builder.call().success((Object)result).build();
        }
        if (goodsListResult.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1003), goodsListResult.getMessage()).build();
        }
        List list = ((OlucPage)goodsListResult.getData()).getRecords();
        ArrayList<GetAlgoListVo> resultList = new ArrayList<GetAlgoListVo>();
        for (GetGoodsListVo item : list) {
            if (item.getCheckType() == null || item.getCheckType().compareTo(CheckTypeEnum.Soft.getCode()) != 0 || item.getDays() == null || item.getDays() <= 0) continue;
            GetAlgoListVo model = new GetAlgoListVo();
            model.setEnterpriseId(item.getEnterpriseId());
            model.setGoodsId(item.getGoodsId());
            model.setGoodsSkuId((Integer)item.getGoodsSkuIdList().get(0));
            model.setGoodsName(item.getGoodsName());
            model.setImg(item.getImg());
            model.setPrice(item.getPrice());
            model.setDescription(item.getDescription());
            model.setReleaseTime(item.getReleaseTime());
            model.setAlgoUpdateTime(item.getAlgoUpdateTime());
            resultList.add(model);
        }
        result.setTotal(((OlucPage)goodsListResult.getData()).getTotal().intValue());
        result.setSize(((OlucPage)goodsListResult.getData()).getSize().intValue());
        result.setRecords(resultList);
        result.setMethod("365\u5929(\u989d\u5916\u8d60\u90017\u5929)");
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<GetAlgoDetailVo> getAlgoDetail(String ticket, Integer goodId) {
        GetAlgoDetailVo result = new GetAlgoDetailVo();
        if (goodId == null) {
            return Response.Builder.call().success((Object)result).build();
        }
        OvoparkUserInfoEntity userInfo = this.commonUtil.getUserInfo(ticket);
        if (userInfo == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u83b7\u53d6\u7528\u6237\u5931\u8d25").build();
        }
        GetOLUCTokenEntity userRequest = new GetOLUCTokenEntity();
        userRequest.setUserId(userInfo.getId());
        userRequest.setUserName(userInfo.getUserName());
        userRequest.setPhone(userInfo.getMobilePhone());
        String token = this.commonUtil.getOLUCToken(userRequest);
        GetGoodsDetailVo detail = this.commonClientService.getGoodsDetail(token, goodId);
        result.setEnterpriseId(detail.getEnterpriseId());
        result.setGoodsId(detail.getGoodsId());
        result.setGoodsSkuId(detail.getGoodsSkuId());
        result.setGoodsName(detail.getGoodsName());
        result.setImg(detail.getImg());
        result.setDescription(detail.getDescription());
        result.setPrice(detail.getPrice());
        result.setMinPrice(detail.getMinPrice());
        result.setMaxPrice(detail.getMaxPrice());
        result.setVideo(detail.getVideo());
        result.setGoodsDetails(detail.getGoodsDetails());
        result.setCarousels(detail.getCarousels());
        result.setRemark(detail.getDescription());
        result.setScene(detail.getScene());
        List<ModelDetailEntity> modelInfos = this.commonClientService.getModelDetail(Arrays.asList(goodId), null, null, 1);
        if (CollectionUtils.isNotEmpty(modelInfos) && CollectionUtils.isNotEmpty((Collection)modelInfos.get(0).getVersionList())) {
            ModelVersionDetailEntity versionInfo = (ModelVersionDetailEntity)modelInfos.get(0).getVersionList().get(0);
            result.setVersion(versionInfo.getVersion());
            result.setReleaseTime(versionInfo.getReleaseTime());
            result.setUpdateTime(versionInfo.getUpdateTime());
        }
        ArrayList<Integer> ids = new ArrayList<Integer>();
        ids.add(goodId);
        List likeList = this.algoLikeInfoMapper.getLikeCountList(ids);
        if (CollectionUtils.isNotEmpty((Collection)likeList)) {
            result.setLikeCount(((AlgoLikeCountEntity)likeList.get(0)).getNum());
        } else {
            result.setLikeCount(Integer.valueOf(0));
        }
        QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userRequest.getUserId())).eq((Object)"row_status", (Object)1);
        List likeInfoList = this.algoLikeInfoMapper.selectList((Wrapper)wrapper);
        List isLike = likeInfoList.stream().filter(m -> m.getAlgoId().compareTo(goodId) == 0).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(isLike)) {
            result.setIsLike(Integer.valueOf(1));
        } else {
            result.setIsLike(Integer.valueOf(0));
        }
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<List<GetOtherAlgoVo>> getOtherAlgo(String ticket, Integer goodId) {
        ArrayList<GetOtherAlgoVo> result = new ArrayList<GetOtherAlgoVo>();
        String token = this.commonUtil.getToken(ticket);
        GetGoodsListBo request = new GetGoodsListBo();
        request.setPageNumber(Integer.valueOf(1));
        request.setPageSize(Integer.valueOf(4));
        request.setCategoryName(CategoryNameEnum.Algo.getName());
        HttpResponseEntity<OlucPage<GetGoodsListVo>> goodsListResult = this.commonClientService.getGoodsDetailList(token, request);
        if (goodsListResult == null || goodsListResult.getData() == null || ((OlucPage)goodsListResult.getData()).getTotal() <= 0) {
            return Response.Builder.call().success(result).build();
        }
        if (goodsListResult.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1003), goodsListResult.getMessage()).build();
        }
        List list = ((OlucPage)goodsListResult.getData()).getRecords();
        GetOtherAlgoVo model = new GetOtherAlgoVo();
        for (GetGoodsListVo item : list) {
            if (goodId.compareTo(item.getGoodsId()) == 0) continue;
            model = new GetOtherAlgoVo();
            model.setGoodId(item.getGoodsId());
            model.setName(item.getGoodsName());
            model.setImg(item.getImg());
            model.setDescription(item.getDescription());
            result.add(model);
        }
        return Response.Builder.call().success(result).build();
    }

    @Override
    public Response<List<GetAlgoDevVo>> getAlgoDev(String ticket, Integer goodId, String deviceType) {
        ArrayList<GetAlgoDevVo> result = new ArrayList<GetAlgoDevVo>();
        if (goodId == null) {
            return Response.Builder.call().success(result).build();
        }
        String token = this.commonUtil.getToken(ticket);
        GetGoodsListBo request = new GetGoodsListBo();
        request.setPageNumber(Integer.valueOf(1));
        request.setPageSize(Integer.valueOf(20));
        request.setCategoryName(CategoryNameEnum.device.getName());
        HttpResponseEntity<OlucPage<GetGoodsListVo>> goodsListResult = this.commonClientService.getGoodsDetailList(token, request);
        if (goodsListResult == null || goodsListResult.getData() == null || ((OlucPage)goodsListResult.getData()).getTotal() <= 0) {
            return Response.Builder.call().success(result).build();
        }
        if (goodsListResult.getCode() != 200) {
            return Response.Builder.call().success(result).build();
        }
        List goodsInfolist = ((OlucPage)goodsListResult.getData()).getRecords();
        GetAlgoDevVo model = new GetAlgoDevVo();
        for (GetGoodsListVo item : goodsInfolist) {
            model = new GetAlgoDevVo();
            model.setGoodId(item.getGoodsId());
            model.setType(item.getDeviceType());
            model.setName(item.getGoodsName());
            model.setImg(item.getImg());
            model.setDescription(item.getDescription());
            result.add(model);
        }
        return Response.Builder.call().success(result).build();
    }

    @Override
    public Response<IPage<GetDeviceListVo>> getDeviceList(String ticket, Integer pageNumber, Integer pageSize, List<String> deviceTypes) {
        Page result = new Page();
        String token = this.commonUtil.getToken(ticket);
        GetGoodsListBo request = new GetGoodsListBo();
        request.setPageNumber(pageNumber);
        request.setPageSize(pageSize);
        request.setCategoryName(CategoryNameEnum.device.getName());
        HttpResponseEntity<OlucPage<GetGoodsListVo>> goodsListResult = this.commonClientService.getGoodsDetailList(token, request);
        if (goodsListResult == null || goodsListResult.getData() == null || ((OlucPage)goodsListResult.getData()).getTotal() <= 0) {
            return Response.Builder.call().success((Object)result).build();
        }
        if (goodsListResult.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1003), goodsListResult.getMessage()).build();
        }
        List list = ((OlucPage)goodsListResult.getData()).getRecords();
        ArrayList<GetDeviceListVo> resultList = new ArrayList<GetDeviceListVo>();
        GetDeviceListVo model = new GetDeviceListVo();
        for (GetGoodsListVo item : list) {
            if (CollectionUtils.isNotEmpty(deviceTypes) && !deviceTypes.contains(item.getDeviceType())) continue;
            model = new GetDeviceListVo();
            model.setGoodId(item.getGoodsId());
            model.setName(item.getGoodsName());
            model.setImg(item.getImg());
            model.setDescription(item.getDescription());
            model.setType(item.getDeviceType());
            resultList.add(model);
        }
        result.setTotal((long)((OlucPage)goodsListResult.getData()).getTotal().intValue());
        result.setSize((long)((OlucPage)goodsListResult.getData()).getSize().intValue());
        result.setRecords(resultList);
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<GetDeviceDetailVo> getDeviceDetail(String ticket, Integer goodId) {
        GetDeviceDetailVo result = new GetDeviceDetailVo();
        if (goodId == null) {
            return Response.Builder.call().success((Object)result).build();
        }
        String token = this.commonUtil.getToken(ticket);
        GetGoodsDetailVo detail = this.commonClientService.getGoodsDetail(token, goodId);
        result.setEnterpriseId(detail.getEnterpriseId());
        result.setGoodsId(detail.getGoodsId());
        result.setGoodsSkuId(detail.getGoodsSkuId());
        result.setGoodsName(detail.getGoodsName());
        result.setImg(detail.getImg());
        result.setDescription(detail.getDescription());
        result.setPrice(detail.getPrice());
        result.setMinPrice(detail.getMinPrice());
        result.setMaxPrice(detail.getMaxPrice());
        result.setVideo(detail.getVideo());
        result.setGoodsDetails(detail.getGoodsDetails());
        result.setCarousels(detail.getCarousels());
        result.setType(detail.getDeviceType());
        result.setBaseInfo((Map)JSONObject.parseObject((String)detail.getBaseInfo(), Map.class));
        result.setVideoInfo((Map)JSONObject.parseObject((String)detail.getVideoInfo(), Map.class));
        result.setNetworkInfo((Map)JSONObject.parseObject((String)detail.getNetworkInfo(), Map.class));
        result.setSystemInfo((Map)JSONObject.parseObject((String)detail.getSystemInfo(), Map.class));
        result.setAiInfo((Map)JSONObject.parseObject((String)detail.getAiInfo(), Map.class));
        result.setApiInfo((Map)JSONObject.parseObject((String)detail.getApiInfo(), Map.class));
        result.setEnvInfo((Map)JSONObject.parseObject((String)detail.getEnvInfo(), Map.class));
        result.setPhysicalInfo((Map)JSONObject.parseObject((String)detail.getPhysicalInfo(), Map.class));
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<Boolean> isLikeGood(String ticket, IsLikeGoodVo request) {
        if (request == null || request.getGoodId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u83b7\u53d6\u8bf7\u6c42\u53c2\u6570\u5931\u8d25").build();
        }
        String key = this.commonUtil.toMd5(String.format("isLikeGood_%s_%s", ticket, request.getGoodId()));
        try {
            Long isExists = this.redisTemplate.opsForValue().increment((Object)key, 1L);
            if (isExists.compareTo(0L) <= 0) {
                this.redisTemplate.opsForValue().increment((Object)key, -1L);
                return Response.Builder.call().error(Integer.valueOf(1004), "\u64cd\u4f5c\u8fc7\u4e8e\u9891\u7e41\u8bf7\u7a0d\u540e").build();
            }
            OvoparkUserInfoEntity userInfo = this.commonUtil.getUserInfo(ticket);
            if (userInfo == null) {
                this.redisTemplate.opsForValue().increment((Object)key, -1L);
                return Response.Builder.call().error(Integer.valueOf(1006), "\u672a\u80fd\u83b7\u53d6\u5230\u7528\u6237\u4fe1\u606f").build();
            }
            QueryWrapper wrapper = (QueryWrapper)((QueryWrapper)new QueryWrapper().eq((Object)"user_id", (Object)userInfo.getId())).eq((Object)"algo_id", (Object)request.getGoodId());
            AlgoLikeInfoDao info = (AlgoLikeInfoDao)this.algoLikeInfoMapper.selectOne((Wrapper)wrapper);
            if (info == null || info.getId() == null) {
                AlgoLikeInfoDao model = new AlgoLikeInfoDao();
                model.setAlgoId(request.getGoodId());
                model.setUserId(Long.valueOf(userInfo.getMobilePhone()));
                model.setCreateBy(userInfo.getUserName());
                model.setUpdateBy(userInfo.getUserName());
                this.algoLikeInfoMapper.insert((Object)model);
            } else {
                int status = info.getRowStatus().compareTo(1) == 0 ? 0 : 1;
                info.setRowStatus(Integer.valueOf(status));
                info.setUpdateTime(new Date());
                this.algoLikeInfoMapper.updateById((Object)info);
            }
            this.redisTemplate.opsForValue().increment((Object)key, -1L);
            return Response.Builder.call().success((Object)true).build();
        }
        catch (Exception ex) {
            this.redisTemplate.opsForValue().increment((Object)key, -1L);
            logger.error(String.format("\u70b9\u8d5e\u5931\u8d25\u3002\u8bf7\u6c42\u53c2\u6570\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", ticket, ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
            return Response.Builder.call().error(Integer.valueOf(1007), "\u63a5\u53e3\u8c03\u7528\u5f02\u5e38").build();
        }
    }
}

