/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.config;

import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import com.ovopark.paas.core.config.RequestContext;
import com.ovopark.paas.core.utils.CommonUtil;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;
import org.springframework.ui.ModelMap;
import org.springframework.web.context.request.WebRequest;
import org.springframework.web.context.request.WebRequestInterceptor;

@Component
public class AuthenticationInterceptor
implements WebRequestInterceptor {
    @Autowired
    private CommonUtil commonUtil;

    public void preHandle(WebRequest request) throws Exception {
        String token = request.getHeader("Ovo-Authorization");
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = request.getHeader("ticket");
        }
        if (StringUtils.isEmpty((CharSequence)token)) {
            token = "";
        } else {
            OvoparkUserInfoEntity user = this.commonUtil.getUserInfo(token);
            if (user != null && user.getId() != null) {
                RequestContext.getCurrentContext().setUserInfo(user);
            }
        }
        RequestContext.getCurrentContext().setToken(token);
    }

    public void postHandle(WebRequest request, ModelMap model) throws Exception {
    }

    public void afterCompletion(WebRequest request, Exception ex) throws Exception {
        RequestContext.getCurrentContext().unSet();
    }
}

