/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.config;

import com.ovopark.paas.core.config.AuthenticationInterceptor;
import com.ovopark.paas.core.config.AuthenticationWebRequestHandlerInterceptorAdapter;
import com.ovopark.paas.core.config.TrainingInterceptor;
import org.springframework.context.annotation.Configuration;
import org.springframework.web.servlet.HandlerInterceptor;
import org.springframework.web.servlet.config.annotation.InterceptorRegistry;
import org.springframework.web.servlet.config.annotation.WebMvcConfigurer;

@Configuration
public class InterceptorConfiguration
implements WebMvcConfigurer {
    private final AuthenticationInterceptor authenticationInterceptor;
    private final TrainingInterceptor trainingInterceptor;

    public InterceptorConfiguration(AuthenticationInterceptor authenticationInterceptor, TrainingInterceptor trainingInterceptor) {
        this.authenticationInterceptor = authenticationInterceptor;
        this.trainingInterceptor = trainingInterceptor;
    }

    public void addInterceptors(InterceptorRegistry registry) {
        registry.addInterceptor((HandlerInterceptor)new AuthenticationWebRequestHandlerInterceptorAdapter(this.authenticationInterceptor)).excludePathPatterns(new String[]{"/paas/training/dataset/**"});
        registry.addInterceptor((HandlerInterceptor)new AuthenticationWebRequestHandlerInterceptorAdapter(this.trainingInterceptor)).addPathPatterns(new String[]{"/paas/training/dataset/**"});
    }
}

