/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.config.requestLog.Impl;

import com.alibaba.fastjson.JSONObject;
import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import com.ovopark.paas.core.config.RequestContext;
import com.ovopark.paas.core.config.requestLog.RequestLog;
import com.ovopark.paas.core.utils.ThreadPoolTaskUtils;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import javax.annotation.Resource;
import org.apache.commons.lang3.StringUtils;
import org.aspectj.lang.JoinPoint;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.AfterReturning;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.aspectj.lang.reflect.MethodSignature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.util.StopWatch;

@Aspect
@Component
public class RequestLogAspect {
    private static final Logger log = LoggerFactory.getLogger(RequestLogAspect.class);
    private static final Logger logger = LoggerFactory.getLogger(RequestLogAspect.class);
    @Resource
    private ThreadPoolTaskUtils threadPoolTaskUtils;
    private HashMap<String, Class> map = new HashMap<String, Class>(){
        {
            this.put("java.lang.Integer", Integer.TYPE);
            this.put("java.lang.Double", Double.TYPE);
            this.put("java.lang.Float", Float.TYPE);
            this.put("java.lang.Long", Long.TYPE);
            this.put("java.lang.Short", Short.TYPE);
            this.put("java.lang.Boolean", Boolean.TYPE);
            this.put("java.lang.Char", Character.TYPE);
        }
    };

    @Pointcut(value="@annotation(com.ovopark.paas.core.config.requestLog.RequestLog))")
    public void pointCut() {
    }

    @Around(value="pointCut()")
    public Object around(ProceedingJoinPoint joinPoint) {
        MethodSignature signature = (MethodSignature)joinPoint.getSignature();
        Method method = signature.getMethod();
        String classType = joinPoint.getTarget().getClass().getName();
        String simpleName = joinPoint.getTarget().getClass().getSimpleName();
        String methodName = method.getName();
        RequestLog requestLog = method.getAnnotation(RequestLog.class);
        try {
            StopWatch sw = new StopWatch("\u7edf\u8ba1\u7a0b\u5e8f\u6267\u884c\u65f6\u95f4\u3002\u3002\u3002");
            String[] argNames = signature.getParameterNames();
            Object[] params = joinPoint.getArgs();
            sw.start();
            Object objResult = joinPoint.proceed();
            sw.stop();
            CompletableFuture.runAsync(() -> {
                String userName = "";
                OvoparkUserInfoEntity userResponse = RequestContext.getCurrentContext().getUserInfo();
                if (userResponse != null) {
                    userName = String.format("%s[%s]", userResponse.getUserName(), userResponse.getId().toString());
                }
                String paramJson = "";
                String resultJson = "";
                String filter1 = "";
                String filter2 = "";
                String category = simpleName;
                String subCategory = methodName;
                Map<Object, Object> mapParam = new HashMap<String, Object>();
                if (argNames != null && !requestLog.onlyResult()) {
                    if (argNames.length == 1 && StringUtils.isNotEmpty((CharSequence)argNames[0]) && argNames[0].equals("request")) {
                        mapParam = this.convertObjectToMap(params[0]);
                    } else if (argNames.length > 0) {
                        for (int i = 0; i < argNames.length; ++i) {
                            mapParam.put(argNames[i], params[i]);
                        }
                    }
                    mapParam.put("token", RequestContext.getCurrentContext().getToken());
                    paramJson = JSONObject.toJSONString(mapParam);
                }
                if (!requestLog.onlyParam()) {
                    resultJson = JSONObject.toJSONString((Object)objResult);
                }
                if (StringUtils.isNotBlank((CharSequence)requestLog.category())) {
                    category = requestLog.category();
                }
                if (StringUtils.isNotBlank((CharSequence)requestLog.subCategory())) {
                    subCategory = requestLog.subCategory();
                }
                if ((StringUtils.isNotBlank((CharSequence)requestLog.filter1()) || StringUtils.isNotBlank((CharSequence)requestLog.filter2())) && mapParam != null && !mapParam.isEmpty()) {
                    if (StringUtils.isNotBlank((CharSequence)requestLog.filter1()) && mapParam.containsKey(requestLog.filter1())) {
                        filter1 = mapParam.get(requestLog.filter1()) != null ? String.valueOf(mapParam.get(requestLog.filter1())) : "";
                    }
                    if (StringUtils.isNotBlank((CharSequence)requestLog.filter2()) && mapParam.containsKey(requestLog.filter2())) {
                        filter2 = mapParam.get(requestLog.filter2()) != null ? String.valueOf(mapParam.get(requestLog.filter1())) : "";
                    }
                }
                String logContent = String.format("\u5927\u5206\u7c7b\uff1a%s ### \u5c0f\u5206\u7c7b\uff1a%s ### \u6761\u4ef61\uff1a%s ### \u6761\u4ef62\uff1a%s ### \u63a5\u53e3\u8017\u65f6\uff1a%sms ### \u8bf7\u6c42\u53c2\u6570\uff1a%s ### \u54cd\u5e94\u53c2\u6570\uff1a%s ### \u64cd\u4f5c\u4eba\uff1a%s", category, subCategory, filter1, filter2, sw.getLastTaskTimeMillis(), paramJson, resultJson, userName);
                logger.info(logContent);
            }, (Executor)this.threadPoolTaskUtils.getThreadPoolTaskExecutor());
            return objResult;
        }
        catch (Throwable e) {
            Object[] params = joinPoint.getArgs();
            String paramJson = "";
            paramJson = params.length >= 1 ? JSONObject.toJSONString((Object)params[0]) : JSONObject.toJSONString((Object)params);
            String logContent = String.format("\u5927\u5206\u7c7b\uff1a%s ### \u5c0f\u5206\u7c7b\uff1a%s ### \u8bf7\u6c42\u53c2\u6570\uff1a%s ### \u5f02\u5e38\u4fe1\u606f\uff1a", simpleName, methodName, paramJson);
            logger.error(logContent, e);
            throw e;
        }
    }

    @AfterReturning(value="pointCut()")
    public void afterReturning(JoinPoint joinPoint) {
    }

    private Map<String, Object> convertObjectToMap(Object obj) {
        Field[] fields;
        HashMap<String, Object> map = new HashMap<String, Object>();
        Class<?> cla = obj.getClass();
        for (Field field : fields = cla.getDeclaredFields()) {
            field.setAccessible(true);
            String keyName = field.getName();
            Object value = null;
            try {
                value = field.get(obj);
            }
            catch (IllegalAccessException e) {
                e.printStackTrace();
            }
            map.put(keyName, value);
        }
        return map;
    }
}

