/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.service.impl;

import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ovopark.open.feign.AiOpenFeignClient;
import com.ovopark.open.paasclient.AiOpenClient;
import com.ovopark.open.paasclient.AlgoClient;
import com.ovopark.open.service.DeviceClientService;
import com.ovopark.paas.api.constant.AlgoMarkEnum;
import com.ovopark.paas.api.constant.AlgoTypeEnum;
import com.ovopark.paas.api.constant.DeployTypeEnum;
import com.ovopark.paas.api.constant.ModelTypeEnum;
import com.ovopark.paas.api.constant.OrderTypeEnum;
import com.ovopark.paas.api.constant.RowStatusEnum;
import com.ovopark.paas.api.entity.DetectTimeListEntity;
import com.ovopark.paas.api.entity.DeviceAlgoConfigEntity;
import com.ovopark.paas.api.entity.GetAlgoServiceListEntity;
import com.ovopark.paas.api.entity.GetAlgoServiceModelListEntity;
import com.ovopark.paas.api.entity.GetCodeListEntity;
import com.ovopark.paas.api.entity.GetServiceInfoEntity;
import com.ovopark.paas.api.entity.GetSupportModelListEntity;
import com.ovopark.paas.api.entity.ModelDetailEntity;
import com.ovopark.paas.api.entity.ModelSupportInfoEntity;
import com.ovopark.paas.api.entity.ModelVersionDetailEntity;
import com.ovopark.paas.api.entity.RealGG;
import com.ovopark.paas.api.entity.Response;
import com.ovopark.paas.api.entity.SetDeviceInfoEntity;
import com.ovopark.paas.api.entity.bo.AlgoManageBo;
import com.ovopark.paas.api.entity.bo.DeviceBindAlgoBo;
import com.ovopark.paas.api.entity.bo.GetAllAlgoServiceListBo;
import com.ovopark.paas.api.entity.bo.GetDeviceAlgoRelationInfoBo;
import com.ovopark.paas.api.entity.bo.GetDeviceSupportAlgoCodeListBo;
import com.ovopark.paas.api.entity.bo.OperateBo;
import com.ovopark.paas.api.entity.bo.SetAlgoAlgoActivBo;
import com.ovopark.paas.api.entity.bo.SetAlgoListBo;
import com.ovopark.paas.api.entity.bo.UnbindingDeviceBo;
import com.ovopark.paas.api.entity.dao.AlgoModelInfoDao;
import com.ovopark.paas.api.entity.dao.AlgoRightVersionInfoDao;
import com.ovopark.paas.api.entity.dao.DeviceAlgoRelationInfoDao;
import com.ovopark.paas.api.entity.dao.UserAlgoDao;
import com.ovopark.paas.api.entity.model.AlgoCodeModel;
import com.ovopark.paas.api.entity.query.OpenAiFilterSnapshotVersionQuery;
import com.ovopark.paas.api.entity.query.SnapshotAlgoQuery;
import com.ovopark.paas.api.entity.query.SnapshotAlgoQueryBatch;
import com.ovopark.paas.api.entity.vo.BindResultInfoVo;
import com.ovopark.paas.api.entity.vo.DeviceAlgoEntity;
import com.ovopark.paas.api.entity.vo.DeviceStatusPojo;
import com.ovopark.paas.api.entity.vo.GetAlgoServiceEntity;
import com.ovopark.paas.api.entity.vo.GetAlgoServiceVo;
import com.ovopark.paas.api.entity.vo.GetAllAlgoServiceListVo;
import com.ovopark.paas.api.entity.vo.GetDeviceAlgoRelationInfoVo;
import com.ovopark.paas.api.entity.vo.GetMyAlgoByDeviceListVo;
import com.ovopark.paas.api.entity.vo.GetSkuListVo;
import com.ovopark.paas.api.entity.vo.MyAlgoListVo;
import com.ovopark.paas.api.entity.vo.OpenAiFilterSnapshotVersionVO;
import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import com.ovopark.paas.api.exception.OpenPaasException;
import com.ovopark.paas.core.service.AlgoService;
import com.ovopark.paas.core.service.CommonClientService;
import com.ovopark.paas.core.service.NewDeviceService;
import com.ovopark.paas.core.utils.CommonUtil;
import com.ovopark.paas.core.utils.DateUtil;
import com.ovopark.paas.core.utils.MessageUtils;
import com.ovopark.paas.repository.paas.mapper.AlgoModelInfoMapper;
import com.ovopark.paas.repository.paas.mapper.AlgoRightVersionInfoMapper;
import com.ovopark.paas.repository.paas.mapper.AlgoVersionInfoMapper;
import com.ovopark.paas.repository.paas.mapper.DeviceAlgoRelationInfoMapper;
import com.ovopark.paas.repository.paas.mapper.UserAlgoMapper;
import java.io.Serializable;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.tuple.ImmutablePair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class AlgoServiceImpl
implements AlgoService {
    private static final Logger log = LoggerFactory.getLogger(AlgoServiceImpl.class);
    @Autowired(required=false)
    private DeviceAlgoRelationInfoMapper deviceAlgoRelationInfoMapper;
    @Autowired
    private DeviceClientService deviceClientService;
    @Autowired
    private CommonUtil commonUtil;
    @Autowired
    private AlgoClient algoClient;
    @Autowired
    private AiOpenClient aiOpenClient;
    @Autowired
    private CommonClientService commonClientService;
    @Autowired(required=false)
    private UserAlgoMapper userAlgoMapper;
    @Autowired
    private NewDeviceService newDeviceService;
    @Autowired
    private AlgoVersionInfoMapper algoVersionInfoMapper;
    @Autowired
    private AlgoRightVersionInfoMapper algoRightVersionInfoMapper;
    @Autowired
    private AiOpenFeignClient aiOpenFeignClient;
    @Autowired(required=false)
    private AlgoModelInfoMapper algoModelInfoMapper;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public Response<IPage<MyAlgoListVo>> newGetMyAlgoList(String ticket, Integer groupId, String name, Integer pageNumber, Integer pageSize) {
        ArrayList<MyAlgoListVo> resultList = new ArrayList<MyAlgoListVo>();
        if (pageNumber == null) {
            pageNumber = 1;
        }
        if (pageSize == null) {
            pageSize = 10;
        }
        if ((groupId = this.commonUtil.getGroupId(ticket, null, groupId)) == null) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u672a\u80fd\u83b7\u53d6\u5230\u4f01\u4e1a\u4fe1\u606f").build();
        }
        Page result = new Page();
        Set<Object> algoCodeSet = new HashSet();
        if (StringUtils.isNotEmpty((CharSequence)name)) {
            OpenAiFilterSnapshotVersionQuery request = new OpenAiFilterSnapshotVersionQuery();
            request.setName(name);
            RealGG realResponse = this.aiOpenFeignClient.filterSnapshotVersion(request);
            if (realResponse.getIsError().booleanValue()) {
                log.error("{}, AI\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Object)realResponse.getMessage());
                throw new OpenPaasException("AI\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
            }
            algoCodeSet = ((List)realResponse.getData()).stream().map(OpenAiFilterSnapshotVersionVO::getAlgoCode).collect(Collectors.toSet());
            if (algoCodeSet.isEmpty()) {
                return Response.Builder.call().success((Object)result).build();
            }
        }
        GetAlgoServiceListEntity params = new GetAlgoServiceListEntity();
        params.setGroupId(groupId);
        params.setNowTime(this.format.parse(this.format.format(new Date())));
        params.setEndTime(this.format.parse(DateUtil.addDays(7)));
        List serviceList = this.deviceAlgoRelationInfoMapper.getAlgoServiceList(params);
        if (!algoCodeSet.isEmpty()) {
            Set<Object> finalAlgoCodeSet = algoCodeSet;
            serviceList = serviceList.stream().filter(item -> finalAlgoCodeSet.contains(item.getAlgoCode())).collect(Collectors.toList());
        }
        int total = serviceList.size();
        if (CollectionUtils.isEmpty(serviceList = serviceList.stream().skip((pageNumber - 1) * pageSize).limit(pageSize.intValue()).collect(Collectors.toList()))) {
            return Response.Builder.call().success((Object)result).build();
        }
        SnapshotAlgoQueryBatch queryBatchList = new SnapshotAlgoQueryBatch();
        ArrayList<SnapshotAlgoQuery> queryList = new ArrayList<SnapshotAlgoQuery>();
        for (GetServiceInfoEntity getAlgoCode : serviceList) {
            SnapshotAlgoQuery query = new SnapshotAlgoQuery();
            query.setAlgoCode(this.commonUtil.getCodeInfo(getAlgoCode.getAlgoCode()));
            queryList.add(query);
        }
        queryBatchList.setList(queryList);
        List<ModelDetailEntity> modelDetailEntityList = this.commonClientService.getModelDetailByAlgoCode(queryBatchList);
        Map<String, List<ModelDetailEntity>> algoCodeMap = modelDetailEntityList.stream().collect(Collectors.groupingBy(ModelDetailEntity::getAlgoCode));
        for (GetServiceInfoEntity item2 : serviceList) {
            MyAlgoListVo model = new MyAlgoListVo();
            if (!algoCodeMap.containsKey(item2.getAlgoCode())) continue;
            ModelDetailEntity modelDetail = algoCodeMap.get(item2.getAlgoCode()).get(0);
            model.setModelId(item2.getModelId());
            model.setGoodsId(modelDetail.getGoodsId());
            model.setIsGoods(Integer.valueOf(modelDetail.getModelType().compareTo(ModelTypeEnum.Special.getCode()) == 0 ? 0 : modelDetail.getIsGoods()));
            model.setImg(modelDetail.getImg());
            model.setDescription(modelDetail.getRemark());
            model.setBackgroundImg(modelDetail.getBackgroundImg());
            model.setTitle(modelDetail.getModelName());
            model.setOrderSns(item2.getOrderId().toString());
            model.setUnBingNum(item2.getUnbindCount() == null ? 0 : item2.getUnbindCount());
            model.setOverdueNum(item2.getEndingCount() == null ? 0 : item2.getEndingCount());
            model.setIsPackage(0);
            model.setDescription(modelDetail.getRemark());
            model.setIsHavePermission(Integer.valueOf(this.commonClientService.isHaveAlgoCodePermission(groupId, modelDetail.getAlgoCode()) != false ? 1 : 0));
            model.setAlgoCode(item2.getAlgoCode());
            model.setPlatform(StringUtils.isEmpty((CharSequence)item2.getAlgoCode()) ? "" : AlgoMarkEnum.getByCode((String)item2.getAlgoCode().substring(1, 4)));
            resultList.add(model);
        }
        result.setSize((long)pageSize.intValue());
        result.setTotal((long)total);
        result.setRecords(resultList);
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<List<GetMyAlgoByDeviceListVo>> newGetMyAlgoByDeviceList(String ticket, Integer groupId, Integer deviceStatusId, Integer algoType, Integer isAll) {
        groupId = this.commonUtil.getGroupId(ticket, null, groupId);
        if (groupId == null) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u672a\u80fd\u83b7\u53d6\u5230\u4f01\u4e1a\u4fe1\u606f").build();
        }
        List<Object> result = new ArrayList();
        List<String> supportModelCodes = this.commonClientService.getDeviceSupportModelCode(ticket, deviceStatusId);
        if (supportModelCodes == null && algoType != null && algoType.compareTo(AlgoTypeEnum.Hardware.getCode()) == 0) {
            return Response.Builder.call().success(result).build();
        }
        LambdaQueryWrapper rightQuery = new LambdaQueryWrapper();
        rightQuery.eq(AlgoRightVersionInfoDao::getGroupId, (Object)groupId);
        if (algoType != null && algoType.compareTo(AlgoTypeEnum.Hardware.getCode()) == 0) {
            rightQuery.in(AlgoRightVersionInfoDao::getModelCode, supportModelCodes);
        }
        rightQuery.eq(AlgoRightVersionInfoDao::getStatus, (Object)1);
        rightQuery.eq(AlgoRightVersionInfoDao::getRowStatus, (Object)1);
        List rightList = this.algoRightVersionInfoMapper.selectList((Wrapper)rightQuery);
        if (CollectionUtils.isEmpty((Collection)rightList)) {
            return Response.Builder.call().error(Integer.valueOf(1007), "\u672a\u80fd\u83b7\u53d6\u5230\u4efb\u4f55\u7b97\u6cd5\u670d\u52a1\u6743\u9650\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406").build();
        }
        List modelCodeList = rightList.stream().map(m -> m.getModelCode()).collect(Collectors.toList());
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (algoType != null && algoType.compareTo(0) != 0) {
            query.eq(DeviceAlgoRelationInfoDao::getAlgoType, (Object)algoType);
        }
        query.in(DeviceAlgoRelationInfoDao::getAlgoCode, modelCodeList);
        query.eq(DeviceAlgoRelationInfoDao::getGroupId, (Object)groupId);
        Date today = this.format.parse(this.format.format(new Date()));
        query.and(m -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)m.ge(DeviceAlgoRelationInfoDao::getExpire, (Object)today)).or()).isNull(DeviceAlgoRelationInfoDao::getExpire);
        });
        if (isAll != null && isAll == 1) {
            query.and(wrapper -> {
                LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)deviceStatusId)).or()).eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)0);
            });
        } else {
            query.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)0);
        }
        query.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)1);
        List list = this.deviceAlgoRelationInfoMapper.selectList((Wrapper)query);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Response.Builder.call().success(result).build();
        }
        SnapshotAlgoQueryBatch queryBatch = new SnapshotAlgoQueryBatch();
        ArrayList<SnapshotAlgoQuery> queryList = new ArrayList<SnapshotAlgoQuery>();
        for (String code : supportModelCodes) {
            SnapshotAlgoQuery algoQuery = new SnapshotAlgoQuery();
            algoQuery.setAlgoCode(code);
            algoQuery.setEnterpriseId(Long.valueOf(groupId.intValue()));
            queryList.add(algoQuery);
        }
        queryBatch.setList(queryList);
        List<ModelDetailEntity> modelDetailEntityList = this.commonClientService.getModelDetailByAlgoCode(queryBatch);
        GetMyAlgoByDeviceListVo resultModel = new GetMyAlgoByDeviceListVo();
        ArrayList<GetMyAlgoByDeviceListVo> algoServiceList = new ArrayList<GetMyAlgoByDeviceListVo>();
        HashSet<String> modelCodeSet = new HashSet<String>(supportModelCodes);
        for (ModelDetailEntity modelDetail : modelDetailEntityList) {
            algoServiceList = new ArrayList();
            String finalCode = modelDetail.getAlgoCode();
            List relationList = list.stream().filter(m -> finalCode.equals(m.getAlgoCode()) && m.getExpire() != null).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(relationList)) {
                relationList = new ArrayList();
            }
            relationList = relationList.stream().sorted(Comparator.comparing(DeviceAlgoRelationInfoDao::getExpire)).collect(Collectors.toList());
            List unRecordList = list.stream().filter(m -> finalCode.equals(m.getAlgoCode()) && m.getExpire() == null).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(unRecordList)) {
                relationList.addAll(unRecordList);
            }
            if (relationList.isEmpty()) continue;
            for (DeviceAlgoRelationInfoDao item : relationList) {
                resultModel = new GetMyAlgoByDeviceListVo();
                resultModel.setId(item.getId());
                resultModel.setAlgoCode(modelDetail.getAlgoCode());
                resultModel.setModelId(item.getModelId());
                resultModel.setAlgoId(item.getAlgoId());
                resultModel.setImg(modelDetail.getImg());
                resultModel.setName(modelDetail.getModelName());
                resultModel.setDesc(modelDetail.getRemark());
                resultModel.setExpire(item.getExpire() == null ? "" : this.format.format(item.getExpire()));
                resultModel.setAlgoVersion(item.getDeviceId() == null || item.getDeviceId() == 0 || StringUtils.isEmpty((CharSequence)item.getAlgoVersion()) ? "" : item.getAlgoVersion());
                resultModel.setServiceList(new ArrayList());
                algoServiceList.add(resultModel);
            }
            resultModel = (GetMyAlgoByDeviceListVo)algoServiceList.get(0);
            resultModel.setServiceList(algoServiceList.stream().skip(1L).collect(Collectors.toList()));
            result.add(resultModel);
        }
        result = result.stream().sorted(Comparator.comparing(GetMyAlgoByDeviceListVo::getAlgoCode)).collect(Collectors.toList());
        return Response.Builder.call().success(result).build();
    }

    @Override
    public Response<List<BindResultInfoVo>> bindDevice(String ticket, DeviceBindAlgoBo request) {
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), MessageUtils.getMessage("code_param_des_fail"), MessageUtils.getMessage("code_fail")).build();
        }
        ImmutablePair<List<String>, DeviceAlgoRelationInfoDao> baseInfo = this.getAlgoCode(request.getModelId(), request.getAlgoId(), request.getAlgoIdList(), request.getAlgoCode(), request.getId());
        if (CollectionUtils.isEmpty((Collection)((Collection)baseInfo.getLeft()))) {
            return Response.Builder.call().error(Integer.valueOf(1006), MessageUtils.getMessage("code_algo_lack"), MessageUtils.getMessage("code_fail")).build();
        }
        if (CollectionUtils.isEmpty((Collection)request.getDeviceInfos())) {
            return Response.Builder.call().error(Integer.valueOf(1007), MessageUtils.getMessage("code_device_lack"), MessageUtils.getMessage("code_fail")).build();
        }
        OvoparkUserInfoEntity userInfo = this.commonUtil.getUserInfo(ticket);
        if (userInfo == null) {
            return Response.Builder.call().error(Integer.valueOf(1008), MessageUtils.getMessage("code_token_invalid"), MessageUtils.getMessage("code_fail")).build();
        }
        userInfo.setGroupId(this.commonUtil.getGroupId(ticket, userInfo, request.getGroupId()));
        if (userInfo.getGroupId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1012), MessageUtils.getMessage("code_fail_enterprise_info"), MessageUtils.getMessage("code_fail")).build();
        }
        if (!this.commonClientService.isHaveAlgoCodePermission(userInfo.getGroupId(), String.join((CharSequence)",", (Iterable)baseInfo.getLeft())).booleanValue()) {
            return Response.Builder.call().error(Integer.valueOf(1013), MessageUtils.getMessage("code_right_clos"), MessageUtils.getMessage("code_fail")).build();
        }
        List<BindResultInfoVo> infoList = this.setDeviceAlgo(ticket, userInfo, request.getDeviceInfos(), (DeviceAlgoRelationInfoDao)baseInfo.getRight(), (List)baseInfo.getLeft(), request.getDetectTimeList(), request.getIsAsync());
        return Response.Builder.call().success(infoList, MessageUtils.getMessage("code_success")).build();
    }

    private ImmutablePair<List<Integer>, DeviceAlgoRelationInfoDao> getAlgoIds(Integer modelId, Integer algoId, List<Integer> algoIds, Integer serviceId) {
        List<Object> ids = new ArrayList<Integer>();
        DeviceAlgoRelationInfoDao relationInfo = null;
        if (modelId != null) {
            AlgoModelInfoDao model = (AlgoModelInfoDao)this.algoModelInfoMapper.selectById((Serializable)modelId);
            if (model != null) {
                ids.add(model.getGoodsId());
            }
        } else if (algoId != null) {
            ids.add(algoId);
        } else if (CollectionUtils.isNotEmpty(algoIds)) {
            ids.addAll(algoIds);
        }
        if (serviceId != null && (relationInfo = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectById((Serializable)serviceId)) != null) {
            List list;
            if (StringUtils.isEmpty((CharSequence)relationInfo.getAlgoCode()) && (list = this.algoVersionInfoMapper.getModelByGoodId(Arrays.asList(Integer.valueOf(relationInfo.getAlgoId())))) != null && !list.isEmpty()) {
                relationInfo.setAlgoCode(((GetCodeListEntity)list.get(0)).getAlgoCode());
            }
            ids.add(Integer.valueOf(relationInfo.getAlgoId()));
        }
        ids = ids.stream().distinct().collect(Collectors.toList());
        return ImmutablePair.of(ids, (Object)relationInfo);
    }

    private ImmutablePair<List<String>, DeviceAlgoRelationInfoDao> getAlgoCode(Integer modelId, Integer algoId, List<Integer> algoIds, String algoCode, Integer serviceId) {
        AlgoModelInfoDao model;
        List<Object> ids = new ArrayList<String>();
        DeviceAlgoRelationInfoDao relationInfo = null;
        if (StringUtils.isNotEmpty((CharSequence)algoCode)) {
            ids.add(algoCode);
        }
        ArrayList<Integer> algoIdList = new ArrayList<Integer>();
        if (algoId != null) {
            algoIdList.add(algoId);
        }
        if (algoIds != null) {
            algoIdList.addAll(algoIds);
        }
        if (modelId != null && (model = (AlgoModelInfoDao)this.algoModelInfoMapper.selectById((Serializable)modelId)) != null) {
            algoIdList.add(model.getGoodsId());
        }
        if (!algoIdList.isEmpty()) {
            List<String> tempCode = this.commonClientService.getAlgoCodeByOther(algoIdList, null);
            ids.addAll(tempCode);
        }
        if (serviceId != null && (relationInfo = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectById((Serializable)serviceId)) != null) {
            List list;
            if (StringUtils.isEmpty((CharSequence)relationInfo.getAlgoCode()) && (list = this.algoVersionInfoMapper.getModelByGoodId(Arrays.asList(Integer.valueOf(relationInfo.getAlgoId())))) != null && !list.isEmpty()) {
                relationInfo.setAlgoCode(((GetCodeListEntity)list.get(0)).getAlgoCode());
            }
            ids.add(relationInfo.getAlgoCode());
        }
        ids = ids.stream().distinct().collect(Collectors.toList());
        return ImmutablePair.of(ids, (Object)relationInfo);
    }

    private List<BindResultInfoVo> setDeviceAlgo(String ticket, OvoparkUserInfoEntity userInfo, List<SetDeviceInfoEntity> deviceInfoList, DeviceAlgoRelationInfoDao relationInfo, List<String> algoCodeList, List<DetectTimeListEntity> detectTimeList, Integer isAsync) {
        ArrayList<BindResultInfoVo> resultInfoList = new ArrayList<BindResultInfoVo>();
        BindResultInfoVo msg = new BindResultInfoVo();
        ArrayList<DeviceAlgoConfigEntity> configList = new ArrayList<DeviceAlgoConfigEntity>();
        DeviceAlgoConfigEntity configModel = new DeviceAlgoConfigEntity();
        ArrayList<DeviceAlgoRelationInfoDao> serviceList = new ArrayList<DeviceAlgoRelationInfoDao>();
        GetDeviceSupportAlgoCodeListBo params = new GetDeviceSupportAlgoCodeListBo();
        params.setDeviceStatusIdList(deviceInfoList.stream().map(m -> m.getDevId()).collect(Collectors.toList()));
        SnapshotAlgoQueryBatch queryBatchList = new SnapshotAlgoQueryBatch();
        ArrayList<SnapshotAlgoQuery> algoQueryList = new ArrayList<SnapshotAlgoQuery>();
        List deviceTypeList = deviceInfoList.stream().map(SetDeviceInfoEntity::getDeviceType).distinct().collect(Collectors.toList());
        HashSet<String> markCode = new HashSet<String>();
        for (String type : deviceTypeList) {
            String mark = DeployTypeEnum.getNameByDevice((String)type);
            if (!StringUtils.isNotEmpty((CharSequence)mark)) continue;
            markCode.add(mark);
        }
        if (!markCode.isEmpty()) {
            algoCodeList = algoCodeList.stream().filter(item -> markCode.contains(item.substring(1, 4))).collect(Collectors.toList());
        }
        for (String code : algoCodeList) {
            SnapshotAlgoQuery query = new SnapshotAlgoQuery();
            if (userInfo != null && userInfo.getGroupId() != null) {
                query.setEnterpriseId(Long.valueOf(userInfo.getGroupId().intValue()));
            }
            query.setAlgoCode(code);
            algoQueryList.add(query);
        }
        queryBatchList.setList(algoQueryList);
        List<ModelDetailEntity> modelList = this.commonClientService.getModelDetailByAlgoCode(queryBatchList);
        Map<String, ModelDetailEntity> modelMap = modelList.stream().collect(Collectors.toMap(ModelDetailEntity::getAlgoCode, item -> item));
        List<GetSupportModelListEntity> deviceModelSupportList = this.commonClientService.getSupportModelList(ticket, params);
        for (SetDeviceInfoEntity deviceInfo : deviceInfoList) {
            Response<List<AlgoCodeModel>> response;
            msg = new BindResultInfoVo();
            msg.setIsSuccess(Integer.valueOf(0));
            msg.setDevId(deviceInfo.getDevId());
            msg.setMac(deviceInfo.getMac());
            List deviceSupportList = deviceModelSupportList.stream().filter(m -> m.getDeviceStatusId().compareTo(deviceInfo.getDevId()) == 0).collect(Collectors.toList());
            RealGG devResponse = this.deviceClientService.getDeviceByMac(ticket, deviceInfo.getMac(), Integer.valueOf(1));
            if (!(devResponse != null && devResponse.getCode() == 0 && devResponse.getData() != null || (devResponse = this.deviceClientService.getDeviceByMac(ticket, deviceInfo.getMac(), Integer.valueOf(0))) != null && devResponse.getCode() == 0 && devResponse.getData() != null)) {
                msg.setError(devResponse != null && StringUtils.isNotEmpty((CharSequence)devResponse.getCodename()) ? devResponse.getCodename() : MessageUtils.getMessage("code_device_not_online"));
                resultInfoList.add(msg);
                continue;
            }
            DeviceStatusPojo devInfo = (DeviceStatusPojo)devResponse.getData();
            log.info("\u7ed1\u5b9a\u8bbe\u5907\uff1a{}", (Object)devInfo.toString());
            serviceList = new ArrayList();
            configList = new ArrayList();
            for (String algoCode : algoCodeList) {
                AlgoRightVersionInfoDao algoRightVersionInfoDao;
                GetSupportModelListEntity deviceSupport;
                DeviceAlgoRelationInfoDao model = null;
                LambdaQueryWrapper queryWrapper = new LambdaQueryWrapper();
                if (relationInfo == null) {
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoCode, (Object)algoCode);
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getOrderType, (Object)OrderTypeEnum.Alone.getCode());
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getGroupId, (Object)userInfo.getGroupId());
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)0);
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
                    queryWrapper.and(wrapper -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(DeviceAlgoRelationInfoDao::getExpire)).or()).ge(DeviceAlgoRelationInfoDao::getExpire, (Object)this.format.format(new Date()));
                    });
                    queryWrapper.last(String.format(" order by device_id desc,IF(ISNULL(expire),0,1) desc,expire asc limit 1", new Object[0]));
                    model = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectOne((Wrapper)queryWrapper);
                } else {
                    model = relationInfo;
                }
                List models = modelList.stream().filter(m -> m.getAlgoCode().compareTo(algoCode) == 0).collect(Collectors.toList());
                if (model == null && CollectionUtils.isNotEmpty(models)) {
                    model = this.commonClientService.getDeviceAlgoCodeRelationInfoDao(userInfo, null, ((ModelDetailEntity)models.get(0)).getAlgoCode(), ((ModelDetailEntity)models.get(0)).getBusinessType(), RowStatusEnum.Valid.getCode());
                }
                if (model == null) {
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoCode, (Object)algoCode);
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getOrderType, (Object)OrderTypeEnum.Alone.getCode());
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getGroupId, (Object)userInfo.getGroupId());
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)deviceInfo.getDevId());
                    queryWrapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
                    queryWrapper.and(wrapper -> {
                        LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(DeviceAlgoRelationInfoDao::getExpire)).or()).ge(DeviceAlgoRelationInfoDao::getExpire, (Object)this.format.format(new Date()));
                    });
                    queryWrapper.last(String.format(" limit 1 ", new Object[0]));
                    model = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectOne((Wrapper)queryWrapper);
                }
                if (model == null) {
                    msg.setError(MessageUtils.getMessage("code_algo_service_num_lack"));
                    resultInfoList.add(msg);
                    continue;
                }
                model.setDeviceId(deviceInfo.getDevId());
                model.setDeviceName(deviceInfo.getName());
                model.setMac(deviceInfo.getMac());
                model.setImg(deviceInfo.getImg());
                if (model.getGroupId().compareTo(devInfo.getGroupId()) != 0) {
                    msg.setError(MessageUtils.getMessage("code_enterprise_error"));
                    resultInfoList.add(msg);
                    continue;
                }
                DeviceAlgoRelationInfoDao finalModel = model;
                List<Object> modelSupportList = new ArrayList();
                if (CollectionUtils.isEmpty(deviceSupportList) && model.getAlgoType().compareTo(AlgoTypeEnum.Hardware.getCode()) == 0) {
                    msg.setError(MessageUtils.getMessage("code_device_algo_blank"));
                    resultInfoList.add(msg);
                    continue;
                }
                if (CollectionUtils.isNotEmpty(deviceSupportList) && CollectionUtils.isEmpty(modelSupportList = (deviceSupport = (GetSupportModelListEntity)deviceSupportList.get(0)).getModelSupportList().stream().filter(m -> m.getAlgoCode().compareTo(finalModel.getAlgoCode()) == 0).collect(Collectors.toList())) && model.getAlgoType().compareTo(AlgoTypeEnum.Hardware.getCode()) == 0) {
                    msg.setError(MessageUtils.getMessage("code_device_not_support_algo"));
                    resultInfoList.add(msg);
                    continue;
                }
                model.setDType(devInfo.getDType());
                model.setDeviceType(devInfo.getDeviceType());
                model.setDepId(devInfo.getDepId());
                model.setDepName(devInfo.getDepName());
                if (!this.commonClientService.removeAlgoFromDevByCode(deviceInfo.getDevId(), model.getAlgoCode(), userInfo, 0).booleanValue()) {
                    msg.setError(MessageUtils.getMessage("code_unbind_algo_fail"));
                    resultInfoList.add(msg);
                    continue;
                }
                if (model.getExpire() == null) {
                    log.info("\u7ed1\u5b9a\u8bbe\u5907\uff0c\u67e5\u8be2\u5929\u6570\uff1a{}", (Object)model);
                    LambdaQueryWrapper wrapper2 = new LambdaQueryWrapper();
                    wrapper2.eq(UserAlgoDao::getOrderId, (Object)model.getOrderId());
                    wrapper2.eq(UserAlgoDao::getAlgoCode, (Object)model.getAlgoCode());
                    wrapper2.eq(UserAlgoDao::getRowStatus, (Object)1);
                    wrapper2.last(" limit 1 ");
                    UserAlgoDao orderInfo = (UserAlgoDao)this.userAlgoMapper.selectOne((Wrapper)wrapper2);
                    log.info("\u7ed1\u5b9a\u8bbe\u5907\uff0c\u67e5\u8be2\u8ba2\u5355\uff1a{}", (Object)orderInfo);
                    if (orderInfo == null || orderInfo.getId() == null) {
                        msg.setError(MessageUtils.getMessage("code_not_find_service_order"));
                        resultInfoList.add(msg);
                        continue;
                    }
                    model.setStartTime(new Date());
                    model.setExpire(this.format.parse(DateUtil.addDays(orderInfo.getDays())));
                }
                if ((algoRightVersionInfoDao = this.algoRightVersionInfoMapper.getNewVersion(algoCode, model.getGroupId())) == null) {
                    msg.setError(MessageUtils.getMessage("code_algo_version_fail"));
                    resultInfoList.add(msg);
                    continue;
                }
                ModelVersionDetailEntity versionModelInfo = new ModelVersionDetailEntity();
                if (CollectionUtils.isNotEmpty((Collection)models) && CollectionUtils.isNotEmpty((Collection)((ModelDetailEntity)models.get(0)).getVersionList())) {
                    String code = ((ModelSupportInfoEntity)modelSupportList.get(0)).getAlgoCode();
                    ModelDetailEntity algoModelInfo = (ModelDetailEntity)(models = models.stream().filter(item -> StringUtils.isNotEmpty((CharSequence)item.getAlgoCode()) && item.getAlgoCode().equals(code)).collect(Collectors.toList())).get(0);
                    List versions = algoModelInfo.getVersionList().stream().filter(item -> item.getVersion().equals(algoRightVersionInfoDao.getVersion())).collect(Collectors.toList());
                    if (CollectionUtils.isNotEmpty(versions)) {
                        versionModelInfo = (ModelVersionDetailEntity)versions.get(0);
                        model.setAlgoVersion(versionModelInfo.getVersion());
                    }
                }
                if (model.getAlgoType().compareTo(AlgoTypeEnum.Hardware.getCode()) == 0 && StringUtils.isEmpty((CharSequence)model.getAlgoVersion())) {
                    msg.setError(MessageUtils.getMessage("code_algo_version_fail"));
                    resultInfoList.add(msg);
                    continue;
                }
                model.setUpdateBy(userInfo.getUserName());
                model.setUpdateTime(new Date());
                log.info("\u83b7\u53d6\u4fe1\u606f\uff1a{}", (Object)models.toString());
                ModelDetailEntity modelDetail = modelMap.get(algoCode);
                if (modelDetail == null) {
                    msg.setError(MessageUtils.getMessage("code_model_not_algo_code"));
                    resultInfoList.add(msg);
                    continue;
                }
                int row = 0;
                row = model.getId() == null ? this.deviceAlgoRelationInfoMapper.insert((Object)model) : this.deviceAlgoRelationInfoMapper.updateById((Object)model);
                if (row < 1) {
                    msg.setError(MessageUtils.getMessage("code_bind_fail"));
                    resultInfoList.add(msg);
                    continue;
                }
                if (model.getAlgoType().compareTo(AlgoTypeEnum.Soft.getCode()) == 0) continue;
                serviceList.add(model);
                configModel = new DeviceAlgoConfigEntity();
                configModel.setModelId(Integer.valueOf(CollectionUtils.isNotEmpty(models) ? ((ModelDetailEntity)models.get(0)).getId() : 0));
                configModel.setModelName(CollectionUtils.isNotEmpty(models) ? ((ModelDetailEntity)models.get(0)).getModelName() : "");
                configModel.setAlgoName(versionModelInfo.getAlgoCode());
                configModel.setModelVersion(versionModelInfo.getVersion());
                configModel.setModelDownloadUrl(versionModelInfo.getAddress());
                configModel.setDetectTimeList(detectTimeList);
                Long fulLife = model.getExpire() != null ? Long.valueOf(Math.abs(model.getExpire().getTime()) / 1000L) : 0L;
                configModel.setUsefulLife(fulLife);
                configList.add(configModel);
            }
            if (!CollectionUtils.isNotEmpty(configList)) continue;
            SetAlgoAlgoActivBo param = new SetAlgoAlgoActivBo();
            param.setDeviceStatusId(devInfo.getId());
            param.setDeviceType(devInfo.getDeviceType());
            param.setConfigList(configList);
            Response<List<AlgoCodeModel>> response2 = response = deviceInfoList.size() > 1 || isAsync == null || isAsync == 1 ? this.commonClientService.setAlgoAlgoActive("", param) : this.commonClientService.setAlgoAlgoActive(ticket, param);
            if (response != null && response.getCode() == 0) continue;
            if (deviceInfoList.size() <= 1) {
                String info = response == null ? "" : String.join((CharSequence)"\uff0c", ((List)response.getData()).stream().map(m -> m.getModelName()).collect(Collectors.toList()));
                msg.setError(String.format("%s" + MessageUtils.getMessage("code_activation_fail"), info));
                resultInfoList.add(msg);
                List idList = ((List)response.getData()).stream().map(m -> m.getModelId()).collect(Collectors.toList());
                for (DeviceAlgoRelationInfoDao model : serviceList) {
                    if (!idList.contains(model.getModelId())) continue;
                    this.commonClientService.removeAlgoFromDevByCode(deviceInfo.getDevId(), model.getAlgoCode(), userInfo, 0);
                }
                continue;
            }
            for (DeviceAlgoRelationInfoDao model : serviceList) {
                SetAlgoListBo request = new SetAlgoListBo();
                request.setServiceId(model.getId());
                Response<String> setAlgoResult = this.newDeviceService.newSetAlgoList(ticket, request);
                if (setAlgoResult != null && setAlgoResult.getCode() == 0) continue;
                this.commonClientService.removeAlgoFromDevByCode(deviceInfo.getDevId(), model.getAlgoCode(), userInfo, 0);
                msg.setError(setAlgoResult == null ? MessageUtils.getMessage("code_bind_device_fail") : setAlgoResult.getCodename());
                resultInfoList.add(msg);
            }
        }
        return resultInfoList;
    }

    private void operate(String authorization, Integer groupId, Integer depId, String deviceType) {
        OperateBo request = new OperateBo();
        request.setEnterpriseId(groupId);
        request.setDeptId(depId);
        request.setDeviceType(deviceType);
        request.setSource(Integer.valueOf(4));
        this.algoClient.operate(authorization, request);
    }

    @Override
    public Response<GetAlgoServiceVo> getAlgoService(String ticket, AlgoManageBo request) {
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), "\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25").build();
        }
        if (StringUtils.isEmpty((CharSequence)request.getOrderSns())) {
            return Response.Builder.call().error(Integer.valueOf(1006), "\u7f3a\u5c11\u7b97\u6cd5\u670d\u52a1\u4fe1\u606f").build();
        }
        if (request.getPageNum() == 0) {
            request.setPageNum(1);
        }
        if (request.getPageSize() == 0) {
            request.setPageSize(10);
        }
        LambdaQueryWrapper algoQuery = new LambdaQueryWrapper();
        if (StringUtils.isEmpty((CharSequence)request.getAlgoCode())) {
            algoQuery.eq(UserAlgoDao::getOrderId, (Object)Integer.valueOf(request.getOrderSns()));
            algoQuery.eq(UserAlgoDao::getAlgoId, (Object)request.getGoodsId());
            algoQuery.eq(UserAlgoDao::getRowStatus, (Object)1);
            algoQuery.last(" limit 1 ");
        } else {
            algoQuery.eq(UserAlgoDao::getOrderId, (Object)Integer.valueOf(request.getOrderSns()));
            algoQuery.eq(UserAlgoDao::getAlgoCode, (Object)request.getAlgoCode());
            algoQuery.eq(UserAlgoDao::getRowStatus, (Object)1);
            algoQuery.last(" limit 1 ");
        }
        UserAlgoDao userAlgo = (UserAlgoDao)this.userAlgoMapper.selectOne((Wrapper)algoQuery);
        if (userAlgo == null || userAlgo.getId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1007), "\u83b7\u53d6\u8ba2\u5355\u4fe1\u606f\u5931\u8d25").build();
        }
        LambdaQueryWrapper query = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)request.getAlgoCode())) {
            query.eq(DeviceAlgoRelationInfoDao::getAlgoCode, (Object)request.getAlgoCode());
        }
        query.eq(DeviceAlgoRelationInfoDao::getGroupId, (Object)userAlgo.getGroupId());
        query.eq(DeviceAlgoRelationInfoDao::getAlgoId, (Object)userAlgo.getAlgoId());
        query.eq(DeviceAlgoRelationInfoDao::getAlgoType, (Object)userAlgo.getAlgoType());
        query.eq(DeviceAlgoRelationInfoDao::getOrderType, (Object)userAlgo.getOrderType());
        query.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)1);
        query.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(DeviceAlgoRelationInfoDao::getExpire)).or()).ge(DeviceAlgoRelationInfoDao::getExpire, (Object)this.format.format(new Date()));
        });
        if (request.getBindStatus() == -1) {
            query.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)0);
        } else if (request.getBindStatus() == 1) {
            query.ne(DeviceAlgoRelationInfoDao::getDeviceId, (Object)0);
        }
        if (request.getExpire() == 1 && request.getSort() == 0) {
            query.last(String.format(" order by expire asc ", new Object[0]));
        } else if (request.getExpire() == 1 && request.getSort() == 1) {
            query.last(String.format(" order by expire desc ", new Object[0]));
        } else if (request.getBuyTime() == 1 && request.getSort() == 0) {
            query.last(String.format(" order by create_time asc ", new Object[0]));
        } else if (request.getBuyTime() == 1 && request.getSort() == 1) {
            query.last(String.format(" order by create_time desc ", new Object[0]));
        } else {
            query.last(String.format(" order by IF(ISNULL(expire)!=1 and expire <= '%s',1,0) desc,IF(device_id=0,1,0) desc,IF(ISNULL(expire),1,0) asc,expire asc", DateUtil.addDays(7)));
        }
        Page pageInfo = new Page((long)request.getPageNum(), (long)request.getPageSize());
        IPage resultInfo = this.deviceAlgoRelationInfoMapper.selectPage((IPage)pageInfo, (Wrapper)query);
        ArrayList<GetAlgoServiceEntity> list = new ArrayList<GetAlgoServiceEntity>();
        String token = this.commonUtil.getToken(ticket);
        if (resultInfo != null && CollectionUtils.isNotEmpty((Collection)resultInfo.getRecords())) {
            GetAlgoServiceEntity model = new GetAlgoServiceEntity();
            for (DeviceAlgoRelationInfoDao item : resultInfo.getRecords()) {
                List skus;
                model = new GetAlgoServiceEntity();
                model.setOrderId(item.getOrderId());
                model.setOrderSn(item.getOrderId().toString());
                model.setBindInfoId(item.getId().intValue());
                model.setExpire(item.getExpire() == null ? "" : this.format.format(item.getExpire()));
                model.setDeviceId(item.getDeviceId().intValue());
                model.setDeviceName(item.getDeviceName());
                model.setName(item.getDeviceName());
                model.setMac(item.getMac());
                model.setDeviceImg(item.getImg());
                model.setDType(item.getDType().intValue());
                model.setDepId(item.getDepId().intValue());
                model.setDepName(item.getDepName());
                model.setIsPackage(item.getOrderType().intValue());
                model.setBuyTime(this.format.format(item.getCreateTime()));
                model.setIsBind(item.getDeviceId() == 0 ? 0 : 1);
                model.setVersion(StringUtils.isEmpty((CharSequence)item.getAlgoVersion()) ? "--" : item.getAlgoVersion());
                AlgoModelInfoDao algoModelInfo = (AlgoModelInfoDao)this.algoModelInfoMapper.selectById((Serializable)item.getModelId());
                if (algoModelInfo != null) {
                    model.setImg(algoModelInfo.getIcon());
                    model.setIsGoods(algoModelInfo.getIsGoods());
                }
                model.setGoodsId(algoModelInfo.getGoodsId());
                model.setAlgoId(algoModelInfo.getGoodsId().intValue());
                model.setAlgoName(algoModelInfo.getModelName());
                model.setGoodsName(algoModelInfo.getModelName());
                model.setTitle(algoModelInfo.getModelName());
                if (model.getIsGoods() == null || model.getIsGoods().compareTo(0) == 0) {
                    list.add(model);
                    continue;
                }
                List<GetSkuListVo> skuList = this.commonClientService.getSkuList(token, Integer.valueOf(item.getAlgoId()));
                if (CollectionUtils.isNotEmpty(skuList) && CollectionUtils.isNotEmpty(skus = skuList.stream().filter(m -> item.getSkuId().compareTo(m.getGoodsSkuId()) == 0).collect(Collectors.toList()))) {
                    GetSkuListVo skuDetail = (GetSkuListVo)skus.get(0);
                    model.setGoodsSkuId(Integer.valueOf(skuDetail.getGoodsSkuId()));
                    model.setPrice(skuDetail.getPrice());
                    model.setMethod(skuDetail.getSpec());
                }
                list.add(model);
            }
        }
        GetAlgoServiceVo result = new GetAlgoServiceVo();
        result.setCount(resultInfo.getTotal());
        result.setPageNumber(request.getPageNum());
        result.setPageSize(request.getPageSize());
        if (userAlgo.getOrderType().compareTo(0) == 0) {
            result.setMyAlgoListVoList(list);
        } else {
            result.setMyAlgoPackageList(list);
        }
        LambdaQueryWrapper unBingNumWrapper = new LambdaQueryWrapper();
        unBingNumWrapper.eq(DeviceAlgoRelationInfoDao::getGroupId, (Object)userAlgo.getGroupId());
        if (StringUtils.isNotEmpty((CharSequence)request.getAlgoCode())) {
            unBingNumWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoCode, (Object)request.getAlgoCode());
        }
        unBingNumWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoId, (Object)userAlgo.getAlgoId());
        unBingNumWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoType, (Object)userAlgo.getAlgoType());
        unBingNumWrapper.eq(DeviceAlgoRelationInfoDao::getOrderType, (Object)userAlgo.getOrderType());
        unBingNumWrapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)1);
        unBingNumWrapper.and(wrapper -> {
            LambdaQueryWrapper cfr_ignored_0 = (LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)wrapper.isNull(DeviceAlgoRelationInfoDao::getExpire)).or()).ge(DeviceAlgoRelationInfoDao::getExpire, (Object)this.format.format(new Date()));
        });
        unBingNumWrapper.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)0);
        Long unBingNum = this.deviceAlgoRelationInfoMapper.selectCount((Wrapper)unBingNumWrapper);
        result.setUnBindNum(unBingNum.longValue());
        LambdaQueryWrapper overdueNumWrapper = new LambdaQueryWrapper();
        if (StringUtils.isNotEmpty((CharSequence)request.getAlgoCode())) {
            overdueNumWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoCode, (Object)request.getAlgoCode());
        }
        overdueNumWrapper.eq(DeviceAlgoRelationInfoDao::getGroupId, (Object)userAlgo.getGroupId());
        overdueNumWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoId, (Object)userAlgo.getAlgoId());
        overdueNumWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoType, (Object)userAlgo.getAlgoType());
        overdueNumWrapper.eq(DeviceAlgoRelationInfoDao::getOrderType, (Object)userAlgo.getOrderType());
        overdueNumWrapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)1);
        overdueNumWrapper.ge(DeviceAlgoRelationInfoDao::getExpire, (Object)this.format.format(new Date()));
        overdueNumWrapper.le(DeviceAlgoRelationInfoDao::getExpire, (Object)DateUtil.addDays(7));
        overdueNumWrapper.isNotNull(DeviceAlgoRelationInfoDao::getExpire);
        Long overdueNum = this.deviceAlgoRelationInfoMapper.selectCount((Wrapper)overdueNumWrapper);
        result.setOverdueNum(overdueNum.longValue());
        result.setPlatform(StringUtils.isNotEmpty((CharSequence)request.getAlgoCode()) ? AlgoMarkEnum.getByCode((String)request.getAlgoCode().substring(1, 4)) : "");
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<IPage<GetDeviceAlgoRelationInfoVo>> getDeviceAlgoRelationInfo(String ticket, GetDeviceAlgoRelationInfoBo request) {
        Integer groupId;
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25").build();
        }
        if (request.getPageNumber() == null) {
            request.setPageNumber(Integer.valueOf(1));
        }
        if (request.getPageSize() == null) {
            request.setPageSize(Integer.valueOf(10));
        }
        if ((groupId = this.commonUtil.getGroupId(ticket, null, request.getGroupId())) == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u672a\u80fd\u83b7\u53d6\u5230\u4f01\u4e1a\u4fe1\u606f").build();
        }
        Page result = new Page();
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(DeviceAlgoRelationInfoDao::getGroupId, (Object)groupId);
        wrapper.eq(DeviceAlgoRelationInfoDao::getAlgoType, (Object)AlgoTypeEnum.Soft.getCode());
        wrapper.ne(DeviceAlgoRelationInfoDao::getDeviceId, (Object)0);
        wrapper.ge(DeviceAlgoRelationInfoDao::getExpire, (Object)this.format.format(new Date()));
        wrapper.eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
        Page pageInfo = new Page((long)request.getPageNumber().intValue(), (long)request.getPageSize().intValue());
        IPage resultInfo = this.deviceAlgoRelationInfoMapper.selectPage((IPage)pageInfo, (Wrapper)wrapper);
        if (resultInfo == null || CollectionUtils.isEmpty((Collection)resultInfo.getRecords())) {
            return Response.Builder.call().success((Object)result).build();
        }
        List<Integer> modelIds = resultInfo.getRecords().stream().map(m -> m.getModelId()).collect(Collectors.toList());
        List<ModelDetailEntity> modelList = this.commonClientService.getModelDetail(null, modelIds, null, 0);
        ArrayList<GetDeviceAlgoRelationInfoVo> list = new ArrayList<GetDeviceAlgoRelationInfoVo>();
        GetDeviceAlgoRelationInfoVo model = new GetDeviceAlgoRelationInfoVo();
        ArrayList<DeviceAlgoEntity> algoList = new ArrayList<DeviceAlgoEntity>();
        DeviceAlgoEntity algoModel = new DeviceAlgoEntity();
        for (DeviceAlgoRelationInfoDao item : resultInfo.getRecords()) {
            model = new GetDeviceAlgoRelationInfoVo();
            algoList = new ArrayList();
            model.setId(item.getId());
            model.setGroupId(item.getGroupId());
            model.setOrderType(item.getOrderType());
            model.setDeviceId(item.getDeviceId());
            model.setMac(item.getMac());
            model.setAlgoVersion(item.getAlgoVersion());
            model.setExpire(this.format.format(item.getExpire()));
            List idInfos = Arrays.asList(item.getAlgoId().split(",")).stream().map(m -> Integer.valueOf(m)).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(modelList)) {
                List details = modelList.stream().filter(m -> idInfos.contains(m.getGoodsId())).collect(Collectors.toList());
                if (CollectionUtils.isEmpty(details)) {
                    model.setAlgoList(new ArrayList());
                    list.add(model);
                }
                for (ModelDetailEntity detail : details) {
                    algoModel = new DeviceAlgoEntity();
                    algoModel.setDeviceAlgoName(detail.getModelEnglishName());
                    algoModel.setDeviceAlgoType(detail.getDeviceType());
                    algoList.add(algoModel);
                }
                model.setAlgoList(algoList);
            }
            list.add(model);
        }
        result.setTotal(resultInfo.getTotal());
        result.setPages(resultInfo.getPages());
        result.setSize(resultInfo.getSize());
        result.setCurrent(resultInfo.getCurrent());
        result.setRecords(list);
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<List<GetAllAlgoServiceListVo>> getAllAlgoServiceList(String ticket, GetAllAlgoServiceListBo request) {
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25").build();
        }
        if ((request.getGroupId() == null || request.getGroupId().compareTo(0) == 0) && CollectionUtils.isEmpty((Collection)request.getDepIds())) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u7f3a\u5c11\u4f01\u4e1a\u6216\u8005\u95e8\u5e97\u4fe1\u606f").build();
        }
        List list = this.deviceAlgoRelationInfoMapper.getAlgoServiceModelList(request.getGroupId(), request.getModelAlgoType(), this.format.parse(this.format.format(new Date())), request.getCheckType(), request.getDepIds());
        ArrayList<GetAllAlgoServiceListVo> result = new ArrayList<GetAllAlgoServiceListVo>();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Response.Builder.call().success(result).build();
        }
        GetAllAlgoServiceListVo model = new GetAllAlgoServiceListVo();
        for (GetAlgoServiceModelListEntity item : list) {
            model = new GetAllAlgoServiceListVo();
            model.setServiceId(item.getAiModelId());
            model.setModelId(item.getId());
            model.setServiceName(item.getModelName());
            model.setCheckType(item.getCheckType());
            model.setModelType(item.getModelType());
            model.setModelAlgoType(item.getModelAlgoType());
            model.setImageUrl(item.getBackgroundImg());
            model.setIconUrl(item.getIcon());
            result.add(model);
        }
        return Response.Builder.call().success(result).build();
    }

    @Override
    public Response unbindingDevice(String token, UnbindingDeviceBo request) {
        if (request == null || request.getId() == null || request.getId().compareTo(0) == 0) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u672a\u80fd\u83b7\u53d6\u5230\u7b97\u6cd5\u670d\u52a1\u4fe1\u606f").build();
        }
        OvoparkUserInfoEntity userInfo = this.commonUtil.getUserInfo(token);
        if (userInfo == null) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u83b7\u53d6\u7528\u6237\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u767b\u5f55").build();
        }
        DeviceAlgoRelationInfoDao model = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectById((Serializable)request.getId());
        if (model == null || model.getId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), "\u672a\u80fd\u83b7\u53d6\u5230\u7b97\u6cd5\u670d\u52a1\u4fe1\u606f").build();
        }
        if (model.getDeviceId() == 0) {
            return Response.Builder.call().success().build();
        }
        Boolean removeResult = true;
        removeResult = StringUtils.isNotEmpty((CharSequence)model.getAlgoCode()) ? this.commonClientService.removeAlgoFromDevByCode(model.getDeviceId(), model.getAlgoCode(), userInfo, 1) : this.commonClientService.removeAlgoFromDev(model.getDeviceId(), Integer.valueOf(model.getAlgoId()), userInfo, 1);
        if (!removeResult.booleanValue()) {
            return Response.Builder.call().error(Integer.valueOf(1006), "\u89e3\u7ed1\u8bbe\u5907\u7b97\u6cd5\u4fe1\u606f\u5931\u8d25").build();
        }
        return Response.Builder.call().success().build();
    }
}

