/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.service.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.open.feign.DeviceAlgoFeignClient;
import com.ovopark.open.paasclient.AiOpenClient;
import com.ovopark.open.paasclient.AlgoClient;
import com.ovopark.open.paasclient.DeviceClient;
import com.ovopark.open.paasclient.OlucClient;
import com.ovopark.open.service.DeviceClientService;
import com.ovopark.paas.api.constant.AlgoTypeEnum;
import com.ovopark.paas.api.constant.BusinessTypeEnum;
import com.ovopark.paas.api.constant.CategoryNameEnum;
import com.ovopark.paas.api.constant.CheckTypeEnum;
import com.ovopark.paas.api.constant.DeviceConstant;
import com.ovopark.paas.api.constant.OnlineStatusEnum;
import com.ovopark.paas.api.constant.RowStatusEnum;
import com.ovopark.paas.api.entity.AlgoCustomParamsEntity;
import com.ovopark.paas.api.entity.AlgoDetailConfigsEntity;
import com.ovopark.paas.api.entity.AlgoLabelEntity;
import com.ovopark.paas.api.entity.AlgoStatusEntity;
import com.ovopark.paas.api.entity.DeviceAlgoConfigEntity;
import com.ovopark.paas.api.entity.DeviceAlgoStatusEntity;
import com.ovopark.paas.api.entity.DeviceCustomParamsEntity;
import com.ovopark.paas.api.entity.EnterpriseGroupEntity;
import com.ovopark.paas.api.entity.GetCodeListEntity;
import com.ovopark.paas.api.entity.GetSupportModelListEntity;
import com.ovopark.paas.api.entity.HttpResponseEntity;
import com.ovopark.paas.api.entity.ModelDetailEntity;
import com.ovopark.paas.api.entity.ModelSupportInfoEntity;
import com.ovopark.paas.api.entity.ModelVersionDetailEntity;
import com.ovopark.paas.api.entity.OlucPage;
import com.ovopark.paas.api.entity.PaasModelInfoEntity;
import com.ovopark.paas.api.entity.RealGG;
import com.ovopark.paas.api.entity.Response;
import com.ovopark.paas.api.entity.TimerListEntity;
import com.ovopark.paas.api.entity.bo.AddAlgoTaskBo;
import com.ovopark.paas.api.entity.bo.AddServeEnterpriseBo;
import com.ovopark.paas.api.entity.bo.GetDeviceSupportAlgoCodeListBo;
import com.ovopark.paas.api.entity.bo.GetGoodsListBo;
import com.ovopark.paas.api.entity.bo.ServeEnterpriseAcEntity;
import com.ovopark.paas.api.entity.bo.SetAlgoAlgoActivBo;
import com.ovopark.paas.api.entity.dao.AlgoModelInfoDao;
import com.ovopark.paas.api.entity.dao.AlgoRightInfoDao;
import com.ovopark.paas.api.entity.dao.AlgoRightVersionInfoDao;
import com.ovopark.paas.api.entity.dao.AlgoVersionInfoDao;
import com.ovopark.paas.api.entity.dao.DeviceAlgoRelationInfoDao;
import com.ovopark.paas.api.entity.dao.UpgradeRecordDao;
import com.ovopark.paas.api.entity.dao.UserAlgoDao;
import com.ovopark.paas.api.entity.dto.AlgoSnapshotDTO;
import com.ovopark.paas.api.entity.dto.GetDeviceStatusPaasOpenVoByIdDTO;
import com.ovopark.paas.api.entity.model.AlgoAlgoActiveModel;
import com.ovopark.paas.api.entity.model.AlgoCodeModel;
import com.ovopark.paas.api.entity.model.GetDeviceAlgoStatusFromDevModel;
import com.ovopark.paas.api.entity.query.SnapshotAlgoQuery;
import com.ovopark.paas.api.entity.query.SnapshotAlgoQueryBatch;
import com.ovopark.paas.api.entity.vo.GetAlgoAlgoConfigVo;
import com.ovopark.paas.api.entity.vo.GetDeviceAlgoSupportListVo;
import com.ovopark.paas.api.entity.vo.GetDeviceSupportAlgoCodeListVo;
import com.ovopark.paas.api.entity.vo.GetGoodsDetailVo;
import com.ovopark.paas.api.entity.vo.GetGoodsListVo;
import com.ovopark.paas.api.entity.vo.GetSkuListVo;
import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import com.ovopark.paas.api.entity.vo.PaasDeviceTaskVO;
import com.ovopark.paas.api.exception.OpenPaasException;
import com.ovopark.paas.core.service.CommonClientService;
import com.ovopark.paas.core.utils.CommonUtil;
import com.ovopark.paas.core.utils.MessageUtils;
import com.ovopark.paas.core.utils.ThreadPoolTaskUtils;
import com.ovopark.paas.repository.paas.mapper.AlgoModelInfoMapper;
import com.ovopark.paas.repository.paas.mapper.AlgoRightInfoMapper;
import com.ovopark.paas.repository.paas.mapper.AlgoRightVersionInfoMapper;
import com.ovopark.paas.repository.paas.mapper.AlgoVersionInfoMapper;
import com.ovopark.paas.repository.paas.mapper.DeviceAlgoRelationInfoMapper;
import com.ovopark.paas.repository.paas.mapper.UpgradeRecordMapper;
import com.ovopark.paas.repository.paas.mapper.UserAlgoMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.time.Duration;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Executor;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.kafka.core.KafkaTemplate;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.util.StopWatch;

@Service
@RefreshScope
public class CommonClientServiceImpl
implements CommonClientService {
    private static final Logger logger = LoggerFactory.getLogger(CommonClientServiceImpl.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private OlucClient olucClient;
    @Autowired
    private DeviceClientService deviceClientService;
    @Autowired
    private DeviceAlgoFeignClient deviceAlgoFeignClient;
    @Autowired(required=false)
    private DeviceClient deviceClient;
    @Autowired(required=false)
    private AlgoClient algoClient;
    @Autowired
    private CommonUtil commonUtil;
    @Autowired(required=false)
    private AlgoModelInfoMapper algoModelInfoMapper;
    @Autowired(required=false)
    private AlgoVersionInfoMapper algoVersionInfoMapper;
    @Autowired(required=false)
    private AlgoRightInfoMapper algoRightInfoMapper;
    @Autowired(required=false)
    private DeviceAlgoRelationInfoMapper deviceAlgoRelationInfoMapper;
    @Autowired(required=false)
    private UpgradeRecordMapper upgradeRecordMapper;
    @Autowired(required=false)
    private UserAlgoMapper userAlgoMapper;
    @Autowired
    private ThreadPoolTaskUtils threadPoolTaskUtils;
    @Autowired
    private KafkaTemplate<String, String> commonKafkaTemplate;
    @Value(value="${storeId}")
    private Integer storeId;
    @Value(value="${aiDeviceDelTopic}")
    private String aiTopic;
    @Autowired
    private AiOpenClient aiOpenClient;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
    @Autowired
    private AlgoRightVersionInfoMapper algoRightVersionInfoMapper;

    @Override
    public List<GetSupportModelListEntity> getSupportModelList(String token, GetDeviceSupportAlgoCodeListBo request) {
        if (request == null || CollectionUtils.isEmpty((Collection)request.getDeviceStatusIdList())) {
            return new ArrayList<GetSupportModelListEntity>();
        }
        List<GetDeviceAlgoStatusFromDevModel> result = this.getDeviceAlgoStatusFromDev(token, request.getDeviceStatusIdList());
        if (CollectionUtils.isEmpty(result)) {
            return new ArrayList<GetSupportModelListEntity>();
        }
        ArrayList<GetSupportModelListEntity> response = new ArrayList<GetSupportModelListEntity>();
        GetSupportModelListEntity model = new GetSupportModelListEntity();
        ArrayList<ModelSupportInfoEntity> ModelSupportList = new ArrayList<ModelSupportInfoEntity>();
        ModelSupportInfoEntity supportModel = new ModelSupportInfoEntity();
        for (GetDeviceAlgoStatusFromDevModel item : result) {
            model = new GetSupportModelListEntity();
            ModelSupportList = new ArrayList();
            model.setDeviceStatusId(item.getDeviceStatusId());
            model.setModelSupportList(ModelSupportList);
            for (AlgoStatusEntity info : item.getAlgoStatusList()) {
                supportModel = new ModelSupportInfoEntity();
                supportModel.setModelId(info.getModelId());
                supportModel.setAlgoCode(info.getAlgoName());
                ModelSupportList.add(supportModel);
            }
            model.setModelSupportList(ModelSupportList);
            response.add(model);
        }
        return response;
    }

    @Override
    public List<GetDeviceAlgoStatusFromDevModel> getDeviceAlgoFromDMS(String token, List<Integer> deviceStatusIdList) {
        GetDeviceSupportAlgoCodeListBo params = new GetDeviceSupportAlgoCodeListBo();
        params.setDeviceStatusIdList(deviceStatusIdList);
        HttpResponseEntity res = this.deviceAlgoFeignClient.getDeviceSupportAlgoCodeList(token, params);
        if (res == null || res.getCode() != 0 || CollectionUtils.isEmpty((Collection)((Collection)res.getData()))) {
            return new ArrayList<GetDeviceAlgoStatusFromDevModel>();
        }
        ArrayList<GetDeviceAlgoStatusFromDevModel> result = new ArrayList<GetDeviceAlgoStatusFromDevModel>();
        GetDeviceAlgoStatusFromDevModel model = new GetDeviceAlgoStatusFromDevModel();
        ArrayList<AlgoStatusEntity> algoStatusList = new ArrayList<AlgoStatusEntity>();
        AlgoStatusEntity info = new AlgoStatusEntity();
        for (GetDeviceSupportAlgoCodeListVo item : (List)res.getData()) {
            algoStatusList = new ArrayList();
            for (String code : item.getAlgoCodeSupportList()) {
                info = new AlgoStatusEntity();
                info.setAlgoName(code);
                info.setAlgoCode(code);
                algoStatusList.add(info);
            }
            model = new GetDeviceAlgoStatusFromDevModel();
            model.setDeviceStatusId(item.getDeviceStatusId());
            model.setAlgoStatusList(algoStatusList);
            result.add(model);
        }
        return result;
    }

    @Override
    public List<GetDeviceAlgoStatusFromDevModel> getDeviceAlgoStatusFromDev(String token, List<Integer> deviceStatusIdList) {
        StopWatch sw = new StopWatch("getDeviceAlgoStatusFromDev");
        sw.start();
        ArrayList<GetDeviceAlgoStatusFromDevModel> res = new ArrayList<GetDeviceAlgoStatusFromDevModel>();
        ArrayList<CompletableFuture<GetDeviceAlgoStatusFromDevModel>> taskList = new ArrayList<CompletableFuture<GetDeviceAlgoStatusFromDevModel>>();
        for (Integer n : deviceStatusIdList) {
            CompletableFuture<GetDeviceAlgoStatusFromDevModel> task = CompletableFuture.supplyAsync(() -> {
                try {
                    HttpResponseEntity result = this.deviceAlgoFeignClient.getDeviceAlgoSupportList(token, id);
                    if (result == null || result.getCode() != 0 || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
                        return null;
                    }
                    GetDeviceAlgoStatusFromDevModel model = new GetDeviceAlgoStatusFromDevModel();
                    ArrayList<AlgoStatusEntity> algoStatusList = new ArrayList<AlgoStatusEntity>();
                    AlgoStatusEntity info = new AlgoStatusEntity();
                    for (GetDeviceAlgoSupportListVo item : (List)result.getData()) {
                        info = new AlgoStatusEntity();
                        info.setAlgoName(item.getAlgoName());
                        info.setAlgoCode(item.getAlgoName());
                        info.setDownloadStatus(Integer.valueOf(item.getActivateFlag() == 1 ? 2 : 0));
                        info.setStatus(Integer.valueOf(0));
                        algoStatusList.add(info);
                    }
                    model.setDeviceStatusId(id);
                    model.setAlgoStatusList(algoStatusList);
                    HttpResponseEntity algoDetailResult = this.deviceAlgoFeignClient.getAlgoDetailConfig(token, id);
                    if (algoDetailResult == null || algoDetailResult.getData() == null || ((GetAlgoAlgoConfigVo)algoDetailResult.getData()).getConfig() == null || CollectionUtils.isEmpty((Collection)((GetAlgoAlgoConfigVo)algoDetailResult.getData()).getConfig().getAlgoConfigs())) {
                        return model;
                    }
                    List algoConfigs = ((GetAlgoAlgoConfigVo)algoDetailResult.getData()).getConfig().getAlgoConfigs();
                    for (DeviceAlgoStatusEntity deviceAlgoStatusEntity : algoStatusList) {
                        AlgoDetailConfigsEntity config;
                        List configs = algoConfigs.stream().filter(m -> m.getAlgoName().equals(item.getAlgoName())).collect(Collectors.toList());
                        if (CollectionUtils.isEmpty(configs) || (config = (AlgoDetailConfigsEntity)configs.get(0)).getEnable() != 1 || !CollectionUtils.isNotEmpty((Collection)config.getDetectTimeList())) continue;
                        String time = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH:mm:ss"));
                        List detectTimeList = config.getDetectTimeList().stream().filter(m -> m.getStartTime().compareTo(time) <= 0 && time.compareTo(m.getEndTime()) <= 0).collect(Collectors.toList());
                        if (!CollectionUtils.isNotEmpty(detectTimeList)) continue;
                        deviceAlgoStatusEntity.setStatus(Integer.valueOf(1));
                    }
                    model.setAlgoStatusList(algoStatusList);
                    return model;
                }
                catch (Exception ex) {
                    logger.error(String.format("category\uff1aCommonClientServiceImpl ### subCategory\uff1agetDeviceAlgoStatusFromDev ### \u9519\u8bef\u4fe1\u606f\uff1a%s ### \u9519\u8bef\u6808\uff1a%s", ex.getMessage(), ex.getStackTrace()));
                    return null;
                }
            }, (Executor)this.threadPoolTaskUtils.getThreadPoolTaskExecutor());
            taskList.add(task);
        }
        for (CompletableFuture completableFuture : taskList) {
            GetDeviceAlgoStatusFromDevModel info = (GetDeviceAlgoStatusFromDevModel)completableFuture.join();
            if (info == null) continue;
            res.add(info);
        }
        sw.stop();
        logger.warn(String.format("getDeviceAlgoStatusFromDev\u8017\u65f6 ### \u8bf7\u6c42\u8bbe\u5907\uff1a%s ### \u63a5\u53e3\u8017\u65f6\uff1a%s ", JSONObject.toJSONString(deviceStatusIdList), sw.getLastTaskTimeMillis()));
        return res;
    }

    @Override
    public List<Integer> getDeviceSupportModelIds(String token, Integer deviceStatusId) {
        if (StringUtils.isEmpty((CharSequence)token) || deviceStatusId == null) {
            return new ArrayList<Integer>();
        }
        HttpResponseEntity result = this.deviceAlgoFeignClient.getDeviceAlgoSupportList(token, deviceStatusId);
        if (result == null || result.getCode() != 0 || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return null;
        }
        List codeList = ((List)result.getData()).stream().map(m -> m.getAlgoName()).collect(Collectors.toList());
        List modelIdList = this.algoVersionInfoMapper.getCodeList(codeList);
        if (CollectionUtils.isEmpty((Collection)modelIdList)) {
            return null;
        }
        ArrayList<Integer> resIds = new ArrayList<Integer>();
        for (GetDeviceAlgoSupportListVo item : (List)result.getData()) {
            List modelIds = modelIdList.stream().filter(m -> m.getAlgoCode().equals(item.getAlgoName())).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(modelIds)) continue;
            resIds.add(((GetCodeListEntity)modelIds.get(0)).getModelId());
        }
        return resIds;
    }

    @Override
    public List<String> getDeviceSupportModelCode(String token, Integer deviceStatusId) {
        if (StringUtils.isEmpty((CharSequence)token) || deviceStatusId == null) {
            return new ArrayList<String>();
        }
        HttpResponseEntity result = this.deviceAlgoFeignClient.getDeviceAlgoSupportList(token, deviceStatusId);
        if (result == null || result.getCode() != 0 || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return null;
        }
        return ((List)result.getData()).stream().map(GetDeviceAlgoSupportListVo::getAlgoName).collect(Collectors.toList());
    }

    @Override
    public Boolean isSupportAlgoOrDev(String token, Integer modelId, Integer deviceStatusId) {
        if (StringUtils.isEmpty((CharSequence)token) || modelId == null || deviceStatusId == null) {
            return false;
        }
        List<Integer> modelIds = this.getDeviceSupportModelIds(token, deviceStatusId);
        if (CollectionUtils.isEmpty(modelIds)) {
            return false;
        }
        return modelIds.contains(modelId);
    }

    @Override
    public Boolean isHavePermission(Integer groupId, String algoId) {
        if (StringUtils.isEmpty((CharSequence)algoId) || groupId == null) {
            return false;
        }
        List ids = Arrays.asList(algoId.split(",")).stream().map(m -> Integer.valueOf(m)).distinct().collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AlgoModelInfoDao::getRowStatus, (Object)1);
        wrapper.in(AlgoModelInfoDao::getGoodsId, ids);
        List list = this.algoModelInfoMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return false;
        }
        List modelIds = list.stream().map(m -> m.getId()).collect(Collectors.toList());
        LambdaQueryWrapper rightWrapper = new LambdaQueryWrapper();
        rightWrapper.eq(AlgoRightInfoDao::getGroupId, (Object)groupId);
        rightWrapper.in(AlgoRightInfoDao::getModelId, modelIds);
        rightWrapper.eq(AlgoRightInfoDao::getRowStatus, (Object)1);
        rightWrapper.eq(AlgoRightInfoDao::getStatus, (Object)1);
        List rightList = this.algoRightInfoMapper.selectList((Wrapper)rightWrapper);
        if (CollectionUtils.isEmpty((Collection)rightList) || ids.size() > rightList.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean isHaveAlgoCodePermission(Integer groupId, String algoCode) {
        if (StringUtils.isEmpty((CharSequence)algoCode) || groupId == null) {
            return false;
        }
        List algoCodeList = Arrays.asList(algoCode.split(",")).stream().distinct().collect(Collectors.toList());
        LambdaQueryWrapper rightWrapper = new LambdaQueryWrapper();
        rightWrapper.eq(AlgoRightVersionInfoDao::getGroupId, (Object)groupId);
        rightWrapper.in(AlgoRightVersionInfoDao::getModelCode, algoCodeList);
        rightWrapper.eq(AlgoRightVersionInfoDao::getRowStatus, (Object)1);
        rightWrapper.eq(AlgoRightVersionInfoDao::getStatus, (Object)1);
        List rightList = this.algoRightVersionInfoMapper.selectList((Wrapper)rightWrapper);
        if (CollectionUtils.isEmpty((Collection)rightList) || algoCodeList.size() > rightList.size()) {
            return false;
        }
        return true;
    }

    @Override
    public Boolean isHavePermission(String userId, String algoId) {
        if (StringUtils.isEmpty((CharSequence)algoId) || StringUtils.isEmpty((CharSequence)userId)) {
            return false;
        }
        List ids = Arrays.asList(algoId.split(",")).stream().map(m -> Integer.valueOf(m)).distinct().collect(Collectors.toList());
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AlgoModelInfoDao::getRowStatus, (Object)1);
        wrapper.in(AlgoModelInfoDao::getGoodsId, ids);
        List list = this.algoModelInfoMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return false;
        }
        List modelIds = list.stream().map(m -> m.getId()).collect(Collectors.toList());
        LambdaQueryWrapper rightWrapper = new LambdaQueryWrapper();
        rightWrapper.eq(AlgoRightInfoDao::getUserId, (Object)userId);
        rightWrapper.in(AlgoRightInfoDao::getModelId, modelIds);
        rightWrapper.eq(AlgoRightInfoDao::getRowStatus, (Object)1);
        rightWrapper.eq(AlgoRightInfoDao::getStatus, (Object)1);
        List rightList = this.algoRightInfoMapper.selectList((Wrapper)rightWrapper);
        if (CollectionUtils.isEmpty((Collection)rightList) || ids.size() != rightList.size()) {
            return false;
        }
        return true;
    }

    @Override
    public HttpResponseEntity<OlucPage<GetGoodsListVo>> getGoodsDetailList(String token, GetGoodsListBo request) {
        Integer categoryId = this.commonUtil.getCategoryId(token, request.getCategoryName(), this.storeId);
        if (categoryId == null) {
            return HttpResponseEntity.Builder.call().success(null).build();
        }
        request.setStoreId(this.storeId);
        request.setCategoryId(categoryId);
        String key = this.commonUtil.toMd5(String.format("oluc_getGoodsList_%s_%s", this.storeId, JSONObject.toJSONString((Object)request)));
        Object resultObj = this.redisTemplate.opsForValue().get((Object)key);
        if (resultObj != null) {
            return (HttpResponseEntity)JSONObject.parseObject((String)resultObj.toString(), (TypeReference)new TypeReference<HttpResponseEntity<OlucPage<GetGoodsListVo>>>(){}, (Feature[])new Feature[0]);
        }
        HttpResponseEntity response = this.olucClient.getGoodsList(token, request);
        if (response == null || response.getData() == null) {
            return HttpResponseEntity.Builder.call().error(Integer.valueOf(1001), "\u67e5\u8be2\u5546\u54c1\u5217\u8868\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5").build();
        }
        if (response != null && response.getData() != null && ((OlucPage)response.getData()).getTotal() > 0 && response.getCode() == 200 && CollectionUtils.isNotEmpty((Collection)((OlucPage)response.getData()).getRecords())) {
            List<Integer> ids = ((OlucPage)response.getData()).getRecords().stream().map(m -> m.getGoodsId()).collect(Collectors.toList());
            List<ModelDetailEntity> modelList = this.getModelDetail(ids, null, null, 1);
            this.getModelDetail(ids, null, null, 1);
            for (GetGoodsListVo item : ((OlucPage)response.getData()).getRecords()) {
                DeviceCustomParamsEntity customParams;
                if (item == null || item.getCategoryId() == null) continue;
                if (StringUtils.isNotEmpty((CharSequence)request.getCategoryName()) && !request.getCategoryName().equals(CategoryNameEnum.device.getName())) {
                    customParams = this.algoCustomParams(item.getRemarks());
                    item.setScene(customParams.getScene());
                    item.setDays(customParams.getDays());
                    List modelBaseInfos = modelList.stream().filter(m -> m.getGoodsId().compareTo(item.getGoodsId()) == 0).collect(Collectors.toList());
                    if (CollectionUtils.isEmpty(modelBaseInfos)) continue;
                    ModelDetailEntity modelBaseInfo = (ModelDetailEntity)modelBaseInfos.get(0);
                    item.setDeviceAlgoName(modelBaseInfo.getModelEnglishName());
                    item.setDeviceAlgoType(modelBaseInfo.getModelAlgoType());
                    item.setCheckType(modelBaseInfo.getCheckType());
                    ArrayList<AlgoLabelEntity> labels = new ArrayList<AlgoLabelEntity>();
                    if (StringUtils.isNotEmpty((CharSequence)modelBaseInfo.getLabel())) {
                        AlgoLabelEntity labelInfo = new AlgoLabelEntity();
                        for (String info : modelBaseInfo.getLabel().split(",")) {
                            labelInfo.setName(info);
                            labels.add(labelInfo);
                        }
                    }
                    item.setLabels(labels);
                    if (CollectionUtils.isNotEmpty((Collection)modelBaseInfo.getVersionList())) {
                        ModelVersionDetailEntity versionInfo = (ModelVersionDetailEntity)modelBaseInfo.getVersionList().get(0);
                        item.setAlgoVersion(versionInfo.getVersion());
                        item.setReleaseTime(versionInfo.getReleaseTime());
                        item.setAlgoUpdateTime(versionInfo.getUpdateTime());
                        item.setModel(versionInfo.getAddress());
                        continue;
                    }
                    item.setReleaseTime(customParams.getReleaseTime());
                    item.setAlgoUpdateTime(customParams.getAlgoUpdateTime());
                    continue;
                }
                customParams = this.deviceCustomParams(item.getRemarks());
                item.setDeviceType(customParams.getDeviceType());
                item.setBaseInfo(customParams.getBaseInfo());
                item.setVideoInfo(customParams.getVideoInfo());
                item.setNetworkInfo(customParams.getNetworkInfo());
                item.setSystemInfo(customParams.getSystemInfo());
                item.setAiInfo(customParams.getAiInfo());
                item.setApiInfo(customParams.getApiInfo());
                item.setEnvInfo(customParams.getEnvInfo());
                item.setPhysicalInfo(customParams.getPhysicalInfo());
            }
        }
        this.redisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)response), Duration.ofSeconds(3600L));
        return response;
    }

    @Override
    public GetGoodsDetailVo getGoodsDetail(String token, Integer goodsId) {
        String key = this.commonUtil.toMd5(String.format("oluc_newGetGoodsDetail_%s_%s", this.storeId, goodsId));
        Object resultObj = this.redisTemplate.opsForValue().get((Object)key);
        if (resultObj != null) {
            return (GetGoodsDetailVo)JSONObject.parseObject((String)resultObj.toString(), GetGoodsDetailVo.class);
        }
        HttpResponseEntity response = this.olucClient.getGoodsDetail(token, goodsId);
        if (response == null || response.getCode() != 200 || response.getData() == null) {
            return new GetGoodsDetailVo();
        }
        GetGoodsDetailVo result = (GetGoodsDetailVo)response.getData();
        Integer categoryId = this.commonUtil.getCategoryId(token, CategoryNameEnum.device.getName(), this.storeId);
        if (result.getCategoryId() != null && categoryId != null) {
            if (result.getCategoryId().compareTo(categoryId) == 0) {
                DeviceCustomParamsEntity customParams = this.deviceCustomParams(result.getRemarks());
                result.setDeviceType(customParams.getDeviceType());
                result.setBaseInfo(customParams.getBaseInfo());
                result.setVideoInfo(customParams.getVideoInfo());
                result.setNetworkInfo(customParams.getNetworkInfo());
                result.setSystemInfo(customParams.getSystemInfo());
                result.setAiInfo(customParams.getAiInfo());
                result.setApiInfo(customParams.getApiInfo());
                result.setEnvInfo(customParams.getEnvInfo());
                result.setPhysicalInfo(customParams.getPhysicalInfo());
                result.setIsDevice(Integer.valueOf(1));
            } else {
                AlgoCustomParamsEntity customParams = this.algoCustomParams(result.getRemarks());
                result.setScene(customParams.getScene());
                result.setIsDevice(Integer.valueOf(0));
            }
        }
        if (result.getGoodsId() != null && result.getGoodsId().compareTo(0) > 0) {
            this.redisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)result), Duration.ofSeconds(3600L));
        }
        return result;
    }

    @Override
    public List<GetSkuListVo> getSkuList(String token, Integer goodsId) {
        String key = this.commonUtil.toMd5(String.format("oluc_getSkuList_%s_%s", this.storeId, goodsId));
        Object resultObj = this.redisTemplate.opsForValue().get((Object)key);
        if (resultObj != null) {
            return JSONObject.parseArray((String)resultObj.toString(), GetSkuListVo.class);
        }
        HttpResponseEntity result = this.olucClient.getSkuList(token, goodsId, this.storeId);
        if (result == null || result.getCode() != 200 || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
            return null;
        }
        List<GetSkuListVo> list = ((List)result.getData()).stream().filter(m -> m.getIsGrounding() != false && m.getEisGrounding() != false).peek(m -> m.setDays(this.commonUtil.getNum(m.getSpec()))).collect(Collectors.toList());
        this.redisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString(list), Duration.ofSeconds(3600L));
        return list;
    }

    @Override
    public List<String> getAlgoCodeByOther(Integer goodsId, Integer modelId) {
        if (goodsId == null && modelId == null) {
            return new ArrayList<String>();
        }
        if (goodsId != null && modelId != null) {
            return new ArrayList<String>();
        }
        return this.getAlgoCodeByOther(goodsId == null ? new ArrayList() : Collections.singletonList(goodsId), modelId == null ? new ArrayList() : Collections.singletonList(modelId));
    }

    @Override
    public List<String> getAlgoCodeByOther(List<Integer> goodsIds, List<Integer> modelIds) {
        if (CollectionUtils.isEmpty(goodsIds) && CollectionUtils.isEmpty(modelIds)) {
            return new ArrayList<String>();
        }
        if (CollectionUtils.isNotEmpty(goodsIds) && CollectionUtils.isNotEmpty(modelIds)) {
            return new ArrayList<String>();
        }
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty(goodsIds)) {
            goodsIds = goodsIds.stream().distinct().collect(Collectors.toList());
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.in(AlgoModelInfoDao::getGoodsId, goodsIds);
            wrapper.eq(AlgoModelInfoDao::getRowStatus, (Object)1);
            list = this.algoModelInfoMapper.selectList((Wrapper)wrapper);
        } else {
            modelIds = modelIds.stream().distinct().collect(Collectors.toList());
            list = this.algoModelInfoMapper.selectBatchIds(modelIds);
        }
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<String>();
        }
        modelIds = list.stream().map(m -> m.getId()).collect(Collectors.toList());
        LambdaQueryWrapper versionWrapper = new LambdaQueryWrapper();
        versionWrapper.in(AlgoVersionInfoDao::getModelId, modelIds);
        versionWrapper.eq(AlgoVersionInfoDao::getStatus, (Object)OnlineStatusEnum.On.getCode());
        versionWrapper.eq(AlgoVersionInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
        versionWrapper.ne(AlgoVersionInfoDao::getAlgoCode, (Object)"");
        versionWrapper.orderByDesc(AlgoVersionInfoDao::getStatus, (Object[])new SFunction[]{AlgoVersionInfoDao::getId});
        List versionInfos = this.algoVersionInfoMapper.selectList((Wrapper)versionWrapper);
        ArrayList<String> result = new ArrayList<String>();
        for (AlgoModelInfoDao modelBaseInfo : list) {
            if (CollectionUtils.isEmpty((Collection)versionInfos)) continue;
            List itemVersions = versionInfos.stream().filter(m -> m.getModelId().compareTo(modelBaseInfo.getId()) == 0).collect(Collectors.toList());
            for (AlgoVersionInfoDao item : itemVersions) {
                result.add(this.commonUtil.getCodeInfo(item.getAlgoCode()));
            }
        }
        return result.stream().distinct().collect(Collectors.toList());
    }

    @Override
    public List<ModelDetailEntity> getModelDetail(List<Integer> goodsIds, List<Integer> modelIds, List<String> englishNames, Integer isGetVersion) {
        LambdaQueryWrapper wrapper;
        if (CollectionUtils.isEmpty(goodsIds) && CollectionUtils.isEmpty(modelIds) && CollectionUtils.isEmpty(englishNames)) {
            return new ArrayList<ModelDetailEntity>();
        }
        List list = new ArrayList();
        if (CollectionUtils.isNotEmpty(goodsIds)) {
            goodsIds = goodsIds.stream().distinct().collect(Collectors.toList());
            wrapper = new LambdaQueryWrapper();
            wrapper.in(AlgoModelInfoDao::getGoodsId, goodsIds);
            wrapper.eq(AlgoModelInfoDao::getRowStatus, (Object)1);
            list = this.algoModelInfoMapper.selectList((Wrapper)wrapper);
        } else if (CollectionUtils.isNotEmpty(englishNames)) {
            englishNames = englishNames.stream().distinct().collect(Collectors.toList());
            wrapper = new LambdaQueryWrapper();
            wrapper.in(AlgoModelInfoDao::getModelEnglishName, englishNames);
            wrapper.eq(AlgoModelInfoDao::getRowStatus, (Object)1);
            list = this.algoModelInfoMapper.selectList((Wrapper)wrapper);
        } else {
            modelIds = modelIds.stream().distinct().collect(Collectors.toList());
            list = this.algoModelInfoMapper.selectBatchIds(modelIds);
        }
        if (CollectionUtils.isEmpty(list)) {
            return new ArrayList<ModelDetailEntity>();
        }
        modelIds = list.stream().map(m -> m.getId()).collect(Collectors.toList());
        List versionInfos = new ArrayList();
        if (isGetVersion != null && isGetVersion.compareTo(1) == 0) {
            LambdaQueryWrapper versionWrapper = new LambdaQueryWrapper();
            versionWrapper.in(AlgoVersionInfoDao::getModelId, modelIds);
            versionWrapper.eq(AlgoVersionInfoDao::getStatus, (Object)OnlineStatusEnum.On.getCode());
            versionWrapper.eq(AlgoVersionInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
            versionWrapper.ne(AlgoVersionInfoDao::getAlgoCode, (Object)"");
            versionWrapper.orderByDesc(AlgoVersionInfoDao::getStatus, (Object[])new SFunction[]{AlgoVersionInfoDao::getId});
            versionInfos = this.algoVersionInfoMapper.selectList((Wrapper)versionWrapper);
        }
        ArrayList<ModelDetailEntity> resultList = new ArrayList<ModelDetailEntity>();
        ModelDetailEntity resultModel = new ModelDetailEntity();
        for (AlgoModelInfoDao modelBaseInfo : list) {
            resultModel = new ModelDetailEntity();
            resultModel.setId(modelBaseInfo.getId());
            resultModel.setModelName(modelBaseInfo.getModelName());
            resultModel.setModelEnglishName(modelBaseInfo.getModelEnglishName());
            resultModel.setCheckType(modelBaseInfo.getCheckType());
            resultModel.setModelAlgoType(modelBaseInfo.getModelAlgoType());
            resultModel.setLabel(modelBaseInfo.getLabel());
            resultModel.setModelType(modelBaseInfo.getModelType());
            resultModel.setIsGoods(modelBaseInfo.getIsGoods());
            resultModel.setGoodsId(modelBaseInfo.getGoodsId());
            resultModel.setStatus(modelBaseInfo.getStatus());
            resultModel.setRemark(modelBaseInfo.getRemark());
            resultModel.setImg(modelBaseInfo.getIcon());
            resultModel.setBackgroundImg(modelBaseInfo.getBackgroundImg());
            resultModel.setDeviceType(DeviceConstant.deviceType);
            resultModel.setBusinessType(modelBaseInfo.getBusinessType());
            resultModel.setSensitivity(modelBaseInfo.getSensitivity());
            if (CollectionUtils.isNotEmpty(versionInfos)) {
                List itemVersions = versionInfos.stream().filter(m -> m.getModelId().compareTo(modelBaseInfo.getId()) == 0).collect(Collectors.toList());
                ArrayList<ModelVersionDetailEntity> versionList = new ArrayList<ModelVersionDetailEntity>();
                ModelVersionDetailEntity versionModel = new ModelVersionDetailEntity();
                for (AlgoVersionInfoDao item : itemVersions) {
                    versionModel = new ModelVersionDetailEntity();
                    versionModel.setVersionId(item.getId());
                    versionModel.setVersion(item.getVersion());
                    versionModel.setAddress(item.getAddress());
                    versionModel.setReleaseTime(this.format.format(item.getCreateTime()));
                    versionModel.setUpdateTime(this.format.format(item.getUpdateTime()));
                    versionModel.setAlgoCode(item.getAlgoCode());
                    versionModel.setAlgoConfigTypes(StringUtils.isEmpty((CharSequence)item.getAlgoConfigType()) ? new ArrayList() : Arrays.stream(item.getAlgoConfigType().split(",")).map(m -> Integer.valueOf(m)).collect(Collectors.toList()));
                    versionModel.setUploadDataTypes(StringUtils.isEmpty((CharSequence)item.getUploadDataType()) ? new ArrayList() : Arrays.stream(item.getUploadDataType().split(",")).map(m -> Integer.valueOf(m)).collect(Collectors.toList()));
                    versionList.add(versionModel);
                }
                resultModel.setVersionList(versionList);
            }
            resultList.add(resultModel);
        }
        return resultList;
    }

    @Override
    public Map<String, PaasModelInfoEntity> getPaasModelInfoByCode(List<String> codeList) {
        if (CollectionUtils.isEmpty(codeList)) {
            return new HashMap<String, PaasModelInfoEntity>();
        }
        List codeInfos = this.algoVersionInfoMapper.getCodeList(codeList);
        if (CollectionUtils.isEmpty((Collection)codeInfos)) {
            return new HashMap<String, PaasModelInfoEntity>();
        }
        Map<String, Integer> codeMap = codeInfos.stream().collect(Collectors.toMap(GetCodeListEntity::getAlgoCode, o -> o.getModelId()));
        List modelIds = codeInfos.stream().map(GetCodeListEntity::getModelId).collect(Collectors.toList());
        List list = this.algoModelInfoMapper.selectBatchIds(modelIds);
        if (CollectionUtils.isEmpty((Collection)list)) {
            return new HashMap<String, PaasModelInfoEntity>();
        }
        Map<Integer, String> modelMap = list.stream().collect(Collectors.toMap(AlgoModelInfoDao::getId, o -> o.getModelEnglishName()));
        HashMap<String, PaasModelInfoEntity> result = new HashMap<String, PaasModelInfoEntity>();
        PaasModelInfoEntity model = new PaasModelInfoEntity();
        for (String code : codeMap.keySet()) {
            Integer modelId = codeMap.get(code);
            if (modelMap.isEmpty() || !modelMap.containsKey(modelId)) continue;
            model = new PaasModelInfoEntity();
            model.setId(modelId);
            model.setModelEnglishName(modelMap.get(modelId));
            result.put(code, model);
        }
        return result;
    }

    @Override
    public List<ModelDetailEntity> getModelDetailByAlgoCode(SnapshotAlgoQueryBatch queryBatchList) {
        if (CollectionUtils.isEmpty((Collection)queryBatchList.getList())) {
            return new ArrayList<ModelDetailEntity>();
        }
        RealGG response = this.aiOpenClient.getSnapshotListBatch(queryBatchList);
        if (response.getIsError().booleanValue()) {
            logger.error("{}, AI\u63a5\u53e3\u8c03\u7528\u5931\u8d25", (Object)queryBatchList);
            throw new OpenPaasException("AI\u63a5\u53e3\u8c03\u7528\u5931\u8d25");
        }
        if (CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
            return new ArrayList<ModelDetailEntity>();
        }
        List modelData = (List)response.getData();
        Map<String, List<AlgoSnapshotDTO>> algoVersion = modelData.stream().collect(Collectors.groupingBy(AlgoSnapshotDTO::getAlgoCode));
        ArrayList<ModelDetailEntity> resultList = new ArrayList<ModelDetailEntity>();
        for (Map.Entry<String, List<AlgoSnapshotDTO>> entry : algoVersion.entrySet()) {
            ModelDetailEntity resultModel = new ModelDetailEntity();
            AlgoSnapshotDTO modelBaseInfo = entry.getValue().get(0);
            resultModel.setId(modelBaseInfo.getId());
            resultModel.setModelName(modelBaseInfo.getName());
            resultModel.setAlgoCode(modelBaseInfo.getAlgoCode());
            resultModel.setModelType(modelBaseInfo.getModelType());
            resultModel.setIsGoods(Integer.valueOf(0));
            resultModel.setRemark(modelBaseInfo.getRemark());
            resultModel.setImg(modelBaseInfo.getIcon());
            resultModel.setBackgroundImg(modelBaseInfo.getPicture());
            resultModel.setDeviceType(DeviceConstant.deviceType);
            resultModel.setBusinessType(modelBaseInfo.getChannel());
            resultModel.setSensitivity(BigDecimal.valueOf(modelBaseInfo.getConfidence()));
            if (modelBaseInfo.getIsDevice().booleanValue()) {
                resultModel.setCheckType(CheckTypeEnum.Hardware.getCode());
            } else {
                resultModel.setCheckType(CheckTypeEnum.Soft.getCode());
            }
            List<Object> versionList = new ArrayList();
            for (AlgoSnapshotDTO item : entry.getValue()) {
                ModelVersionDetailEntity versionModel = new ModelVersionDetailEntity();
                versionModel.setVersion(item.getVersion());
                versionModel.setAddress(item.getUrl());
                versionModel.setReleaseTime(item.getCreateTime());
                versionModel.setAlgoCode(item.getAlgoCode());
                versionModel.setAlgoConfigTypes(StringUtils.isEmpty((CharSequence)item.getConfigTypes()) ? new ArrayList() : Arrays.stream(item.getConfigTypes().split(",")).map(m -> Integer.valueOf(m)).collect(Collectors.toList()));
                versionModel.setUploadDataTypes(StringUtils.isEmpty((CharSequence)item.getUploadDataTypes()) ? new ArrayList() : Arrays.stream(item.getUploadDataTypes().split(",")).map(m -> Integer.valueOf(m)).collect(Collectors.toList()));
                versionList.add(versionModel);
            }
            versionList = versionList.stream().sorted(Comparator.comparing(ModelVersionDetailEntity::getVersion).reversed()).collect(Collectors.toList());
            resultModel.setVersionList(versionList);
            resultList.add(resultModel);
        }
        return resultList;
    }

    @Override
    public Boolean addAlgoRightInfo(Integer groupId, Integer modelId, String userName, Integer isPersonal, String userId) {
        AlgoModelInfoDao modelInfo = (AlgoModelInfoDao)this.algoModelInfoMapper.selectById((Serializable)modelId);
        if (modelInfo == null) {
            return false;
        }
        LambdaQueryWrapper versionWrapper = new LambdaQueryWrapper();
        versionWrapper.eq(AlgoVersionInfoDao::getModelId, (Object)modelInfo.getId());
        versionWrapper.eq(AlgoVersionInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
        versionWrapper.orderByDesc(AlgoVersionInfoDao::getId);
        List versionList = this.algoVersionInfoMapper.selectList((Wrapper)versionWrapper);
        if (CollectionUtils.isEmpty((Collection)versionList)) {
            return false;
        }
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        if (isPersonal == 0) {
            wrapper.eq(AlgoRightInfoDao::getUserId, (Object)userId);
            wrapper.eq(AlgoRightInfoDao::getGroupId, (Object)groupId);
        } else {
            wrapper.eq(AlgoRightInfoDao::getGroupId, (Object)groupId);
        }
        wrapper.eq(AlgoRightInfoDao::getModelId, (Object)modelId);
        List rightList = this.algoRightInfoMapper.selectList((Wrapper)wrapper);
        AlgoRightInfoDao model = new AlgoRightInfoDao();
        if (CollectionUtils.isNotEmpty((Collection)rightList) && (model = (AlgoRightInfoDao)rightList.get(0)).getRowStatus().compareTo(RowStatusEnum.Valid.getCode()) == 0) {
            return true;
        }
        RealGG groupResult = this.deviceClient.getEnterpriseByGroupIdApi(groupId);
        if (groupResult != null && groupResult.getCode() == 0 && groupResult.getData() != null) {
            model.setIsRegistry(((EnterpriseGroupEntity)groupResult.getData()).getIsRegistry());
        }
        if (isPersonal == 0) {
            model.setUserId(userId);
            model.setGroupId(groupId);
        } else {
            model.setGroupId(groupId);
        }
        model.setModelId(modelId);
        model.setStatus(Integer.valueOf(1));
        model.setRowStatus(Integer.valueOf(1));
        model.setCreateBy(userName);
        model.setUpdateBy(userName);
        int row = 0;
        row = model.getId() == null ? this.algoRightInfoMapper.insert((Object)model) : this.algoRightInfoMapper.updateById((Object)model);
        if (row <= 0) {
            return false;
        }
        if (this.commonUtil.isRightBusinessType(modelInfo.getBusinessType(), BusinessTypeEnum.shop.getCode(), null).booleanValue()) {
            for (AlgoVersionInfoDao item : versionList) {
                if (StringUtils.isEmpty((CharSequence)item.getAlgoCode())) continue;
                AddServeEnterpriseBo params = new AddServeEnterpriseBo();
                ArrayList<ServeEnterpriseAcEntity> serveEnterpriseAcVOS = new ArrayList<ServeEnterpriseAcEntity>();
                ServeEnterpriseAcEntity modelEntity = new ServeEnterpriseAcEntity();
                modelEntity.setModelIdentifier(this.commonUtil.getCodeInfo(item.getAlgoCode()));
                serveEnterpriseAcVOS.add(modelEntity);
                params.setEnterpriseId(groupId);
                params.setServeEnterpriseAcVOS(serveEnterpriseAcVOS);
                RealGG addResponse = this.algoClient.addServeEnterprise(params);
                if (addResponse != null && addResponse.getCode() == 0) continue;
                return false;
            }
        }
        return true;
    }

    @Override
    public Boolean closeRightRecord(Integer groupId, List<Integer> modelIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AlgoRightInfoDao::getGroupId, (Object)groupId);
        wrapper.in(AlgoRightInfoDao::getModelId, modelIds);
        wrapper.eq(AlgoRightInfoDao::getRowStatus, (Object)RowStatusEnum.Invalid.getCode());
        List rightList = this.algoRightInfoMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)rightList)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean closeUserRightRecord(Integer userId, List<Integer> modelIds) {
        LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
        wrapper.eq(AlgoRightInfoDao::getUserId, (Object)userId);
        wrapper.in(AlgoRightInfoDao::getModelId, modelIds);
        wrapper.eq(AlgoRightInfoDao::getRowStatus, (Object)RowStatusEnum.Invalid.getCode());
        List rightList = this.algoRightInfoMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isNotEmpty((Collection)rightList)) {
            return true;
        }
        return false;
    }

    @Override
    public Boolean isAlgoOrder(String token, Integer categoryId) {
        if (categoryId == null) {
            return false;
        }
        Integer devCategoryId = this.commonUtil.getCategoryId(token, CategoryNameEnum.device.getName(), this.storeId);
        if (devCategoryId == null || categoryId.compareTo(devCategoryId) == 0) {
            return false;
        }
        return true;
    }

    @Override
    public void insertUpgradeRecord(List<DeviceAlgoRelationInfoDao> relationInfo, Integer operationType, OvoparkUserInfoEntity userInfo) {
        if (CollectionUtils.isEmpty(relationInfo)) {
            return;
        }
        ArrayList<UpgradeRecordDao> recordList = new ArrayList<UpgradeRecordDao>();
        UpgradeRecordDao recordModel = new UpgradeRecordDao();
        for (DeviceAlgoRelationInfoDao item : relationInfo) {
            recordModel = new UpgradeRecordDao();
            recordModel.setServiceId(item.getId());
            recordModel.setGroupId(item.getGroupId());
            recordModel.setDeviceId(item.getDeviceId());
            recordModel.setMac(item.getMac());
            recordModel.setOperationType(operationType);
            recordModel.setStatus(Integer.valueOf(1));
            recordModel.setPhone(userInfo.getMobilePhone() == null ? "" : userInfo.getMobilePhone());
            recordModel.setCreateBy(userInfo.getUserName());
            recordModel.setUpdateBy(userInfo.getUserName());
            recordList.add(recordModel);
        }
        if (CollectionUtils.isNotEmpty(recordList)) {
            this.upgradeRecordMapper.insertBatch(recordList);
        }
    }

    @Override
    public Response addAlgoTask(DeviceAlgoRelationInfoDao param, List<TimerListEntity> timerList, Integer warningConf, Integer uploadType, Integer businessType) {
        if (param == null || param.getDeviceId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), MessageUtils.getMessage("code_lack_model_id_sure"), MessageUtils.getMessage("code_fail")).build();
        }
        if (param.getAlgoType().compareTo(AlgoTypeEnum.Soft.getCode()) == 0) {
            return Response.Builder.call().success(MessageUtils.getMessage("code_success")).build();
        }
        if (param.getDeviceType().equals("Dolphin1-A")) {
            return Response.Builder.call().success(MessageUtils.getMessage("code_success")).build();
        }
        if (businessType == null ? this.commonUtil.isRightBusinessType(null, BusinessTypeEnum.shop.getCode(), param.getModelId()) == false : this.commonUtil.isRightBusinessType(businessType, BusinessTypeEnum.shop.getCode(), null) == false) {
            return Response.Builder.call().success(MessageUtils.getMessage("code_success")).build();
        }
        if (CollectionUtils.isEmpty(timerList)) {
            timerList = new ArrayList<TimerListEntity>();
            TimerListEntity timerModel = new TimerListEntity();
            timerModel.setStarTime("08:00:00");
            timerModel.setEndTime("20:00:00");
            timerList.add(timerModel);
        }
        AddAlgoTaskBo aiParams = new AddAlgoTaskBo();
        aiParams.setTimerList(timerList);
        aiParams.setWarningConf(Integer.valueOf(warningConf == null ? 5 : warningConf));
        HttpResponseEntity macResponse = this.deviceAlgoFeignClient.getDeviceStatusPaasOpenVoById(null, param.getDeviceId());
        if (macResponse == null || ((GetDeviceStatusPaasOpenVoByIdDTO)macResponse.getData()).getId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1010), MessageUtils.getMessage("code_get_device_video_fail"), MessageUtils.getMessage("code_fail")).build();
        }
        aiParams.setEnterpriseId(param.getGroupId());
        aiParams.setDepId(param.getDepId());
        aiParams.setDeviceId(((GetDeviceStatusPaasOpenVoByIdDTO)macResponse.getData()).getId());
        aiParams.setModelIdentifier(param.getAlgoCode());
        aiParams.setUploadType(uploadType);
        RealGG result = this.algoClient.addAlgoTask(aiParams);
        if (result == null || result.getCode() != 0) {
            return Response.Builder.call().error(Integer.valueOf(1009), MessageUtils.getMessage("code_create_ai_algo_fail"), MessageUtils.getMessage("code_fail")).build();
        }
        return Response.Builder.call().success(MessageUtils.getMessage("code_success")).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean removeAlgoFromDev(Integer devId, Integer algoId, OvoparkUserInfoEntity userInfo, Integer sendSev) {
        List devRelationInfoList;
        if (devId == null || devId == 0) {
            return false;
        }
        LambdaQueryWrapper devWrapper = new LambdaQueryWrapper();
        devWrapper.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)devId);
        if (algoId != null) {
            devWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoId, (Object)algoId);
        }
        if (CollectionUtils.isEmpty((Collection)(devRelationInfoList = this.deviceAlgoRelationInfoMapper.selectList((Wrapper)devWrapper)))) {
            return true;
        }
        SetAlgoAlgoActivBo params = new SetAlgoAlgoActivBo();
        params.setDeviceStatusId(devId);
        ArrayList<DeviceAlgoConfigEntity> configList = new ArrayList<DeviceAlgoConfigEntity>();
        DeviceAlgoConfigEntity configModel = new DeviceAlgoConfigEntity();
        for (int index = 0; index < devRelationInfoList.size(); ++index) {
            AlgoVersionInfoDao versions;
            DeviceAlgoRelationInfoDao item = (DeviceAlgoRelationInfoDao)devRelationInfoList.get(index);
            AlgoModelInfoDao algoModel = (AlgoModelInfoDao)this.algoModelInfoMapper.selectById((Serializable)item.getModelId());
            if (algoModel == null) {
                return false;
            }
            if (this.commonUtil.isRightBusinessType(algoModel.getBusinessType(), BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
                item.setRowStatus(RowStatusEnum.Invalid.getCode());
            }
            if (item.getAlgoType().compareTo(AlgoTypeEnum.Hardware.getCode()) == 0 && !item.getDeviceType().equals("Dolphin1-A") && this.commonUtil.isRightBusinessType(algoModel.getBusinessType(), BusinessTypeEnum.shop.getCode(), null).booleanValue() && (versions = (AlgoVersionInfoDao)this.algoVersionInfoMapper.selectById((Serializable)item.getVersionId())) != null) {
                configModel = new DeviceAlgoConfigEntity();
                configModel.setAlgoName(this.commonUtil.getCodeInfo(versions.getAlgoCode()));
                configModel.setModelVersion(versions.getVersion());
                configModel.setModelDownloadUrl(versions.getAddress());
                Long fulLife = Long.valueOf(Math.abs(new Date().getTime()) / 1000L) - 86400L;
                configModel.setUsefulLife(fulLife);
                configList.add(configModel);
                HttpResponseEntity macResponse = this.deviceAlgoFeignClient.getDeviceStatusPaasOpenVoById(null, devId);
                if (macResponse == null || ((GetDeviceStatusPaasOpenVoByIdDTO)macResponse.getData()).getId() == null) {
                    return false;
                }
                this.algoClient.delAlgoTask(this.commonUtil.getCodeInfo(versions.getAlgoCode()), ((GetDeviceStatusPaasOpenVoByIdDTO)macResponse.getData()).getId());
            }
            item.setDeviceId(Integer.valueOf(0));
            item.setDeviceName("");
            item.setDeviceName("");
            item.setMac("");
            item.setImg("");
            item.setDType(Integer.valueOf(0));
            item.setDepId(Integer.valueOf(0));
            item.setDepName("");
            item.setDeviceType("");
            item.setAlgoVersion("");
            item.setVersionId(Integer.valueOf(0));
            item.setUpdateBy(userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getUserName()) ? "" : userInfo.getUserName());
            item.setUpdateTime(new Date());
            devRelationInfoList.set(index, item);
        }
        if (sendSev != null && sendSev.compareTo(1) == 0 && CollectionUtils.isNotEmpty(configList)) {
            params.setConfigList(configList);
            this.deviceClientService.asyncSetAlgoAlgoActive(params, Boolean.valueOf(true));
        }
        this.deviceAlgoRelationInfoMapper.upsert(devRelationInfoList);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Boolean removeAlgoFromDevByCode(Integer devId, String algoCode, OvoparkUserInfoEntity userInfo, Integer sendSev) {
        List devRelationInfoList;
        if (devId == null || devId == 0) {
            return false;
        }
        LambdaQueryWrapper devWrapper = new LambdaQueryWrapper();
        devWrapper.eq(DeviceAlgoRelationInfoDao::getDeviceId, (Object)devId);
        if (StringUtils.isNotEmpty((CharSequence)algoCode)) {
            devWrapper.eq(DeviceAlgoRelationInfoDao::getAlgoCode, (Object)algoCode);
        }
        if (CollectionUtils.isEmpty((Collection)(devRelationInfoList = this.deviceAlgoRelationInfoMapper.selectList((Wrapper)devWrapper)))) {
            return true;
        }
        SetAlgoAlgoActivBo params = new SetAlgoAlgoActivBo();
        params.setDeviceStatusId(devId);
        ArrayList<DeviceAlgoConfigEntity> configList = new ArrayList<DeviceAlgoConfigEntity>();
        DeviceAlgoConfigEntity configModel = new DeviceAlgoConfigEntity();
        SnapshotAlgoQueryBatch queryBatchList = new SnapshotAlgoQueryBatch();
        ArrayList<SnapshotAlgoQuery> algoQueryList = new ArrayList<SnapshotAlgoQuery>();
        for (DeviceAlgoRelationInfoDao deviceAlgoRelationInfoDao : devRelationInfoList) {
            SnapshotAlgoQuery query = new SnapshotAlgoQuery();
            if (deviceAlgoRelationInfoDao.getGroupId() != null) {
                query.setEnterpriseId(Long.valueOf(deviceAlgoRelationInfoDao.getGroupId().intValue()));
            }
            query.setAlgoCode(deviceAlgoRelationInfoDao.getAlgoCode());
            algoQueryList.add(query);
        }
        queryBatchList.setList(algoQueryList);
        List<ModelDetailEntity> modelRes = this.getModelDetailByAlgoCode(queryBatchList);
        Map<String, ModelDetailEntity> modelInfoMap = modelRes.stream().collect(Collectors.toMap(ModelDetailEntity::getAlgoCode, item -> item));
        for (DeviceAlgoRelationInfoDao item2 : devRelationInfoList) {
            List versionDetailEntity;
            if (!modelInfoMap.containsKey(item2.getAlgoCode())) {
                return false;
            }
            ModelDetailEntity algoModel = modelInfoMap.get(item2.getAlgoCode());
            if (this.commonUtil.isRightBusinessType(algoModel.getBusinessType(), BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
                item2.setRowStatus(RowStatusEnum.Invalid.getCode());
            }
            if (item2.getAlgoType().compareTo(AlgoTypeEnum.Hardware.getCode()) == 0 && !item2.getDeviceType().equals("Dolphin1-A") && this.commonUtil.isRightBusinessType(algoModel.getBusinessType(), BusinessTypeEnum.shop.getCode(), null).booleanValue() && !(versionDetailEntity = algoModel.getVersionList().stream().filter(m -> m.getVersion().equals(item2.getAlgoVersion())).collect(Collectors.toList())).isEmpty()) {
                ModelVersionDetailEntity entity = (ModelVersionDetailEntity)versionDetailEntity.get(0);
                configModel = new DeviceAlgoConfigEntity();
                configModel.setAlgoName(this.commonUtil.getCodeInfo(entity.getAlgoCode()));
                configModel.setModelVersion(entity.getVersion());
                configModel.setModelDownloadUrl(entity.getAddress());
                Long fulLife = Long.valueOf(Math.abs(new Date().getTime()) / 1000L) - 86400L;
                configModel.setUsefulLife(fulLife);
                configList.add(configModel);
                HttpResponseEntity macResponse = this.deviceAlgoFeignClient.getDeviceStatusPaasOpenVoById(null, devId);
                if (macResponse == null || ((GetDeviceStatusPaasOpenVoByIdDTO)macResponse.getData()).getId() == null) {
                    return false;
                }
                PaasDeviceTaskVO paasDeviceTaskVO = new PaasDeviceTaskVO();
                paasDeviceTaskVO.setAlgoCode(this.commonUtil.getCodeInfo(entity.getAlgoCode()));
                paasDeviceTaskVO.setDeviceId(((GetDeviceStatusPaasOpenVoByIdDTO)macResponse.getData()).getId());
                paasDeviceTaskVO.setChannel(algoModel.getBusinessType());
                this.commonKafkaTemplate.send(this.aiTopic, (Object)JSON.toJSONString((Object)paasDeviceTaskVO));
            }
            item2.setDeviceId(Integer.valueOf(0));
            item2.setDeviceName("");
            item2.setDeviceName("");
            item2.setMac("");
            item2.setImg("");
            item2.setDType(Integer.valueOf(0));
            item2.setDepId(Integer.valueOf(0));
            item2.setDepName("");
            item2.setDeviceType("");
            item2.setAlgoVersion("");
            item2.setVersionId(Integer.valueOf(0));
            item2.setUpdateBy(userInfo == null || StringUtils.isEmpty((CharSequence)userInfo.getUserName()) ? "" : userInfo.getUserName());
            item2.setUpdateTime(new Date());
        }
        if (sendSev != null && sendSev.compareTo(1) == 0 && CollectionUtils.isNotEmpty(configList)) {
            params.setConfigList(configList);
            this.deviceClientService.asyncSetAlgoAlgoActive(params, Boolean.valueOf(true));
        }
        this.deviceAlgoRelationInfoMapper.upsert(devRelationInfoList);
        return true;
    }

    @Deprecated
    private AlgoCustomParamsEntity algoCustomParams(String remark) {
        AlgoCustomParamsEntity result = new AlgoCustomParamsEntity();
        result.setLabels(new ArrayList());
        try {
            if (StringUtils.isNotEmpty((CharSequence)remark) && CollectionUtils.isEmpty((Collection)(result = (AlgoCustomParamsEntity)JSONObject.parseObject((String)remark, AlgoCustomParamsEntity.class)).getLabels())) {
                result.setLabels(new ArrayList());
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u53cd\u5e8f\u5217\u5316\u4e07\u96c6\u540e\u53f0\u7b97\u6cd5\u5546\u54c1\u81ea\u5b9a\u4e49\u53c2\u6570\u5931\u8d25\u3002\u8bf7\u6c42\u53c2\u6570\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", remark, ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
        }
        return result;
    }

    @Deprecated
    private DeviceCustomParamsEntity deviceCustomParams(String remark) {
        DeviceCustomParamsEntity result = new DeviceCustomParamsEntity();
        try {
            if (StringUtils.isNotEmpty((CharSequence)remark)) {
                result = (DeviceCustomParamsEntity)JSONObject.parseObject((String)remark, DeviceCustomParamsEntity.class);
            }
        }
        catch (Exception ex) {
            logger.error(String.format("\u53cd\u5e8f\u5217\u5316\u4e07\u96c6\u540e\u53f0\u8bbe\u5907\u5546\u54c1\u81ea\u5b9a\u4e49\u53c2\u6570\u5931\u8d25\u3002\u8bf7\u6c42\u53c2\u6570\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", remark, ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
        }
        return result;
    }

    @Override
    public DeviceAlgoRelationInfoDao getDeviceAlgoRelationInfoDao(OvoparkUserInfoEntity userInfo, UserAlgoDao userOrder, Integer modelId, Integer businessType, Integer rowStatus) {
        if (userInfo == null) {
            return null;
        }
        if (userOrder == null && this.commonUtil.isRightBusinessType(businessType, BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(UserAlgoDao::getGroupId, (Object)userInfo.getGroupId());
            wrapper.eq(UserAlgoDao::getModelId, (Object)modelId);
            wrapper.eq(UserAlgoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
            wrapper.ge(UserAlgoDao::getExpire, (Object)this.format.format(new Date()));
            wrapper.orderByDesc(UserAlgoDao::getId);
            wrapper.last(" limit 1 ");
            userOrder = (UserAlgoDao)this.userAlgoMapper.selectOne((Wrapper)wrapper);
        }
        if (userOrder == null) {
            return null;
        }
        DeviceAlgoRelationInfoDao bindModel = new DeviceAlgoRelationInfoDao();
        bindModel.setAlgoId(userOrder.getAlgoId());
        bindModel.setAlgoType(userOrder.getAlgoType());
        bindModel.setGroupId(userOrder.getGroupId());
        bindModel.setOrderId(userOrder.getOrderId());
        bindModel.setOrderType(userOrder.getOrderType());
        bindModel.setDeviceId(Integer.valueOf(0));
        bindModel.setIsPersonal(userOrder.getIsPersonal());
        bindModel.setUserId(userOrder.getUserId());
        bindModel.setDeviceName("");
        bindModel.setMac("");
        bindModel.setImg("");
        bindModel.setDType(Integer.valueOf(0));
        bindModel.setDepId(Integer.valueOf(0));
        bindModel.setDepName("");
        bindModel.setDeviceType("");
        bindModel.setAlgoVersion("");
        bindModel.setVersionId(Integer.valueOf(0));
        bindModel.setStartTime(userOrder.getExpire() != null ? userOrder.getCreateTime() : null);
        bindModel.setExpire(userOrder.getExpire() != null ? userOrder.getExpire() : null);
        bindModel.setRowStatus(rowStatus);
        bindModel.setCreateBy(userInfo.getUserName());
        bindModel.setUpdateBy(userInfo.getUserName());
        bindModel.setModelId(Integer.valueOf(userOrder.getModelId() == null ? 0 : userOrder.getModelId()));
        bindModel.setRightFrom(userOrder.getRightFrom());
        bindModel.setSkuId(userOrder.getSkuId());
        return bindModel;
    }

    @Override
    public DeviceAlgoRelationInfoDao getDeviceAlgoCodeRelationInfoDao(OvoparkUserInfoEntity userInfo, UserAlgoDao userOrder, String algoCode, Integer businessType, Integer rowStatus) {
        if (userInfo == null) {
            return null;
        }
        if (userOrder == null && this.commonUtil.isRightBusinessType(businessType, BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
            LambdaQueryWrapper wrapper = new LambdaQueryWrapper();
            wrapper.eq(UserAlgoDao::getGroupId, (Object)userInfo.getGroupId());
            wrapper.eq(UserAlgoDao::getAlgoCode, (Object)algoCode);
            wrapper.eq(UserAlgoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
            wrapper.ge(UserAlgoDao::getExpire, (Object)this.format.format(new Date()));
            wrapper.orderByDesc(UserAlgoDao::getId);
            wrapper.last(" limit 1 ");
            userOrder = (UserAlgoDao)this.userAlgoMapper.selectOne((Wrapper)wrapper);
        }
        if (userOrder == null) {
            return null;
        }
        DeviceAlgoRelationInfoDao bindModel = new DeviceAlgoRelationInfoDao();
        bindModel.setAlgoId(userOrder.getAlgoId());
        bindModel.setAlgoType(userOrder.getAlgoType());
        bindModel.setGroupId(userOrder.getGroupId());
        bindModel.setOrderId(userOrder.getOrderId());
        bindModel.setOrderType(userOrder.getOrderType());
        bindModel.setDeviceId(Integer.valueOf(0));
        bindModel.setIsPersonal(userOrder.getIsPersonal());
        bindModel.setUserId(userOrder.getUserId());
        bindModel.setDeviceName("");
        bindModel.setAlgoCode(userOrder.getAlgoCode());
        bindModel.setMac("");
        bindModel.setImg("");
        bindModel.setDType(Integer.valueOf(0));
        bindModel.setDepId(Integer.valueOf(0));
        bindModel.setDepName("");
        bindModel.setDeviceType("");
        bindModel.setAlgoVersion("");
        bindModel.setVersionId(Integer.valueOf(0));
        bindModel.setStartTime(userOrder.getExpire() != null ? userOrder.getCreateTime() : null);
        bindModel.setExpire(userOrder.getExpire() != null ? userOrder.getExpire() : null);
        bindModel.setRowStatus(rowStatus);
        bindModel.setCreateBy(userInfo.getUserName());
        bindModel.setUpdateBy(userInfo.getUserName());
        bindModel.setModelId(Integer.valueOf(userOrder.getModelId() == null ? 0 : userOrder.getModelId()));
        bindModel.setRightFrom(userOrder.getRightFrom());
        bindModel.setSkuId(userOrder.getSkuId());
        return bindModel;
    }

    @Override
    public Response<List<AlgoAlgoActiveModel>> setAlgoAlgoActive(String token, List<SetAlgoAlgoActivBo> request) {
        if (CollectionUtils.isEmpty(request)) {
            return Response.Builder.call().error(Integer.valueOf(101), "\u7f3a\u5c11\u6fc0\u6d3b\u4fe1\u606f").build();
        }
        ArrayList<AlgoAlgoActiveModel> activeList = new ArrayList<AlgoAlgoActiveModel>();
        AlgoAlgoActiveModel info = new AlgoAlgoActiveModel();
        for (SetAlgoAlgoActivBo item : request) {
            Response<List<AlgoCodeModel>> res = this.setAlgoAlgoActive(token, item);
            if (res == null || res.getCode() == 0 || !CollectionUtils.isNotEmpty((Collection)((Collection)res.getData()))) continue;
            for (AlgoCodeModel code : (List)res.getData()) {
                info = new AlgoAlgoActiveModel();
                info.setDeviceStatusId(item.getDeviceStatusId());
                info.setModelName(code.getModelName());
                info.setAlgoCode(code.getAlgoCode());
                activeList.add(info);
            }
        }
        if (CollectionUtils.isNotEmpty(activeList)) {
            return Response.Builder.call().error(Integer.valueOf(102), "\u90e8\u5206\u7b97\u6cd5\u6fc0\u6d3b\u5931\u8d25", activeList).build();
        }
        return Response.Builder.call().success().build();
    }

    @Override
    public Response<List<AlgoCodeModel>> setAlgoAlgoActive(String token, SetAlgoAlgoActivBo request) {
        if (request == null || CollectionUtils.isEmpty((Collection)request.getConfigList())) {
            return Response.Builder.call().error(Integer.valueOf(101), "\u7f3a\u5c11\u6fc0\u6d3b\u4fe1\u606f").build();
        }
        ArrayList<AlgoCodeModel> codeList = new ArrayList<AlgoCodeModel>();
        AlgoCodeModel model = new AlgoCodeModel();
        for (DeviceAlgoConfigEntity item : request.getConfigList()) {
            Long seconds = item.getUsefulLife() + 86400L - 1L;
            item.setUsefulLife(seconds);
            model = new AlgoCodeModel();
            model.setAlgoCode(item.getAlgoName());
            model.setModelId(item.getModelId());
            model.setModelName(item.getModelName());
            codeList.add(model);
        }
        Response response = this.deviceClientService.asyncSetAlgoAlgoActive(request, Boolean.valueOf(false));
        if (response == null || response.getCode() != 0) {
            response.setData(codeList);
            return response;
        }
        codeList = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)token) && StringUtils.isNotEmpty((CharSequence)request.getDeviceType()) && (request.getDeviceType().equals("A1") || request.getDeviceType().equals("A1-W"))) {
            List<Object> list = new ArrayList();
            for (int num = 1; num <= 6; ++num) {
                try {
                    TimeUnit.SECONDS.sleep(5L);
                    list = new ArrayList();
                    HttpResponseEntity algoSupportResult = this.deviceAlgoFeignClient.getDeviceAlgoSupportList(token, request.getDeviceStatusId());
                    if (algoSupportResult != null && algoSupportResult.getCode() == 0 && CollectionUtils.isNotEmpty((Collection)((Collection)algoSupportResult.getData()))) {
                        List finalCodeList = codeList.stream().map(m -> m.getAlgoCode()).collect(Collectors.toList());
                        list = ((List)algoSupportResult.getData()).stream().filter(m -> finalCodeList.contains(m.getAlgoName()) && m.getActivateFlag() == 1).collect(Collectors.toList());
                        if (CollectionUtils.isNotEmpty(list) && list.size() == codeList.size()) break;
                    }
                    TimeUnit.SECONDS.sleep(15L);
                    continue;
                }
                catch (Exception ex) {
                    logger.error(String.format("\u83b7\u53d6\u6fc0\u6d3b\u4fe1\u606f\u5931\u8d25\u3002\u8bf7\u6c42\u53c2\u6570\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", JSONObject.toJSONString((Object)request), ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
                }
            }
            ArrayList activeCodeList = CollectionUtils.isEmpty(list) ? new ArrayList() : list.stream().map(m -> m.getAlgoName()).collect(Collectors.toList());
            List<Object> list2 = codeList = CollectionUtils.isEmpty(activeCodeList) ? codeList : codeList.stream().filter(m -> !activeCodeList.contains(m.getAlgoCode())).collect(Collectors.toList());
        }
        if (CollectionUtils.isNotEmpty(codeList)) {
            return Response.Builder.call().error(Integer.valueOf(102), "\u90e8\u5206\u7b97\u6cd5\u6fc0\u6d3b\u5931\u8d25", codeList).build();
        }
        return Response.Builder.call().success().build();
    }

    @Override
    public String getNewVersionByRight(Integer groupId, String algoCode) {
        AlgoRightVersionInfoDao algoRightVersionInfoDao = this.algoRightVersionInfoMapper.getNewVersion(algoCode, groupId);
        if (algoRightVersionInfoDao != null) {
            return algoRightVersionInfoDao.getVersion();
        }
        return "";
    }
}

