/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.service.impl;

import cn.hutool.core.collection.ListUtil;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.support.SFunction;
import com.ovopark.open.paasclient.DeviceClient;
import com.ovopark.open.paasclient.OlucClient;
import com.ovopark.open.service.DeviceClientService;
import com.ovopark.paas.api.constant.AlgoTypeEnum;
import com.ovopark.paas.api.constant.BusinessTypeEnum;
import com.ovopark.paas.api.constant.CheckTypeEnum;
import com.ovopark.paas.api.constant.OlucConstant;
import com.ovopark.paas.api.constant.OnlineStatusEnum;
import com.ovopark.paas.api.constant.PaasDetailTypeEnum;
import com.ovopark.paas.api.constant.RowStatusEnum;
import com.ovopark.paas.api.entity.GetOLUCTokenEntity;
import com.ovopark.paas.api.entity.GetPaasDetailTypeEntity;
import com.ovopark.paas.api.entity.HttpResponseEntity;
import com.ovopark.paas.api.entity.ModelDetailEntity;
import com.ovopark.paas.api.entity.OrderGoodsDTOListEntity;
import com.ovopark.paas.api.entity.OrderGoodsInfoEntity;
import com.ovopark.paas.api.entity.OrderInfoEntity;
import com.ovopark.paas.api.entity.OrderPriceEntity;
import com.ovopark.paas.api.entity.RealGG;
import com.ovopark.paas.api.entity.Response;
import com.ovopark.paas.api.entity.SetDeviceInfoEntity;
import com.ovopark.paas.api.entity.bo.AddAddressBo;
import com.ovopark.paas.api.entity.bo.CancelOrderForUserBo;
import com.ovopark.paas.api.entity.bo.CompleteOrderBo;
import com.ovopark.paas.api.entity.bo.DeviceBindAlgoBo;
import com.ovopark.paas.api.entity.bo.GetOrderDetailBo;
import com.ovopark.paas.api.entity.bo.GetOrderListBo;
import com.ovopark.paas.api.entity.bo.ManualConfirmReceiptBo;
import com.ovopark.paas.api.entity.bo.OlucWechatOrderStatusBo;
import com.ovopark.paas.api.entity.bo.OlucWechatPayBo;
import com.ovopark.paas.api.entity.bo.OrderSettleBo;
import com.ovopark.paas.api.entity.bo.PlaceOrderBo;
import com.ovopark.paas.api.entity.bo.SkuInfoEntity;
import com.ovopark.paas.api.entity.bo.UpdateAddressBo;
import com.ovopark.paas.api.entity.dao.AlgoModelInfoDao;
import com.ovopark.paas.api.entity.dao.AlgoVersionInfoDao;
import com.ovopark.paas.api.entity.dao.DeviceAlgoRelationInfoDao;
import com.ovopark.paas.api.entity.dao.UserAlgoDao;
import com.ovopark.paas.api.entity.vo.DeviceStatusPojo;
import com.ovopark.paas.api.entity.vo.GetGoodsDetailVo;
import com.ovopark.paas.api.entity.vo.GetOrderDetailVo;
import com.ovopark.paas.api.entity.vo.GetOrderListVo;
import com.ovopark.paas.api.entity.vo.GetSelectDepByUserIdVo;
import com.ovopark.paas.api.entity.vo.GetSkuListVo;
import com.ovopark.paas.api.entity.vo.GetTokenByPhoneVo;
import com.ovopark.paas.api.entity.vo.OlucWechatOrderStatusVo;
import com.ovopark.paas.api.entity.vo.OlucWechatPayInfoVo;
import com.ovopark.paas.api.entity.vo.OlucWechatPayVo;
import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import com.ovopark.paas.api.entity.vo.PlaceOrderVo;
import com.ovopark.paas.core.service.AlgoService;
import com.ovopark.paas.core.service.CommonClientService;
import com.ovopark.paas.core.service.NewDeviceService;
import com.ovopark.paas.core.service.OrderService;
import com.ovopark.paas.core.utils.CommonUtil;
import com.ovopark.paas.core.utils.DateUtil;
import com.ovopark.paas.repository.paas.mapper.AlgoModelInfoMapper;
import com.ovopark.paas.repository.paas.mapper.AlgoVersionInfoMapper;
import com.ovopark.paas.repository.paas.mapper.DeviceAlgoRelationInfoMapper;
import com.ovopark.paas.repository.paas.mapper.UserAlgoMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import java.util.stream.Collectors;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
@RefreshScope
public class OrderServiceImpl
implements OrderService {
    private static final Logger logger = LoggerFactory.getLogger(OrderServiceImpl.class);
    @Autowired(required=false)
    private OlucClient olucClient;
    @Autowired(required=false)
    private UserAlgoMapper userAlgoMapper;
    @Autowired
    private CommonUtil commonUtil;
    @Autowired
    private CommonClientService commonClientService;
    @Autowired(required=false)
    private DeviceAlgoRelationInfoMapper deviceAlgoRelationInfoMapper;
    @Autowired(required=false)
    private AlgoModelInfoMapper algoModelInfoMapper;
    @Value(value="${storeId}")
    private Integer storeId;
    @Value(value="${packagePrice}")
    private String packagePrice;
    @Autowired(required=false)
    private NewDeviceService newDeviceService;
    @Autowired
    private DeviceClientService deviceClientService;
    @Autowired
    private AlgoVersionInfoMapper algoVersionInfoMapper;
    @Autowired
    private AlgoService algoService;
    @Autowired
    private DeviceClient deviceClient;
    SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");

    @Override
    public Response<GetOrderListVo> getOrderList(String ticket, GetOrderListBo request) {
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.getOrderList(token, request);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1003), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u83b7\u53d6\u8ba2\u5355\u5931\u8d25" : response.getMessage()).build();
        }
        GetOrderListVo result = (GetOrderListVo)response.getData();
        if (result == null || CollectionUtils.isEmpty((Collection)result.getRecords())) {
            return Response.Builder.call().success((Object)result).build();
        }
        List records = result.getRecords();
        ArrayList<Integer> goodIds = new ArrayList<Integer>();
        records.forEach(m -> m.getOrderGoodsDTOList().forEach(n -> goodIds.add(n.getEnterpriseGoodsId())));
        List<ModelDetailEntity> modelList = this.commonClientService.getModelDetail(goodIds, null, null, 0);
        for (OrderInfoEntity orderInfo : records) {
            Iterator iterator;
            List orderGoodsDTOList = orderInfo.getOrderGoodsDTOList();
            if (!CollectionUtils.isNotEmpty((Collection)orderGoodsDTOList) || !(iterator = orderGoodsDTOList.iterator()).hasNext()) continue;
            OrderGoodsInfoEntity item = (OrderGoodsInfoEntity)iterator.next();
            OrderPriceEntity priceInfo = new OrderPriceEntity();
            priceInfo.setGoodsId(item.getEnterpriseGoodsId());
            priceInfo.setTotalPrice(item.getTotalPrice());
            priceInfo.setUnitPrice(item.getUnitPrice());
            priceInfo.setQuantity(item.getQuantity());
            GetPaasDetailTypeEntity typeInfo = this.getPaasDetailType(modelList, priceInfo, token);
            orderInfo.setPaasDetailType(typeInfo.getPaasDetailType());
            orderInfo.setDeviceType(typeInfo.getDeviceType());
            orderInfo.setBackgroundImg(typeInfo.getBackgroundImg());
        }
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<GetOrderListVo> getOrderDetail(String ticket, GetOrderDetailBo request) {
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.getOrderDetail(token, request);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1004), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u5931\u8d25" : response.getMessage()).build();
        }
        GetOrderDetailVo result = (GetOrderDetailVo)response.getData();
        if (CollectionUtils.isNotEmpty((Collection)result.getOrderGoodsDTOList())) {
            ArrayList<Integer> goodIds = new ArrayList<Integer>();
            result.getOrderGoodsDTOList().forEach(m -> goodIds.add(m.getEnterpriseGoodsId()));
            List<ModelDetailEntity> modelList = this.commonClientService.getModelDetail(goodIds, null, null, 0);
            for (OrderGoodsDTOListEntity item : result.getOrderGoodsDTOList()) {
                OrderPriceEntity priceInfo = new OrderPriceEntity();
                priceInfo.setGoodsId(item.getEnterpriseGoodsId());
                priceInfo.setTotalPrice(item.getTotalPrice());
                priceInfo.setUnitPrice(item.getUnitPrice());
                priceInfo.setQuantity(Integer.valueOf(item.getQuantity()));
                GetPaasDetailTypeEntity typeInfo = this.getPaasDetailType(modelList, priceInfo, token);
                item.setPaasDetailType(typeInfo.getPaasDetailType());
                item.setDeviceType(typeInfo.getDeviceType());
                item.setBackgroundImg(typeInfo.getBackgroundImg());
            }
        }
        return Response.Builder.call().success((Object)result).build();
    }

    private GetPaasDetailTypeEntity getPaasDetailType(List<ModelDetailEntity> list, OrderPriceEntity orderGoodsInfo, String token) {
        List infos;
        GetPaasDetailTypeEntity result = new GetPaasDetailTypeEntity();
        Integer type = PaasDetailTypeEnum.UnKnow.getCode();
        if (CollectionUtils.isNotEmpty(list) && CollectionUtils.isNotEmpty(infos = list.stream().filter(m -> m.getGoodsId().compareTo(orderGoodsInfo.getGoodsId()) == 0).collect(Collectors.toList()))) {
            type = orderGoodsInfo.getUnitPrice().multiply(new BigDecimal(orderGoodsInfo.getQuantity())).setScale(2, 4).compareTo(orderGoodsInfo.getTotalPrice()) == 0 ? PaasDetailTypeEnum.AI.getCode() : PaasDetailTypeEnum.AIPackage.getCode();
            result.setPaasDetailType(type);
            result.setBackgroundImg(((ModelDetailEntity)infos.get(0)).getBackgroundImg());
            return result;
        }
        GetGoodsDetailVo goodsDetail = this.commonClientService.getGoodsDetail(token, orderGoodsInfo.getGoodsId());
        if (goodsDetail != null && goodsDetail.getGoodsId() != null) {
            if (goodsDetail.getIsDevice().compareTo(1) == 0) {
                type = PaasDetailTypeEnum.Device.getCode();
                result.setDeviceType(goodsDetail.getDeviceType());
            } else {
                type = PaasDetailTypeEnum.AI.getCode();
            }
        }
        result.setPaasDetailType(type);
        return result;
    }

    @Override
    public Response<Object> manualConfirmReceipt(String ticket, ManualConfirmReceiptBo request) {
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.manualConfirmReceipt(token, request);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1001), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u786e\u8ba4\u6536\u8d27\u5931\u8d25" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    public Response<Object> addAddress(String ticket, AddAddressBo request) {
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.addAddress(token, request);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1001), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u6dfb\u52a0\u6536\u8d27\u4eba\u5730\u5740\u5931\u8d25" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    public Response<Object> updateAddress(String ticket, UpdateAddressBo request) {
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.updateAddress(token, request);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1001), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u66f4\u65b0\u5730\u5740\u5931\u8d25" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    public Response<Object> getAddressList(String ticket) {
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.getAddressList(token);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1001), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u83b7\u53d6\u6536\u8d27\u5730\u5740\u5217\u8868\u5931\u8d25" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    public Response<Object> orderSettle(String ticket, OrderSettleBo request) {
        request.setStoreId(this.storeId);
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.orderSettle(token, request);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1001), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u4e0b\u5355\u7ed3\u7b97\u5931\u8d25" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    @Transactional(rollbackFor={RuntimeException.class})
    public Response<PlaceOrderVo> placeOrder(String ticket, PlaceOrderBo request) {
        if (request == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u8bf7\u6c42\u53c2\u6570\u53cd\u5e8f\u5217\u5316\u5931\u8d25").build();
        }
        if (request.getChangeSkuRequest() != null && CollectionUtils.isEmpty((Collection)request.getChangeSkuRequest().getSkuIdList())) {
            return Response.Builder.call().error(Integer.valueOf(1004), "\u7f3a\u5c11\u5546\u54c1\u4fe1\u606f").build();
        }
        OvoparkUserInfoEntity userInfo = this.commonUtil.getUserInfo(ticket);
        if (userInfo == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), "\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25").build();
        }
        if (userInfo.getGroupId() == null) {
            return Response.Builder.call().error(Integer.valueOf(1006), "\u4e0d\u652f\u6301\u8d85\u7ba1\u4e0b\u5355").build();
        }
        Set<Object> supportAlgoSet = new HashSet();
        DeviceStatusPojo devInfo = null;
        SetDeviceInfoEntity deviceInfo = null;
        AlgoVersionInfoDao version = null;
        if (request.getIsPersonal() == 0) {
            if (request.getDeviceInfo() == null) {
                return Response.Builder.call().error(Integer.valueOf(1006), "\u4e2a\u4eba\u4e0b\u5355\uff0c\u9700\u8981\u6709\u8bbe\u5907\u4fe1\u606f").build();
            }
            deviceInfo = request.getDeviceInfo();
            RealGG devResponse = this.deviceClientService.getDeviceByMac(ticket, deviceInfo.getMac(), Integer.valueOf(1));
            if (devResponse == null || devResponse.getCode() != 0 || devResponse.getData() == null) {
                return Response.Builder.call().error(Integer.valueOf(1014), "\u672a\u80fd\u67e5\u8be2\u5230\u7b97\u6cd5\u6a21\u578b\u4fe1\u606f").build();
            }
            devInfo = (DeviceStatusPojo)devResponse.getData();
            List<Integer> modelIds = this.commonClientService.getDeviceSupportModelIds(ticket, deviceInfo.getDevId());
            if (CollectionUtils.isEmpty(modelIds)) {
                return Response.Builder.call().error(Integer.valueOf(1014), "\u8be5\u8bbe\u5907\u652f\u6301\u7684\u7b97\u6cd5\u4e3a\u7a7a").build();
            }
            supportAlgoSet = modelIds.stream().collect(Collectors.toSet());
            if (CollectionUtils.isEmpty(supportAlgoSet)) {
                return Response.Builder.call().error(Integer.valueOf(1014), "\u8be5\u8bbe\u5907\u652f\u6301\u7684\u7b97\u6cd5\u4e3a\u7a7a").build();
            }
        }
        GetOLUCTokenEntity tokenRequest = new GetOLUCTokenEntity();
        tokenRequest.setUserId(userInfo.getId());
        tokenRequest.setUserName(userInfo.getUserName());
        tokenRequest.setPhone(userInfo.getMobilePhone());
        String token = this.commonUtil.getOLUCToken(tokenRequest);
        request.setStoreId(this.storeId);
        if (request.getChangeSkuRequest() != null && CollectionUtils.isNotEmpty((Collection)request.getChangeSkuRequest().getSkuList())) {
            request.setSkuList(request.getChangeSkuRequest().getSkuList());
            List goodsIdList = request.getChangeSkuRequest().getSkuList().stream().map(m -> m.getGoodId()).collect(Collectors.toList());
            List skuIdList = request.getChangeSkuRequest().getSkuList().stream().map(m -> m.getSkuId()).collect(Collectors.toList());
            request.getChangeSkuRequest().setGoodsIdList(goodsIdList);
            request.getChangeSkuRequest().setSkuIdList(skuIdList);
            request.getChangeSkuRequest().setPrice(this.packagePrice);
        }
        if (CollectionUtils.isNotEmpty((Collection)request.getSkuList())) {
            List<Integer> goodsIds = request.getSkuList().stream().map(m -> m.getGoodId()).collect(Collectors.toList());
            List<ModelDetailEntity> modelList = this.commonClientService.getModelDetail(goodsIds, null, null, 0);
            List<Integer> idList = modelList.stream().map(m -> m.getId()).collect(Collectors.toList());
            if (CollectionUtils.isNotEmpty(modelList)) {
                boolean rightResult;
                if (request.getIsPersonal() == 1) {
                    rightResult = this.commonClientService.closeRightRecord(userInfo.getGroupId(), idList);
                    if (rightResult) {
                        return Response.Builder.call().error(Integer.valueOf(1007), "\u6743\u9650\u88ab\u5173\u95ed\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406").build();
                    }
                } else {
                    rightResult = this.commonClientService.closeUserRightRecord(userInfo.getId(), idList);
                    if (rightResult) {
                        return Response.Builder.call().error(Integer.valueOf(1007), "\u4e2a\u4eba\u6743\u9650\u88ab\u5173\u95ed\uff0c\u8bf7\u8054\u7cfb\u7ba1\u7406\u5458\u5904\u7406").build();
                    }
                }
            }
        }
        ArrayList<UserAlgoDao> algoOrderList = new ArrayList<UserAlgoDao>();
        UserAlgoDao model = new UserAlgoDao();
        ArrayList<DeviceAlgoRelationInfoDao> bindList = new ArrayList<DeviceAlgoRelationInfoDao>();
        UserAlgoDao oldOrder = new UserAlgoDao();
        for (SkuInfoEntity skuInfo : request.getSkuList()) {
            if (skuInfo == null || skuInfo.getSkuId() == null || skuInfo.getGoodId() == null || skuInfo.getNum() == null) {
                return Response.Builder.call().error(Integer.valueOf(1009), "\u7f3a\u5c11\u5546\u54c1\u4fe1\u606f").build();
            }
            List<GetSkuListVo> skuList = this.commonClientService.getSkuList(token, skuInfo.getGoodId());
            if (CollectionUtils.isEmpty(skuList)) {
                return Response.Builder.call().error(Integer.valueOf(1011), "\u672a\u80fd\u67e5\u8be2\u5230\u8be5\u5546\u54c1\u4fe1\u606f").build();
            }
            List skus = skuList.stream().filter(m -> skuInfo.getSkuId().compareTo(m.getGoodsSkuId()) == 0).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(skus)) {
                return Response.Builder.call().error(Integer.valueOf(1012), "\u8be5\u5546\u54c1\u5df2\u4e0b\u67b6").build();
            }
            GetSkuListVo skuDetail = (GetSkuListVo)skus.get(0);
            if (!this.commonClientService.isAlgoOrder(token, skuDetail.getCategoryId()).booleanValue()) continue;
            if (skuDetail.getDays() == 0 || skuDetail.getDays().compareTo(0) <= 0) {
                return Response.Builder.call().error(Integer.valueOf(1013), "\u672a\u80fd\u83b7\u53d6\u5230\u5546\u54c1\u6743\u76ca\u4fe1\u606f").build();
            }
            LambdaQueryWrapper modelWrapper = new LambdaQueryWrapper();
            modelWrapper.eq(AlgoModelInfoDao::getIsGoods, (Object)1);
            modelWrapper.eq(AlgoModelInfoDao::getGoodsId, (Object)String.valueOf(skuDetail.getGoodsId()));
            modelWrapper.eq(AlgoModelInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
            AlgoModelInfoDao algoModelInfo = (AlgoModelInfoDao)this.algoModelInfoMapper.selectOne((Wrapper)modelWrapper);
            if (algoModelInfo == null) {
                return Response.Builder.call().error(Integer.valueOf(1014), "\u672a\u80fd\u67e5\u8be2\u5230\u7b97\u6cd5\u6a21\u578b\u4fe1\u606f").build();
            }
            if (request.getIsPersonal() == 0 && !supportAlgoSet.contains(algoModelInfo.getId())) {
                return Response.Builder.call().error(Integer.valueOf(1014), "\u8be5\u8bbe\u5907\u4e0d\u652f\u6301\u8be5\u7b97\u6cd5\u6a21\u578b").build();
            }
            Date date = new Date();
            date.setTime(date.getTime() - 900000L);
            LambdaQueryWrapper infoWrapper = new LambdaQueryWrapper();
            infoWrapper.eq(UserAlgoDao::getModelId, (Object)algoModelInfo.getId());
            infoWrapper.eq(UserAlgoDao::getGroupId, (Object)userInfo.getGroupId());
            infoWrapper.ge(UserAlgoDao::getCreateTime, (Object)date);
            infoWrapper.eq(UserAlgoDao::getRowStatus, (Object)RowStatusEnum.Invalid.getCode());
            List infoList = this.userAlgoMapper.selectList((Wrapper)infoWrapper);
            if (CollectionUtils.isNotEmpty((Collection)infoList) && this.commonUtil.isRightBusinessType(algoModelInfo.getBusinessType(), BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
                if (algoModelInfo.getIsGoods().compareTo(1) == 0) {
                    GetOrderDetailBo params = new GetOrderDetailBo();
                    params.setId(((UserAlgoDao)infoList.get(0)).getOrderId().toString());
                    HttpResponseEntity response = this.olucClient.getOrderDetail(token, params);
                    if (response == null || response.getCode() != 200 || response.getData() == null || ((GetOrderDetailVo)response.getData()).getOrderDTO() == null) {
                        return Response.Builder.call().error(Integer.valueOf(1004), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u83b7\u53d6\u8ba2\u5355\u8be6\u60c5\u5931\u8d25" : response.getMessage()).build();
                    }
                    GetOrderDetailVo result = (GetOrderDetailVo)response.getData();
                    if (result.getOrderDTO().getOrderStatus() == 1) {
                        return Response.Builder.call().error(Integer.valueOf(1015), "\u5b58\u5728\u672a\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u652f\u4ed8\u6216\u53d6\u6d88\u540e\u91cd\u65b0\u4e0b\u5355").build();
                    }
                } else {
                    return Response.Builder.call().error(Integer.valueOf(1014), "\u5b58\u5728\u672a\u652f\u4ed8\u8ba2\u5355\u4fe1\u606f\uff0c\u8bf7\u652f\u4ed8\u6216\u53d6\u6d88\u540e\u91cd\u65b0\u4e0b\u5355").build();
                }
            }
            DeviceAlgoRelationInfoDao oldInfo = null;
            LambdaQueryWrapper orderWrapper = new LambdaQueryWrapper();
            oldOrder = new UserAlgoDao();
            if (request.getBindInfoId() != null && request.getBindInfoId().compareTo(0) > 0 && !this.commonUtil.isRightBusinessType(algoModelInfo.getBusinessType(), BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
                oldInfo = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectById((Serializable)request.getBindInfoId());
                if (oldInfo == null || oldInfo.getId() == null) {
                    return Response.Builder.call().error(Integer.valueOf(1015), "\u67e5\u8be2\u5386\u53f2\u8ba2\u5355\u5931\u8d25").build();
                }
                orderWrapper.eq(UserAlgoDao::getOrderId, (Object)oldInfo.getOrderId());
                orderWrapper.eq(UserAlgoDao::getModelId, (Object)algoModelInfo.getId());
                oldOrder = (UserAlgoDao)this.userAlgoMapper.selectOne((Wrapper)orderWrapper);
            } else if (this.commonUtil.isRightBusinessType(algoModelInfo.getBusinessType(), BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
                orderWrapper.eq(UserAlgoDao::getModelId, (Object)algoModelInfo.getId());
                orderWrapper.eq(UserAlgoDao::getGroupId, (Object)userInfo.getGroupId());
                orderWrapper.ge(UserAlgoDao::getExpire, (Object)this.format.format(new Date()));
                orderWrapper.eq(UserAlgoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
                orderWrapper.orderByDesc(UserAlgoDao::getId);
                List oldList = this.userAlgoMapper.selectList((Wrapper)orderWrapper);
                if (CollectionUtils.isNotEmpty((Collection)oldList) && CollectionUtils.isNotEmpty(oldList = oldList.stream().filter(m -> m.getRowStatus().compareTo(RowStatusEnum.Valid.getCode()) == 0).collect(Collectors.toList()))) {
                    oldOrder = (UserAlgoDao)oldList.get(0);
                    oldOrder.setIsRenew(Integer.valueOf(0));
                    oldOrder.setServiceId(Integer.valueOf(0));
                    oldOrder.setNewOrderId(Integer.valueOf(0));
                }
            }
            if (oldOrder != null && oldOrder.getId() != null && oldInfo != null) {
                oldOrder.setIsRenew(Integer.valueOf(1));
                oldOrder.setServiceId(oldInfo.getId());
                oldOrder.setNewOrderId(Integer.valueOf(0));
            } else if (oldOrder != null && oldOrder.getId() != null) {
                oldOrder.setIsRenew(Integer.valueOf(1));
                oldOrder.setServiceId(Integer.valueOf(0));
                oldOrder.setNewOrderId(Integer.valueOf(0));
            }
            String sign = UUID.randomUUID().toString().replaceAll("-", "");
            model = new UserAlgoDao();
            model.setAlgoId(String.valueOf(skuDetail.getGoodsId()));
            model.setSkuId(Integer.valueOf(skuDetail.getGoodsSkuId()));
            model.setNums(skuInfo.getNum());
            model.setGroupId(userInfo.getGroupId());
            model.setRowStatus(Integer.valueOf(0));
            model.setCreateBy(userInfo.getUserName());
            model.setRightFrom(Integer.valueOf(0));
            model.setOrderType(Integer.valueOf(0));
            model.setIsRenew(Integer.valueOf(0));
            model.setServiceId(Integer.valueOf(0));
            model.setNewOrderId(Integer.valueOf(0));
            model.setModelId(Integer.valueOf(0));
            model.setAlgoType(Integer.valueOf(0));
            model.setOrderId(Integer.valueOf(0));
            model.setOrderSn("");
            model.setIsPersonal(request.getIsPersonal());
            model.setDays(Integer.valueOf(request.getBusinessCode().equals("5") ? OlucConstant.packageRightDays : (this.commonUtil.isRightBusinessType(algoModelInfo.getBusinessType(), BusinessTypeEnum.bird.getCode(), null) != false ? skuInfo.getNum() * skuDetail.getDays() : skuDetail.getDays())));
            model.setUserId(userInfo.getId().toString());
            model.setPhone(StringUtils.isEmpty((CharSequence)userInfo.getMobilePhone()) ? "" : userInfo.getMobilePhone());
            model.setUpdateBy(userInfo.getUserName());
            model.setModelId(algoModelInfo.getId());
            model.setAlgoType(algoModelInfo.getCheckType().compareTo(CheckTypeEnum.Hardware.getCode()) == 0 ? AlgoTypeEnum.Hardware.getCode() : AlgoTypeEnum.Soft.getCode());
            if (request.getIsPersonal() == 0) {
                model.setExpire(DateUtil.addTime(new Date(), model.getDays()));
                logger.info("\u4e2a\u4eba\u4e0b\u5355\u9700\u8981\u5904\u7406\u8fc7\u671f\u65f6\u95f4{}\u548c\u6807\u5fd7{}", (Object)model.getExpire());
            }
            if (request.getIsPersonal() == 0) {
                LambdaQueryWrapper versionWrapper = new LambdaQueryWrapper();
                versionWrapper.in(AlgoVersionInfoDao::getModelId, new Object[]{algoModelInfo.getId()});
                versionWrapper.eq(AlgoVersionInfoDao::getStatus, (Object)OnlineStatusEnum.On.getCode());
                versionWrapper.eq(AlgoVersionInfoDao::getRowStatus, (Object)RowStatusEnum.Valid.getCode());
                versionWrapper.ne(AlgoVersionInfoDao::getAlgoCode, (Object)"");
                versionWrapper.orderByDesc(AlgoVersionInfoDao::getStatus, (Object[])new SFunction[]{AlgoVersionInfoDao::getId});
                List versionInfos = this.algoVersionInfoMapper.selectList((Wrapper)versionWrapper);
                if (versionInfos == null || versionInfos.size() == 0) {
                    return Response.Builder.call().error(Integer.valueOf(1008), "\u8be5\u7b97\u6cd5\u6a21\u578b\u5e76\u6ca1\u6709\u7248\u672c\u4fe1\u606f").build();
                }
                version = (AlgoVersionInfoDao)versionInfos.get(0);
            }
            if (!(this.commonUtil.isRightBusinessType(algoModelInfo.getBusinessType(), BusinessTypeEnum.bird.getCode(), null).booleanValue() || oldOrder != null && oldOrder.getIsRenew() != null && oldOrder.getIsRenew().compareTo(0) != 0)) {
                for (int i = 0; i < model.getNums(); ++i) {
                    DeviceAlgoRelationInfoDao bindModel = this.commonClientService.getDeviceAlgoRelationInfoDao(userInfo, model, algoModelInfo.getId(), algoModelInfo.getBusinessType(), RowStatusEnum.Invalid.getCode());
                    if (bindModel == null) continue;
                    if (bindModel.getIsPersonal() == 0) {
                        HttpResponseEntity response = this.deviceClient.getSelectDepByUserId(ticket, userInfo.getGroupId(), userInfo.getId(), null);
                        if (response == null || response.getCode() != 0) {
                            String msg = response != null && StringUtils.isNotEmpty((CharSequence)response.getMessage()) ? response.getMessage() : "\u83b7\u53d6\u95e8\u5e97\u5931\u8d25";
                            return Response.Builder.call().error(Integer.valueOf(1002), msg).build();
                        }
                        List selectDepByUserId = (List)response.getData();
                        GetSelectDepByUserIdVo getSelectDepByUserIdVo = (GetSelectDepByUserIdVo)selectDepByUserId.get(0);
                        bindModel.setDepId(getSelectDepByUserIdVo.getId());
                        bindModel.setDepName(getSelectDepByUserIdVo.getName());
                        bindModel.setDeviceId(deviceInfo.getDevId());
                        bindModel.setDeviceName(deviceInfo.getName());
                        bindModel.setMac(deviceInfo.getMac());
                        bindModel.setImg(deviceInfo.getImg());
                        bindModel.setDType(devInfo.getDType());
                        bindModel.setDeviceType(devInfo.getDeviceType());
                        if (version != null) {
                            bindModel.setAlgoVersion(version.getVersion());
                            bindModel.setVersionId(version.getId());
                        }
                    }
                    bindList.add(bindModel);
                }
            }
            if (oldOrder != null && oldOrder.getIsRenew() != null) {
                algoOrderList.add(oldOrder);
            }
            algoOrderList.add(model);
        }
        if (CollectionUtils.isEmpty(algoOrderList)) {
            return Response.Builder.call().error(Integer.valueOf(1014), "\u672a\u80fd\u83b7\u53d6\u5230\u8ba2\u5355\u5546\u54c1\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355").build();
        }
        HttpResponseEntity httpResponseEntity = this.olucClient.placeOrder(token, request);
        if (httpResponseEntity == null || httpResponseEntity.getCode() != 200 || httpResponseEntity.getData() == null) {
            String msg = httpResponseEntity != null && StringUtils.isNotEmpty((CharSequence)httpResponseEntity.getMessage()) ? httpResponseEntity.getMessage() : "\u4e0b\u5355\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355";
            return Response.Builder.call().error(Integer.valueOf(1008), msg).build();
        }
        for (UserAlgoDao item : algoOrderList) {
            if (item.getOrderId().compareTo(0) == 0 && StringUtils.isEmpty((CharSequence)item.getOrderSn())) {
                item.setOrderId(Integer.valueOf(((PlaceOrderVo)httpResponseEntity.getData()).getId()));
                item.setOrderSn(((PlaceOrderVo)httpResponseEntity.getData()).getOrderSn());
            }
            if (item.getIsRenew().compareTo(1) != 0 || item.getNewOrderId().compareTo(0) != 0) continue;
            item.setNewOrderId(Integer.valueOf(((PlaceOrderVo)httpResponseEntity.getData()).getId()));
        }
        int row = this.userAlgoMapper.upsertBatch(algoOrderList);
        if (row > 0 && CollectionUtils.isNotEmpty(bindList)) {
            bindList.forEach(m -> m.setOrderId(Integer.valueOf(((PlaceOrderVo)httpResponseEntity.getData()).getId())));
            int bindRow = this.deviceAlgoRelationInfoMapper.upsert(bindList);
            if (bindRow < 0) {
                return Response.Builder.call().error(Integer.valueOf(1015), "\u751f\u6210\u7ed1\u5b9a\u8bb0\u5f55\u5931\u8d25\uff0c\u8bf7\u91cd\u65b0\u4e0b\u5355").build();
            }
        }
        return Response.Builder.call().success(httpResponseEntity.getData()).build();
    }

    @Override
    public Response<Object> getDeliveryMode(String ticket) {
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.getDeliveryMode(token, this.storeId);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1001), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u914d\u9001\u4fe1\u606f\u83b7\u53d6\u5931\u8d25" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public Response<Boolean> setUserAlgoInfo(String orderSn) {
        if (StringUtils.isEmpty((CharSequence)orderSn)) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u672a\u80fd\u83b7\u53d6\u5230\u8ba2\u5355\u53f7").build();
        }
        logger.info("\u652f\u4ed8\u56de\u8c03\u8ba2\u5355\u53f7\u4e3a: " + orderSn);
        LambdaUpdateWrapper orderWrapper = new LambdaUpdateWrapper();
        ((LambdaUpdateWrapper)((LambdaUpdateWrapper)orderWrapper.eq(UserAlgoDao::getOrderSn, (Object)orderSn)).eq(UserAlgoDao::getRowStatus, (Object)0)).set(UserAlgoDao::getRowStatus, (Object)1);
        this.userAlgoMapper.update(null, (Wrapper)orderWrapper);
        LambdaUpdateWrapper wrapper = new LambdaUpdateWrapper();
        wrapper.eq(UserAlgoDao::getOrderSn, (Object)orderSn);
        List orderList = this.userAlgoMapper.selectList((Wrapper)wrapper);
        if (CollectionUtils.isEmpty((Collection)orderList)) {
            return Response.Builder.call().error(Integer.valueOf(1005), "\u67e5\u65e0\u8ba2\u5355").build();
        }
        if (CollectionUtils.isEmpty(orderList = orderList.stream().filter(m -> m.getRowStatus().compareTo(RowStatusEnum.Valid.getCode()) == 0).collect(Collectors.toList()))) {
            return Response.Builder.call().error(Integer.valueOf(1010), "\u67e5\u65e0\u6709\u6548\u8ba2\u5355").build();
        }
        LambdaUpdateWrapper queryWrapper = new LambdaUpdateWrapper();
        queryWrapper.eq(UserAlgoDao::getNewOrderId, (Object)((UserAlgoDao)orderList.get(0)).getOrderId());
        List oldList = this.userAlgoMapper.selectList((Wrapper)queryWrapper);
        UserAlgoDao model = (UserAlgoDao)orderList.get(0);
        GetOLUCTokenEntity userInfo = new GetOLUCTokenEntity();
        userInfo.setUserId(Integer.valueOf(model.getUserId()));
        userInfo.setUserName(model.getCreateBy());
        userInfo.setPhone(model.getPhone());
        String token = this.commonUtil.getOLUCToken(userInfo);
        List modelIds = orderList.stream().map(m -> m.getModelId()).collect(Collectors.toList());
        List modelList = this.algoModelInfoMapper.selectBatchIds(modelIds);
        HashSet<Integer> code = new HashSet<Integer>();
        ArrayList configList = new ArrayList();
        for (UserAlgoDao item : orderList) {
            LambdaUpdateWrapper updateWrapper = new LambdaUpdateWrapper();
            ((LambdaUpdateWrapper)((LambdaUpdateWrapper)updateWrapper.eq(DeviceAlgoRelationInfoDao::getOrderId, (Object)item.getOrderId())).eq(DeviceAlgoRelationInfoDao::getRowStatus, (Object)0)).set(DeviceAlgoRelationInfoDao::getRowStatus, (Object)1);
            this.deviceAlgoRelationInfoMapper.update(null, (Wrapper)updateWrapper);
            List<Object> skuList = this.commonClientService.getSkuList(token, Integer.valueOf(item.getAlgoId()));
            if (CollectionUtils.isEmpty(skuList)) {
                return Response.Builder.call().error(Integer.valueOf(1008), "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25").build();
            }
            if (CollectionUtils.isEmpty(skuList = skuList.stream().filter(m -> m.getGoodsSkuId() == item.getSkuId().intValue()).collect(Collectors.toList()))) {
                return Response.Builder.call().error(Integer.valueOf(1009), "\u5546\u54c1\u4fe1\u606f\u67e5\u8be2\u5931\u8d25").build();
            }
            List modelInfos = modelList.stream().filter(m -> m.getId().compareTo(item.getModelId()) == 0).collect(Collectors.toList());
            Integer businessType = null;
            if (CollectionUtils.isNotEmpty(modelInfos)) {
                businessType = ((AlgoModelInfoDao)modelInfos.get(0)).getBusinessType();
            }
            boolean algoIssued = false;
            if (CollectionUtils.isNotEmpty((Collection)oldList)) {
                List itemOldOrder = oldList.stream().filter(m -> m.getNewOrderId().compareTo(item.getOrderId()) == 0).collect(Collectors.toList());
                if (CollectionUtils.isNotEmpty(itemOldOrder) && !this.commonUtil.isRightBusinessType(businessType, BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
                    Date newTime;
                    DeviceAlgoRelationInfoDao oldInfo = (DeviceAlgoRelationInfoDao)this.deviceAlgoRelationInfoMapper.selectById((Serializable)((UserAlgoDao)itemOldOrder.get(0)).getServiceId());
                    oldInfo.setOrderId(item.getOrderId());
                    Date date = newTime = oldInfo.getExpire().getTime() > new Date().getTime() ? oldInfo.getExpire() : new Date();
                    if (oldInfo.getOrderType().compareTo(0) == 0) {
                        oldInfo.setExpire(DateUtil.addTime(newTime, ((GetSkuListVo)skuList.get(0)).getDays()));
                    } else {
                        oldInfo.setExpire(DateUtil.addTime(newTime, OlucConstant.packageRightDays));
                    }
                    oldInfo.setUpdateBy(item.getCreateBy());
                    oldInfo.setUpdateTime(new Date());
                    this.deviceAlgoRelationInfoMapper.updateById((Object)oldInfo);
                    if (oldInfo.getDeviceId() > 0) {
                        OvoparkUserInfoEntity userModelInfo = new OvoparkUserInfoEntity();
                        userModelInfo.setUserName(item.getCreateBy());
                        this.newDeviceService.insertUpdateAlgoConfigQueue(oldInfo.getId(), null, userModelInfo, "");
                    }
                    algoIssued = true;
                } else if (CollectionUtils.isNotEmpty(itemOldOrder)) {
                    Date newTime = ((UserAlgoDao)itemOldOrder.get(0)).getExpire() != null && ((UserAlgoDao)itemOldOrder.get(0)).getExpire().getTime() > new Date().getTime() ? ((UserAlgoDao)itemOldOrder.get(0)).getExpire() : new Date();
                    item.setExpire(DateUtil.addTime(newTime, item.getDays()));
                    this.userAlgoMapper.updateById((Object)item);
                }
            } else if (this.commonUtil.isRightBusinessType(businessType, BusinessTypeEnum.bird.getCode(), null).booleanValue()) {
                item.setExpire(DateUtil.addTime(new Date(), item.getDays()));
                this.userAlgoMapper.updateById((Object)item);
            }
            this.commonClientService.addAlgoRightInfo(item.getGroupId(), item.getModelId(), item.getUpdateBy(), item.getIsPersonal(), item.getUserId());
            if (item.getIsPersonal() != 0 || algoIssued) continue;
            code.add(item.getOrderId());
        }
        try {
            CompleteOrderBo request = new CompleteOrderBo();
            request.setOrderId(model.getOrderId().toString());
            this.olucClient.completeOrder(token, request);
        }
        catch (Exception exception) {
            logger.error("\u652f\u4ed8\u56de\u8c03--\u4e07\u96c6\u7b97\u6cd5\u8ba2\u5355\u5b8c\u6210\u63a5\u53e3\u8c03\u7528\u51fa\u9519\u4e86\uff0cerror:{}", (Object)exception.toString());
        }
        if (code.size() > 0) {
            for (Integer orderId : code) {
                List deviceAlgoRelationInfo = this.deviceAlgoRelationInfoMapper.selectList((Wrapper)new LambdaQueryWrapper().eq(DeviceAlgoRelationInfoDao::getOrderId, (Object)orderId));
                if (deviceAlgoRelationInfo.size() == 0) {
                    logger.error("orderSn--{},\u4e0b\u53d1\u7b97\u6cd5\u9636\u6bb5\uff0c\u8ba2\u5355\u6807\u8bc6{}\u83b7\u53d6\u8bbe\u5907\u7b97\u6cd5\u76f8\u5173\u4fe1\u606f\u5931\u8d25", (Object)orderSn, (Object)orderId);
                    return Response.Builder.call().error(Integer.valueOf(1008), "\u8ba2\u5355\u5df2\u7ecf\u5b8c\u6210\uff0c\u4e0b\u53d1\u7b97\u6cd5\u51fa\u73b0\u5f02\u5e38\uff0c\u534f\u8c03\u5de5\u4f5c\u4eba\u5458").build();
                }
                DeviceAlgoRelationInfoDao deviceAlgoRelation = (DeviceAlgoRelationInfoDao)deviceAlgoRelationInfo.get(0);
                DeviceBindAlgoBo deviceBindAlgoBo = new DeviceBindAlgoBo();
                deviceBindAlgoBo.setId(deviceAlgoRelation.getId());
                deviceBindAlgoBo.setIsPackage(Integer.valueOf(0));
                deviceBindAlgoBo.setGroupId(deviceAlgoRelation.getGroupId());
                SetDeviceInfoEntity deviceInfos = new SetDeviceInfoEntity();
                deviceInfos.setDevId(deviceAlgoRelation.getDeviceId());
                deviceInfos.setMac(deviceAlgoRelation.getMac());
                deviceInfos.setName(deviceAlgoRelation.getDeviceName());
                deviceInfos.setImg(deviceAlgoRelation.getImg());
                deviceBindAlgoBo.setDeviceInfos((List)ListUtil.toList((Object[])new SetDeviceInfoEntity[]{deviceInfos}));
                GetTokenByPhoneVo tokenInfo = this.commonUtil.getDeviceTokenByUserId(Integer.valueOf(model.getUserId()));
                this.algoService.bindDevice(tokenInfo.getToken(), deviceBindAlgoBo);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
                this.deviceAlgoRelationInfoMapper.updateStartTime(deviceAlgoRelation.getId(), simpleDateFormat.format(new Date()));
            }
        }
        return Response.Builder.call().success((Object)true).build();
    }

    @Override
    public Response<OlucWechatPayInfoVo> olucWechatPay(String ticket, String orderSn) {
        if (StringUtils.isEmpty((CharSequence)orderSn)) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u672a\u80fd\u83b7\u53d6\u5230\u8ba2\u5355\u53f7").build();
        }
        String token = this.commonUtil.getToken(ticket);
        OlucWechatPayBo params = new OlucWechatPayBo();
        params.setOrderNo(orderSn);
        params.setStoreId(this.storeId);
        params.setPayType(Integer.valueOf(8));
        HttpResponseEntity response = this.olucClient.olucWechatPay(token, params);
        if (response == null || response.getCode() != 200 || response.getData() == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5" : response.getMessage()).build();
        }
        if (StringUtils.isEmpty((CharSequence)((OlucWechatPayVo)response.getData()).getResultCode()) || !((OlucWechatPayVo)response.getData()).getResultCode().equals("SUCCESS")) {
            return Response.Builder.call().error(Integer.valueOf(1006), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u652f\u4ed8\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5" : response.getMessage()).build();
        }
        OlucWechatPayInfoVo result = new OlucWechatPayInfoVo();
        result.setCodeUrl(((OlucWechatPayVo)response.getData()).getCodeUrl());
        return Response.Builder.call().success((Object)result).build();
    }

    @Override
    public Response<OlucWechatOrderStatusVo> olucWechatOrderStatus(String ticket, String orderSn) {
        if (StringUtils.isEmpty((CharSequence)orderSn)) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u672a\u80fd\u83b7\u53d6\u5230\u8ba2\u5355\u53f7").build();
        }
        String token = this.commonUtil.getToken(ticket);
        OlucWechatOrderStatusBo params = new OlucWechatOrderStatusBo();
        params.setOrderNo(orderSn);
        HttpResponseEntity response = this.olucClient.olucWechatOrderStatus(token, params);
        if (response == null || response.getCode() != 200 || response.getData() == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u83b7\u53d6\u8ba2\u5355\u72b6\u6001\u5931\u8d25" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    public Response<Object> getLogisticsDetail(String ticket, Integer orderId) {
        if (orderId == null) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u672a\u80fd\u83b7\u53d6\u5230\u8ba2\u5355\u53f7").build();
        }
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.getLogisticsDetail(token, orderId);
        if (response == null || response.getCode() != 200 || response.getData() == null) {
            return Response.Builder.call().error(Integer.valueOf(1005), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u83b7\u53d6\u7269\u6d41\u4fe1\u606f\u5931\u8d25" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }

    @Override
    public Response<Object> cancelOrderForUser(String ticket, CancelOrderForUserBo request) {
        if (request == null || StringUtils.isEmpty((CharSequence)request.getId())) {
            return Response.Builder.call().error(Integer.valueOf(1003), "\u672a\u80fd\u83b7\u53d6\u5230\u8ba2\u5355\u53f7").build();
        }
        String token = this.commonUtil.getToken(ticket);
        HttpResponseEntity response = this.olucClient.cancelOrderForUser(token, request);
        if (response == null || response.getCode() != 200) {
            return Response.Builder.call().error(Integer.valueOf(1005), response == null || StringUtils.isEmpty((CharSequence)response.getMessage()) ? "\u53d6\u6d88\u5931\u8d25\uff0c\u8bf7\u91cd\u8bd5" : response.getMessage()).build();
        }
        return Response.Builder.call().success(response.getData()).build();
    }
}

