/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.utils;

import cn.hutool.crypto.digest.MD5;
import com.alibaba.fastjson.JSONObject;
import com.alibaba.fastjson.TypeReference;
import com.alibaba.fastjson.parser.Feature;
import com.ovopark.open.paasclient.DeviceClient;
import com.ovopark.open.paasclient.OlucClient;
import com.ovopark.open.service.DeviceClientService;
import com.ovopark.paas.api.entity.GetOLUCTokenEntity;
import com.ovopark.paas.api.entity.HttpResponseEntity;
import com.ovopark.paas.api.entity.RealGG;
import com.ovopark.paas.api.entity.bo.GetOLUCTokenBo;
import com.ovopark.paas.api.entity.dao.AlgoModelInfoDao;
import com.ovopark.paas.api.entity.vo.GetCategoryVo;
import com.ovopark.paas.api.entity.vo.GetEnterpriseListVo;
import com.ovopark.paas.api.entity.vo.GetMyInfoVo;
import com.ovopark.paas.api.entity.vo.GetOLUCTokenVo;
import com.ovopark.paas.api.entity.vo.GetTokenByPhoneVo;
import com.ovopark.paas.api.entity.vo.OvoparkUserInfoEntity;
import com.ovopark.paas.core.config.RequestContext;
import com.ovopark.paas.repository.paas.mapper.AlgoModelInfoMapper;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.time.Duration;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.crypto.BadPaddingException;
import javax.crypto.Cipher;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.KeyGenerator;
import javax.crypto.NoSuchPaddingException;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.collections4.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cloud.context.config.annotation.RefreshScope;
import org.springframework.data.redis.core.RedisTemplate;
import org.springframework.stereotype.Component;

@Component
@RefreshScope
public class CommonUtil {
    private static final Logger logger = LoggerFactory.getLogger(CommonUtil.class);
    @Autowired
    private RedisTemplate<String, Object> redisTemplate;
    @Autowired(required=false)
    private OlucClient olucClient;
    @Autowired(required=false)
    private DeviceClient deviceClient;
    @Autowired(required=false)
    private DeviceClientService deviceClientService;
    @Autowired(required=false)
    private AlgoModelInfoMapper algoModelInfoMapper;
    @Value(value="${deviceAuthorization}")
    private String authorization;
    @Value(value="${app.id}")
    private String serverName;
    @Value(value="${active.env}")
    private String env;
    @Value(value="${redisChangeKey}")
    private Integer redisChangeKey;
    @Value(value="${uploadFreqTypeList}")
    private String uploadFreqTypeList;

    public String toMd5(String key) {
        if (StringUtils.isEmpty((CharSequence)key)) {
            return "";
        }
        String md5key = String.format("%s_%s_%s_%s", this.redisChangeKey, this.serverName, this.env, key);
        return MD5.create().digestHex(md5key.getBytes(StandardCharsets.UTF_8));
    }

    public Integer getGroupId(String token, OvoparkUserInfoEntity userInfo, Integer groupId) {
        if (StringUtils.isEmpty((CharSequence)token) && (userInfo == null || userInfo.getId() == null)) {
            return null;
        }
        if (userInfo == null || userInfo.getId() == null) {
            userInfo = this.getUserInfo(token);
        }
        if (userInfo == null || userInfo.getId() == null) {
            return null;
        }
        if (userInfo.getGroupId() == null && groupId != null) {
            RealGG response = this.deviceClient.getEnterpriseList(token);
            if (response == null || response.getCode() != 0 || CollectionUtils.isEmpty((Collection)((Collection)response.getData()))) {
                return null;
            }
            List list = (List)response.getData();
            if (CollectionUtils.isNotEmpty(list = list.stream().filter(m -> Integer.valueOf(m.getId()).compareTo(groupId) == 0).collect(Collectors.toList()))) {
                userInfo.setGroupId(Integer.valueOf(((GetEnterpriseListVo)list.get(0)).getId()));
            }
        }
        return userInfo.getGroupId();
    }

    public OvoparkUserInfoEntity getUserInfo(String token) {
        if (StringUtils.isEmpty((CharSequence)token)) {
            return null;
        }
        OvoparkUserInfoEntity user = RequestContext.getCurrentContext().getUserInfo();
        if (user != null) {
            return user;
        }
        RealGG response = this.deviceClientService.getMyInfo(token);
        if (response == null || response.getCode() != 0 || response.getData() == null || ((GetMyInfoVo)response.getData()).getData() == null) {
            return null;
        }
        return ((GetMyInfoVo)response.getData()).getData();
    }

    public GetTokenByPhoneVo getDeviceToken(String phone) {
        try {
            String key = this.toMd5(String.format("%s_getDeviceToken", phone));
            Object resultObj = this.redisTemplate.opsForValue().get((Object)key);
            if (resultObj != null) {
                GetTokenByPhoneVo res = (GetTokenByPhoneVo)JSONObject.parseObject((String)resultObj.toString(), GetTokenByPhoneVo.class);
                return res;
            }
            RealGG result = this.deviceClient.getTokenByPhone(this.authorization, phone);
            if (result == null || result.getCode() != 0 || result.getData() == null) {
                return null;
            }
            String token = String.format("%s web 1.0 SIMPLIFIED_CHINESE GMT+8:00", ((GetTokenByPhoneVo)result.getData()).getToken());
            ((GetTokenByPhoneVo)result.getData()).setToken(token);
            this.redisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)result.getData()), Duration.ofSeconds(1500L));
            return (GetTokenByPhoneVo)result.getData();
        }
        catch (Exception ex) {
            logger.error(String.format("\u83b7\u53d6\u4e3b\u7ebftoken\u5931\u8d25\u3002phone\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", phone, ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
            return null;
        }
    }

    public GetTokenByPhoneVo getDeviceTokenByUserId(Integer userId) {
        try {
            String key = this.toMd5(String.format("%s_getDeviceToken", userId));
            Object resultObj = this.redisTemplate.opsForValue().get((Object)key);
            if (resultObj != null) {
                GetTokenByPhoneVo res = (GetTokenByPhoneVo)JSONObject.parseObject((String)resultObj.toString(), GetTokenByPhoneVo.class);
                return res;
            }
            RealGG result = this.deviceClient.getTokenByUserId(this.authorization, userId);
            if (result == null || result.getCode() != 0 || result.getData() == null) {
                return null;
            }
            String token = String.format("%s web 1.0 SIMPLIFIED_CHINESE GMT+8:00", ((GetTokenByPhoneVo)result.getData()).getToken());
            ((GetTokenByPhoneVo)result.getData()).setToken(token);
            this.redisTemplate.opsForValue().set((Object)key, (Object)JSONObject.toJSONString((Object)result.getData()), Duration.ofSeconds(1500L));
            return (GetTokenByPhoneVo)result.getData();
        }
        catch (Exception ex) {
            logger.error(String.format("\u83b7\u53d6\u4e3b\u7ebftoken\u5931\u8d25\u3002userId\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", userId, ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
            return null;
        }
    }

    public String getToken(String ticket) {
        try {
            OvoparkUserInfoEntity response = this.getUserInfo(ticket);
            if (response == null) {
                return "";
            }
            GetOLUCTokenEntity request = new GetOLUCTokenEntity();
            request.setUserId(response.getId());
            request.setUserName(response.getUserName());
            request.setPhone(response.getMobilePhone());
            return this.getOLUCToken(request);
        }
        catch (Exception ex) {
            logger.error(String.format("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002\u8bf7\u6c42\u53c2\u6570\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", ticket, ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
            return "";
        }
    }

    public String getOLUCToken(GetOLUCTokenEntity userInfo) {
        try {
            if (userInfo == null) {
                return "";
            }
            String key = this.toMd5(String.format("%s_%s_%s_getOLUCToken", userInfo.getUserId(), userInfo.getUserName(), userInfo.getPhone()));
            Object token = this.redisTemplate.opsForValue().get((Object)key);
            if (token != null && StringUtils.isNotEmpty((CharSequence)token.toString())) {
                return token.toString();
            }
            if (StringUtils.isEmpty((CharSequence)userInfo.getPhone())) {
                userInfo.setPhone("13506139753");
            }
            GetOLUCTokenBo request = new GetOLUCTokenBo();
            request.setP(this.encrypttoStr(userInfo.getPhone(), "4daad3cfae87843*0?."));
            request.setU(this.encrypttoStr(String.valueOf(userInfo.getUserId()), "4daad3cfae87843*0?."));
            request.setN(this.encrypttoStr(userInfo.getUserName(), "4daad3cfae87843*0?."));
            HttpResponseEntity result = this.olucClient.getOLUCToken(request);
            if (result == null || result.getData() == null || result.getCode() != 200 || StringUtils.isEmpty((CharSequence)((GetOLUCTokenVo)result.getData()).getToken())) {
                return "";
            }
            this.redisTemplate.opsForValue().set((Object)key, (Object)((GetOLUCTokenVo)result.getData()).getToken(), Duration.ofSeconds(7140L));
            return ((GetOLUCTokenVo)result.getData()).getToken();
        }
        catch (Exception ex) {
            logger.error(String.format("\u83b7\u53d6\u7528\u6237\u4fe1\u606f\u5931\u8d25\u3002\u8bf7\u6c42\u53c2\u6570\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", JSONObject.toJSONString((Object)userInfo), ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
            return "";
        }
    }

    public Integer getCategoryId(String token, String categoryName, Integer storeId) {
        try {
            String key = this.toMd5(String.format("%s_%s_getCategoryId", categoryName, storeId));
            Object resultObj = this.redisTemplate.opsForValue().get((Object)key);
            if (resultObj != null) {
                return Integer.valueOf(resultObj.toString());
            }
            HttpResponseEntity result = this.olucClient.getCategoryList(token, storeId);
            if (result == null || result.getCode() != 200 || CollectionUtils.isEmpty((Collection)((Collection)result.getData()))) {
                return null;
            }
            List list = ((List)result.getData()).stream().filter(m -> m.getCategoryName().contains(categoryName)).collect(Collectors.toList());
            if (CollectionUtils.isEmpty(list)) {
                return null;
            }
            Integer id = ((GetCategoryVo)list.get(0)).getId();
            this.redisTemplate.opsForValue().set((Object)key, (Object)String.valueOf(id), Duration.ofSeconds(3600L));
            return id;
        }
        catch (Exception ex) {
            logger.error(String.format("\u83b7\u53d6\u5546\u54c1\u5206\u7c7b\u4fe1\u606f\u5931\u8d25\u3002\u8bf7\u6c42\u53c2\u6570\uff1a%s\uff1b\u9519\u8bef\u4fe1\u606f\uff1a%s\uff1b\u6808\u4fe1\u606f\uff1a%s", categoryName, ex.getMessage(), JSONObject.toJSONString((Object)ex.getStackTrace())));
            return null;
        }
    }

    public Integer getNum(String str) {
        if (StringUtils.isEmpty((CharSequence)str)) {
            return 0;
        }
        Pattern reg = Pattern.compile("\\d+");
        Matcher matcher = reg.matcher(str);
        if (!matcher.find()) {
            return 0;
        }
        Integer num = Integer.valueOf(matcher.group(0));
        return num;
    }

    @Deprecated
    private String encrypttoStr(String content, String password) {
        return this.parseByte2HexStr(this.encrypt(content, password));
    }

    @Deprecated
    private byte[] encrypt(String content, String keyWord) {
        try {
            KeyGenerator kgen = KeyGenerator.getInstance("AES");
            SecureRandom secureRandom = SecureRandom.getInstance("SHA1PRNG");
            secureRandom.setSeed(keyWord.getBytes());
            kgen.init(128, secureRandom);
            SecretKey secretKey = kgen.generateKey();
            byte[] enCodeFormat = secretKey.getEncoded();
            SecretKeySpec key = new SecretKeySpec(enCodeFormat, "AES");
            Cipher cipher = Cipher.getInstance("AES");
            byte[] byteContent = content.getBytes("utf-8");
            cipher.init(1, key);
            byte[] result = cipher.doFinal(byteContent);
            return result;
        }
        catch (NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        catch (NoSuchPaddingException e) {
            e.printStackTrace();
        }
        catch (InvalidKeyException e) {
            e.printStackTrace();
        }
        catch (UnsupportedEncodingException e) {
            e.printStackTrace();
        }
        catch (IllegalBlockSizeException e) {
            e.printStackTrace();
        }
        catch (BadPaddingException e) {
            e.printStackTrace();
        }
        return null;
    }

    @Deprecated
    private String parseByte2HexStr(byte[] buf) {
        StringBuffer sb = new StringBuffer();
        for (int i = 0; i < buf.length; ++i) {
            String hex = Integer.toHexString(buf[i] & 0xFF);
            if (hex.length() == 1) {
                hex = '0' + hex;
            }
            sb.append(hex.toUpperCase());
        }
        return sb.toString();
    }

    public String getCodeInfo(String code) {
        if (StringUtils.isEmpty((CharSequence)code) || code.length() < 21) {
            return "";
        }
        return code.substring(0, 21);
    }

    public String getAlgoInfo(String code) {
        if (StringUtils.isEmpty((CharSequence)code) || code.length() < 10) {
            return "";
        }
        return code.substring(4, 10);
    }

    public Integer getCodeGroupId(String code) {
        if (StringUtils.isEmpty((CharSequence)code) || code.length() < 21) {
            return null;
        }
        return Integer.valueOf(code.substring(10, 21));
    }

    public String getVersionInfo(String code) {
        if (StringUtils.isEmpty((CharSequence)code) || code.length() != 32) {
            return "";
        }
        return code.substring(21);
    }

    public String getMarkInfo(String code) {
        if (StringUtils.isEmpty((CharSequence)code) || code.length() < 5) {
            return "";
        }
        return code.substring(1, 4);
    }

    public List<String> getUploadFreqTypeList() {
        List result = (List)JSONObject.parseObject((String)this.uploadFreqTypeList, (TypeReference)new TypeReference<List<String>>(){}, (Feature[])new Feature[0]);
        return CollectionUtils.isNotEmpty((Collection)result) ? result : new ArrayList();
    }

    public Boolean isRightBusinessType(Integer sourceBusinessType, Integer targetBusinessType, Integer modelId) {
        if (sourceBusinessType == null && modelId == null) {
            return false;
        }
        if (targetBusinessType == null) {
            return false;
        }
        if (sourceBusinessType != null && sourceBusinessType.compareTo(targetBusinessType) == 0) {
            return true;
        }
        AlgoModelInfoDao model = (AlgoModelInfoDao)this.algoModelInfoMapper.selectById((Serializable)modelId);
        if (model == null || model.getBusinessType() == null) {
            return false;
        }
        return model.getBusinessType().compareTo(targetBusinessType) == 0;
    }
}

