/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.utils;

import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;
import org.springframework.core.task.TaskDecorator;
import org.springframework.security.core.context.SecurityContext;
import org.springframework.security.core.context.SecurityContextHolder;
import org.springframework.stereotype.Component;
import org.springframework.web.context.request.RequestAttributes;
import org.springframework.web.context.request.RequestContextHolder;

@Component
public class ContextCopyingDecorator
implements TaskDecorator {
    private static final Logger log = LoggerFactory.getLogger(ContextCopyingDecorator.class);

    public Runnable decorate(Runnable runnable) {
        try {
            RequestAttributes context = RequestContextHolder.currentRequestAttributes();
            Map previous = MDC.getCopyOfContextMap();
            SecurityContext securityContext = SecurityContextHolder.getContext();
            return () -> {
                try {
                    RequestContextHolder.setRequestAttributes((RequestAttributes)context);
                    MDC.setContextMap((Map)previous);
                    SecurityContextHolder.setContext((SecurityContext)securityContext);
                    runnable.run();
                }
                finally {
                    RequestContextHolder.resetRequestAttributes();
                    MDC.clear();
                    SecurityContextHolder.clearContext();
                }
            };
        }
        catch (Exception ex) {
            log.error(String.format("category\uff1aThreadPoolTaskUtils ### subCategory\uff1aContextCopyingDecorator ### \u9519\u8bef\u4fe1\u606f\uff1a%s ### \u9519\u8bef\u6808\uff1a%s", ex.getMessage(), ex.getStackTrace()));
            return runnable;
        }
    }
}

