/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.utils;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Date;
import java.util.UUID;

public class DateUtil {
    public static final String YYYYMMDD = "yyyyMMdd";
    public static final String YYYYMMDDHH = "yyyyMMddHH";
    private static final ThreadLocal<DateFormat> SDF = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd HH:mm:ss"));
    private static final ThreadLocal<DateFormat> YYMMDD = ThreadLocal.withInitial(() -> new SimpleDateFormat("yyyy-MM-dd"));

    public static String format(long timeMills) {
        return SDF.get().format(new Date(timeMills));
    }

    public static String format(Date date) {
        return SDF.get().format(date);
    }

    public static String shortFormat(long timeMills) {
        return YYMMDD.get().format(new Date(timeMills));
    }

    public static String shortFormat(Date date) {
        return YYMMDD.get().format(date);
    }

    public static String shortFormat(String time) {
        return YYMMDD.get().format(DateUtil.parse(time));
    }

    public static Date parse(String str) {
        return YYMMDD.get().parse(str);
    }

    public static int differentDays(Date date1, Date date2) {
        Calendar cal1 = Calendar.getInstance();
        cal1.setTime(date1);
        Calendar cal2 = Calendar.getInstance();
        cal2.setTime(date2);
        int day1 = cal1.get(6);
        int day2 = cal2.get(6);
        int year1 = cal1.get(1);
        int year2 = cal2.get(1);
        if (year1 != year2) {
            int timeDistance = 0;
            for (int i = year1; i < year2; ++i) {
                if (i % 4 == 0 && i % 100 != 0 || i % 400 == 0) {
                    timeDistance += 366;
                    continue;
                }
                timeDistance += 365;
            }
            return timeDistance + (day2 - day1);
        }
        return day2 - day1;
    }

    public static int differentDays(String date1, String date2) {
        Date start = YYMMDD.get().parse(date1);
        Date end = YYMMDD.get().parse(date2);
        return DateUtil.differentDays(start, end);
    }

    public static Date addTime(Date date, int duration) {
        Date current = YYMMDD.get().parse(YYMMDD.get().format(date));
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(current);
        calendar.add(5, duration);
        Date target = calendar.getTime();
        return target;
    }

    public static String addDays(Integer days) {
        Date current = new Date();
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(current);
        calendar.add(5, days);
        return YYMMDD.get().format(calendar.getTime());
    }

    public static String addYear() {
        Date current = new Date();
        return DateUtil.addYear(YYMMDD.get().format(current));
    }

    public static String addYear(String currentExpire) {
        Date current = YYMMDD.get().parse(currentExpire);
        Calendar calendar = Calendar.getInstance();
        calendar.setTime(current);
        calendar.add(1, 1);
        calendar.add(5, 7);
        return YYMMDD.get().format(calendar.getTime());
    }

    public static void main(String[] args) {
        System.out.println(UUID.randomUUID());
    }
}

