/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.core.utils;

import com.ovopark.paas.core.utils.ContextCopyingDecorator;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CompletableFuture;
import org.apache.commons.collections4.CollectionUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.task.TaskDecorator;
import org.springframework.scheduling.concurrent.ThreadPoolTaskExecutor;
import org.springframework.stereotype.Component;

@Component
public class ThreadPoolTaskUtils {
    private static final Logger log = LoggerFactory.getLogger(ThreadPoolTaskUtils.class);
    private static ThreadPoolTaskExecutor executor;
    private int threads = Runtime.getRuntime().availableProcessors();

    public ThreadPoolTaskExecutor getThreadPoolTaskExecutor() {
        if (executor == null) {
            this.init();
        }
        return executor;
    }

    public List<CompletableFuture> getTask(List<CompletableFuture> taskList) {
        if (CollectionUtils.isEmpty(taskList)) {
            return taskList;
        }
        for (CompletableFuture item : taskList) {
            item.join();
        }
        return new ArrayList<CompletableFuture>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void init() {
        Class<ThreadPoolTaskUtils> clazz = ThreadPoolTaskUtils.class;
        synchronized (ThreadPoolTaskUtils.class) {
            if (executor == null) {
                executor = new ThreadPoolTaskExecutor();
                executor.initialize();
                executor.setCorePoolSize(this.threads * 4 + 1);
                executor.setMaxPoolSize(this.threads * 32 + 1);
                executor.setKeepAliveSeconds(60);
                executor.setQueueCapacity(1500);
                executor.setThreadNamePrefix("async_task_executor_");
                executor.setTaskDecorator((TaskDecorator)new ContextCopyingDecorator());
                executor.setWaitForTasksToCompleteOnShutdown(true);
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

