/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.paas.repository.persist;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.ovopark.paas.repository.persist.paas.UserAlgoPersistService;
import com.ovopark.paas.repository.persist.pay.OperateLogPersistService;
import com.ovopark.paas.repository.persist.pay.PayOrderPersistService;
import com.ovopark.paas.repository.persist.wx.WxEventTracePersistService;
import com.ovopark.paas.repository.persist.wx.WxPaasDeliveryAddressPersistService;
import com.ovopark.paas.repository.persist.wx.WxPaasUserPersistService;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.springframework.beans.BeansException;
import org.springframework.context.ApplicationContext;
import org.springframework.context.ApplicationContextAware;
import org.springframework.stereotype.Component;

@Component
public class PersistService
implements ApplicationContextAware {
    private final Map<String, ServiceImpl> persistentServices = new LinkedHashMap<String, ServiceImpl>();

    public PersistService(List<ServiceImpl> services) {
        services.forEach(service -> this.persistentServices.put(service.getClass().getCanonicalName(), (ServiceImpl)service));
    }

    private <T extends ServiceImpl> T getService(Class<T> clazz) {
        return (T)this.persistentServices.get(clazz.getSimpleName().toUpperCase());
    }

    public WxPaasUserPersistService getWxPaasUser() {
        return this.getService(WxPaasUserPersistService.class);
    }

    public WxPaasDeliveryAddressPersistService getDeliveryAddress() {
        return this.getService(WxPaasDeliveryAddressPersistService.class);
    }

    public WxEventTracePersistService getWxEventTrace() {
        return this.getService(WxEventTracePersistService.class);
    }

    public PayOrderPersistService getPayOrder() {
        return this.getService(PayOrderPersistService.class);
    }

    public OperateLogPersistService getOperateLog() {
        return this.getService(OperateLogPersistService.class);
    }

    public UserAlgoPersistService getUserAlgo() {
        return this.getService(UserAlgoPersistService.class);
    }

    public void setApplicationContext(ApplicationContext applicationContext) throws BeansException {
        Map map = applicationContext.getBeansOfType(ServiceImpl.class);
        map.forEach((key, value) -> this.persistentServices.put(key.toUpperCase(), (ServiceImpl)value));
    }
}

