/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pojo.dto;

public class BaseResult<T> {
    private Boolean isError;
    private T data;
    private String code;
    private String message;

    public BaseResult() {
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public T getData() {
        return this.data;
    }

    public void setData(T data) {
        this.data = data;
    }

    public String getCode() {
        return this.code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public String getMessage() {
        return this.message;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public BaseResult(Boolean isError, T data, String code, String message) {
        this.isError = isError;
        this.data = data;
        this.code = code;
        this.message = message;
    }

    public static <T> BaseResult<T> getInstance(Boolean isError, T data, String code, String message) {
        return new BaseResult<T>(isError, data, code, message);
    }

    public static <T> BaseResult<T> invalidToken() {
        return BaseResult.getInstance(true, null, CommonCode.INVALID_TOKEN.getCode(), CommonCode.INVALID_TOKEN.getMessage());
    }

    public static <T> BaseResult<T> paramError() {
        return BaseResult.getInstance(true, null, CommonCode.PARAM_ERROR.getCode(), CommonCode.PARAM_ERROR.getMessage());
    }

    public static <T> BaseResult<T> success() {
        return BaseResult.getInstance(false, null, CommonCode.SUCCESS.getCode(), CommonCode.SUCCESS.getMessage());
    }

    public static <T> BaseResult<T> success(T data) {
        return BaseResult.getInstance(false, data, CommonCode.SUCCESS.getCode(), CommonCode.SUCCESS.getMessage());
    }

    public static <T> BaseResult<T> error() {
        return BaseResult.getInstance(true, null, CommonCode.ERROR.getCode(), CommonCode.ERROR.getMessage());
    }

    public static <T> BaseResult<T> error(String code, String message) {
        return BaseResult.getInstance(true, null, code, message);
    }

    public static <T> BaseResult<T> error(T data) {
        return BaseResult.getInstance(true, data, CommonCode.ERROR.getCode(), CommonCode.ERROR.getMessage());
    }

    public static enum CommonCode {
        SUCCESS("0", "\u8bf7\u6c42\u6570\u636e\u6210\u529f"),
        ERROR("1", "\u8bf7\u6c42\u6570\u636e\u5931\u8d25"),
        INVALID_TOKEN("20000", "\u65e0\u6548\u7684token"),
        PARAM_ERROR("20001", "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef");

        private String code;
        private String message;

        private CommonCode() {
        }

        private CommonCode(String code, String message) {
            this.code = code;
            this.message = message;
        }

        public String getCode() {
            return this.code;
        }

        public void setCode(String code) {
            this.code = code;
        }

        public String getMessage() {
            return this.message;
        }

        public void setMessage(String message) {
            this.message = message;
        }
    }
}

