/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.util;

import com.ovopark.pojo.dto.IdentityMatchDto;
import com.ovopark.pojo.dto.PassengerFlowGroupBatchDto;
import com.ovopark.pojo.dto.PassengerFlowGroupDto;
import com.ovopark.pojo.vo.EnumFaceSetHead;
import java.util.List;
import java.util.Objects;

public class FlowGroupUtils {
    public static final String IDENTITY_STAFF = "staff";
    public static final String IDENTITY_COURIER = "courier";
    public static final String IDENTITY_TAKEOUT = "takeout";

    public static Boolean isWorker(PassengerFlowGroupDto groupDto) {
        if (groupDto == null) {
            return false;
        }
        if (Objects.equals(IDENTITY_STAFF, groupDto.getIdentity())) {
            return true;
        }
        List<IdentityMatchDto> matchList = groupDto.getMatchList();
        if (matchList == null || matchList.size() == 0) {
            return false;
        }
        for (IdentityMatchDto dto : matchList) {
            if (!dto.getGroupName().startsWith(EnumFaceSetHead.FR3PRO_WORKER.getValue()) && !dto.getGroupName().startsWith("clerk-a5289bfc") && !dto.getGroupName().startsWith("auto-clerk-a5289bfc") && !dto.getGroupName().startsWith("similar-a5289bfc")) continue;
            return true;
        }
        return false;
    }

    public static boolean isValid(PassengerFlowGroupDto groupDto) {
        if (groupDto == null) {
            return false;
        }
        return groupDto.getAge() != null && groupDto.getGender() != null && groupDto.getMac() != null && groupDto.getRecordTime() != null;
    }

    public static Boolean isWorker(PassengerFlowGroupBatchDto groupDto) {
        if (groupDto == null) {
            return false;
        }
        if (Objects.equals(IDENTITY_STAFF, groupDto.getIdentity())) {
            return true;
        }
        List<IdentityMatchDto> matchList = groupDto.getMatchList();
        if (matchList == null || matchList.size() == 0) {
            return false;
        }
        for (IdentityMatchDto dto : matchList) {
            if (!dto.getGroupName().startsWith(EnumFaceSetHead.FR3PRO_WORKER.getValue()) && !dto.getGroupName().startsWith("clerk-a5289bfc") && !dto.getGroupName().startsWith("auto-clerk-a5289bfc") && !dto.getGroupName().startsWith("similar-a5289bfc")) continue;
            return true;
        }
        return false;
    }

    public static boolean isValid(PassengerFlowGroupBatchDto groupDto) {
        if (groupDto == null) {
            return false;
        }
        return groupDto.getAge() != null && groupDto.getGender() != null && groupDto.getMac() != null && groupDto.getRecordTime() != null && groupDto.getAreaId() != null;
    }

    public static boolean isWorker(String identity) {
        return Objects.equals(IDENTITY_STAFF, identity);
    }
}

