/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pr.service.impl;

import cn.hutool.core.util.StrUtil;
import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.ovopark.pr.api.dto.BaseResult;
import com.ovopark.pr.api.query.BasicQuery;
import com.ovopark.pr.bo.CustomerGroupDistributionBo;
import com.ovopark.pr.dao.common.TimeQry;
import com.ovopark.pr.dao.entity.AgeConfig;
import com.ovopark.pr.dao.entity.PassengerFlow;
import com.ovopark.pr.dao.repository.PassengerFlowRepository;
import com.ovopark.pr.dao.repository.ShopFlowTagRepository;
import com.ovopark.pr.manager.common.Context;
import com.ovopark.pr.manager.common.util.LocalDateTimeUtils;
import com.ovopark.pr.manager.common.util.NumberUtils;
import com.ovopark.pr.manager.exception.BizException;
import com.ovopark.pr.manager.export.dataobj.DynamicExportDataBo;
import com.ovopark.pr.manager.service.AgeConfigService;
import com.ovopark.pr.manager.service.DepartmentService;
import com.ovopark.pr.manager.support.basic.dto.DepartmentDTO;
import com.ovopark.pr.manager.support.basic.rpc.DepartmentProvider;
import com.ovopark.pr.query.CustomerGroupExportQuery;
import com.ovopark.pr.service.CustomerGroupService;
import com.ovopark.pr.vo.AgeDistributionVo;
import com.ovopark.pr.vo.FlowGroupDistributionExpandVo;
import com.ovopark.pr.vo.GenderDistributionVo;
import com.ovopark.pr.vo.GroupDistributionVo;
import jakarta.annotation.Resource;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service(value="customerGroupService")
public class CustomerGroupServiceImpl
implements CustomerGroupService {
    private static final Logger log = LoggerFactory.getLogger(CustomerGroupServiceImpl.class);
    @Resource
    private DepartmentProvider departmentProvider;
    @Resource
    private AgeConfigService ageConfigService;
    @Resource
    private ShopFlowTagRepository shopFlowTagRepository;
    @Resource
    private PassengerFlowRepository passengerFlowRepository;
    @Resource
    private DepartmentService departmentService;
    @Resource
    private MessageSource messageSource;
    public static final String AGE_ABBREVIATION = "a";
    public static final String GENDER_ABBREVIATION = "g";

    @Override
    public GroupDistributionVo getPersonalizationAgeGroupAndGenderDistribution(BasicQuery query) {
        Context context = Context.getContextFromThreadLocal();
        List depIds = this.departmentService.getDepIdsByIdStr(query.getId(), context.getEnterpriseId(), context.getUserId());
        if (CollectionUtils.isEmpty((Collection)depIds)) {
            return new GroupDistributionVo();
        }
        return this.getPersonalizationAgeGroupAndGenderDistribution(depIds, query);
    }

    @Override
    public DynamicExportDataBo exportFlowGroupDistribution(CustomerGroupExportQuery query) {
        DynamicExportDataBo res = new DynamicExportDataBo();
        Context context = Context.getContextFromThreadLocal();
        List deps = this.departmentService.getDepsByIdStr(query.getId(), context.getEnterpriseId(), context.getUserId());
        if (CollectionUtils.isEmpty((Collection)deps)) {
            return res;
        }
        List<Integer> depIds = deps.stream().map(DepartmentDTO::getId).collect(Collectors.toList());
        Integer enterpriseId = this.getEnterpriseId(depIds);
        List<AgeConfig> ageConfigs = this.ageConfigService.getAgeGroupConfig(enterpriseId).stream().filter(AgeConfig::getEnable).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ageConfigs)) {
            return res;
        }
        List tagIds = this.shopFlowTagRepository.getPrimaryTagIds(depIds);
        List<CustomerGroupDistributionBo> groupDistributionBos = CustomerGroupServiceImpl.getCustomerGroupDistributionBos(ageConfigs);
        HashMap<Integer, List<CustomerGroupDistributionBo>> depGroupDistributionBosMap = new HashMap<Integer, List<CustomerGroupDistributionBo>>();
        if (query.getId().startsWith("O_")) {
            for (Integer depId : depIds) {
                depGroupDistributionBosMap.put(depId, CustomerGroupServiceImpl.getCustomerGroupDistributionBos(ageConfigs));
            }
        }
        TimeQry param = TimeQry.builder().setBasicParams(depIds, tagIds, LocalDateTimeUtils.convertTimeStr2LDT((String)query.getStartTime()), LocalDateTimeUtils.convertTimeStr2LDT((String)query.getEndTime())).setHourFilterParams(query.getStartHour(), query.getEndHour()).setOnBusinessTime(query.getIsOnBusinessTime()).build();
        List passengerFlows = this.passengerFlowRepository.listValidPassengerFlowDistributionGroupByDepId(param);
        this.fillCustomerGroupDistribution(groupDistributionBos, passengerFlows);
        Map<Integer, List<PassengerFlow>> depIdMap = passengerFlows.stream().collect(Collectors.groupingBy(PassengerFlow::getDepId));
        for (Map.Entry<Integer, List<PassengerFlow>> entry : depIdMap.entrySet()) {
            Integer depId = entry.getKey();
            List<PassengerFlow> depPassengerFlows = entry.getValue();
            List customerGroupDistributionBos = (List)depGroupDistributionBosMap.get(depId);
            this.fillCustomerGroupDistribution(customerGroupDistributionBos, depPassengerFlows);
        }
        ArrayList<FlowGroupDistributionExpandVo> flowGroupDistributionList = new ArrayList<FlowGroupDistributionExpandVo>();
        FlowGroupDistributionExpandVo thisData = new FlowGroupDistributionExpandVo();
        thisData.setName(this.departmentService.getNameByIdStr(query.getId()));
        GroupDistributionVo ageAndGenderDistribution = this.getAgeAndGenderDistribution(groupDistributionBos, ageConfigs);
        thisData.setAgeDistribution(ageAndGenderDistribution.getAgeDistribution());
        thisData.setGenderDistribution(ageAndGenderDistribution.getGenderDistribution());
        if (this.departmentService.isStore(query.getId()).booleanValue()) {
            DepartmentDTO dep = (DepartmentDTO)deps.get(0);
            thisData.setShopId(dep.getShopId());
            thisData.setDepId(dep.getId());
        }
        flowGroupDistributionList.add(thisData);
        if (query.getId().startsWith("O_")) {
            for (int i = 0; i < depIds.size(); ++i) {
                FlowGroupDistributionExpandVo flowGroupDistributionExpandVo = new FlowGroupDistributionExpandVo();
                GroupDistributionVo distribution = this.getAgeAndGenderDistribution((List)depGroupDistributionBosMap.get(depIds.get(i)), ageConfigs);
                flowGroupDistributionExpandVo.setAgeDistribution(distribution.getAgeDistribution());
                flowGroupDistributionExpandVo.setGenderDistribution(distribution.getGenderDistribution());
                flowGroupDistributionExpandVo.setName(((DepartmentDTO)deps.get(i)).getName());
                flowGroupDistributionExpandVo.setDepId(((DepartmentDTO)deps.get(i)).getId());
                flowGroupDistributionExpandVo.setShopId(((DepartmentDTO)deps.get(i)).getShopId());
                flowGroupDistributionList.add(flowGroupDistributionExpandVo);
            }
        }
        Locale locale = context.getLocale();
        ArrayList<List<String>> headList = new ArrayList<List<String>>();
        String shopId = this.messageSource.getMessage("passenger.export.shopId", null, locale);
        headList.add(List.of(shopId));
        String flowGroupDepName = this.messageSource.getMessage("passenger.export.flowGroup.depName", null, locale);
        headList.add(List.of(flowGroupDepName));
        boolean needAge = query.getNeedAge();
        boolean needGender = query.getNeedGender();
        if (needAge) {
            for (AgeConfig ageConfig : ageConfigs) {
                headList.add(List.of(this.generateAgeName(ageConfig.getAgeType(), ageConfig.getName(), null, locale)));
            }
        }
        if (needGender) {
            for (PassengerFlow.GenderEnum genderEnum : PassengerFlow.GenderEnum.values()) {
                headList.add(List.of(this.generateGenderName(genderEnum.getIndex(), null, null, locale)));
            }
        }
        if (needAge && needGender) {
            for (AgeConfig ageConfig : ageConfigs) {
                for (PassengerFlow.GenderEnum genderEnum : PassengerFlow.GenderEnum.values()) {
                    headList.add(List.of(this.generateAgeName(ageConfig.getAgeType(), ageConfig.getName(), genderEnum.getIndex(), locale)));
                }
            }
            for (PassengerFlow.GenderEnum genderEnum : PassengerFlow.GenderEnum.values()) {
                for (AgeConfig ageConfig : ageConfigs) {
                    headList.add(List.of(this.generateGenderName(genderEnum.getIndex(), ageConfig.getAgeType(), ageConfig.getName(), locale)));
                }
            }
        }
        ArrayList dataList = new ArrayList();
        for (FlowGroupDistributionExpandVo expandVo : flowGroupDistributionList) {
            ArrayList<Object> dataLine = new ArrayList<Object>();
            dataLine.add(StringUtils.isNotBlank((CharSequence)expandVo.getShopId()) ? expandVo.getShopId() : "-");
            dataLine.add(expandVo.getName());
            List<AgeDistributionVo> ageDistribution = expandVo.getAgeDistribution();
            List<GenderDistributionVo> genderDistribution = expandVo.getGenderDistribution();
            if (needAge) {
                for (AgeDistributionVo ageDistributionVo : ageDistribution) {
                    dataLine.add(ageDistributionVo.getPeopleNum());
                }
            }
            if (needGender) {
                for (GenderDistributionVo genderDistributionVo : genderDistribution) {
                    dataLine.add(genderDistributionVo.getPeopleNum());
                }
            }
            if (needAge && needGender) {
                for (AgeDistributionVo ageDistributionVo : ageDistribution) {
                    for (GenderDistributionVo genderVo : ageDistributionVo.getGenderDistribution()) {
                        dataLine.add(genderVo.getPeopleNum());
                    }
                }
                for (GenderDistributionVo genderDistributionVo : genderDistribution) {
                    for (AgeDistributionVo ageVo : genderDistributionVo.getAgeDistribution()) {
                        dataLine.add(ageVo.getPeopleNum());
                    }
                }
            }
            dataList.add(dataLine);
        }
        res.setHeadList(headList);
        res.setDataList(dataList);
        return res;
    }

    private String generateAgeKey(Integer ageType, String ageName, Integer gender) {
        if (ageType == -1) {
            if (gender == null) {
                return ageName;
            }
            return StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{ageName, GENDER_ABBREVIATION, String.valueOf(gender)});
        }
        if (gender == null) {
            return AGE_ABBREVIATION + ageType;
        }
        return StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{AGE_ABBREVIATION, String.valueOf(ageType), GENDER_ABBREVIATION, String.valueOf(gender)});
    }

    private String generateGenderKey(Integer gender, Integer ageType, String ageName) {
        if (ageType == null) {
            return GENDER_ABBREVIATION + gender;
        }
        if (ageType == -1) {
            return StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{GENDER_ABBREVIATION, String.valueOf(gender), ageName});
        }
        return StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{GENDER_ABBREVIATION, String.valueOf(gender), AGE_ABBREVIATION, String.valueOf(ageType)});
    }

    private String generateAgeName(Integer ageType, String ageName, Integer gender, Locale locale) {
        if (ageType == -1) {
            if (gender == null) {
                return ageName;
            }
            return this.messageSource.getMessage("passenger.attributes.export.name." + StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{AGE_ABBREVIATION, GENDER_ABBREVIATION, String.valueOf(gender)}), new Object[]{ageName}, locale);
        }
        return this.messageSource.getMessage("passenger.attributes.export.name." + this.generateAgeKey(ageType, ageName, gender), null, locale);
    }

    private String generateGenderName(Integer gender, Integer ageType, String ageName, Locale locale) {
        if (ageType == null) {
            return this.messageSource.getMessage("passenger.attributes.export.name." + this.generateGenderKey(gender, ageType, ageName), null, locale);
        }
        if (ageType == -1) {
            return this.messageSource.getMessage("passenger.attributes.export.name." + StrUtil.concat((boolean)true, (CharSequence[])new CharSequence[]{GENDER_ABBREVIATION, String.valueOf(gender), AGE_ABBREVIATION}), new Object[]{ageName}, locale);
        }
        return this.messageSource.getMessage("passenger.attributes.export.name." + this.generateGenderKey(gender, ageType, ageName), null, locale);
    }

    public GroupDistributionVo getPersonalizationAgeGroupAndGenderDistribution(List<Integer> depIds, BasicQuery query) {
        if (CollectionUtils.isEmpty(depIds)) {
            return new GroupDistributionVo();
        }
        Integer enterpriseId = this.getEnterpriseId(depIds);
        List<AgeConfig> ageConfigs = this.ageConfigService.getAgeGroupConfig(enterpriseId).stream().filter(AgeConfig::getEnable).collect(Collectors.toList());
        if (CollectionUtils.isEmpty(ageConfigs)) {
            return new GroupDistributionVo();
        }
        return this.getGroupDistributionVo(depIds, query, ageConfigs);
    }

    private GroupDistributionVo getGroupDistributionVo(List<Integer> depIds, BasicQuery query, List<AgeConfig> ageConfigs) {
        List tagIds = this.shopFlowTagRepository.getPrimaryTagIds(depIds);
        List<CustomerGroupDistributionBo> groupDistributionBos = CustomerGroupServiceImpl.getCustomerGroupDistributionBos(ageConfigs);
        TimeQry param = TimeQry.builder().setBasicParams(depIds, tagIds, LocalDateTimeUtils.convertTimeStr2LDT((String)query.getStartTime()), LocalDateTimeUtils.convertTimeStr2LDT((String)query.getEndTime())).setHourFilterParams(query.getStartHour(), query.getEndHour()).setOnBusinessTime(query.getIsOnBusinessTime()).build();
        List passengerFlows = this.passengerFlowRepository.listValidPassengerFlowDistribution(param);
        this.fillCustomerGroupDistribution(groupDistributionBos, passengerFlows);
        return this.getAgeAndGenderDistribution(groupDistributionBos, ageConfigs);
    }

    private void fillCustomerGroupDistribution(List<CustomerGroupDistributionBo> details, List<PassengerFlow> passengerFlows) {
        if (CollectionUtils.isNotEmpty(passengerFlows)) {
            block0: for (PassengerFlow passengerFlow : passengerFlows) {
                Integer age = passengerFlow.getAge();
                Integer gender = passengerFlow.getGender();
                for (CustomerGroupDistributionBo bo : details) {
                    if (age == null || bo.getAgeFrom() != null && bo.getAgeFrom() > age || bo.getAgeTo() != null && age > bo.getAgeTo() || !bo.getGender().equals(gender)) continue;
                    bo.setPeopleNum(bo.getPeopleNum() + passengerFlow.getInCount1());
                    continue block0;
                }
            }
        }
    }

    private GroupDistributionVo getAgeAndGenderDistribution(List<CustomerGroupDistributionBo> distributions, List<AgeConfig> ageConfigs) {
        List<AgeDistributionVo> ageDistribution = this.getAgeDistribution(ageConfigs);
        List<GenderDistributionVo> genderDistribution = this.getGenderDistribution(ageConfigs);
        block0: for (CustomerGroupDistributionBo customerGroupDistributionBo : distributions) {
            block1: for (AgeDistributionVo ageVo : ageDistribution) {
                if (!customerGroupDistributionBo.getAgeDivisionType().equals(ageVo.getAgeDivisionType()) || !Objects.equals(customerGroupDistributionBo.getAgeName(), ageVo.getName())) continue;
                ageVo.setPeopleNum(ageVo.getPeopleNum() + customerGroupDistributionBo.getPeopleNum());
                for (GenderDistributionVo genderDistributionVo : ageVo.getGenderDistribution()) {
                    if (!customerGroupDistributionBo.getGender().equals(genderDistributionVo.getGender())) continue;
                    genderDistributionVo.setPeopleNum(genderDistributionVo.getPeopleNum() + customerGroupDistributionBo.getPeopleNum());
                    break block1;
                }
            }
            for (GenderDistributionVo genderVo : genderDistribution) {
                if (!customerGroupDistributionBo.getGender().equals(genderVo.getGender())) continue;
                genderVo.setPeopleNum(genderVo.getPeopleNum() + customerGroupDistributionBo.getPeopleNum());
                for (AgeDistributionVo ageDistributionVo : genderVo.getAgeDistribution()) {
                    if (!customerGroupDistributionBo.getAgeDivisionType().equals(ageDistributionVo.getAgeDivisionType()) || !Objects.equals(customerGroupDistributionBo.getAgeName(), ageDistributionVo.getName())) continue;
                    ageDistributionVo.setPeopleNum(ageDistributionVo.getPeopleNum() + customerGroupDistributionBo.getPeopleNum());
                    continue block0;
                }
                continue block0;
            }
        }
        this.calculateAgeProportion(ageDistribution);
        for (AgeDistributionVo ageDistributionVo : ageDistribution) {
            this.calculateGenderProportion(ageDistributionVo.getGenderDistribution());
        }
        this.calculateGenderProportion(genderDistribution);
        for (GenderDistributionVo genderDistributionVo : genderDistribution) {
            this.calculateAgeProportion(genderDistributionVo.getAgeDistribution());
        }
        return new GroupDistributionVo(ageDistribution, genderDistribution);
    }

    private List<GenderDistributionVo> getGenderDistribution(List<AgeConfig> ageConfigs) {
        PassengerFlow.GenderEnum[] genderEnums;
        ArrayList<GenderDistributionVo> res = new ArrayList<GenderDistributionVo>();
        for (PassengerFlow.GenderEnum genderEnum : genderEnums = PassengerFlow.GenderEnum.values()) {
            GenderDistributionVo vo = new GenderDistributionVo();
            vo.setGender(genderEnum.getIndex());
            ArrayList<AgeDistributionVo> ageDistribution = new ArrayList<AgeDistributionVo>();
            for (AgeConfig ageConfig : ageConfigs) {
                AgeDistributionVo ageVo = new AgeDistributionVo();
                ageVo.setAgeDivisionType(ageConfig.getAgeType());
                ageVo.setName(ageConfig.getName());
                ageVo.setAgeFrom(ageConfig.getAgeFrom());
                ageVo.setAgeTo(ageConfig.getAgeTo());
                ageDistribution.add(ageVo);
            }
            vo.setAgeDistribution(ageDistribution);
            res.add(vo);
        }
        return res;
    }

    private List<AgeDistributionVo> getAgeDistribution(List<AgeConfig> ageConfigs) {
        ArrayList<AgeDistributionVo> res = new ArrayList<AgeDistributionVo>();
        PassengerFlow.GenderEnum[] genderEnums = PassengerFlow.GenderEnum.values();
        for (AgeConfig ageConfig : ageConfigs) {
            AgeDistributionVo vo = new AgeDistributionVo();
            vo.setAgeDivisionType(ageConfig.getAgeType());
            vo.setName(ageConfig.getName());
            vo.setAgeFrom(ageConfig.getAgeFrom());
            vo.setAgeTo(ageConfig.getAgeTo());
            ArrayList<GenderDistributionVo> genderDistribution = new ArrayList<GenderDistributionVo>();
            for (PassengerFlow.GenderEnum genderEnum : genderEnums) {
                GenderDistributionVo genderVo = new GenderDistributionVo();
                genderVo.setGender(genderEnum.getIndex());
                genderDistribution.add(genderVo);
            }
            vo.setGenderDistribution(genderDistribution);
            res.add(vo);
        }
        return res;
    }

    private static List<CustomerGroupDistributionBo> getCustomerGroupDistributionBos(List<AgeConfig> ageConfigs) {
        ArrayList<CustomerGroupDistributionBo> groupDistributionBos = new ArrayList<CustomerGroupDistributionBo>();
        PassengerFlow.GenderEnum[] genderEnums = PassengerFlow.GenderEnum.values();
        for (AgeConfig ageConfig : ageConfigs) {
            for (PassengerFlow.GenderEnum genderEnum : genderEnums) {
                CustomerGroupDistributionBo bo = new CustomerGroupDistributionBo();
                bo.setAgeDivisionType(ageConfig.getAgeType());
                bo.setAgeName(ageConfig.getName());
                bo.setAgeFrom(ageConfig.getAgeFrom());
                bo.setAgeTo(ageConfig.getAgeTo());
                bo.setGender(genderEnum.getIndex());
                groupDistributionBos.add(bo);
            }
        }
        return groupDistributionBos;
    }

    private Integer getEnterpriseId(List<Integer> depIds) {
        Context context = Context.getContextFromThreadLocal();
        Integer enterpriseId = null;
        if (context == null || context.getEnterpriseId() == null) {
            log.warn("token\u65e0\u4f01\u4e1aid");
            Integer depId = depIds.get(0);
            DepartmentDTO dep = this.departmentProvider.getById(depId);
            if (dep == null || dep.getEnterpriseId() == null) {
                log.warn("\u7b2c\u4e00\u5bb6\u95e8\u5e97\u65e0\u4f01\u4e1aid");
                throw new BizException(BaseResult.ResultCodeEnum.PARAM_ERROR.getCode(), BaseResult.ResultCodeEnum.PARAM_ERROR.getMessage());
            }
            enterpriseId = dep.getEnterpriseId();
        } else {
            enterpriseId = context.getEnterpriseId();
        }
        return enterpriseId;
    }

    public void calculateAgeProportion(List<AgeDistributionVo> ageDistributions) {
        List collect = ageDistributions.stream().sorted(Comparator.comparing(AgeDistributionVo::getPeopleNum)).collect(Collectors.toList());
        List counts = collect.stream().map(AgeDistributionVo::getPeopleNum).collect(Collectors.toList());
        List rates = NumberUtils.calculateProportion(counts);
        block0: for (AgeDistributionVo vo : ageDistributions) {
            for (int i = 0; i < collect.size(); ++i) {
                if (!Objects.equals(vo.getAgeFrom(), ((AgeDistributionVo)collect.get(i)).getAgeFrom()) || !Objects.equals(vo.getAgeTo(), ((AgeDistributionVo)collect.get(i)).getAgeTo()) || !Objects.equals(vo.getAgeDivisionType(), ((AgeDistributionVo)collect.get(i)).getAgeDivisionType()) || !Objects.equals(vo.getName(), ((AgeDistributionVo)collect.get(i)).getName())) continue;
                vo.setPercentage((BigDecimal)rates.get(i));
                continue block0;
            }
        }
    }

    public void calculateGenderProportion(List<GenderDistributionVo> genderDistributions) {
        List collect = genderDistributions.stream().sorted(Comparator.comparing(GenderDistributionVo::getPeopleNum)).collect(Collectors.toList());
        List counts = collect.stream().map(GenderDistributionVo::getPeopleNum).collect(Collectors.toList());
        List rates = NumberUtils.calculateProportion(counts);
        block0: for (GenderDistributionVo vo : genderDistributions) {
            for (int i = 0; i < collect.size(); ++i) {
                if (!Objects.equals(vo.getGender(), ((GenderDistributionVo)collect.get(i)).getGender())) continue;
                vo.setPercentage((BigDecimal)rates.get(i));
                continue block0;
            }
        }
    }
}

