/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pr.service.impl;

import cn.hutool.core.io.FileUtil;
import cn.hutool.core.util.RandomUtil;
import com.alibaba.fastjson.JSON;
import com.ovopark.pr.api.query.BasicQuery;
import com.ovopark.pr.manager.common.Context;
import com.ovopark.pr.manager.common.util.LocalDateTimeUtils;
import com.ovopark.pr.manager.common.util.ObsHelper;
import com.ovopark.pr.manager.common.util.SpringContextUtils;
import com.ovopark.pr.manager.export.ExcelProvider;
import com.ovopark.pr.manager.export.ExcelUtils;
import com.ovopark.pr.manager.export.ExportExcelService;
import com.ovopark.pr.manager.export.ExportTask;
import com.ovopark.pr.manager.export.ExportTaskContext;
import com.ovopark.pr.manager.export.ExportTaskConverter;
import com.ovopark.pr.manager.export.ExportTaskTypeEnum;
import com.ovopark.pr.manager.export.dataobj.DynamicExportDataBo;
import com.ovopark.pr.manager.export.dataobj.MoreSheetExportDataBo;
import com.ovopark.pr.manager.export.event.ExportTaskEvent;
import com.ovopark.pr.manager.export.event.ExportTaskEventContext;
import com.ovopark.pr.manager.support.basic.dto.ExportTaskDTO;
import com.ovopark.pr.manager.support.basic.rpc.ExportTaskProvider;
import com.ovopark.pr.query.CustomerGroupExportQuery;
import com.ovopark.pr.service.CustomerGroupService;
import com.ovopark.pr.service.OperationsAnalysisService;
import jakarta.annotation.PostConstruct;
import jakarta.annotation.Resource;
import java.io.File;
import java.lang.reflect.Method;
import java.time.LocalDateTime;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.MessageSource;
import org.springframework.stereotype.Service;

@Service(value="exportExcelService")
public class ExportExcelServiceImpl
implements ExportExcelService {
    private static final Logger log = LoggerFactory.getLogger(ExportExcelServiceImpl.class);
    @Resource
    private ObsHelper obsHelper;
    @Resource
    private OperationsAnalysisService operationsAnalysisService;
    @Resource
    private MessageSource messageSource;
    @Resource
    private ExportTaskProvider exportTaskProvider;
    @Resource
    private CustomerGroupService customerGroupService;
    private final Map<ExportTaskTypeEnum, Method> exportTaskTypeMethodMap = new HashMap<ExportTaskTypeEnum, Method>();

    @PostConstruct
    public void afterPropertiesSet() throws Exception {
        for (Method method : this.getClass().getMethods()) {
            ExcelProvider annotation = method.getAnnotation(ExcelProvider.class);
            if (annotation == null) continue;
            for (ExportTaskTypeEnum value : annotation.value()) {
                this.exportTaskTypeMethodMap.put(value, method);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void generateExcel4ExportTask(ExportTask exportTask) {
        File file;
        String tempPath;
        block12: {
            tempPath = "";
            file = null;
            try {
                String url;
                Method method = this.exportTaskTypeMethodMap.get(exportTask.getTaskType());
                ExportExcelServiceImpl target = (ExportExcelServiceImpl)SpringContextUtils.getBean(this.getClass());
                ExportTaskContext context = exportTask.getContext();
                Object obj = method.invoke((Object)target, context);
                if (obj instanceof List) {
                    List list = (List)obj;
                    tempPath = this.getTempPath(exportTask);
                    ExcelUtils.write((String)tempPath, (List)list, (Locale)context.getContext().getLocale());
                    url = this.obsHelper.uploadFile(new File(tempPath));
                    exportTask.done(url);
                }
                if (obj instanceof File) {
                    file = (File)obj;
                    String url2 = this.obsHelper.uploadFile(file);
                    exportTask.done(url2);
                }
                if (obj instanceof DynamicExportDataBo) {
                    DynamicExportDataBo dynamicExportDataBo = (DynamicExportDataBo)obj;
                    tempPath = this.getTempPath(exportTask);
                    ExcelUtils.write((String)tempPath, (DynamicExportDataBo)dynamicExportDataBo, (Locale)context.getContext().getLocale());
                    url = this.obsHelper.uploadFile(new File(tempPath));
                    exportTask.done(url);
                }
                if (!(obj instanceof MoreSheetExportDataBo)) break block12;
                MoreSheetExportDataBo data = (MoreSheetExportDataBo)obj;
                tempPath = this.getTempPath(exportTask);
                ExcelUtils.write((String)tempPath, (MoreSheetExportDataBo)data, (Locale)context.getContext().getLocale());
                url = this.obsHelper.uploadFile(new File(tempPath));
                exportTask.done(url);
            }
            catch (Throwable e) {
                try {
                    exportTask.fail();
                    log.error("\u751f\u6210excel\u9519\u8bef", e);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (StringUtils.isNotBlank((CharSequence)tempPath)) {
                        FileUtil.del((String)tempPath);
                    }
                    if (file != null) {
                        FileUtil.del(file);
                    }
                }
            }
        }
        if (StringUtils.isNotBlank((CharSequence)tempPath)) {
            FileUtil.del((String)tempPath);
        }
        if (file != null) {
            FileUtil.del((File)file);
        }
    }

    private String getTempPath(ExportTask exportTask) {
        log.info("\u751f\u6210excel {}", (Object)exportTask.getId());
        String randomName = RandomUtil.randomString((int)32) + "." + String.valueOf(exportTask.getTaskType().getFileType());
        String tempPath = "/extend/" + randomName;
        log.info("\u751f\u6210\u672c\u5730excel{}", (Object)tempPath);
        return tempPath;
    }

    @ExcelProvider(value={ExportTaskTypeEnum.PRIMARY_PORT_TRAFFIC_DETAIL})
    public MoreSheetExportDataBo exportPrimaryPortTrafficDetail(ExportTaskContext context) {
        Context.CONTEXT.set(context.getContext());
        BasicQuery query = (BasicQuery)JSON.parseObject((String)context.getParams(), BasicQuery.class);
        return this.operationsAnalysisService.exportPrimaryPortTrafficDetail(query);
    }

    public ExportTaskDTO createExportTask(ExportTaskContext context, Context localContext, ExportTaskTypeEnum exportTaskType) {
        String fileName = this.messageSource.getMessage(exportTaskType.getI18nNameKey(), null, localContext.getLocale()) + "(" + LocalDateTimeUtils.formatDateTime((LocalDateTime)Context.now()) + ")." + exportTaskType.getFileType().name();
        ExportTask exportTask = new ExportTask();
        exportTask.setTaskType(exportTaskType);
        exportTask.setName(fileName);
        exportTask.setCreateTime(LocalDateTime.now());
        exportTask.setContext(context);
        if (exportTask.isWaiting()) {
            exportTask.setScheduled();
            this.exportTaskProvider.save(exportTask);
        }
        if (exportTask.getId() != null) {
            ExportTaskEventContext.publish((ExportTaskEvent)new ExportTaskEvent(exportTask));
        }
        return this.exportTaskProvider.getById(exportTask.getId());
    }

    public void retryExportTask(Integer taskId) {
        ExportTaskDTO dto = this.exportTaskProvider.getById(taskId);
        if (dto == null) {
            return;
        }
        ExportTask exportTask = ExportTaskConverter.dto2Domain((ExportTaskDTO)dto);
        exportTask.setWaiting();
        ExportTaskEventContext.publish((ExportTaskEvent)new ExportTaskEvent(exportTask));
    }

    @ExcelProvider(value={ExportTaskTypeEnum.CUSTOMER_GROUP_DISTRIBUTION})
    public DynamicExportDataBo exportFlowGroupDistribution(ExportTaskContext context) {
        Context.CONTEXT.set(context.getContext());
        CustomerGroupExportQuery query = (CustomerGroupExportQuery)((Object)JSON.parseObject((String)context.getParams(), CustomerGroupExportQuery.class));
        return this.customerGroupService.exportFlowGroupDistribution(query);
    }
}

