/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.pr.service.impl;

import com.baomidou.mybatisplus.core.toolkit.CollectionUtils;
import com.google.common.collect.Lists;
import com.ovopark.pr.dao.entity.AgeConfig;
import com.ovopark.pr.dao.repository.AgeConfigRepository;
import com.ovopark.pr.manager.common.enums.AgeGroupEnum;
import com.ovopark.pr.manager.service.AgeConfigService;
import jakarta.annotation.Resource;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.stereotype.Service;

@Service(value="ageConfigService")
public class AgeConfigServiceImpl
implements AgeConfigService {
    @Resource
    private AgeConfigRepository ageConfigRepository;

    public List<AgeConfig> getAgeGroupConfig(Integer enterpriseId) {
        List<AgeConfig> res = this.ageConfigRepository.getAgeGroupPersonalizationConfig(enterpriseId).stream().filter(AgeConfig::getEnable).collect(Collectors.toList());
        if (CollectionUtils.isNotEmpty(res)) {
            return res;
        }
        return this.getAgeGroupCommonConfig(enterpriseId);
    }

    public List<AgeConfig> getAgeGroupCommonConfig(Integer enterpriseId) {
        List list = this.ageConfigRepository.getAgeGroupCommonConfig(enterpriseId);
        AgeGroupEnum[] values = AgeGroupEnum.values();
        if (CollectionUtils.isEmpty((Collection)list)) {
            return Lists.newArrayList((Object[])new AgeConfig[]{new AgeConfig().setAgeType(Integer.valueOf(AgeGroupEnum.EARLY_YOUTH.getIndex())).setAgeFrom(Integer.valueOf(0)).setAgeTo(Integer.valueOf(14)).setEnterpriseId(enterpriseId).setEnable(Boolean.valueOf(true)), new AgeConfig().setAgeType(Integer.valueOf(AgeGroupEnum.YOUTH.getIndex())).setAgeFrom(Integer.valueOf(15)).setAgeTo(Integer.valueOf(35)).setEnterpriseId(enterpriseId).setEnable(Boolean.valueOf(true)), new AgeConfig().setAgeType(Integer.valueOf(AgeGroupEnum.MIDDLE_AGE.getIndex())).setAgeFrom(Integer.valueOf(36)).setAgeTo(Integer.valueOf(45)).setEnterpriseId(enterpriseId).setEnable(Boolean.valueOf(true)), new AgeConfig().setAgeType(Integer.valueOf(AgeGroupEnum.MIDDLE_AND_OLD_AGE.getIndex())).setAgeFrom(Integer.valueOf(46)).setAgeTo(Integer.valueOf(60)).setEnterpriseId(enterpriseId).setEnable(Boolean.valueOf(true)), new AgeConfig().setAgeType(Integer.valueOf(AgeGroupEnum.OLD_AGE.getIndex())).setAgeFrom(Integer.valueOf(61)).setEnterpriseId(enterpriseId).setEnable(Boolean.valueOf(true))});
        }
        return Arrays.stream(values).map(groupEnum -> {
            AgeConfig vo = new AgeConfig().setEnterpriseId(enterpriseId).setAgeType(Integer.valueOf(groupEnum.getIndex())).setEnable(Boolean.valueOf(false));
            for (AgeConfig config : list) {
                if (config.getAgeType().intValue() != groupEnum.getIndex()) continue;
                BeanUtils.copyProperties((Object)config, (Object)vo);
                break;
            }
            return vo;
        }).collect(Collectors.toList());
    }
}

