/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.shared.alert;

import com.ovopark.device.shared.MsgImpl;
import com.ovopark.kernel.shared.Util;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.concurrent.TimeUnit;

public class AlertMsg
extends MsgImpl {
    private String mac;
    private Integer channel;
    private Integer channelId;
    private Integer alertType;
    private Integer nvrAlertType;
    private String sessionId;
    private String alertTime;
    private String alertSN;
    private String version;
    private long timestamp;
    private String pictureUrl;
    private String forward_pic_file_name;
    private Integer deviceStatusId;
    private long offlineStamp;

    public static String nowAsAlertTime() {
        return LocalDateTime.now().format(DateTimeFormatter.ofPattern("yyyyMMddHHmmss"));
    }

    public static long nowAsTimestamp() {
        return System.currentTimeMillis() / 1000L;
    }

    public LocalDateTime alertTimeAsTime() {
        return Util.isEmpty((CharSequence)this.alertTime) ? null : Util.dateTime((String)this.alertTime, (String[])new String[]{"yyyyMMddHHmmss"});
    }

    public LocalDateTime timestampAsTime() {
        return this.timestamp <= 0L ? null : Util.dateTime((long)TimeUnit.SECONDS.toMillis(this.timestamp));
    }

    public LocalDateTime offlineStampAsTime() {
        return this.offlineStamp <= 0L ? null : Util.dateTime((long)TimeUnit.SECONDS.toMillis(this.offlineStamp));
    }

    public String getMac() {
        return this.mac;
    }

    public Integer getChannel() {
        return this.channel;
    }

    public Integer getChannelId() {
        return this.channelId;
    }

    public Integer getAlertType() {
        return this.alertType;
    }

    public Integer getNvrAlertType() {
        return this.nvrAlertType;
    }

    public String getSessionId() {
        return this.sessionId;
    }

    public String getAlertTime() {
        return this.alertTime;
    }

    public String getAlertSN() {
        return this.alertSN;
    }

    public String getVersion() {
        return this.version;
    }

    public long getTimestamp() {
        return this.timestamp;
    }

    public String getPictureUrl() {
        return this.pictureUrl;
    }

    public String getForward_pic_file_name() {
        return this.forward_pic_file_name;
    }

    public Integer getDeviceStatusId() {
        return this.deviceStatusId;
    }

    public long getOfflineStamp() {
        return this.offlineStamp;
    }

    public void setMac(String mac) {
        this.mac = mac;
    }

    public void setChannel(Integer channel) {
        this.channel = channel;
    }

    public void setChannelId(Integer channelId) {
        this.channelId = channelId;
    }

    public void setAlertType(Integer alertType) {
        this.alertType = alertType;
    }

    public void setNvrAlertType(Integer nvrAlertType) {
        this.nvrAlertType = nvrAlertType;
    }

    public void setSessionId(String sessionId) {
        this.sessionId = sessionId;
    }

    public void setAlertTime(String alertTime) {
        this.alertTime = alertTime;
    }

    public void setAlertSN(String alertSN) {
        this.alertSN = alertSN;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setTimestamp(long timestamp) {
        this.timestamp = timestamp;
    }

    public void setPictureUrl(String pictureUrl) {
        this.pictureUrl = pictureUrl;
    }

    public void setForward_pic_file_name(String forward_pic_file_name) {
        this.forward_pic_file_name = forward_pic_file_name;
    }

    public void setDeviceStatusId(Integer deviceStatusId) {
        this.deviceStatusId = deviceStatusId;
    }

    public void setOfflineStamp(long offlineStamp) {
        this.offlineStamp = offlineStamp;
    }

    @Override
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AlertMsg)) {
            return false;
        }
        AlertMsg other = (AlertMsg)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getTimestamp() != other.getTimestamp()) {
            return false;
        }
        if (this.getOfflineStamp() != other.getOfflineStamp()) {
            return false;
        }
        Integer this$channel = this.getChannel();
        Integer other$channel = other.getChannel();
        if (this$channel == null ? other$channel != null : !((Object)this$channel).equals(other$channel)) {
            return false;
        }
        Integer this$channelId = this.getChannelId();
        Integer other$channelId = other.getChannelId();
        if (this$channelId == null ? other$channelId != null : !((Object)this$channelId).equals(other$channelId)) {
            return false;
        }
        Integer this$alertType = this.getAlertType();
        Integer other$alertType = other.getAlertType();
        if (this$alertType == null ? other$alertType != null : !((Object)this$alertType).equals(other$alertType)) {
            return false;
        }
        Integer this$nvrAlertType = this.getNvrAlertType();
        Integer other$nvrAlertType = other.getNvrAlertType();
        if (this$nvrAlertType == null ? other$nvrAlertType != null : !((Object)this$nvrAlertType).equals(other$nvrAlertType)) {
            return false;
        }
        Integer this$deviceStatusId = this.getDeviceStatusId();
        Integer other$deviceStatusId = other.getDeviceStatusId();
        if (this$deviceStatusId == null ? other$deviceStatusId != null : !((Object)this$deviceStatusId).equals(other$deviceStatusId)) {
            return false;
        }
        String this$mac = this.getMac();
        String other$mac = other.getMac();
        if (this$mac == null ? other$mac != null : !this$mac.equals(other$mac)) {
            return false;
        }
        String this$sessionId = this.getSessionId();
        String other$sessionId = other.getSessionId();
        if (this$sessionId == null ? other$sessionId != null : !this$sessionId.equals(other$sessionId)) {
            return false;
        }
        String this$alertTime = this.getAlertTime();
        String other$alertTime = other.getAlertTime();
        if (this$alertTime == null ? other$alertTime != null : !this$alertTime.equals(other$alertTime)) {
            return false;
        }
        String this$alertSN = this.getAlertSN();
        String other$alertSN = other.getAlertSN();
        if (this$alertSN == null ? other$alertSN != null : !this$alertSN.equals(other$alertSN)) {
            return false;
        }
        String this$version = this.getVersion();
        String other$version = other.getVersion();
        if (this$version == null ? other$version != null : !this$version.equals(other$version)) {
            return false;
        }
        String this$pictureUrl = this.getPictureUrl();
        String other$pictureUrl = other.getPictureUrl();
        if (this$pictureUrl == null ? other$pictureUrl != null : !this$pictureUrl.equals(other$pictureUrl)) {
            return false;
        }
        String this$forward_pic_file_name = this.getForward_pic_file_name();
        String other$forward_pic_file_name = other.getForward_pic_file_name();
        return !(this$forward_pic_file_name == null ? other$forward_pic_file_name != null : !this$forward_pic_file_name.equals(other$forward_pic_file_name));
    }

    @Override
    protected boolean canEqual(Object other) {
        return other instanceof AlertMsg;
    }

    @Override
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $timestamp = this.getTimestamp();
        result = result * 59 + (int)($timestamp >>> 32 ^ $timestamp);
        long $offlineStamp = this.getOfflineStamp();
        result = result * 59 + (int)($offlineStamp >>> 32 ^ $offlineStamp);
        Integer $channel = this.getChannel();
        result = result * 59 + ($channel == null ? 43 : ((Object)$channel).hashCode());
        Integer $channelId = this.getChannelId();
        result = result * 59 + ($channelId == null ? 43 : ((Object)$channelId).hashCode());
        Integer $alertType = this.getAlertType();
        result = result * 59 + ($alertType == null ? 43 : ((Object)$alertType).hashCode());
        Integer $nvrAlertType = this.getNvrAlertType();
        result = result * 59 + ($nvrAlertType == null ? 43 : ((Object)$nvrAlertType).hashCode());
        Integer $deviceStatusId = this.getDeviceStatusId();
        result = result * 59 + ($deviceStatusId == null ? 43 : ((Object)$deviceStatusId).hashCode());
        String $mac = this.getMac();
        result = result * 59 + ($mac == null ? 43 : $mac.hashCode());
        String $sessionId = this.getSessionId();
        result = result * 59 + ($sessionId == null ? 43 : $sessionId.hashCode());
        String $alertTime = this.getAlertTime();
        result = result * 59 + ($alertTime == null ? 43 : $alertTime.hashCode());
        String $alertSN = this.getAlertSN();
        result = result * 59 + ($alertSN == null ? 43 : $alertSN.hashCode());
        String $version = this.getVersion();
        result = result * 59 + ($version == null ? 43 : $version.hashCode());
        String $pictureUrl = this.getPictureUrl();
        result = result * 59 + ($pictureUrl == null ? 43 : $pictureUrl.hashCode());
        String $forward_pic_file_name = this.getForward_pic_file_name();
        result = result * 59 + ($forward_pic_file_name == null ? 43 : $forward_pic_file_name.hashCode());
        return result;
    }

    @Override
    public String toString() {
        return "AlertMsg(mac=" + this.getMac() + ", channel=" + this.getChannel() + ", channelId=" + this.getChannelId() + ", alertType=" + this.getAlertType() + ", nvrAlertType=" + this.getNvrAlertType() + ", sessionId=" + this.getSessionId() + ", alertTime=" + this.getAlertTime() + ", alertSN=" + this.getAlertSN() + ", version=" + this.getVersion() + ", timestamp=" + this.getTimestamp() + ", pictureUrl=" + this.getPictureUrl() + ", forward_pic_file_name=" + this.getForward_pic_file_name() + ", deviceStatusId=" + this.getDeviceStatusId() + ", offlineStamp=" + this.getOfflineStamp() + ")";
    }
}

