/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.device.shared;

import com.ovopark.device.shared.DeviceConfig;
import com.ovopark.device.shared.MsgContext;
import com.ovopark.kernel.shared.kv.CacheService;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.log.Trace;
import org.slf4j.Logger;

public class ContextImpl
extends Stream.MsgPerContextImpl
implements MsgContext {
    private final DeviceConfig deviceConfig;
    final Stream.MsgPerContext.PerLogger perLogger;

    public ContextImpl(String seq, CacheService clusterCacheService, DeviceConfig deviceConfig) {
        super(seq, clusterCacheService);
        this.deviceConfig = deviceConfig;
        this.perLogger = new PerLoggerImpl();
    }

    @Override
    public DeviceConfig deviceConfig() {
        return this.deviceConfig;
    }

    public Stream.MsgPerContext.PerLogger logger() {
        return this.perLogger;
    }

    private class PerLoggerImpl
    implements Stream.MsgPerContext.PerLogger {
        private Trace trace = Trace.from((String)"DEVICE_MSG");

        private PerLoggerImpl() {
        }

        public void debug(Logger logger, String message) {
            if (ContextImpl.this.deviceConfig().isVerbose()) {
                logger.info(this.trace.tag(ContextImpl.this.seq()).trace(message));
            } else if (logger.isDebugEnabled()) {
                logger.debug(this.trace.tag(ContextImpl.this.seq()).trace(message));
            }
        }

        public void info(Logger logger, String message) {
            if (logger.isInfoEnabled()) {
                logger.info(this.trace.tag(ContextImpl.this.seq()).trace(message));
            }
        }

        public void error(Logger logger, Exception e) {
            if (logger.isErrorEnabled()) {
                logger.error(this.trace.tag(ContextImpl.this.seq()).trace(e.getMessage()), (Throwable)e);
            }
        }

        public void error(Logger logger, Throwable e, String message) {
            if (logger.isErrorEnabled()) {
                logger.error(this.trace.tag(ContextImpl.this.seq()).trace(message), e);
            }
        }

        public void error(Logger logger, String message) {
            if (logger.isErrorEnabled()) {
                logger.error(this.trace.tag(ContextImpl.this.seq()).trace(message));
            }
        }

        public void warn(Logger logger, String message) {
            if (logger.isWarnEnabled()) {
                logger.warn(this.trace.tag(ContextImpl.this.seq()).trace(message));
            }
        }
    }
}

