/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.vfile;

import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.OnlyPrivate;
import com.ovopark.kernel.shared.OnlyTest;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ReleasableLock;
import com.ovopark.kernel.shared.kv.KVEngine;
import com.ovopark.kernel.shared.vfile.FileIO;
import com.ovopark.kernel.shared.vfile.ILayeredFileIO;
import com.ovopark.kernel.shared.vfile.SimpleFileIO;
import com.ovopark.kernel.shared.vfile.SimpleShardFileIO;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.StandardOpenOption;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LayeredFileIO
implements ILayeredFileIO,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(LayeredFileIO.class);
    final String UUID_STR = Util.uniqueFirstPart();
    private static final String WRITE_LOCK = ".iol";
    private static final String MF_IOM = ".iom";
    private static final String MF_IOS = ".ios";
    private final List<FileIOProxy> fileIOProxyList = new CopyOnWriteArrayList<FileIOProxy>();
    volatile FileIOProxy writableFileIOProxy;
    final String tag;
    final String basePath;
    final boolean compressed;
    final long maxFileSizeMb;
    private final boolean autoIncrement;
    private final boolean merged;
    private final boolean flushPeriod;
    final AtomicInteger fileIndex = new AtomicInteger(-1);
    private final AutoIncrementKeyGenerator autoIncrementKeyGenerator;
    private final AtomicLong vcc = new AtomicLong();
    final AtomicBoolean closed = new AtomicBoolean(false);
    static final int LONG_LENGTH = String.valueOf(Long.MAX_VALUE).length();
    private static final String ZERO = String.join((CharSequence)"", Collections.nCopies(LONG_LENGTH, "0"));
    private final ReentrantReadWriteLock metaReadWriteLock = new ReentrantReadWriteLock();
    private final ReleasableLock metaSLock = new ReleasableLock(this.metaReadWriteLock.readLock());
    private final ReleasableLock metaXLock = new ReleasableLock(this.metaReadWriteLock.writeLock());
    private final ReentrantReadWriteLock dataReadWriteLock = new ReentrantReadWriteLock();
    private final ReleasableLock dataSLock = new ReleasableLock(this.dataReadWriteLock.readLock());
    private final ReleasableLock dataXLock = new ReleasableLock(this.dataReadWriteLock.writeLock());
    public static final int LOCK_TIMEOUT_SEC = Math.max(Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.lockTimeoutSec", Config.ConfigPriority.option().getInt("shared.jdk8.module.vfile.lockTimeoutSec", 30)), 30);
    static final ScheduledExecutorService checkFileCountSchedule = Executors.newSingleThreadScheduledExecutor(Util.newThreadFactory("checkFileCount"));
    static final ScheduledExecutorService flushSchedule = Executors.newScheduledThreadPool(4, Util.newThreadFactory("flush"));
    static final ExecutorService mergeExecutor = Executors.newFixedThreadPool(Math.max(Runtime.getRuntime().availableProcessors(), 4), Util.newThreadFactory("merge"));
    final boolean onlySupportInsert;
    private final int rowRegion;
    private final String mergeStrategy;
    private final int skipMergeIfMaxRowCount;
    private final int forceMergeIfMaxSkipCount;
    private final int keepMaxFileCount;
    private final int sparseIfMinCount;
    final SimpleFileIO.MemoryBuffer memoryBuffer;
    final boolean shardIf;
    final boolean shardIfAutoIncrement;
    private final int walBufferSizeMb;
    private final long walDiskSizeMb;
    static final KVEngine.TtlFunc<String> snapshotTtl = KVEngine.newTtl(LayeredFileIO.class.getName());
    private final AtomicBoolean merging = new AtomicBoolean(false);
    private FileLock writeLockFileLock;
    private FileChannel writeLockFileChannel;

    public LayeredFileIO(String basePath, Conf conf) {
        this(basePath, conf, null, false, false);
    }

    LayeredFileIO(String basePath, Conf conf, AutoIncrementKeyGenerator autoIncrementKeyGenerator, boolean shardIf, boolean shardIfAutoIncrement) {
        if (shardIfAutoIncrement && autoIncrementKeyGenerator == null) {
            throw DBOpeException.from("a shard, the autoincrement implementation is provided by " + SimpleShardFileIO.class.getSimpleName());
        }
        this.tag = Util.uniqueFirstPart();
        this.basePath = basePath;
        this.compressed = conf.isCompressed();
        this.onlySupportInsert = conf.isOnlySupportInsert();
        this.autoIncrement = conf.isAutoIncrement();
        this.maxFileSizeMb = conf.getWalDiskSizeMb();
        this.rowRegion = conf.getRowRegion();
        this.merged = conf.merged;
        this.flushPeriod = conf.isFlushPeriod();
        this.mergeStrategy = conf.mergeStrategy;
        this.walBufferSizeMb = conf.getWalBufferSizeMb();
        this.walDiskSizeMb = conf.getWalDiskSizeMb();
        this.skipMergeIfMaxRowCount = conf.getSkipMergeIfMaxRowCount();
        if (conf.getForceMergeIfMaxSkipCount() > 2) {
            log.info("ignore forceMergeIfMaxSkipCount: " + conf.getSkipMergeIfMaxRowCount() + " , <= 2 & >=0");
        }
        this.forceMergeIfMaxSkipCount = Math.min(2, conf.getForceMergeIfMaxSkipCount());
        this.keepMaxFileCount = Math.max(conf.getKeepMaxFileCount(), 2);
        log.info("used forceMergeIfMaxSkipCount: " + this.forceMergeIfMaxSkipCount + " , keepMaxFileCount: " + this.keepMaxFileCount);
        this.sparseIfMinCount = Math.max(conf.getSparseIfMinCount(), 100000);
        this.memoryBuffer = new SimpleFileIO.MemoryBufferImpl(0x100000L * conf.getMemoryBufferSizeMb());
        this.autoIncrementKeyGenerator = autoIncrementKeyGenerator == null ? new AutoIncrementKeyGeneratorImpl(new AtomicLong()) : autoIncrementKeyGenerator;
        this.shardIf = shardIf;
        this.shardIfAutoIncrement = shardIfAutoIncrement;
        this.loadBeforeAvailable();
    }

    private void loadBeforeAvailable() {
        Meta meta;
        File bf = new File(this.basePath);
        if (!bf.exists()) {
            bf.mkdirs();
        }
        if (bf.listFiles().length == 0) {
            meta = new Meta();
            meta.setCompressed(this.compressed);
            meta.setOnlySupportInsert(this.onlySupportInsert);
            meta.setAutoIncrement(this.autoIncrement);
            this.writeMeta(meta);
        }
        if ((meta = this.readMeta()).compressed != this.compressed) {
            throw DBOpeException.from("diff compressed: " + meta.compressed + ", but " + this.compressed);
        }
        if (meta.onlySupportInsert != this.onlySupportInsert) {
            throw DBOpeException.from("diff onlySupportInsert: " + meta.onlySupportInsert + ", but " + this.onlySupportInsert);
        }
        if (meta.autoIncrement != this.autoIncrement) {
            throw DBOpeException.from("diff autoIncrement: " + meta.autoIncrement + ", but " + this.autoIncrement);
        }
        try {
            this.ensureWriteLock();
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw DBOpeException.from(e);
        }
        for (FileInfo fileInfo : new ArrayList<FileInfo>(meta.fileInfoList)) {
            String fPath = this.basePath + "/" + fileInfo.fileName;
            String name = fileInfo.fileName;
            int fi = fileInfo.fileIndex;
            SimpleFileIO.Conf conf = new SimpleFileIO.Conf();
            conf.setCompressed(this.compressed);
            conf.setWalBufferSizeMb(this.walBufferSizeMb);
            conf.setWalDiskSizeMb(this.walDiskSizeMb);
            conf.setSorted(fileInfo.isSorted());
            conf.setSparse(fileInfo.isSorted() && fileInfo.isMerged() && fileInfo.getRowCountIncludeInvalidData() > this.sparseIfMinCount);
            SimpleFileIO simpleFileIO = new SimpleFileIO(name, fPath, conf, true, true, true, new SimpleFileIO.VccGenerator(){

                @Override
                public long next() {
                    throw new UnsupportedOperationException();
                }
            }, this.memoryBuffer);
            FileIOProxy fileIOProxy = new FileIOProxy(simpleFileIO, fi);
            if (fileIOProxy.rowCountIncludeInvalidData() == 0) {
                meta.fileInfoList.removeIf(f -> f.fileIndex == fileIOProxy.fileIndex);
                meta.fileInfoList.sort(Comparator.comparing(FileInfo::getFileIndex));
                this.writeMeta(meta);
                try {
                    fileIOProxy.close();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw DBOpeException.from(e);
                }
                try {
                    Path path = Files.move(new File(fileIOProxy.filePath()).toPath(), new File(fileIOProxy.filePath() + ".deleted").toPath(), StandardCopyOption.REPLACE_EXISTING);
                    boolean f2 = Files.deleteIfExists(path);
                    log.info("empty, " + fileIOProxy.filePath() + " move to : " + path + " ( deleted: " + f2 + ")");
                }
                catch (IOException e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw DBOpeException.from(e);
                }
            }
            this.fileIOProxyList.add(fileIOProxy);
            this.fileIndex.updateAndGet(operand -> Math.max(operand, fi));
        }
        log.info("max file index: " + this.fileIndex.get());
        AtomicLong tempKey = new AtomicLong(0L);
        if (Util.isNotEmpty(this.fileIOProxyList)) {
            this.fileIOProxyList.sort(Comparator.comparingInt(o -> o.fileIndex));
            for (int j = this.fileIOProxyList.size() - 1; j >= 0; --j) {
                FileIOProxy fileIOProxy = this.fileIOProxyList.get(j);
                if (fileIOProxy.rowCountIncludeInvalidData() == 0) continue;
                log.info("get max vcc , key from file: " + fileIOProxy.filePath());
                SimpleFileIO.SearchContextImpl sc = new SimpleFileIO.SearchContextImpl();
                fileIOProxy.search0((fileGetResult, searchContext) -> {
                    long v = fileGetResult.vcc();
                    this.vcc.updateAndGet(operand -> Math.max(v, operand));
                    if (this.autoIncrement || this.shardIfAutoIncrement) {
                        tempKey.updateAndGet(operand -> Math.max(Long.parseLong(fileGetResult.key()), operand));
                    }
                }, sc, false, false);
                break;
            }
            if (this.autoIncrement || this.shardIfAutoIncrement) {
                this.autoIncrementKeyGenerator.updateAndGet(l -> Math.max(l, Math.max(tempKey.get(), meta.mayMaxKey)));
            }
            log.info("(shard?: " + this.shardIf + ", shardIfAutoIncrement?:" + this.shardIfAutoIncrement + "), max vcc: " + this.vcc.get() + ", max key autoIncrement?(" + this.autoIncrement + "): " + this.autoIncrementKeyGenerator.get());
        }
        this.createAndRefreshFile(null);
        this.checkFileCountAndMerge();
        this.flushPeriod();
    }

    private void flushPeriod() {
        if (!this.flushPeriod) {
            log.info("flushPeriod: " + this.flushPeriod);
            return;
        }
        Util.schedule(flushSchedule, () -> this.dataX_lock(() -> {
            LinkedHashMap<String, Object> stat = new LinkedHashMap<String, Object>();
            stat.put("missRate", "");
            ArrayList<Integer> sList = new ArrayList<Integer>();
            SimpleFileIO.MemoryBufferImpl mb = (SimpleFileIO.MemoryBufferImpl)this.memoryBuffer;
            for (SimpleFileIO.MemoryBufferImpl.ShardMap shardMap : mb.shards) {
                if (shardMap == null) {
                    sList.add(null);
                    continue;
                }
                sList.add(shardMap.size());
            }
            stat.put("maxBufferSize", mb.maxBufferSize);
            stat.put("splitBufferSize", mb.splitBufferSize);
            stat.put("usedByteSize", mb.usedByteSize.get());
            stat.put("clearCount", mb.memoryBufferStat.getClearCount());
            stat.put("shard", sList);
            long hint = 0L;
            long miss = 0L;
            for (FileIOProxy fileIOProxy : this.cloneFileRefAsLocal()) {
                LinkedHashMap<String, SimpleFileIO.MemoryBufferStat> fileMap = new LinkedHashMap<String, SimpleFileIO.MemoryBufferStat>();
                SimpleFileIO.MemoryBufferStat memoryBufferStat = fileIOProxy.memoryBufferStat();
                hint += memoryBufferStat.getHint().get();
                miss += memoryBufferStat.getMiss().get();
                memoryBufferStat.setMissRate(new BigDecimal(memoryBufferStat.getMiss().get()).divide(new BigDecimal(1L + memoryBufferStat.getHint().get() + memoryBufferStat.getMiss().get()), 5, RoundingMode.HALF_UP).doubleValue());
                fileMap.put("memoryBufferStat", memoryBufferStat);
                stat.put(fileIOProxy.filePath(), fileMap);
            }
            double missRate = new BigDecimal(miss).divide(new BigDecimal(1L + miss + hint), 5, RoundingMode.HALF_UP).doubleValue();
            stat.put("missRate", missRate);
            try {
                Util.writeAtomic(new File(this.basePath + "/" + MF_IOS), JSONAccessor.impl().formatAsBytes(stat));
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
            if (this.writableFileIOProxy.isClosed()) {
                return null;
            }
            long l = this.writableFileIOProxy.commitAndFsync(false, true, false);
            if (l > 0L) {
                log.debug(this.writableFileIOProxy.filePath() + ", flush data size: " + l);
            }
            return null;
        }, Integer.MAX_VALUE, TimeUnit.SECONDS), 1L, TimeUnit.SECONDS, t -> {
            log.error(t.getMessage(), t);
            return true;
        }, () -> !this.closed.get());
    }

    private void checkFileCountAndMerge() {
        log.info("merged supported: " + this.merged);
        if (!this.merged) {
            return;
        }
        Util.schedule(checkFileCountSchedule, () -> {
            ArrayList<FileIOProxy> ioProxyList = this.cloneFileRefAsLocal();
            int size = ioProxyList.size();
            if (size > this.keepMaxFileCount) {
                mergeExecutor.submit(Util.catchRunnable(() -> {
                    if (this.merging.compareAndSet(false, true)) {
                        log.info("ready merging");
                        try {
                            this.merge0(this.mergeStrategy);
                        }
                        finally {
                            log.info("reset merging flag > false");
                            this.merging.set(false);
                        }
                    }
                }));
            }
        }, 15L, TimeUnit.SECONDS, t -> {
            log.error(t.getMessage(), t);
            return true;
        }, () -> !this.closed.get());
    }

    private FileIOProxy createAndRefreshFile(final FileIOProxy beforeWritableFileIOProxy) {
        SimpleFileIO.Conf conf = new SimpleFileIO.Conf();
        conf.setCompressed(this.compressed);
        conf.setWalBufferSizeMb(this.walBufferSizeMb);
        conf.setWalDiskSizeMb(this.maxFileSizeMb);
        conf.setRowRegion(this.rowRegion);
        int fi = this.fileIndex.incrementAndGet();
        String fileName = this.UUID_STR + "-" + fi;
        String filePath = this.basePath + "/" + fileName;
        SimpleFileIO simpleFileIO = new SimpleFileIO(fileName, filePath, conf, false, true, true, new SimpleFileIO.VccGenerator(){

            @Override
            public long next() {
                return LayeredFileIO.this.vcc.incrementAndGet();
            }
        }, this.memoryBuffer);
        final FileIOProxy fileIOProxy = new FileIOProxy(simpleFileIO, fi);
        Meta meta = this.metaX_lock(new DoInLock<Meta>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Meta doInLock() {
                Meta meta = LayeredFileIO.this.readMeta();
                if (beforeWritableFileIOProxy != null) {
                    meta.fileInfoList.stream().filter(fileInfo -> new File(beforeWritableFileIOProxy.filePath()).getName().endsWith(fileInfo.fileName)).findFirst().get().setRowCountIncludeInvalidData(beforeWritableFileIOProxy.rowCountIncludeInvalidData());
                }
                FileInfo fileInfo2 = new FileInfo();
                fileInfo2.setFileIndex(fileIOProxy.fileIndex);
                fileInfo2.setFileName(new File(fileIOProxy.filePath()).getName());
                meta.fileInfoList.add(fileInfo2);
                meta.fileInfoList.sort(Comparator.comparing(FileInfo::getFileIndex));
                meta.setMayMaxKey(LayeredFileIO.this.autoIncrementKeyGenerator.get());
                LayeredFileIO.this.writeMeta(meta);
                ArrayList loadedFileIOProxyList = LayeredFileIO.this.cloneFileRefAsLocal();
                ArrayList<FileIOProxy> fpList = new ArrayList<FileIOProxy>(meta.fileInfoList.size());
                for (FileInfo f : meta.fileInfoList) {
                    if (fileInfo2.fileIndex == f.fileIndex) continue;
                    FileIOProxy found = null;
                    for (FileIOProxy loadedProxy : loadedFileIOProxyList) {
                        if (f.fileIndex != loadedProxy.fileIndex) continue;
                        found = loadedProxy;
                        break;
                    }
                    if (found == null) {
                        throw DBOpeException.from("file(" + f.fileIndex + ") not loaded, ???");
                    }
                    fpList.add(found);
                }
                fpList.add(fileIOProxy);
                fpList.sort(Comparator.comparing(FileIOProxy::getFileIndex));
                List list = LayeredFileIO.this.fileIOProxyList;
                synchronized (list) {
                    LayeredFileIO.this.fileIOProxyList.clear();
                    LayeredFileIO.this.fileIOProxyList.addAll(fpList);
                    for (FileIOProxy fileIOProxy2 : LayeredFileIO.this.fileIOProxyList) {
                        fileIOProxy2.writable.set(false);
                    }
                    fileIOProxy.writable.set(true);
                    LayeredFileIO.this.writableFileIOProxy = fileIOProxy;
                }
                return meta;
            }
        }, Integer.MAX_VALUE, TimeUnit.SECONDS);
        log.info("created new file: " + filePath);
        StringBuilder stringBuilder = new StringBuilder();
        for (FileInfo fileInfo : meta.fileInfoList) {
            stringBuilder.append(fileInfo.fileName + ",");
        }
        log.debug("loaded file: " + stringBuilder.toString());
        return fileIOProxy;
    }

    @Override
    public FileIO.FilePutResult put(String key, Map<String, Object> meta, byte[] data) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (this.onlySupportInsert) {
            throw DBOpeException.from("custom PK is not supported");
        }
        if (this.autoIncrement || this.shardIfAutoIncrement) {
            long l = Long.parseLong(key);
            FileIO.FilePutResult filePutResult = this.put0(Util.leftPad(l, LONG_LENGTH), meta, data);
            if (filePutResult.vcc() > 0L) {
                this.autoIncrementKeyGenerator.updateAndGet(operand -> Math.max(operand, l));
            }
            return filePutResult;
        }
        return this.put0(key, meta, data);
    }

    @Override
    public FileIO.FilePutResult put(Map<String, Object> meta, byte[] data) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (!this.autoIncrement) {
            throw DBOpeException.from("autoIncrement must be true");
        }
        return this.put0(Util.leftPad(this.autoIncrementKeyGenerator.next(), LONG_LENGTH), meta, data);
    }

    @Override
    public FileIO.CompareAndSetResult compareAndSet(String key, FileIO.CompareAndSet compareAndSet) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (this.onlySupportInsert) {
            throw DBOpeException.from("custom PK is not supported");
        }
        return this.dataX_lock(() -> {
            SimpleFileIO.FileGetResultImpl fileGetResult = this.get0(key);
            if (fileGetResult == null) {
                throw DBOpeException.from("key does not exist: " + key);
            }
            fileGetResult.fetchDataAndReleaseBufferRef();
            SimpleFileIO.OperatorImpl operator = new SimpleFileIO.OperatorImpl();
            FileIO.Setter setter = compareAndSet.test(fileGetResult, operator);
            if (setter instanceof SimpleFileIO.NoopImpl) {
                return new SimpleFileIO.CompareAndSetResultImpl(null, null);
            }
            if (setter instanceof FileIO.Delete) {
                SimpleFileIO.FileDeleteResultImpl fileDeleteResult = this.delete0(key);
                return new SimpleFileIO.CompareAndSetResultImpl(null, fileDeleteResult);
            }
            if (setter instanceof FileIO.Put) {
                FileIO.FilePutResult filePutResult = this.put0(key, ((SimpleFileIO.PutImpl)setter).getMeta(), ((SimpleFileIO.PutImpl)setter).getData());
                return new SimpleFileIO.CompareAndSetResultImpl(filePutResult, null);
            }
            throw DBOpeException.from("setter is not supported");
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    private FileIO.FilePutResult put0(String key, Map<String, Object> meta, byte[] data) {
        return this.dataX_lock(() -> {
            FileIOProxy writableFileProxy = this.writableFileIOProxy;
            long freeSize = writableFileProxy.freeSize();
            if (freeSize < (long)data.length) {
                writableFileProxy.commitAndFsync(true, false);
                writableFileProxy = this.createAndRefreshFile(writableFileProxy);
            }
            return writableFileProxy.put0(false, key, meta, data, -1L);
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public FileIO.FileGetResult get(String key) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.metaS_lock(() -> this.getIfFetch(key, true), LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    private SimpleFileIO.FileGetResultImpl getIfFetch(String key, boolean fetchData) {
        SimpleFileIO.FileGetResultImpl fileGetResult = this.get0(key);
        if (fileGetResult == null) {
            return null;
        }
        if (fetchData) {
            fileGetResult.fetchDataAndReleaseBufferRef();
        } else {
            fileGetResult.releaseBufferRef();
        }
        return fileGetResult;
    }

    @Override
    public FileIO.FileGetResult get(String key, boolean fetchData) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.metaS_lock(() -> this.getIfFetch(key, fetchData), LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    private SimpleFileIO.FileGetResultImpl get0(String key) {
        ArrayList<FileIOProxy> localIOProxyList = this.cloneFileRefAsLocal();
        int size = localIOProxyList.size();
        for (int i = size - 1; i > -1; --i) {
            FileIOProxy fileIOProxy = (FileIOProxy)localIOProxyList.get(i);
            SimpleFileIO.FileGetResultImpl getResult = fileIOProxy.get0(key);
            if (getResult == null) continue;
            if (getResult.deleted()) {
                return null;
            }
            return getResult;
        }
        return null;
    }

    @Override
    public FileIO.FileDeleteResult delete(String key) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (this.onlySupportInsert) {
            throw DBOpeException.from("custom PK is not supported");
        }
        return this.dataX_lock(() -> this.delete0(key), LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    private SimpleFileIO.FileDeleteResultImpl delete0(String key) {
        FileIOProxy writableFileProxy = this.writableFileIOProxy;
        long freeSize = writableFileProxy.freeSize();
        if (freeSize < 1024L) {
            writableFileProxy.commitAndFsync(true, false);
            writableFileProxy = this.createAndRefreshFile(writableFileProxy);
        }
        return writableFileProxy.delete0(key);
    }

    private boolean dataIsNewest(FileIO.FileGetResult fileGetResult, List<FileIOProxy> topLayList, boolean fetchMemory) {
        for (int i = 0; i < topLayList.size(); ++i) {
            SimpleFileIO.BinMeta binMeta;
            FileIOProxy fileIOProxy = topLayList.get(i);
            SimpleFileIO.BinReader.BinMetaGet binMetaGet = fileIOProxy.getBinMetaGet0(fileGetResult.key(), fetchMemory, false);
            if (binMetaGet == null || (binMeta = binMetaGet.binMeta()).getVcc() <= fileGetResult.vcc()) continue;
            ((SimpleFileIO.FileGetResultImpl)fileGetResult).simpleFileIO.addDeletedByHighLayer(fileGetResult.key(), fileGetResult.vcc());
            return false;
        }
        return true;
    }

    @Override
    public void search(FileIO.SearchListener searchListener) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        this.metaS_lock(() -> {
            long maxSearchVcc = this.vcc.get();
            FileIO.SearchListener proxy = (fileGetResult, searchContext) -> {
                if (maxSearchVcc < fileGetResult.vcc() || ((SimpleFileIO.FileGetResultImpl)fileGetResult).deleted()) {
                    return;
                }
                SimpleFileIO.SearchContextImpl context = (SimpleFileIO.SearchContextImpl)searchContext;
                boolean f = this.dataIsNewest(fileGetResult, context.topLayList, true);
                if (f) {
                    ((SimpleFileIO.FileGetResultImpl)fileGetResult).fetchDataAndReleaseBufferRef();
                    searchListener.onRow(fileGetResult, searchContext);
                }
            };
            this.search0(proxy, true);
            return null;
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    private void search0(FileIO.SearchListener proxy, boolean fetchData) {
        SimpleFileIO.SearchContextImpl searchContext = new SimpleFileIO.SearchContextImpl();
        ArrayList<FileIOProxy> localIOProxyList = this.cloneFileRefAsLocal();
        localIOProxyList.sort(Comparator.comparingInt(o -> o.fileIndex));
        int size = localIOProxyList.size();
        FileIOProxy lastFileIOProxy = (FileIOProxy)localIOProxyList.get(size - 1);
        for (int i = 0; i < size; ++i) {
            FileIOProxy fileIOProxy = (FileIOProxy)localIOProxyList.get(i);
            searchContext.topLayList = i == size - 1 ? Collections.singletonList(lastFileIOProxy) : localIOProxyList.subList(i + 1, size);
            fileIOProxy.search0(proxy, searchContext, true, fetchData);
            if (searchContext.isCancelled()) break;
        }
    }

    @Override
    public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n, final Predicate<String> predicate) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.metaS_lock(() -> {
            final long maxSearchVcc = this.vcc.get();
            ArrayList<FileIOProxy> localIOProxyList = this.cloneFileRefAsLocal();
            int size = localIOProxyList.size();
            FileIOProxy lastFileIOProxy = (FileIOProxy)localIOProxyList.get(size - 1);
            ArrayList<FileIO.FileGetResult> fileGetResultList = new ArrayList<FileIO.FileGetResult>(n * size);
            for (int i = 0; i < size; ++i) {
                FileIOProxy fileIOProxy = (FileIOProxy)localIOProxyList.get(i);
                final List<FileIOProxy> topLayList = i == size - 1 ? Collections.singletonList(lastFileIOProxy) : localIOProxyList.subList(i + 1, size);
                Supplier<List> supplier = () -> fileIOProxy.searchAfter0(key, inclusive, n, false, new SimpleFileIO.DataValidChecker(){

                    @Override
                    public boolean dataIsValid(FileIO.FileGetResult fileGetResult) {
                        return !((SimpleFileIO.FileGetResultImpl)fileGetResult).deleted() && maxSearchVcc >= fileGetResult.vcc() && LayeredFileIO.this.dataIsNewest(fileGetResult, topLayList, true) && predicate.test(fileGetResult.key());
                    }
                });
                List list = supplier.get();
                fileGetResultList.addAll(list);
            }
            fileGetResultList.sort(Comparator.comparing(FileIO.FileGetResult::key));
            List resultList = fileGetResultList.subList(0, Math.min(fileGetResultList.size(), n));
            resultList.forEach(fileGetResult -> ((SimpleFileIO.FileGetResultImpl)fileGetResult).fetchDataAndReleaseBufferRef());
            return resultList;
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n) {
        return this.searchAfter(key, inclusive, n, k -> true);
    }

    @Override
    public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n, final Predicate<String> predicate) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.metaS_lock(() -> {
            final long maxSearchVcc = this.vcc.get();
            ArrayList<FileIOProxy> localIOProxyList = this.cloneFileRefAsLocal();
            int size = localIOProxyList.size();
            FileIOProxy lastFileIOProxy = (FileIOProxy)localIOProxyList.get(size - 1);
            ArrayList<FileIO.FileGetResult> fileGetResultList = new ArrayList<FileIO.FileGetResult>(n * size);
            for (int i = 0; i < size; ++i) {
                FileIOProxy fileIOProxy = (FileIOProxy)localIOProxyList.get(i);
                final List<FileIOProxy> topLayList = i == size - 1 ? Collections.singletonList(lastFileIOProxy) : localIOProxyList.subList(i + 1, size);
                Supplier<List> supplier = () -> fileIOProxy.searchBefore0(key, inclusive, n, false, new SimpleFileIO.DataValidChecker(){

                    @Override
                    public boolean dataIsValid(FileIO.FileGetResult fileGetResult) {
                        return !((SimpleFileIO.FileGetResultImpl)fileGetResult).deleted() && maxSearchVcc >= fileGetResult.vcc() && LayeredFileIO.this.dataIsNewest(fileGetResult, topLayList, true) && predicate.test(fileGetResult.key());
                    }
                });
                List list = supplier.get();
                fileGetResultList.addAll(list);
            }
            fileGetResultList.sort(Comparator.comparing(FileIO.FileGetResult::key).reversed());
            List resultList = fileGetResultList.subList(0, Math.min(fileGetResultList.size(), n));
            resultList.forEach(fileGetResult -> ((SimpleFileIO.FileGetResultImpl)fileGetResult).fetchDataAndReleaseBufferRef());
            return resultList;
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    private ArrayList<FileIOProxy> cloneFileRefAsLocal() {
        return new ArrayList<FileIOProxy>(this.fileIOProxyList);
    }

    @Override
    public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n) {
        return this.searchBefore(key, inclusive, n, k -> true);
    }

    @Override
    public List<FileIO.FileGetResult> top(int n) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.searchAfter(null, true, n);
    }

    @Override
    public List<FileIO.FileGetResult> tail(int n) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.searchBefore(null, true, n);
    }

    @Override
    public int rowCountIncludeInvalidData() {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.metaS_lock(() -> {
            int sum = 0;
            ArrayList<FileIOProxy> localIOProxyList = this.cloneFileRefAsLocal();
            int size = localIOProxyList.size();
            for (int i = 0; i < size; ++i) {
                sum += localIOProxyList.get(i).rowCountIncludeInvalidData();
            }
            return sum;
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public int count() {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.metaS_lock(() -> {
            AtomicInteger c = new AtomicInteger();
            long maxSearchVcc = this.vcc.get();
            FileIO.SearchListener proxy = (fileGetResult, searchContext) -> {
                if (maxSearchVcc < fileGetResult.vcc() || ((SimpleFileIO.FileGetResultImpl)fileGetResult).deleted()) {
                    return;
                }
                SimpleFileIO.SearchContextImpl context = (SimpleFileIO.SearchContextImpl)searchContext;
                boolean f = this.dataIsNewest(fileGetResult, context.topLayList, true);
                if (f) {
                    c.incrementAndGet();
                }
            };
            this.search0(proxy, false);
            return c.get();
        }, LOCK_TIMEOUT_SEC, TimeUnit.SECONDS);
    }

    @Override
    public void close() throws Exception {
        this.dataX_metaX_lock(() -> {
            this.closed.set(true);
            Exception exception = null;
            for (FileIOProxy fileIOProxy : this.fileIOProxyList) {
                try {
                    fileIOProxy.close();
                }
                catch (Exception e) {
                    exception = e;
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            try {
                this.writeLockFileLock.close();
            }
            catch (IOException e) {
                exception = e;
                log.error(e.getMessage(), (Throwable)e);
            }
            try {
                this.writeLockFileChannel.close();
            }
            catch (IOException e) {
                exception = e;
                log.error(e.getMessage(), (Throwable)e);
            }
            if (exception != null) {
                throw Util.convert2RuntimeException(exception);
            }
            return null;
        }, Integer.MAX_VALUE, TimeUnit.SECONDS);
    }

    @Override
    public FileIO.DiskFileStat diskFileStat() {
        return new FileIO.DiskFileStat(){

            @Override
            public FileIO.FileStat fileStat() {
                FileIO.FileStat fileStat = new FileIO.FileStat();
                File baseF = new File(LayeredFileIO.this.basePath);
                long sumByteSize = 0L;
                long sumValidByteSize = 0L;
                for (File f : baseF.listFiles()) {
                    boolean valid;
                    FileIO.FileStat.File file = new FileIO.FileStat.File();
                    file.setName(f.getName());
                    file.setLastModifiedTimeMs(f.lastModified());
                    boolean bl = valid = LayeredFileIO.WRITE_LOCK.equals(f.getName()) || LayeredFileIO.MF_IOM.equals(f.getName()) || LayeredFileIO.MF_IOS.equals(f.getName());
                    if (!valid) {
                        boolean found = false;
                        for (FileIOProxy fileIOProxy : LayeredFileIO.this.fileIOProxyList) {
                            File sf = new File(fileIOProxy.filePath());
                            if (!sf.getName().equals(f.getName())) continue;
                            found = true;
                            break;
                        }
                        if (found) {
                            valid = true;
                        }
                    }
                    file.setValid(valid);
                    file.setByteSize(f.length());
                    if (file.isValid()) {
                        sumValidByteSize += file.getByteSize();
                    }
                    sumByteSize += file.getByteSize();
                    fileStat.fileList.add(file);
                }
                fileStat.setSumByteSize(sumByteSize);
                fileStat.setSumValidByteSize(sumValidByteSize);
                return fileStat;
            }

            @Override
            public void pretty(OutputStreamWriter outputStreamWriter) {
                try {
                    FileIO.FileStat fileStat = this.fileStat();
                    outputStreamWriter.write("basePath: " + LayeredFileIO.this.basePath);
                    outputStreamWriter.write("\r\nsumByteSize: " + fileStat.getSumValidByteSize() + "/" + fileStat.getSumByteSize() + " (" + (fileStat.getSumValidByteSize() - fileStat.getSumByteSize()) + ")");
                    for (FileIO.FileStat.File file : fileStat.fileList) {
                        outputStreamWriter.write("\r\n\t" + (file.isValid() ? " - " : " x ") + file.getName() + "," + file.getByteSize() + "," + file.getLastModifiedTimeMs() + "(" + Util.formatTime(Util.dateTime(file.getLastModifiedTimeMs()), new String[0]) + "),valid?: " + file.isValid());
                    }
                }
                catch (IOException e) {
                    throw Util.convert2RuntimeException(e);
                }
            }
        };
    }

    @Override
    @OnlyTest
    @OnlyPrivate
    public void merge() {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        log.warn("should not call this function , are you sure???");
        if (this.merging.compareAndSet(false, true)) {
            try {
                log.info("merge2One, ready merging");
                this.merge0("Force2One");
            }
            finally {
                log.info("merge2One, reset merging flag > false");
                this.merging.set(false);
            }
        }
    }

    private void merge0(String mergeStrategy) {
        MergeFileSelected fileSelected = null;
        if ("FromFirst".endsWith(mergeStrategy)) {
            FromFirstFileSelect fromFirstFileSelect = new FromFirstFileSelect();
            fileSelected = fromFirstFileSelect.select();
        } else if ("FromFirstAndLessThanRow".endsWith(mergeStrategy)) {
            FromFirstAndLessThanRowSelect fromFirstAndLessThanRowSelect = new FromFirstAndLessThanRowSelect();
            fileSelected = fromFirstAndLessThanRowSelect.select();
        } else if ("Force2One".endsWith(mergeStrategy)) {
            Force2OneSelect force2OneSelect = new Force2OneSelect();
            fileSelected = force2OneSelect.select();
        }
        if (fileSelected == null) {
            return;
        }
        boolean deleteDeletedMarkRow = fileSelected.isDeleteDeletedMarkRow();
        final List<FileIOProxy> mergedFileList = fileSelected.getMergedFileList();
        List<FileIOProxy> topLayFileList = fileSelected.getTopLayFileList();
        final FileIOProxy mergedFileIOProxy = this.doMerge(mergedFileList, topLayFileList, deleteDeletedMarkRow);
        Meta meta = this.metaX_lock(new DoInLock<Meta>(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public Meta doInLock() {
                if (LayeredFileIO.this.closed.get()) {
                    throw DBOpeException.from("ignore the error,normal closed,break merge flow");
                }
                Meta meta = LayeredFileIO.this.readMeta();
                ArrayList mergedFileNameList = new ArrayList();
                ArrayList mergedFileNameHistory = new ArrayList();
                meta.fileInfoList.removeIf(fileInfo -> {
                    for (FileIOProxy mergedFileIOProxy2 : mergedFileList) {
                        if (mergedFileIOProxy2.getFileIndex() != fileInfo.fileIndex) continue;
                        if (fileInfo.merged) {
                            mergedFileNameHistory.addAll(Arrays.asList(((FileInfo)fileInfo).mergedFileHistory.split(",")));
                            mergedFileNameHistory.addAll(Arrays.asList(((FileInfo)fileInfo).mergedFileList.split(",")));
                        }
                        mergedFileNameList.add(fileInfo.fileName);
                        return true;
                    }
                    return false;
                });
                FileInfo fileInfo2 = new FileInfo();
                fileInfo2.setFileIndex(mergedFileIOProxy.fileIndex);
                fileInfo2.setFileName(new File(mergedFileIOProxy.filePath()).getName());
                fileInfo2.setRowCountIncludeInvalidData(mergedFileIOProxy.rowCountIncludeInvalidData());
                fileInfo2.setMerged(true);
                fileInfo2.setSorted(true);
                fileInfo2.setFirstKeyIncludeInvalidData(mergedFileIOProxy.firstIncludeInvalidData().key());
                fileInfo2.setLastKeyIncludeInvalidData(mergedFileIOProxy.lastIncludeInvalidData().key());
                fileInfo2.setMergedFileList(mergedFileNameList.stream().distinct().filter(Util::isNotEmpty).sorted(Comparator.comparing(o -> Integer.valueOf(o.split("-")[1]))).collect(Collectors.joining(",")));
                List list = mergedFileNameHistory.stream().distinct().filter(Util::isNotEmpty).sorted(Comparator.comparing(o -> Integer.valueOf(o.split("-")[1]))).collect(Collectors.toList());
                fileInfo2.setMergedFileHistory(String.join((CharSequence)",", list.subList(Math.max(0, list.size() - 100), list.size())));
                meta.fileInfoList.add(fileInfo2);
                meta.fileInfoList.sort(Comparator.comparing(FileInfo::getFileIndex));
                LayeredFileIO.this.writeMeta(meta);
                ArrayList loadedFileIOProxyList = LayeredFileIO.this.cloneFileRefAsLocal();
                ArrayList<FileIOProxy> fpList = new ArrayList<FileIOProxy>(meta.fileInfoList.size());
                for (FileInfo f : meta.fileInfoList) {
                    if (fileInfo2.fileIndex == f.fileIndex) continue;
                    FileIOProxy found = null;
                    for (FileIOProxy loadedProxy : loadedFileIOProxyList) {
                        if (f.fileIndex != loadedProxy.fileIndex) continue;
                        found = loadedProxy;
                        break;
                    }
                    if (found == null) {
                        throw DBOpeException.from("file(" + f.fileIndex + ") not loaded, ???");
                    }
                    fpList.add(found);
                }
                fpList.add(mergedFileIOProxy);
                fpList.sort(Comparator.comparing(FileIOProxy::getFileIndex));
                List list2 = LayeredFileIO.this.fileIOProxyList;
                synchronized (list2) {
                    LayeredFileIO.this.fileIOProxyList.clear();
                    LayeredFileIO.this.fileIOProxyList.addAll(fpList);
                }
                return meta;
            }
        }, Integer.MAX_VALUE, TimeUnit.SECONDS);
        for (final FileIOProxy merged : mergedFileList) {
            this.dataX_lock(new DoInLock<Void>(){

                @Override
                public Void doInLock() {
                    Exception exception = null;
                    try {
                        merged.close();
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        exception = e;
                    }
                    try {
                        LayeredFileIO.this.memoryBuffer.removeAllBuffer(merged.filePath());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                        exception = e;
                    }
                    if (exception != null) {
                        throw DBOpeException.from(exception);
                    }
                    return null;
                }
            }, Integer.MAX_VALUE, TimeUnit.SECONDS);
            try {
                Path path = Files.move(new File(merged.filePath()).toPath(), new File(merged.filePath() + ".deleted").toPath(), StandardCopyOption.REPLACE_EXISTING);
                boolean f = Files.deleteIfExists(path);
                log.info(merged.filePath() + " move to : " + path + " ( deleted: " + f + ")");
            }
            catch (IOException e) {
                log.error(e.getMessage(), (Throwable)e);
                throw DBOpeException.from(e);
            }
        }
        log.debug("print loaded file, start > ");
        StringBuilder stringBuilder = new StringBuilder();
        for (FileInfo fileInfo : meta.fileInfoList) {
            stringBuilder.append(fileInfo.fileName + ",");
        }
        log.debug("loaded file: " + stringBuilder.toString());
        log.info("merged completely , fm: " + JSONAccessor.impl().format(meta));
    }

    private FileIOProxy doMerge(List<FileIOProxy> mergedFileList, List<FileIOProxy> topLayFileList, final boolean deleteDeletedMarkRow) {
        SimpleFileIO.Conf tempConf = new SimpleFileIO.Conf();
        tempConf.setCompressed(this.compressed);
        tempConf.setWalDiskSizeMb(4096L);
        tempConf.setWalBufferSizeMb(10);
        mergedFileList.sort(Comparator.comparing(FileIOProxy::getFileIndex));
        for (FileIOProxy fileIOProxy : mergedFileList) {
            log.info("merge file: " + fileIOProxy.filePath() + ": " + fileIOProxy.rowCountIncludeInvalidData());
        }
        int sum = mergedFileList.stream().mapToInt(FileIOProxy::rowCountIncludeInvalidData).sum();
        final ArrayList<MergingRef> mergingRefList = new ArrayList<MergingRef>(sum);
        for (int i = 0; i < mergedFileList.size(); ++i) {
            final FileIOProxy fileIOProxy = mergedFileList.get(i);
            long start = System.currentTimeMillis();
            List<FileIOProxy> mergedTopLay = mergedFileList.subList(i + 1, mergedFileList.size());
            ArrayList<FileIOProxy> topLayList = new ArrayList<FileIOProxy>(mergedTopLay.size() + topLayFileList.size());
            topLayList.addAll(topLayFileList);
            topLayList.addAll(mergedTopLay);
            SimpleFileIO.SearchContextImpl sc = new SimpleFileIO.SearchContextImpl();
            sc.setTopLayList(topLayList);
            fileIOProxy.search0(new FileIO.SearchListener(){

                @Override
                public void onRow(FileIO.FileGetResult fileGetResult, FileIO.SearchContext searchContext) {
                    boolean f = LayeredFileIO.this.dataIsNewest(fileGetResult, ((SimpleFileIO.SearchContextImpl)searchContext).getTopLayList(), false);
                    if (f) {
                        SimpleFileIO.FileGetResultImpl result;
                        if (deleteDeletedMarkRow && (result = (SimpleFileIO.FileGetResultImpl)fileGetResult).deleted()) {
                            return;
                        }
                        MergingRef mergingRef = new MergingRef(fileGetResult.key(), fileGetResult.vcc(), fileIOProxy);
                        mergingRefList.add(mergingRef);
                    }
                }
            }, sc, false, true);
            log.info("merge, scan merged file(" + (i + 1) + "/" + mergedFileList.size() + ":" + fileIOProxy.rowCountIncludeInvalidData() + "): " + fileIOProxy.filePath() + ", cost: " + Util.costTime(start));
        }
        int fi = mergedFileList.get(mergedFileList.size() - 1).getFileIndex();
        String fileName = Util.uniqueFirstPart() + "-" + fi;
        String filePath = this.basePath + "/" + fileName;
        SimpleFileIO.Conf sortedConf = new SimpleFileIO.Conf();
        sortedConf.setCompressed(this.compressed);
        sortedConf.setWalDiskSizeMb(4096L);
        sortedConf.setWalBufferSizeMb(10);
        sortedConf.setSorted(true);
        sortedConf.setSparse(mergingRefList.size() > this.sparseIfMinCount);
        sortedConf.setRowRegion(100);
        SimpleFileIO sortedSimpleFileIO = new SimpleFileIO(fileName, filePath, sortedConf, false, true, true, new SimpleFileIO.VccGenerator(){

            @Override
            public long next() {
                throw new UnsupportedOperationException();
            }
        }, this.memoryBuffer);
        log.info("merge, create new sorted file: " + sortedSimpleFileIO.filePath);
        if (Util.isEmpty(mergingRefList)) {
            sortedSimpleFileIO.commitAndFsync(true, true);
            log.info("merge, empty, new file merged: " + filePath + ": " + sortedSimpleFileIO.rowCountIncludeInvalidData());
            return new FileIOProxy(sortedSimpleFileIO, fi);
        }
        SimpleFileIO.FileGetResultImpl lastFileGetResult = null;
        long start = System.currentTimeMillis();
        log.info("merge , to sort key list: " + mergingRefList.size());
        mergingRefList.sort(Comparator.comparing(o -> o.key));
        log.info("merge , sort key list completed,cost: " + Util.costTime(start));
        start = System.currentTimeMillis();
        int size = mergingRefList.size();
        for (int i = 0; i < size; ++i) {
            MergingRef mergingRef = (MergingRef)mergingRefList.get(i);
            SimpleFileIO.FileGetResultImpl fileGetResult = mergingRef.fileIOProxy.get0(mergingRef.key, false);
            if (fileGetResult == null || fileGetResult.vcc() != mergingRef.vcc) {
                throw DBOpeException.from("error vcc: " + mergingRef.vcc + " <> " + (fileGetResult == null ? -1L : fileGetResult.vcc));
            }
            if (i < size - 1) {
                sortedSimpleFileIO.put0(fileGetResult.deleted(), fileGetResult.key(), fileGetResult.meta(), fileGetResult.byteBuffer, fileGetResult.vcc());
                continue;
            }
            lastFileGetResult = fileGetResult;
        }
        sortedSimpleFileIO.commitAndFsync(false, false);
        sortedSimpleFileIO.put0(lastFileGetResult.deleted(), lastFileGetResult.key(), lastFileGetResult.meta(), lastFileGetResult.byteBuffer, lastFileGetResult.vcc());
        sortedSimpleFileIO.commitAndFsync(true, true);
        log.info("merge, new file merged: " + filePath + ": " + sortedSimpleFileIO.rowCountIncludeInvalidData() + ",cost: " + Util.costTime(start));
        return new FileIOProxy(sortedSimpleFileIO, fi);
    }

    Meta readMeta() {
        try {
            File file = new File(this.basePath + "/" + MF_IOM);
            byte[] bytes = Util.read(file);
            return JSONAccessor.impl().read(bytes, Meta.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw DBOpeException.from(e);
        }
    }

    void writeMeta(Meta meta) {
        try {
            File file = new File(this.basePath + "/" + MF_IOM);
            String s = JSONAccessor.impl().format(meta);
            Util.writeAtomic(file, Util.utf8(s));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw DBOpeException.from(e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private <T> T dataX_metaX_lock(DoInLock<T> doInLock, long time, TimeUnit unit) {
        try (ReleasableLock metaSLock = this.dataXLock.acquire(time, unit);){
            T t;
            block16: {
                if (metaSLock == null) {
                    throw new TimeoutException("dataXLock timeout: " + unit.toSeconds(time));
                }
                ReleasableLock dataXLock = this.metaXLock.acquire(time, unit);
                try {
                    if (dataXLock == null) {
                        throw new TimeoutException("metaXLock timeout: " + unit.toSeconds(time));
                    }
                    t = doInLock.doInLock();
                    if (dataXLock == null) break block16;
                }
                catch (Throwable throwable) {
                    if (dataXLock != null) {
                        try {
                            dataXLock.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                dataXLock.close();
            }
            return t;
        }
        catch (Exception e) {
            throw DBOpeException.from(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T metaX_lock(DoInLock<T> doInLock, long time, TimeUnit unit) {
        try (ReleasableLock metaXLock = this.metaXLock.acquire(time, unit);){
            if (metaXLock == null) {
                throw new TimeoutException("metaXLock timeout: " + unit.toSeconds(time));
            }
            T t = doInLock.doInLock();
            return t;
        }
        catch (Exception e) {
            throw DBOpeException.from(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T metaS_lock(DoInLock<T> doInLock, long time, TimeUnit unit) {
        try (ReleasableLock metaSLock = this.metaSLock.acquire(time, unit);){
            if (metaSLock == null) {
                throw new TimeoutException("metaSLock timeout: " + unit.toSeconds(time));
            }
            T t = doInLock.doInLock();
            return t;
        }
        catch (Exception e) {
            throw DBOpeException.from(e);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private <T> T dataX_lock(DoInLock<T> doInLock, long time, TimeUnit unit) {
        try (ReleasableLock dataXLock = this.dataXLock.acquire(time, unit);){
            if (dataXLock == null) {
                throw new TimeoutException("dataXLock timeout: " + unit.toSeconds(time));
            }
            T t = doInLock.doInLock();
            return t;
        }
        catch (Exception e) {
            throw DBOpeException.from(e);
        }
    }

    private void ensureWriteLock() throws Exception {
        block5: {
            FileLock lock = null;
            try {
                FileChannel channel = FileChannel.open(Paths.get(this.basePath + "/" + WRITE_LOCK, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                lock = channel.tryLock();
                if (lock != null) {
                    log.debug("got lock: " + this.basePath + "/" + WRITE_LOCK);
                    this.writeLockFileLock = lock;
                    this.writeLockFileChannel = channel;
                    break block5;
                }
                log.error("Lock held by another program: " + this.basePath + "/" + WRITE_LOCK);
                throw DBOpeException.from("Lock held by another program: " + this.basePath + "/" + WRITE_LOCK);
            }
            finally {
                if (lock == null) {
                    throw DBOpeException.from("cannot obtain lock , " + this.basePath + ",path: " + this.basePath);
                }
            }
        }
    }

    SnapshotImpl snapshot(long waitTimeSec) {
        long startTime = System.currentTimeMillis();
        while (!this.merging.compareAndSet(false, true)) {
            if (System.currentTimeMillis() - startTime > waitTimeSec * 1000L) {
                return null;
            }
            try {
                TimeUnit.SECONDS.sleep(1L);
            }
            catch (InterruptedException e) {
                throw Util.convert2RuntimeException(e);
            }
        }
        try {
            log.info("got merge lock , to create snapshot: " + this.basePath);
            SnapshotImpl snapshot = this.dataX_lock(() -> {
                LayeredFileIO cloned;
                log.info("get dataX lock, to create snapshot");
                FileIOProxy writableFileProxy = this.writableFileIOProxy;
                writableFileProxy.commitAndFsync(true, false);
                this.createAndRefreshFile(writableFileProxy);
                try {
                    cloned = (LayeredFileIO)this.clone();
                }
                catch (CloneNotSupportedException e) {
                    throw Util.convert2RuntimeException(e);
                }
                List<FileIOProxy> ioProxyList = this.fileIOProxyList.subList(0, this.fileIOProxyList.size() - 1);
                ArrayList<FileIOProxy> ioProxySnapshotList = new ArrayList<FileIOProxy>(ioProxyList.size());
                try {
                    for (FileIOProxy fileIOProxy2 : ioProxyList) {
                        FileIOProxy proxySnapshot = fileIOProxy2.snapshot();
                        ioProxySnapshotList.add(proxySnapshot);
                    }
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    for (FileIOProxy fileIOProxy3 : ioProxySnapshotList) {
                        try {
                            fileIOProxy3.releaseSnapshot();
                        }
                        catch (Exception ex) {
                            log.error(e.getMessage(), (Throwable)e);
                        }
                    }
                    throw Util.convert2RuntimeException(e);
                }
                try {
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("fileIOProxyList"), ioProxySnapshotList);
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("writableFileIOProxy"), null);
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("fileIndex"), (Object)new AtomicInteger(cloned.fileIndex.get()));
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("vcc"), (Object)new AtomicLong(cloned.vcc.get()));
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("autoIncrementKeyGenerator"), (Object)new UnsupportedAutoIncrementKeyGenerator());
                    ReentrantReadWriteLock metaReadWriteLock = new ReentrantReadWriteLock();
                    ReleasableLock metaSLock = new ReleasableLock(metaReadWriteLock.readLock());
                    ReleasableLock metaXLock = new ReleasableLock(metaReadWriteLock.writeLock());
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("metaReadWriteLock"), (Object)metaReadWriteLock);
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("metaSLock"), (Object)metaSLock);
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("metaXLock"), (Object)metaXLock);
                    ReentrantReadWriteLock dataReadWriteLock = new ReentrantReadWriteLock();
                    ReleasableLock dataSLock = new ReleasableLock(dataReadWriteLock.readLock());
                    ReleasableLock dataXLock = new ReleasableLock(dataReadWriteLock.writeLock());
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("dataReadWriteLock"), (Object)dataReadWriteLock);
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("dataSLock"), (Object)dataSLock);
                    LayeredFileIO.setVal(cloned, LayeredFileIO.class.getDeclaredField("dataXLock"), (Object)dataXLock);
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw Util.convert2RuntimeException(e);
                }
                String id = Util.uniqueFirstPart();
                SnapshotImpl sp = new SnapshotImpl(cloned, id, this);
                SnapshotInfo snapshotInfo = new SnapshotInfo(id, ioProxyList.stream().map(fileIOProxy -> fileIOProxy.fileName()).collect(Collectors.toList()), sp);
                snapshotTtl.putIfAbsentAndGet("snapshot:" + id, s -> snapshotInfo, 60L, TimeUnit.MINUTES);
                return sp;
            }, waitTimeSec, TimeUnit.SECONDS);
            log.info(snapshot.id + ", created snapshot: " + this.basePath);
            return snapshot;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            this.merging.compareAndSet(true, false);
            throw Util.convert2RuntimeException(e);
        }
    }

    private static void setVal(LayeredFileIO layeredFileIO, Field field, Object newVal) throws Exception {
        field.setAccessible(true);
        field.set(layeredFileIO, newVal);
    }

    private static void setVal(FileIOProxy fileIOProxy, Field field, Object newVal) throws Exception {
        field.setAccessible(true);
        field.set(fileIOProxy, newVal);
    }

    static {
        snapshotTtl.subscribeTtl(k -> true, (getResult, startMillis, expiredMillis) -> {
            Object v = getResult.value();
            if (v instanceof SnapshotInfo) {
                SnapshotImpl snapshot = ((SnapshotInfo)v).snapshot;
                snapshot.closed = true;
                boolean f = snapshot.source.merging.compareAndSet(true, false);
                log.info((String)getResult.key() + ", release merge lock: " + f + ", " + snapshot.snapshot.basePath);
            }
            log.info("expired: " + (String)getResult.key());
        });
    }

    static class FileIOProxy
    implements Cloneable {
        private final SimpleFileIO fileIO;
        final int fileIndex;
        final AtomicBoolean writable = new AtomicBoolean(false);
        private final ReentrantReadWriteLock writableFileLock = new ReentrantReadWriteLock();
        private final ReleasableLock writableFileSLock = new ReleasableLock(this.writableFileLock.readLock());
        private final ReleasableLock writableFileXLock = new ReleasableLock(this.writableFileLock.writeLock());

        public FileIOProxy(SimpleFileIO fileIO, int fileIndex) {
            this.fileIO = fileIO;
            this.fileIndex = fileIndex;
        }

        FileIOProxy snapshot() {
            FileIOProxy cloned;
            try {
                cloned = (FileIOProxy)this.clone();
            }
            catch (CloneNotSupportedException e) {
                throw Util.convert2RuntimeException(e);
            }
            SimpleFileIO simpleFileIO = this.fileIO.snapshot();
            try {
                LayeredFileIO.setVal(cloned, FileIOProxy.class.getDeclaredField("fileIO"), simpleFileIO);
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw Util.convert2RuntimeException(e);
            }
            return cloned;
        }

        public void releaseSnapshot() {
            if (this.fileIO != null) {
                this.fileIO.releaseSnapshot();
            }
        }

        SimpleFileIO.FileGetResultImpl get0(String key) {
            return this.fileIO.get0(key);
        }

        SimpleFileIO.FileGetResultImpl get0(String key, boolean checkDeletedByHighLayer) {
            return this.fileIO.get0(key, checkDeletedByHighLayer);
        }

        SimpleFileIO.BinReader.BinMetaGet getBinMetaGet0(String key, boolean fetchMemory, boolean checkDeletedByHighLayer) {
            return this.fileIO.getBinMetaGet0(key, fetchMemory, checkDeletedByHighLayer);
        }

        void search0(FileIO.SearchListener searchListener, SimpleFileIO.SearchContextImpl searchContext, boolean checkDiskAtMemory, boolean fetchData) {
            block9: {
                if (this.writable.get()) {
                    try (ReleasableLock dataSLock = this.writableFileSLock.acquire();){
                        this.fileIO.search0(searchListener, searchContext, checkDiskAtMemory, fetchData);
                        break block9;
                    }
                    catch (Exception e) {
                        throw DBOpeException.from(e);
                    }
                }
                this.fileIO.search0(searchListener, searchContext, checkDiskAtMemory, fetchData);
            }
        }

        List<FileIO.FileGetResult> searchAfter0(String key, boolean inclusive, int n, boolean checkMemory, SimpleFileIO.DataValidChecker dataValidChecker) {
            if (this.writable.get()) {
                List<FileIO.FileGetResult> list;
                block9: {
                    ReleasableLock dataSLock = this.writableFileSLock.acquire();
                    try {
                        list = this.fileIO.searchAfter0(key, inclusive, n, checkMemory, dataValidChecker);
                        if (dataSLock == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (dataSLock != null) {
                                try {
                                    dataSLock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw DBOpeException.from(e);
                        }
                    }
                    dataSLock.close();
                }
                return list;
            }
            return this.fileIO.searchAfter0(key, inclusive, n, checkMemory, dataValidChecker);
        }

        List<FileIO.FileGetResult> searchBefore0(String key, boolean inclusive, int n, boolean checkMemory, SimpleFileIO.DataValidChecker dataValidChecker) {
            if (this.writable.get()) {
                List<FileIO.FileGetResult> list;
                block9: {
                    ReleasableLock dataSLock = this.writableFileSLock.acquire();
                    try {
                        list = this.fileIO.searchBefore0(key, inclusive, n, checkMemory, dataValidChecker);
                        if (dataSLock == null) break block9;
                    }
                    catch (Throwable throwable) {
                        try {
                            if (dataSLock != null) {
                                try {
                                    dataSLock.close();
                                }
                                catch (Throwable throwable2) {
                                    throwable.addSuppressed(throwable2);
                                }
                            }
                            throw throwable;
                        }
                        catch (Exception e) {
                            throw DBOpeException.from(e);
                        }
                    }
                    dataSLock.close();
                }
                return list;
            }
            return this.fileIO.searchBefore0(key, inclusive, n, checkMemory, dataValidChecker);
        }

        FileIO.FilePutResult put0(boolean deleted, String key, Map<String, Object> meta, byte[] data, long vccPreDef) {
            SimpleFileIO.FilePutResultImpl filePutResultImpl;
            block8: {
                ReleasableLock dataXLock = this.writableFileXLock.acquire();
                try {
                    filePutResultImpl = this.fileIO.put0(deleted, key, meta, data, vccPreDef);
                    if (dataXLock == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (dataXLock != null) {
                            try {
                                dataXLock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw DBOpeException.from(e);
                    }
                }
                dataXLock.close();
            }
            return filePutResultImpl;
        }

        SimpleFileIO.FileDeleteResultImpl delete0(String key) {
            SimpleFileIO.FileDeleteResultImpl fileDeleteResultImpl;
            block8: {
                ReleasableLock dataXLock = this.writableFileXLock.acquire();
                try {
                    fileDeleteResultImpl = this.fileIO.delete0(key);
                    if (dataXLock == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (dataXLock != null) {
                            try {
                                dataXLock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw DBOpeException.from(e);
                    }
                }
                dataXLock.close();
            }
            return fileDeleteResultImpl;
        }

        long commitAndFsync(boolean closeWrite, boolean postSparse) {
            long l;
            block8: {
                ReleasableLock dataXLock = this.writableFileXLock.acquire();
                try {
                    l = this.fileIO.commitAndFsync(closeWrite, postSparse);
                    if (dataXLock == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (dataXLock != null) {
                            try {
                                dataXLock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw DBOpeException.from(e);
                    }
                }
                dataXLock.close();
            }
            return l;
        }

        long commitAndFsync(boolean closeWrite, boolean disableSharedByteBuffer, boolean postSparse) {
            long l;
            block8: {
                ReleasableLock dataXLock = this.writableFileXLock.acquire();
                try {
                    l = this.fileIO.commitAndFsync(closeWrite, disableSharedByteBuffer, postSparse);
                    if (dataXLock == null) break block8;
                }
                catch (Throwable throwable) {
                    try {
                        if (dataXLock != null) {
                            try {
                                dataXLock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (Exception e) {
                        throw DBOpeException.from(e);
                    }
                }
                dataXLock.close();
            }
            return l;
        }

        boolean isClosed() {
            return this.fileIO.isClosed();
        }

        long freeSize() {
            return this.fileIO.freeSize();
        }

        String filePath() {
            return this.fileIO.getFilePath();
        }

        String fileName() {
            return this.fileIO.fileName;
        }

        FileIO.FileGetResult firstIncludeInvalidData() {
            return this.fileIO.firstIncludeInvalidData();
        }

        FileIO.FileGetResult lastIncludeInvalidData() {
            return this.fileIO.lastIncludeInvalidData();
        }

        SimpleFileIO.MemoryBufferStat memoryBufferStat() {
            return this.fileIO.memoryBufferStat();
        }

        public int rowCountIncludeInvalidData() {
            return this.fileIO.rowCountIncludeInvalidData();
        }

        public void close() throws Exception {
            this.fileIO.close();
        }

        public int getFileIndex() {
            return this.fileIndex;
        }
    }

    static interface AutoIncrementKeyGenerator {
        public long next();

        public long get();

        public long updateAndGet(LongUnaryOperator var1);
    }

    public static class Conf
    extends SimpleFileIO.Conf
    implements Model {
        private boolean autoIncrement;
        private boolean onlySupportInsert;
        private boolean merged = true;
        private boolean flushPeriod = true;
        private String mergeStrategy = "FromFirstAndLessThanRow";
        private int skipMergeIfMaxRowCount = 1000000;
        private int forceMergeIfMaxSkipCount = 2;
        private int keepMaxFileCount = 2;
        private int sparseIfMinCount = 1000000;

        public static Conf defaultConf() {
            Conf conf = new Conf();
            conf.setCompressed(true);
            return conf;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public boolean isOnlySupportInsert() {
            return this.onlySupportInsert;
        }

        public boolean isMerged() {
            return this.merged;
        }

        public boolean isFlushPeriod() {
            return this.flushPeriod;
        }

        public String getMergeStrategy() {
            return this.mergeStrategy;
        }

        public int getSkipMergeIfMaxRowCount() {
            return this.skipMergeIfMaxRowCount;
        }

        public int getForceMergeIfMaxSkipCount() {
            return this.forceMergeIfMaxSkipCount;
        }

        public int getKeepMaxFileCount() {
            return this.keepMaxFileCount;
        }

        public int getSparseIfMinCount() {
            return this.sparseIfMinCount;
        }

        public void setAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
        }

        public void setOnlySupportInsert(boolean onlySupportInsert) {
            this.onlySupportInsert = onlySupportInsert;
        }

        public void setMerged(boolean merged) {
            this.merged = merged;
        }

        public void setFlushPeriod(boolean flushPeriod) {
            this.flushPeriod = flushPeriod;
        }

        public void setMergeStrategy(String mergeStrategy) {
            this.mergeStrategy = mergeStrategy;
        }

        public void setSkipMergeIfMaxRowCount(int skipMergeIfMaxRowCount) {
            this.skipMergeIfMaxRowCount = skipMergeIfMaxRowCount;
        }

        public void setForceMergeIfMaxSkipCount(int forceMergeIfMaxSkipCount) {
            this.forceMergeIfMaxSkipCount = forceMergeIfMaxSkipCount;
        }

        public void setKeepMaxFileCount(int keepMaxFileCount) {
            this.keepMaxFileCount = keepMaxFileCount;
        }

        public void setSparseIfMinCount(int sparseIfMinCount) {
            this.sparseIfMinCount = sparseIfMinCount;
        }

        @Override
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conf)) {
                return false;
            }
            Conf other = (Conf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isAutoIncrement() != other.isAutoIncrement()) {
                return false;
            }
            if (this.isOnlySupportInsert() != other.isOnlySupportInsert()) {
                return false;
            }
            if (this.isMerged() != other.isMerged()) {
                return false;
            }
            if (this.isFlushPeriod() != other.isFlushPeriod()) {
                return false;
            }
            if (this.getSkipMergeIfMaxRowCount() != other.getSkipMergeIfMaxRowCount()) {
                return false;
            }
            if (this.getForceMergeIfMaxSkipCount() != other.getForceMergeIfMaxSkipCount()) {
                return false;
            }
            if (this.getKeepMaxFileCount() != other.getKeepMaxFileCount()) {
                return false;
            }
            if (this.getSparseIfMinCount() != other.getSparseIfMinCount()) {
                return false;
            }
            String this$mergeStrategy = this.getMergeStrategy();
            String other$mergeStrategy = other.getMergeStrategy();
            return !(this$mergeStrategy == null ? other$mergeStrategy != null : !this$mergeStrategy.equals(other$mergeStrategy));
        }

        @Override
        protected boolean canEqual(Object other) {
            return other instanceof Conf;
        }

        @Override
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
            result = result * 59 + (this.isOnlySupportInsert() ? 79 : 97);
            result = result * 59 + (this.isMerged() ? 79 : 97);
            result = result * 59 + (this.isFlushPeriod() ? 79 : 97);
            result = result * 59 + this.getSkipMergeIfMaxRowCount();
            result = result * 59 + this.getForceMergeIfMaxSkipCount();
            result = result * 59 + this.getKeepMaxFileCount();
            result = result * 59 + this.getSparseIfMinCount();
            String $mergeStrategy = this.getMergeStrategy();
            result = result * 59 + ($mergeStrategy == null ? 43 : $mergeStrategy.hashCode());
            return result;
        }

        @Override
        public String toString() {
            return "LayeredFileIO.Conf(autoIncrement=" + this.isAutoIncrement() + ", onlySupportInsert=" + this.isOnlySupportInsert() + ", merged=" + this.isMerged() + ", flushPeriod=" + this.isFlushPeriod() + ", mergeStrategy=" + this.getMergeStrategy() + ", skipMergeIfMaxRowCount=" + this.getSkipMergeIfMaxRowCount() + ", forceMergeIfMaxSkipCount=" + this.getForceMergeIfMaxSkipCount() + ", keepMaxFileCount=" + this.getKeepMaxFileCount() + ", sparseIfMinCount=" + this.getSparseIfMinCount() + ")";
        }
    }

    static final class AutoIncrementKeyGeneratorImpl
    implements AutoIncrementKeyGenerator {
        private final AtomicLong key;

        public AutoIncrementKeyGeneratorImpl(AtomicLong key) {
            this.key = key;
        }

        @Override
        public long next() {
            return this.key.incrementAndGet();
        }

        @Override
        public long get() {
            return this.key.get();
        }

        @Override
        public long updateAndGet(LongUnaryOperator updateFunction) {
            return this.key.updateAndGet(updateFunction);
        }
    }

    static class Meta
    implements Model {
        List<FileInfo> fileInfoList = new ArrayList<FileInfo>();
        private boolean compressed;
        private boolean onlySupportInsert;
        private boolean autoIncrement;
        private long mayMaxKey;

        public List<FileInfo> getFileInfoList() {
            return this.fileInfoList;
        }

        public boolean isCompressed() {
            return this.compressed;
        }

        public boolean isOnlySupportInsert() {
            return this.onlySupportInsert;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public long getMayMaxKey() {
            return this.mayMaxKey;
        }

        public void setFileInfoList(List<FileInfo> fileInfoList) {
            this.fileInfoList = fileInfoList;
        }

        public void setCompressed(boolean compressed) {
            this.compressed = compressed;
        }

        public void setOnlySupportInsert(boolean onlySupportInsert) {
            this.onlySupportInsert = onlySupportInsert;
        }

        public void setAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
        }

        public void setMayMaxKey(long mayMaxKey) {
            this.mayMaxKey = mayMaxKey;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Meta)) {
                return false;
            }
            Meta other = (Meta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isCompressed() != other.isCompressed()) {
                return false;
            }
            if (this.isOnlySupportInsert() != other.isOnlySupportInsert()) {
                return false;
            }
            if (this.isAutoIncrement() != other.isAutoIncrement()) {
                return false;
            }
            if (this.getMayMaxKey() != other.getMayMaxKey()) {
                return false;
            }
            List<FileInfo> this$fileInfoList = this.getFileInfoList();
            List<FileInfo> other$fileInfoList = other.getFileInfoList();
            return !(this$fileInfoList == null ? other$fileInfoList != null : !((Object)this$fileInfoList).equals(other$fileInfoList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Meta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isCompressed() ? 79 : 97);
            result = result * 59 + (this.isOnlySupportInsert() ? 79 : 97);
            result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
            long $mayMaxKey = this.getMayMaxKey();
            result = result * 59 + (int)($mayMaxKey >>> 32 ^ $mayMaxKey);
            List<FileInfo> $fileInfoList = this.getFileInfoList();
            result = result * 59 + ($fileInfoList == null ? 43 : ((Object)$fileInfoList).hashCode());
            return result;
        }

        public String toString() {
            return "LayeredFileIO.Meta(fileInfoList=" + this.getFileInfoList() + ", compressed=" + this.isCompressed() + ", onlySupportInsert=" + this.isOnlySupportInsert() + ", autoIncrement=" + this.isAutoIncrement() + ", mayMaxKey=" + this.getMayMaxKey() + ")";
        }
    }

    static class FileInfo
    implements Model {
        int fileIndex;
        long maxVcc;
        String fileName;
        int rowCountIncludeInvalidData;
        String firstKeyIncludeInvalidData;
        String lastKeyIncludeInvalidData;
        boolean sorted;
        boolean merged;
        private String mergedFileHistory;
        private String mergedFileList;

        public int getFileIndex() {
            return this.fileIndex;
        }

        public long getMaxVcc() {
            return this.maxVcc;
        }

        public String getFileName() {
            return this.fileName;
        }

        public int getRowCountIncludeInvalidData() {
            return this.rowCountIncludeInvalidData;
        }

        public String getFirstKeyIncludeInvalidData() {
            return this.firstKeyIncludeInvalidData;
        }

        public String getLastKeyIncludeInvalidData() {
            return this.lastKeyIncludeInvalidData;
        }

        public boolean isSorted() {
            return this.sorted;
        }

        public boolean isMerged() {
            return this.merged;
        }

        public String getMergedFileHistory() {
            return this.mergedFileHistory;
        }

        public String getMergedFileList() {
            return this.mergedFileList;
        }

        public void setFileIndex(int fileIndex) {
            this.fileIndex = fileIndex;
        }

        public void setMaxVcc(long maxVcc) {
            this.maxVcc = maxVcc;
        }

        public void setFileName(String fileName) {
            this.fileName = fileName;
        }

        public void setRowCountIncludeInvalidData(int rowCountIncludeInvalidData) {
            this.rowCountIncludeInvalidData = rowCountIncludeInvalidData;
        }

        public void setFirstKeyIncludeInvalidData(String firstKeyIncludeInvalidData) {
            this.firstKeyIncludeInvalidData = firstKeyIncludeInvalidData;
        }

        public void setLastKeyIncludeInvalidData(String lastKeyIncludeInvalidData) {
            this.lastKeyIncludeInvalidData = lastKeyIncludeInvalidData;
        }

        public void setSorted(boolean sorted) {
            this.sorted = sorted;
        }

        public void setMerged(boolean merged) {
            this.merged = merged;
        }

        public void setMergedFileHistory(String mergedFileHistory) {
            this.mergedFileHistory = mergedFileHistory;
        }

        public void setMergedFileList(String mergedFileList) {
            this.mergedFileList = mergedFileList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileInfo)) {
                return false;
            }
            FileInfo other = (FileInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getFileIndex() != other.getFileIndex()) {
                return false;
            }
            if (this.getMaxVcc() != other.getMaxVcc()) {
                return false;
            }
            if (this.getRowCountIncludeInvalidData() != other.getRowCountIncludeInvalidData()) {
                return false;
            }
            if (this.isSorted() != other.isSorted()) {
                return false;
            }
            if (this.isMerged() != other.isMerged()) {
                return false;
            }
            String this$fileName = this.getFileName();
            String other$fileName = other.getFileName();
            if (this$fileName == null ? other$fileName != null : !this$fileName.equals(other$fileName)) {
                return false;
            }
            String this$firstKeyIncludeInvalidData = this.getFirstKeyIncludeInvalidData();
            String other$firstKeyIncludeInvalidData = other.getFirstKeyIncludeInvalidData();
            if (this$firstKeyIncludeInvalidData == null ? other$firstKeyIncludeInvalidData != null : !this$firstKeyIncludeInvalidData.equals(other$firstKeyIncludeInvalidData)) {
                return false;
            }
            String this$lastKeyIncludeInvalidData = this.getLastKeyIncludeInvalidData();
            String other$lastKeyIncludeInvalidData = other.getLastKeyIncludeInvalidData();
            if (this$lastKeyIncludeInvalidData == null ? other$lastKeyIncludeInvalidData != null : !this$lastKeyIncludeInvalidData.equals(other$lastKeyIncludeInvalidData)) {
                return false;
            }
            String this$mergedFileHistory = this.getMergedFileHistory();
            String other$mergedFileHistory = other.getMergedFileHistory();
            if (this$mergedFileHistory == null ? other$mergedFileHistory != null : !this$mergedFileHistory.equals(other$mergedFileHistory)) {
                return false;
            }
            String this$mergedFileList = this.getMergedFileList();
            String other$mergedFileList = other.getMergedFileList();
            return !(this$mergedFileList == null ? other$mergedFileList != null : !this$mergedFileList.equals(other$mergedFileList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getFileIndex();
            long $maxVcc = this.getMaxVcc();
            result = result * 59 + (int)($maxVcc >>> 32 ^ $maxVcc);
            result = result * 59 + this.getRowCountIncludeInvalidData();
            result = result * 59 + (this.isSorted() ? 79 : 97);
            result = result * 59 + (this.isMerged() ? 79 : 97);
            String $fileName = this.getFileName();
            result = result * 59 + ($fileName == null ? 43 : $fileName.hashCode());
            String $firstKeyIncludeInvalidData = this.getFirstKeyIncludeInvalidData();
            result = result * 59 + ($firstKeyIncludeInvalidData == null ? 43 : $firstKeyIncludeInvalidData.hashCode());
            String $lastKeyIncludeInvalidData = this.getLastKeyIncludeInvalidData();
            result = result * 59 + ($lastKeyIncludeInvalidData == null ? 43 : $lastKeyIncludeInvalidData.hashCode());
            String $mergedFileHistory = this.getMergedFileHistory();
            result = result * 59 + ($mergedFileHistory == null ? 43 : $mergedFileHistory.hashCode());
            String $mergedFileList = this.getMergedFileList();
            result = result * 59 + ($mergedFileList == null ? 43 : $mergedFileList.hashCode());
            return result;
        }

        public String toString() {
            return "LayeredFileIO.FileInfo(fileIndex=" + this.getFileIndex() + ", maxVcc=" + this.getMaxVcc() + ", fileName=" + this.getFileName() + ", rowCountIncludeInvalidData=" + this.getRowCountIncludeInvalidData() + ", firstKeyIncludeInvalidData=" + this.getFirstKeyIncludeInvalidData() + ", lastKeyIncludeInvalidData=" + this.getLastKeyIncludeInvalidData() + ", sorted=" + this.isSorted() + ", merged=" + this.isMerged() + ", mergedFileHistory=" + this.getMergedFileHistory() + ", mergedFileList=" + this.getMergedFileList() + ")";
        }
    }

    private static interface DoInLock<T> {
        public T doInLock();
    }

    class FromFirstFileSelect
    implements MergeFileSelect {
        FromFirstFileSelect() {
        }

        @Override
        public MergeFileSelected select() {
            MergeFileSelected mergeFileSelected = new MergeFileSelected();
            ArrayList ioProxyList = LayeredFileIO.this.cloneFileRefAsLocal();
            int size = ioProxyList.size();
            if (size > LayeredFileIO.this.keepMaxFileCount) {
                log.info("FromFirstFileSelect to merge file: " + size + " > " + LayeredFileIO.this.keepMaxFileCount);
                int toIndex = size - LayeredFileIO.this.keepMaxFileCount + 1;
                ArrayList<FileIOProxy> mergedFileList = new ArrayList<FileIOProxy>(ioProxyList.subList(0, toIndex));
                mergeFileSelected.setMergedFileList(mergedFileList);
                mergeFileSelected.setTopLayFileList(new ArrayList<FileIOProxy>(ioProxyList.subList(toIndex, size)));
                mergeFileSelected.setDeleteDeletedMarkRow(true);
                return mergeFileSelected;
            }
            return null;
        }
    }

    class MergeFileSelected {
        List<FileIOProxy> mergedFileList;
        List<FileIOProxy> topLayFileList;
        boolean deleteDeletedMarkRow;

        public List<FileIOProxy> getMergedFileList() {
            return this.mergedFileList;
        }

        public List<FileIOProxy> getTopLayFileList() {
            return this.topLayFileList;
        }

        public boolean isDeleteDeletedMarkRow() {
            return this.deleteDeletedMarkRow;
        }

        public void setMergedFileList(List<FileIOProxy> mergedFileList) {
            this.mergedFileList = mergedFileList;
        }

        public void setTopLayFileList(List<FileIOProxy> topLayFileList) {
            this.topLayFileList = topLayFileList;
        }

        public void setDeleteDeletedMarkRow(boolean deleteDeletedMarkRow) {
            this.deleteDeletedMarkRow = deleteDeletedMarkRow;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof MergeFileSelected)) {
                return false;
            }
            MergeFileSelected other = (MergeFileSelected)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.isDeleteDeletedMarkRow() != other.isDeleteDeletedMarkRow()) {
                return false;
            }
            List<FileIOProxy> this$mergedFileList = this.getMergedFileList();
            List<FileIOProxy> other$mergedFileList = other.getMergedFileList();
            if (this$mergedFileList == null ? other$mergedFileList != null : !((Object)this$mergedFileList).equals(other$mergedFileList)) {
                return false;
            }
            List<FileIOProxy> this$topLayFileList = this.getTopLayFileList();
            List<FileIOProxy> other$topLayFileList = other.getTopLayFileList();
            return !(this$topLayFileList == null ? other$topLayFileList != null : !((Object)this$topLayFileList).equals(other$topLayFileList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof MergeFileSelected;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isDeleteDeletedMarkRow() ? 79 : 97);
            List<FileIOProxy> $mergedFileList = this.getMergedFileList();
            result = result * 59 + ($mergedFileList == null ? 43 : ((Object)$mergedFileList).hashCode());
            List<FileIOProxy> $topLayFileList = this.getTopLayFileList();
            result = result * 59 + ($topLayFileList == null ? 43 : ((Object)$topLayFileList).hashCode());
            return result;
        }

        public String toString() {
            return "LayeredFileIO.MergeFileSelected(mergedFileList=" + this.getMergedFileList() + ", topLayFileList=" + this.getTopLayFileList() + ", deleteDeletedMarkRow=" + this.isDeleteDeletedMarkRow() + ")";
        }
    }

    class FromFirstAndLessThanRowSelect
    implements MergeFileSelect {
        FromFirstAndLessThanRowSelect() {
        }

        @Override
        public MergeFileSelected select() {
            MergeFileSelected mergeFileSelected = new MergeFileSelected();
            ArrayList ioProxyList = LayeredFileIO.this.cloneFileRefAsLocal();
            int startFile = -1;
            for (int i = 0; i < ioProxyList.size(); ++i) {
                if (((FileIOProxy)ioProxyList.get(i)).rowCountIncludeInvalidData() >= LayeredFileIO.this.skipMergeIfMaxRowCount) continue;
                startFile = i;
                break;
            }
            if (startFile > LayeredFileIO.this.forceMergeIfMaxSkipCount) {
                log.info("too many files, merge from begin: " + JSONAccessor.impl().format(ioProxyList.subList(0, startFile).stream().map(FileIOProxy::filePath).collect(Collectors.toSet())));
                FromFirstFileSelect fromFirstFileSelect = new FromFirstFileSelect();
                return fromFirstFileSelect.select();
            }
            if (startFile == -1) {
                return null;
            }
            int size = (ioProxyList = new ArrayList(ioProxyList.subList(startFile, ioProxyList.size()))).size();
            if (size > LayeredFileIO.this.keepMaxFileCount) {
                log.info("FromFirstAndLessThanRowSelect to merge file: " + size + " > " + LayeredFileIO.this.keepMaxFileCount);
                int toIndex = size - LayeredFileIO.this.keepMaxFileCount + 1;
                ArrayList<FileIOProxy> mergedFileList = new ArrayList<FileIOProxy>(ioProxyList.subList(0, toIndex));
                mergeFileSelected.setMergedFileList(mergedFileList);
                mergeFileSelected.setTopLayFileList(new ArrayList<FileIOProxy>(ioProxyList.subList(toIndex, size)));
                mergeFileSelected.setDeleteDeletedMarkRow(false);
                return mergeFileSelected;
            }
            return null;
        }
    }

    class Force2OneSelect
    implements MergeFileSelect {
        Force2OneSelect() {
        }

        @Override
        public MergeFileSelected select() {
            MergeFileSelected mergeFileSelected = new MergeFileSelected();
            ArrayList ioProxyList = LayeredFileIO.this.cloneFileRefAsLocal();
            int size = ioProxyList.size();
            if (size > 2) {
                log.info("Force2OneSelect to merge file: " + size + " > 2");
                int toIndex = size - 1;
                ArrayList<FileIOProxy> mergedFileList = new ArrayList<FileIOProxy>(ioProxyList.subList(0, toIndex));
                mergeFileSelected.setMergedFileList(mergedFileList);
                mergeFileSelected.setTopLayFileList(new ArrayList<FileIOProxy>(ioProxyList.subList(toIndex, size)));
                mergeFileSelected.setDeleteDeletedMarkRow(true);
                return mergeFileSelected;
            }
            return null;
        }
    }

    static class MergingRef {
        final String key;
        final long vcc;
        final FileIOProxy fileIOProxy;

        public MergingRef(String key, long vcc, FileIOProxy fileIOProxy) {
            this.key = key;
            this.vcc = vcc;
            this.fileIOProxy = fileIOProxy;
        }
    }

    static class SnapshotImpl
    implements ILayeredFileIO {
        final LayeredFileIO snapshot;
        final String id;
        final LayeredFileIO source;
        final long startTime = System.currentTimeMillis();
        private boolean closed;

        @Override
        public void releaseSnapshot() {
            log.info("releaseSnapshot: " + this.id + ", " + this.snapshot.basePath);
            KVEngine.GetResult getResult = snapshotTtl.ttlAndGet("snapshot:" + this.id, 3L, TimeUnit.SECONDS);
            log.info("set ttl: " + getResult.exists() + " , releaseSnapshot: " + this.id + ", " + this.snapshot.basePath);
        }

        public SnapshotImpl(LayeredFileIO snapshot, String id, LayeredFileIO source) {
            this.snapshot = snapshot;
            this.id = id;
            this.source = source;
        }

        @Override
        public FileIO.FileGetResult get(String key) {
            return this.snapshot.get(key);
        }

        @Override
        public FileIO.FileGetResult get(String key, boolean fetchData) {
            return this.snapshot.get(key, fetchData);
        }

        @Override
        public void search(FileIO.SearchListener searchListener) {
            this.snapshot.search(searchListener);
        }

        @Override
        public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n) {
            return this.snapshot.searchAfter(key, inclusive, n);
        }

        @Override
        public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n, Predicate<String> predicate) {
            return this.snapshot.searchAfter(key, inclusive, n, predicate);
        }

        @Override
        public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n) {
            return this.snapshot.searchBefore(key, inclusive, n);
        }

        @Override
        public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n, Predicate<String> predicate) {
            return this.snapshot.searchBefore(key, inclusive, n, predicate);
        }

        @Override
        public List<FileIO.FileGetResult> top(int n) {
            return this.snapshot.top(n);
        }

        @Override
        public List<FileIO.FileGetResult> tail(int n) {
            return this.snapshot.tail(n);
        }

        @Override
        public int rowCountIncludeInvalidData() {
            return this.snapshot.rowCountIncludeInvalidData();
        }

        @Override
        public int count() {
            return this.snapshot.count();
        }

        @Override
        public void close() throws Exception {
        }

        @Override
        public FileIO.FilePutResult put(String key, Map<String, Object> meta, byte[] data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileIO.FilePutResult put(Map<String, Object> meta, byte[] data) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileIO.CompareAndSetResult compareAndSet(String key, FileIO.CompareAndSet compareAndSet) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileIO.FileDeleteResult delete(String key) {
            throw new UnsupportedOperationException();
        }

        @Override
        public FileIO.DiskFileStat diskFileStat() {
            return this.snapshot.diskFileStat();
        }

        @Override
        public void merge() {
            throw new UnsupportedOperationException();
        }
    }

    static class UnsupportedAutoIncrementKeyGenerator
    implements AutoIncrementKeyGenerator {
        UnsupportedAutoIncrementKeyGenerator() {
        }

        @Override
        public long next() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long get() {
            throw new UnsupportedOperationException();
        }

        @Override
        public long updateAndGet(LongUnaryOperator updateFunction) {
            throw new UnsupportedOperationException();
        }
    }

    static class SnapshotInfo
    implements Model {
        private final String id;
        private final List<String> fileNameList;
        final SnapshotImpl snapshot;

        public SnapshotInfo(String id, List<String> fileNameList, SnapshotImpl snapshot) {
            this.id = id;
            this.fileNameList = fileNameList;
            this.snapshot = snapshot;
        }

        public String getId() {
            return this.id;
        }

        public List<String> getFileNameList() {
            return this.fileNameList;
        }

        public SnapshotImpl getSnapshot() {
            return this.snapshot;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SnapshotInfo)) {
                return false;
            }
            SnapshotInfo other = (SnapshotInfo)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$id = this.getId();
            String other$id = other.getId();
            if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                return false;
            }
            List<String> this$fileNameList = this.getFileNameList();
            List<String> other$fileNameList = other.getFileNameList();
            if (this$fileNameList == null ? other$fileNameList != null : !((Object)this$fileNameList).equals(other$fileNameList)) {
                return false;
            }
            SnapshotImpl this$snapshot = this.getSnapshot();
            SnapshotImpl other$snapshot = other.getSnapshot();
            return !(this$snapshot == null ? other$snapshot != null : !this$snapshot.equals(other$snapshot));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SnapshotInfo;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $id = this.getId();
            result = result * 59 + ($id == null ? 43 : $id.hashCode());
            List<String> $fileNameList = this.getFileNameList();
            result = result * 59 + ($fileNameList == null ? 43 : ((Object)$fileNameList).hashCode());
            SnapshotImpl $snapshot = this.getSnapshot();
            result = result * 59 + ($snapshot == null ? 43 : $snapshot.hashCode());
            return result;
        }

        public String toString() {
            return "LayeredFileIO.SnapshotInfo(id=" + this.getId() + ", fileNameList=" + this.getFileNameList() + ", snapshot=" + this.getSnapshot() + ")";
        }
    }

    static interface MergeFileSelect {
        public MergeFileSelected select();
    }
}

