/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.vfile;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.OnlyPrivate;
import com.ovopark.kernel.shared.OnlyTest;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.vfile.FileIO;
import com.ovopark.kernel.shared.vfile.ILayeredFileIO;
import com.ovopark.kernel.shared.vfile.LayeredFileIO;
import com.ovopark.kernel.shared.vfile.Snapshot;
import java.io.File;
import java.io.IOException;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.LongUnaryOperator;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleShardFileIO
implements FileIO.ShardFileIO,
Cloneable {
    private static final Logger log = LoggerFactory.getLogger(SimpleShardFileIO.class);
    private static final String MF_SFM = ".sfm";
    final String basePath;
    private final int shardCount;
    private final boolean autoIncrement;
    final List<ILayeredFileIO> layeredFileIOList;
    final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicLong keyNum = new AtomicLong();

    public SimpleShardFileIO(String basePath, int shardCount) {
        this.basePath = basePath;
        this.shardCount = shardCount;
        this.autoIncrement = false;
        this.layeredFileIOList = new ArrayList<ILayeredFileIO>(shardCount);
        Conf conf = new Conf();
        conf.setShardCount(shardCount);
        this.loadBeforeAvailable(conf);
    }

    public SimpleShardFileIO(String basePath, Conf conf) {
        this.basePath = basePath;
        this.shardCount = conf.getShardCount();
        this.autoIncrement = conf.isAutoIncrement();
        this.layeredFileIOList = new ArrayList<ILayeredFileIO>(this.shardCount);
        this.loadBeforeAvailable(conf);
    }

    private void loadBeforeAvailable(Conf conf) {
        Meta meta;
        File bf = new File(this.basePath);
        if (!bf.exists()) {
            bf.mkdirs();
        }
        if (bf.listFiles().length == 0) {
            meta = new Meta();
            meta.setShardCount(this.shardCount);
            meta.setAutoIncrement(this.autoIncrement);
            this.writeMeta(meta);
        }
        if ((meta = this.readMeta()).getShardCount() != this.shardCount) {
            throw DBOpeException.from("diff shardCount: " + meta.shardCount + ", but " + this.shardCount);
        }
        if (meta.autoIncrement != this.autoIncrement) {
            throw DBOpeException.from("diff autoIncrement: " + meta.autoIncrement + ", but " + this.autoIncrement);
        }
        ArrayList<LayeredFileIO> tempFileIOList = new ArrayList<LayeredFileIO>(this.shardCount);
        try {
            for (int i = 0; i < this.shardCount; ++i) {
                String shardBasePath = this.basePath + "/" + i;
                LayeredFileIO.Conf conf2 = LayeredFileIO.Conf.defaultConf();
                conf2.setWalBufferSizeMb(conf.getWalBufferSizeMb());
                conf2.setWalDiskSizeMb(conf.getWalDiskSizeMb());
                conf2.setCompressed(true);
                conf2.setRowRegion(100);
                conf2.setMemoryBufferSizeMb(conf.getMemoryBufferSizeMb());
                conf2.setAutoIncrement(false);
                conf2.setSparseIfMinCount(conf.getSparseIfMinCount());
                conf2.setForceMergeIfMaxSkipCount(conf.getForceMergeIfMaxSkipCount());
                conf2.setKeepMaxFileCount(conf.getKeepMaxFileCount());
                LayeredFileIO layeredFileIO = new LayeredFileIO(shardBasePath, conf2, new AutoIncrementKeyGeneratorImpl(), true, this.autoIncrement);
                tempFileIOList.add(layeredFileIO);
                log.info("load shard(" + i + "): " + layeredFileIO.basePath + ", sparseIfMinCount: " + conf.getSparseIfMinCount());
            }
        }
        catch (Throwable t) {
            for (ILayeredFileIO iLayeredFileIO : tempFileIOList) {
                try {
                    iLayeredFileIO.close();
                }
                catch (Throwable e) {
                    log.error(e.getMessage(), e);
                }
            }
            log.error(t.getMessage(), t);
            throw DBOpeException.from(t);
        }
        log.info("max key num: " + this.keyNum.get());
        this.layeredFileIOList.addAll(tempFileIOList);
    }

    private ILayeredFileIO layeredFile(String route) {
        if (Util.isEmpty(route)) {
            throw DBOpeException.from("route is empty");
        }
        int shard = Util.shard(route, this.shardCount);
        return this.layeredFileIOList.get(shard);
    }

    @Override
    public FileIO.FilePutResult put(String key, Map<String, Object> meta, byte[] data) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFile(key).put(key, meta, data);
    }

    @Override
    public FileIO.FilePutResult put(Map<String, Object> meta, byte[] data) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (!this.autoIncrement) {
            throw DBOpeException.from("key is missing, autoIncrement is closed.");
        }
        return this.put(Util.leftPad(this.keyNum.incrementAndGet(), LayeredFileIO.LONG_LENGTH), meta, data);
    }

    @Override
    public FileIO.CompareAndSetResult compareAndSet(String key, FileIO.CompareAndSet compareAndSet) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFile(key).compareAndSet(key, compareAndSet);
    }

    @Override
    public FileIO.FileGetResult get(String key) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFile(key).get(key);
    }

    @Override
    public FileIO.FileGetResult get(String key, boolean fetchData) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFile(key).get(key, fetchData);
    }

    @Override
    public FileIO.FileDeleteResult delete(String key) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFile(key).delete(key);
    }

    @Override
    public void search(FileIO.SearchListener searchListener) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
            layeredFileIO.search(searchListener);
        }
    }

    @Override
    public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n) {
        return this.searchAfter(key, inclusive, n, (String k) -> true);
    }

    @Override
    public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n, Predicate<String> predicate) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        ArrayList<FileIO.FileGetResult> fileGetResultList = new ArrayList<FileIO.FileGetResult>(n * this.shardCount);
        for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
            List<FileIO.FileGetResult> list = layeredFileIO.searchAfter(key, inclusive, n, predicate);
            fileGetResultList.addAll(list);
        }
        fileGetResultList.sort(Comparator.comparing(FileIO.FileGetResult::key));
        List<FileIO.FileGetResult> resultList = fileGetResultList.subList(0, Math.min(fileGetResultList.size(), n));
        return resultList;
    }

    @Override
    public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n) {
        return this.searchBefore(key, inclusive, n, (String k) -> true);
    }

    @Override
    public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n, Predicate<String> predicate) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        ArrayList<FileIO.FileGetResult> fileGetResultList = new ArrayList<FileIO.FileGetResult>(n * this.shardCount);
        for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
            List<FileIO.FileGetResult> list = layeredFileIO.searchBefore(key, inclusive, n, predicate);
            fileGetResultList.addAll(list);
        }
        fileGetResultList.sort(Comparator.comparing(FileIO.FileGetResult::key).reversed());
        List<FileIO.FileGetResult> resultList = fileGetResultList.subList(0, Math.min(fileGetResultList.size(), n));
        return resultList;
    }

    @Override
    public List<FileIO.FileGetResult> top(int n) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        ArrayList<FileIO.FileGetResult> fileGetResultList = new ArrayList<FileIO.FileGetResult>(n * this.shardCount);
        for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
            List<FileIO.FileGetResult> list = layeredFileIO.top(n);
            fileGetResultList.addAll(list);
        }
        fileGetResultList.sort(Comparator.comparing(FileIO.FileGetResult::key));
        List<FileIO.FileGetResult> resultList = fileGetResultList.subList(0, Math.min(fileGetResultList.size(), n));
        return resultList;
    }

    @Override
    public List<FileIO.FileGetResult> tail(int n) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        ArrayList<FileIO.FileGetResult> fileGetResultList = new ArrayList<FileIO.FileGetResult>(n * this.shardCount);
        for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
            List<FileIO.FileGetResult> list = layeredFileIO.tail(n);
            fileGetResultList.addAll(list);
        }
        fileGetResultList.sort(Comparator.comparing(FileIO.FileGetResult::key).reversed());
        List<FileIO.FileGetResult> resultList = fileGetResultList.subList(0, Math.min(fileGetResultList.size(), n));
        return resultList;
    }

    @Override
    public int rowCountIncludeInvalidData() {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFileIOList.stream().mapToInt(Snapshot::rowCountIncludeInvalidData).sum();
    }

    @Override
    public int count() {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFileIOList.stream().mapToInt(Snapshot::count).sum();
    }

    @Override
    public void close() throws Exception {
        this.closed.set(true);
        for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
            try {
                layeredFileIO.close();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    @Override
    public FileIO.DiskFileStat diskFileStat() {
        return new FileIO.DiskFileStat(){

            @Override
            public FileIO.FileStat fileStat() {
                long sumByteSize = 0L;
                FileIO.FileStat fileStat = new FileIO.FileStat();
                for (int i = 0; i < SimpleShardFileIO.this.layeredFileIOList.size(); ++i) {
                    FileIO.FileStat layered = SimpleShardFileIO.this.layeredFileIOList.get(i).diskFileStat().fileStat();
                    for (FileIO.FileStat.File file : layered.fileList) {
                        file.setShard(i);
                        fileStat.fileList.add(file);
                    }
                    sumByteSize += layered.getSumByteSize();
                }
                fileStat.setSumByteSize(sumByteSize);
                return fileStat;
            }

            @Override
            public void pretty(OutputStreamWriter outputStreamWriter) {
                long sumByteSize = 0L;
                long sumValidByteSize = 0L;
                StringBuilder stringBuilder = new StringBuilder();
                for (int i = 0; i < SimpleShardFileIO.this.layeredFileIOList.size(); ++i) {
                    FileIO.FileStat layered = SimpleShardFileIO.this.layeredFileIOList.get(i).diskFileStat().fileStat();
                    stringBuilder.append("\r\n" + i + " - " + layered.getSumValidByteSize() + "/" + layered.getSumByteSize() + " (" + (layered.getSumValidByteSize() - layered.getSumByteSize()) + "):");
                    for (FileIO.FileStat.File file : layered.fileList) {
                        stringBuilder.append("\r\n\t" + (file.isValid() ? " - " : " x ") + file.getName() + "," + file.getByteSize() + "," + file.getLastModifiedTimeMs() + "(" + Util.formatTime(Util.dateTime(file.getLastModifiedTimeMs()), new String[0]) + "),valid?: " + file.isValid());
                        if (!file.isValid()) continue;
                        sumValidByteSize += file.getByteSize();
                    }
                    sumByteSize += layered.getSumByteSize();
                }
                try {
                    outputStreamWriter.write("basePath: " + SimpleShardFileIO.this.basePath);
                    outputStreamWriter.write("\r\nsumByteSize: " + sumValidByteSize + "/" + sumByteSize + " (" + (sumValidByteSize - sumByteSize) + ")");
                    File file = new File(SimpleShardFileIO.this.basePath);
                    for (File listFile : file.listFiles()) {
                        outputStreamWriter.write("\r\n- " + listFile.getName());
                    }
                    outputStreamWriter.write(stringBuilder.toString());
                }
                catch (IOException e) {
                    throw Util.convert2RuntimeException(e);
                }
            }
        };
    }

    @Override
    public FileIO.FilePutResult put(String key, Map<String, Object> meta, byte[] data, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFile(Util.convert2Self(options.getRoute(), key)).put(key, meta, data);
    }

    @Override
    public FileIO.FilePutResult put(Map<String, Object> meta, byte[] data, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        String key = Util.leftPad(this.keyNum.incrementAndGet(), LayeredFileIO.LONG_LENGTH);
        return this.layeredFile(Util.convert2Self(options.getRoute(), key)).put(key, meta, data);
    }

    @Override
    public FileIO.CompareAndSetResult compareAndSet(String key, FileIO.CompareAndSet compareAndSet, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFile(Util.convert2Self(options.getRoute(), key)).compareAndSet(key, compareAndSet);
    }

    @Override
    public FileIO.FileGetResult get(String key, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.get0(key, options, true);
    }

    FileIO.FileGetResult get0(String key, FileIO.ShardFileIO.Options options, boolean fetchData) {
        return this.layeredFile(Util.convert2Self(options.getRoute(), key)).get(key, fetchData);
    }

    @Override
    public FileIO.FileDeleteResult delete(String key, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.layeredFile(Util.convert2Self(options.getRoute(), key)).delete(key);
    }

    @Override
    public void search(FileIO.SearchListener searchListener, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (Util.isEmpty(options.getRoute())) {
            this.search(searchListener);
        } else {
            this.layeredFile(options.getRoute()).search(searchListener);
        }
    }

    @Override
    public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.searchAfter(key, inclusive, n, k -> true, options);
    }

    @Override
    public List<FileIO.FileGetResult> searchAfter(String key, boolean inclusive, int n, Predicate<String> predicate, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (Util.isEmpty(options.getRoute())) {
            return this.searchAfter(key, inclusive, n, predicate);
        }
        return this.layeredFile(options.getRoute()).searchAfter(key, inclusive, n, predicate);
    }

    @Override
    public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        return this.searchBefore(key, inclusive, n, k -> true, options);
    }

    @Override
    public List<FileIO.FileGetResult> searchBefore(String key, boolean inclusive, int n, Predicate<String> predicate, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (Util.isEmpty(options.getRoute())) {
            return this.searchBefore(key, inclusive, n, predicate);
        }
        return this.layeredFile(options.getRoute()).searchBefore(key, inclusive, n, predicate);
    }

    @Override
    public List<FileIO.FileGetResult> top(int n, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (Util.isEmpty(options.getRoute())) {
            return this.top(n);
        }
        return this.layeredFile(options.getRoute()).top(n);
    }

    @Override
    public List<FileIO.FileGetResult> tail(int n, FileIO.ShardFileIO.Options options) {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        if (Util.isEmpty(options.getRoute())) {
            return this.tail(n);
        }
        return this.layeredFile(options.getRoute()).tail(n);
    }

    @OnlyTest
    @OnlyPrivate
    public void merge() {
        if (this.closed.get()) {
            throw DBOpeException.from("closed");
        }
        this.layeredFileIOList.forEach(ILayeredFileIO::merge);
    }

    Meta readMeta() {
        try {
            File file = new File(this.basePath + "/" + MF_SFM);
            byte[] bytes = Util.read(file);
            return JSONAccessor.impl().read(bytes, Meta.class);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw DBOpeException.from(e);
        }
    }

    void writeMeta(Meta meta) {
        try {
            File file = new File(this.basePath + "/" + MF_SFM);
            String s = JSONAccessor.impl().format(meta);
            Util.writeAtomic(file, Util.utf8(s));
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            throw DBOpeException.from(e);
        }
    }

    void dump(FileIO.SearchListener searchListener) {
        for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
            LayeredFileIO.SnapshotImpl layeredSnapshot = (LayeredFileIO.SnapshotImpl)layeredFileIO;
            layeredSnapshot.search(searchListener);
        }
    }

    SimpleShardFileIO snapshot(long waitTimeSec) {
        SimpleShardFileIO cloned;
        log.info("to create snapshot: " + this.basePath);
        try {
            cloned = (SimpleShardFileIO)this.clone();
        }
        catch (CloneNotSupportedException e) {
            throw Util.convert2RuntimeException(e);
        }
        ArrayList<LayeredFileIO.SnapshotImpl> snapshotList = new ArrayList<LayeredFileIO.SnapshotImpl>(this.layeredFileIOList.size());
        try {
            for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
                LayeredFileIO.SnapshotImpl snapshotImpl = ((LayeredFileIO)layeredFileIO).snapshot(waitTimeSec);
                if (snapshotImpl == null) {
                    throw new IllegalStateException("cannot create snapshot: " + ((LayeredFileIO)layeredFileIO).basePath);
                }
                snapshotList.add(snapshotImpl);
            }
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            for (ILayeredFileIO iLayeredFileIO : snapshotList) {
                try {
                    iLayeredFileIO.close();
                }
                catch (Exception ex) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            throw Util.convert2RuntimeException(e);
        }
        try {
            SimpleShardFileIO.setVal(cloned, SimpleShardFileIO.class.getDeclaredField("layeredFileIOList"), snapshotList);
            SimpleShardFileIO.setVal(cloned, SimpleShardFileIO.class.getDeclaredField("closed"), new AtomicBoolean(this.closed.get()));
            SimpleShardFileIO.setVal(cloned, SimpleShardFileIO.class.getDeclaredField("keyNum"), new AtomicLong(this.keyNum.get()));
            log.info("created snapshot: " + this.basePath);
            return cloned;
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
            for (ILayeredFileIO iLayeredFileIO : snapshotList) {
                try {
                    iLayeredFileIO.close();
                }
                catch (Exception ex) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
            throw Util.convert2RuntimeException(e);
        }
    }

    @Override
    public void releaseSnapshot() {
        for (ILayeredFileIO layeredFileIO : this.layeredFileIOList) {
            try {
                layeredFileIO.releaseSnapshot();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
        }
    }

    private static void setVal(SimpleShardFileIO simpleShardFileIO, Field field, Object newVal) throws Exception {
        field.setAccessible(true);
        field.set(simpleShardFileIO, newVal);
    }

    public static class Conf
    implements Model {
        private int walBufferSizeMb = 10;
        long walDiskSizeMb = 10L;
        private int shardCount;
        private long memoryBufferSizeMb = 10L;
        private boolean autoIncrement;
        private int sparseIfMinCount = 1000000;
        private int forceMergeIfMaxSkipCount = 2;
        private int keepMaxFileCount = 2;

        public int getWalBufferSizeMb() {
            return this.walBufferSizeMb;
        }

        public long getWalDiskSizeMb() {
            return this.walDiskSizeMb;
        }

        public int getShardCount() {
            return this.shardCount;
        }

        public long getMemoryBufferSizeMb() {
            return this.memoryBufferSizeMb;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public int getSparseIfMinCount() {
            return this.sparseIfMinCount;
        }

        public int getForceMergeIfMaxSkipCount() {
            return this.forceMergeIfMaxSkipCount;
        }

        public int getKeepMaxFileCount() {
            return this.keepMaxFileCount;
        }

        public void setWalBufferSizeMb(int walBufferSizeMb) {
            this.walBufferSizeMb = walBufferSizeMb;
        }

        public void setWalDiskSizeMb(long walDiskSizeMb) {
            this.walDiskSizeMb = walDiskSizeMb;
        }

        public void setShardCount(int shardCount) {
            this.shardCount = shardCount;
        }

        public void setMemoryBufferSizeMb(long memoryBufferSizeMb) {
            this.memoryBufferSizeMb = memoryBufferSizeMb;
        }

        public void setAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
        }

        public void setSparseIfMinCount(int sparseIfMinCount) {
            this.sparseIfMinCount = sparseIfMinCount;
        }

        public void setForceMergeIfMaxSkipCount(int forceMergeIfMaxSkipCount) {
            this.forceMergeIfMaxSkipCount = forceMergeIfMaxSkipCount;
        }

        public void setKeepMaxFileCount(int keepMaxFileCount) {
            this.keepMaxFileCount = keepMaxFileCount;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Conf)) {
                return false;
            }
            Conf other = (Conf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWalBufferSizeMb() != other.getWalBufferSizeMb()) {
                return false;
            }
            if (this.getWalDiskSizeMb() != other.getWalDiskSizeMb()) {
                return false;
            }
            if (this.getShardCount() != other.getShardCount()) {
                return false;
            }
            if (this.getMemoryBufferSizeMb() != other.getMemoryBufferSizeMb()) {
                return false;
            }
            if (this.isAutoIncrement() != other.isAutoIncrement()) {
                return false;
            }
            if (this.getSparseIfMinCount() != other.getSparseIfMinCount()) {
                return false;
            }
            if (this.getForceMergeIfMaxSkipCount() != other.getForceMergeIfMaxSkipCount()) {
                return false;
            }
            return this.getKeepMaxFileCount() == other.getKeepMaxFileCount();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Conf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWalBufferSizeMb();
            long $walDiskSizeMb = this.getWalDiskSizeMb();
            result = result * 59 + (int)($walDiskSizeMb >>> 32 ^ $walDiskSizeMb);
            result = result * 59 + this.getShardCount();
            long $memoryBufferSizeMb = this.getMemoryBufferSizeMb();
            result = result * 59 + (int)($memoryBufferSizeMb >>> 32 ^ $memoryBufferSizeMb);
            result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
            result = result * 59 + this.getSparseIfMinCount();
            result = result * 59 + this.getForceMergeIfMaxSkipCount();
            result = result * 59 + this.getKeepMaxFileCount();
            return result;
        }

        public String toString() {
            return "SimpleShardFileIO.Conf(walBufferSizeMb=" + this.getWalBufferSizeMb() + ", walDiskSizeMb=" + this.getWalDiskSizeMb() + ", shardCount=" + this.getShardCount() + ", memoryBufferSizeMb=" + this.getMemoryBufferSizeMb() + ", autoIncrement=" + this.isAutoIncrement() + ", sparseIfMinCount=" + this.getSparseIfMinCount() + ", forceMergeIfMaxSkipCount=" + this.getForceMergeIfMaxSkipCount() + ", keepMaxFileCount=" + this.getKeepMaxFileCount() + ")";
        }
    }

    static class Meta
    implements Model {
        private int shardCount;
        private boolean autoIncrement;

        public int getShardCount() {
            return this.shardCount;
        }

        public boolean isAutoIncrement() {
            return this.autoIncrement;
        }

        public void setShardCount(int shardCount) {
            this.shardCount = shardCount;
        }

        public void setAutoIncrement(boolean autoIncrement) {
            this.autoIncrement = autoIncrement;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Meta)) {
                return false;
            }
            Meta other = (Meta)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getShardCount() != other.getShardCount()) {
                return false;
            }
            return this.isAutoIncrement() == other.isAutoIncrement();
        }

        protected boolean canEqual(Object other) {
            return other instanceof Meta;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getShardCount();
            result = result * 59 + (this.isAutoIncrement() ? 79 : 97);
            return result;
        }

        public String toString() {
            return "SimpleShardFileIO.Meta(shardCount=" + this.getShardCount() + ", autoIncrement=" + this.isAutoIncrement() + ")";
        }
    }

    private class AutoIncrementKeyGeneratorImpl
    implements LayeredFileIO.AutoIncrementKeyGenerator {
        private AutoIncrementKeyGeneratorImpl() {
        }

        @Override
        public long next() {
            return SimpleShardFileIO.this.keyNum.incrementAndGet();
        }

        @Override
        public long get() {
            return SimpleShardFileIO.this.keyNum.get();
        }

        @Override
        public long updateAndGet(LongUnaryOperator updateFunction) {
            return SimpleShardFileIO.this.keyNum.updateAndGet(updateFunction);
        }
    }
}

