/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.delay;

import com.ovopark.kernel.shared.delay.DelayTask;
import com.ovopark.kernel.shared.stream.Stream;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Predicate;

public interface TimingWheelTimer {
    public void delay(DelayTask var1);

    public void shutdown() throws Exception;

    public int size();

    public TimingWheelStat stat();

    public void seek(Consumer<DelayTask> var1, int var2);

    default public void seek(Consumer<DelayTask> delayTaskConsumer) {
        this.seek(delayTaskConsumer, 10000);
    }

    public SearchResult search(SearchPredicate var1);

    public Stream<DelayTask> stream();

    public static class BucketStat {
        private int size;

        public int getSize() {
            return this.size;
        }

        public void setSize(int size) {
            this.size = size;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof BucketStat)) {
                return false;
            }
            BucketStat other = (BucketStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getSize() == other.getSize();
        }

        protected boolean canEqual(Object other) {
            return other instanceof BucketStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getSize();
            return result;
        }

        public String toString() {
            return "TimingWheelTimer.BucketStat(size=" + this.getSize() + ")";
        }
    }

    public static class WheelStat {
        private int level;
        private long startMs;
        private String startMsStr;
        private String endMsStr;
        private long tickMs;
        private long interval;
        private String intervalStr;
        private long currentTime;
        private String currentTimeStr;
        private long sumTaskCount;
        private List<BucketStat> bucketStatList;

        public int getLevel() {
            return this.level;
        }

        public long getStartMs() {
            return this.startMs;
        }

        public String getStartMsStr() {
            return this.startMsStr;
        }

        public String getEndMsStr() {
            return this.endMsStr;
        }

        public long getTickMs() {
            return this.tickMs;
        }

        public long getInterval() {
            return this.interval;
        }

        public String getIntervalStr() {
            return this.intervalStr;
        }

        public long getCurrentTime() {
            return this.currentTime;
        }

        public String getCurrentTimeStr() {
            return this.currentTimeStr;
        }

        public long getSumTaskCount() {
            return this.sumTaskCount;
        }

        public List<BucketStat> getBucketStatList() {
            return this.bucketStatList;
        }

        public void setLevel(int level) {
            this.level = level;
        }

        public void setStartMs(long startMs) {
            this.startMs = startMs;
        }

        public void setStartMsStr(String startMsStr) {
            this.startMsStr = startMsStr;
        }

        public void setEndMsStr(String endMsStr) {
            this.endMsStr = endMsStr;
        }

        public void setTickMs(long tickMs) {
            this.tickMs = tickMs;
        }

        public void setInterval(long interval) {
            this.interval = interval;
        }

        public void setIntervalStr(String intervalStr) {
            this.intervalStr = intervalStr;
        }

        public void setCurrentTime(long currentTime) {
            this.currentTime = currentTime;
        }

        public void setCurrentTimeStr(String currentTimeStr) {
            this.currentTimeStr = currentTimeStr;
        }

        public void setSumTaskCount(long sumTaskCount) {
            this.sumTaskCount = sumTaskCount;
        }

        public void setBucketStatList(List<BucketStat> bucketStatList) {
            this.bucketStatList = bucketStatList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof WheelStat)) {
                return false;
            }
            WheelStat other = (WheelStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getLevel() != other.getLevel()) {
                return false;
            }
            if (this.getStartMs() != other.getStartMs()) {
                return false;
            }
            if (this.getTickMs() != other.getTickMs()) {
                return false;
            }
            if (this.getInterval() != other.getInterval()) {
                return false;
            }
            if (this.getCurrentTime() != other.getCurrentTime()) {
                return false;
            }
            if (this.getSumTaskCount() != other.getSumTaskCount()) {
                return false;
            }
            String this$startMsStr = this.getStartMsStr();
            String other$startMsStr = other.getStartMsStr();
            if (this$startMsStr == null ? other$startMsStr != null : !this$startMsStr.equals(other$startMsStr)) {
                return false;
            }
            String this$endMsStr = this.getEndMsStr();
            String other$endMsStr = other.getEndMsStr();
            if (this$endMsStr == null ? other$endMsStr != null : !this$endMsStr.equals(other$endMsStr)) {
                return false;
            }
            String this$intervalStr = this.getIntervalStr();
            String other$intervalStr = other.getIntervalStr();
            if (this$intervalStr == null ? other$intervalStr != null : !this$intervalStr.equals(other$intervalStr)) {
                return false;
            }
            String this$currentTimeStr = this.getCurrentTimeStr();
            String other$currentTimeStr = other.getCurrentTimeStr();
            if (this$currentTimeStr == null ? other$currentTimeStr != null : !this$currentTimeStr.equals(other$currentTimeStr)) {
                return false;
            }
            List<BucketStat> this$bucketStatList = this.getBucketStatList();
            List<BucketStat> other$bucketStatList = other.getBucketStatList();
            return !(this$bucketStatList == null ? other$bucketStatList != null : !((Object)this$bucketStatList).equals(other$bucketStatList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof WheelStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getLevel();
            long $startMs = this.getStartMs();
            result = result * 59 + (int)($startMs >>> 32 ^ $startMs);
            long $tickMs = this.getTickMs();
            result = result * 59 + (int)($tickMs >>> 32 ^ $tickMs);
            long $interval = this.getInterval();
            result = result * 59 + (int)($interval >>> 32 ^ $interval);
            long $currentTime = this.getCurrentTime();
            result = result * 59 + (int)($currentTime >>> 32 ^ $currentTime);
            long $sumTaskCount = this.getSumTaskCount();
            result = result * 59 + (int)($sumTaskCount >>> 32 ^ $sumTaskCount);
            String $startMsStr = this.getStartMsStr();
            result = result * 59 + ($startMsStr == null ? 43 : $startMsStr.hashCode());
            String $endMsStr = this.getEndMsStr();
            result = result * 59 + ($endMsStr == null ? 43 : $endMsStr.hashCode());
            String $intervalStr = this.getIntervalStr();
            result = result * 59 + ($intervalStr == null ? 43 : $intervalStr.hashCode());
            String $currentTimeStr = this.getCurrentTimeStr();
            result = result * 59 + ($currentTimeStr == null ? 43 : $currentTimeStr.hashCode());
            List<BucketStat> $bucketStatList = this.getBucketStatList();
            result = result * 59 + ($bucketStatList == null ? 43 : ((Object)$bucketStatList).hashCode());
            return result;
        }

        public String toString() {
            return "TimingWheelTimer.WheelStat(level=" + this.getLevel() + ", startMs=" + this.getStartMs() + ", startMsStr=" + this.getStartMsStr() + ", endMsStr=" + this.getEndMsStr() + ", tickMs=" + this.getTickMs() + ", interval=" + this.getInterval() + ", intervalStr=" + this.getIntervalStr() + ", currentTime=" + this.getCurrentTime() + ", currentTimeStr=" + this.getCurrentTimeStr() + ", sumTaskCount=" + this.getSumTaskCount() + ", bucketStatList=" + this.getBucketStatList() + ")";
        }
    }

    public static class TimingWheelStat {
        private int wheelSize;
        private List<WheelStat> wheelStatList;

        public int getWheelSize() {
            return this.wheelSize;
        }

        public List<WheelStat> getWheelStatList() {
            return this.wheelStatList;
        }

        public void setWheelSize(int wheelSize) {
            this.wheelSize = wheelSize;
        }

        public void setWheelStatList(List<WheelStat> wheelStatList) {
            this.wheelStatList = wheelStatList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TimingWheelStat)) {
                return false;
            }
            TimingWheelStat other = (TimingWheelStat)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getWheelSize() != other.getWheelSize()) {
                return false;
            }
            List<WheelStat> this$wheelStatList = this.getWheelStatList();
            List<WheelStat> other$wheelStatList = other.getWheelStatList();
            return !(this$wheelStatList == null ? other$wheelStatList != null : !((Object)this$wheelStatList).equals(other$wheelStatList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof TimingWheelStat;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getWheelSize();
            List<WheelStat> $wheelStatList = this.getWheelStatList();
            result = result * 59 + ($wheelStatList == null ? 43 : ((Object)$wheelStatList).hashCode());
            return result;
        }

        public String toString() {
            return "TimingWheelTimer.TimingWheelStat(wheelSize=" + this.getWheelSize() + ", wheelStatList=" + this.getWheelStatList() + ")";
        }
    }

    public static class SearchResult {
        long scanSize;
        List<DelayTask> delayTaskList;

        public long getScanSize() {
            return this.scanSize;
        }

        public List<DelayTask> getDelayTaskList() {
            return this.delayTaskList;
        }

        public void setScanSize(long scanSize) {
            this.scanSize = scanSize;
        }

        public void setDelayTaskList(List<DelayTask> delayTaskList) {
            this.delayTaskList = delayTaskList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SearchResult)) {
                return false;
            }
            SearchResult other = (SearchResult)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getScanSize() != other.getScanSize()) {
                return false;
            }
            List<DelayTask> this$delayTaskList = this.getDelayTaskList();
            List<DelayTask> other$delayTaskList = other.getDelayTaskList();
            return !(this$delayTaskList == null ? other$delayTaskList != null : !((Object)this$delayTaskList).equals(other$delayTaskList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SearchResult;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $scanSize = this.getScanSize();
            result = result * 59 + (int)($scanSize >>> 32 ^ $scanSize);
            List<DelayTask> $delayTaskList = this.getDelayTaskList();
            result = result * 59 + ($delayTaskList == null ? 43 : ((Object)$delayTaskList).hashCode());
            return result;
        }

        public String toString() {
            return "TimingWheelTimer.SearchResult(scanSize=" + this.getScanSize() + ", delayTaskList=" + this.getDelayTaskList() + ")";
        }
    }

    public static interface SearchPredicate
    extends Predicate<DelayTask> {
        @Override
        public boolean test(DelayTask var1);

        default public boolean breakTest() {
            return false;
        }
    }
}

