/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.vfile;

import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.OnlyPrivate;
import com.ovopark.kernel.shared.OnlyTest;
import com.ovopark.kernel.shared.vfile.DefaultLemonEngine;
import java.io.OutputStreamWriter;
import java.util.List;
import java.util.Map;
import java.util.function.Predicate;

public interface LemonEngine {
    public PutResult put(String var1, Map<String, Object> var2);

    public PutResult put(String var1, Map<String, Object> var2, Options var3);

    public PutResult append(String var1, Map<String, Object> var2);

    public PutResult append(String var1, Map<String, Object> var2, Options var3);

    public GetResult get(String var1);

    public GetResult get(String var1, Options var2);

    public boolean exists(String var1);

    public boolean exists(String var1, Options var2);

    public DeleteResult delete(String var1);

    public DeleteResult delete(String var1, Options var2);

    public CompareAndSetResult compareAndSet(String var1, CompareAndSet var2);

    public CompareAndSetResult compareAndSet(String var1, CompareAndSet var2, Options var3);

    public void search(SearchListener var1);

    public void search(SearchListener var1, Options var2);

    public List<GetResult> searchAfter(String var1, boolean var2, int var3);

    public List<GetResult> searchAfter(String var1, boolean var2, int var3, Predicate<String> var4);

    public List<GetResult> searchAfter(String var1, boolean var2, int var3, Options var4);

    public List<GetResult> searchAfter(String var1, boolean var2, int var3, Predicate<String> var4, Options var5);

    public List<GetResult> searchBefore(String var1, boolean var2, int var3);

    public List<GetResult> searchBefore(String var1, boolean var2, int var3, Predicate<String> var4);

    public List<GetResult> searchBefore(String var1, boolean var2, int var3, Options var4);

    public List<GetResult> searchBefore(String var1, boolean var2, int var3, Predicate<String> var4, Options var5);

    public List<GetResult> top(int var1);

    public List<GetResult> tail(int var1);

    public List<GetResult> top(int var1, Options var2);

    public List<GetResult> tail(int var1, Options var2);

    public int count();

    public void close() throws Exception;

    public void pretty(OutputStreamWriter var1);

    @OnlyPrivate
    @OnlyTest
    public void dump(SearchListener var1);

    public void dump(SearchListener var1, DumpConf var2);

    public static Mgr mgr() {
        return DefaultLemonEngine.MgrImpl.mgr;
    }

    public static interface Mgr {
        public void add(String var1, LemonEngine var2);

        public void remove(String var1);

        public LemonEngine get(String var1);

        public List<String> list();
    }

    public static interface Setter {
    }

    public static interface Put
    extends Setter {
        public Put data(Map<String, Object> var1);
    }

    public static interface Delete
    extends Setter {
    }

    public static interface Operator {
        public Setter noop();

        public Put update();

        public Delete delete();
    }

    public static class DumpConf
    implements Model {
        long snapshotCreatedWaitTimeSec;

        public long getSnapshotCreatedWaitTimeSec() {
            return this.snapshotCreatedWaitTimeSec;
        }

        public void setSnapshotCreatedWaitTimeSec(long snapshotCreatedWaitTimeSec) {
            this.snapshotCreatedWaitTimeSec = snapshotCreatedWaitTimeSec;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof DumpConf)) {
                return false;
            }
            DumpConf other = (DumpConf)o;
            if (!other.canEqual(this)) {
                return false;
            }
            return this.getSnapshotCreatedWaitTimeSec() == other.getSnapshotCreatedWaitTimeSec();
        }

        protected boolean canEqual(Object other) {
            return other instanceof DumpConf;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $snapshotCreatedWaitTimeSec = this.getSnapshotCreatedWaitTimeSec();
            result = result * 59 + (int)($snapshotCreatedWaitTimeSec >>> 32 ^ $snapshotCreatedWaitTimeSec);
            return result;
        }

        public String toString() {
            return "LemonEngine.DumpConf(snapshotCreatedWaitTimeSec=" + this.getSnapshotCreatedWaitTimeSec() + ")";
        }
    }

    public static class Options
    implements Model {
        String route;

        public static Options fromRoute(String route) {
            Options options = new Options();
            options.setRoute(route);
            return options;
        }

        public String getRoute() {
            return this.route;
        }

        public void setRoute(String route) {
            this.route = route;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Options)) {
                return false;
            }
            Options other = (Options)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$route = this.getRoute();
            String other$route = other.getRoute();
            return !(this$route == null ? other$route != null : !this$route.equals(other$route));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Options;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $route = this.getRoute();
            result = result * 59 + ($route == null ? 43 : $route.hashCode());
            return result;
        }

        public String toString() {
            return "LemonEngine.Options(route=" + this.getRoute() + ")";
        }
    }

    public static interface CompareAndSet {
        public Setter test(GetResult var1, Operator var2);
    }

    public static interface DeleteResult {
        public boolean exists();

        public boolean deleted();

        public String key();

        public long vcc();
    }

    public static interface GetResult {
        public boolean exists();

        public String key();

        public Map<String, Object> value();

        public long vcc();

        public <T> T get(String var1, Class<T> var2);
    }

    public static interface PutResult {
        public boolean updated();

        public boolean created();

        public String key();

        public long vcc();
    }

    public static interface SearchContext {
        public void cancel();
    }

    public static interface SearchListener {
        public void onRow(GetResult var1, SearchContext var2);
    }

    public static interface CompareAndSetResult {
        public PutResult updated();

        public DeleteResult deleted();

        public boolean noop();
    }
}

