/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.kv;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.KeyLockLock;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public interface CacheServiceV2<K extends Comparable<?>> {
    public static <K extends Comparable<?>> CacheServiceV2<K> impl() {
        return new SimpleCacheServiceV2();
    }

    public <V> V get(K var1);

    public <V> GetResult<V> checkExistsAndGet(K var1);

    public <V> V remove(K var1);

    public <V> GetResult<V> checkExistsAndRemove(K var1);

    public boolean contains(K var1);

    public boolean isEmpty();

    public int size();

    public void clear();

    public void shutdown();

    public <V> V putIfAbsentAndGet(K var1, Supplier<V> var2);

    public <V> PutResult<V> putAndGet(K var1, Function<V, V> var2);

    public void forEach(BiConsumer<K, Object> var1);

    public static class SimpleCacheServiceV2<K extends Comparable<?>>
    implements CacheServiceV2<K>,
    Closeable {
        private static final Logger log = LoggerFactory.getLogger(SimpleCacheServiceV2.class);
        private final Map<K, Entry<K>> repo = new ConcurrentHashMap<K, Entry<K>>();
        private final KeyLockLock keyLockLock = new KeyLockLock();

        private SimpleCacheServiceV2() {
        }

        @Override
        public void close() {
            try {
                this.shutdown();
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException(e);
            }
        }

        private <V> V getAndCreateEntry0(K key, V object) {
            Objects.requireNonNull(key);
            Entry entry = new Entry();
            entry.key = key;
            entry.value = object;
            entry.startMilli = System.currentTimeMillis();
            Entry old = this.repo.put(key, entry);
            return (V)(old == null ? null : old.value);
        }

        @Override
        public <V> V get(K key) {
            Entry<K> entry = this.repo.get(key);
            if (entry != null) {
                return (V)entry.getValue();
            }
            return null;
        }

        @Override
        public <V> GetResult<V> checkExistsAndGet(K key) {
            Entry<K> entry = this.repo.get(key);
            if (entry != null) {
                return new GetResultImpl<Object>(true, entry.getValue());
            }
            return new GetResultImpl<Object>(false, null);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> V remove(K key) {
            Entry<K> entry = this.repo.get(key);
            if (entry == null) {
                return null;
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)entry.getKey());){
                entry = this.repo.remove(key);
                if (entry == null) return null;
                Object object = entry.getValue();
                return (V)object;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> GetResult<V> checkExistsAndRemove(K key) {
            Entry<K> entry = this.repo.get(key);
            if (entry == null) {
                return new GetResultImpl<Object>(false, null);
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)entry.getKey());){
                entry = this.repo.remove(key);
                if (entry != null) {
                    GetResultImpl<Object> getResultImpl2 = new GetResultImpl<Object>(true, entry.getValue());
                    return getResultImpl2;
                }
                GetResultImpl<Object> getResultImpl = new GetResultImpl<Object>(false, null);
                return getResultImpl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public boolean contains(K key) {
            return this.repo.containsKey(key);
        }

        @Override
        public boolean isEmpty() {
            return this.repo.isEmpty();
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> V putIfAbsentAndGet(K key, Supplier<V> func) {
            Objects.requireNonNull(key);
            V v = this.get(key);
            if (v != null) {
                return v;
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                v = this.get(key);
                if (v != null) {
                    V v2 = v;
                    return v2;
                }
                V object = func.get();
                this.getAndCreateEntry0(key, object);
                V v3 = object;
                return v3;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> PutResult<V> putAndGet(K key, Function<V, V> func) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K> entry = this.repo.get(key);
                if (entry == null) {
                    V applied = func.apply(null);
                    V v = this.getAndCreateEntry0(key, applied);
                    PutResultImpl<Object> putResultImpl2 = new PutResultImpl<Object>(false, true, null, v);
                    return putResultImpl2;
                }
                Object old = entry.getValue();
                V applied = func.apply(entry.getValue());
                entry.setValue(applied);
                PutResultImpl<Object> putResultImpl = new PutResultImpl<Object>(true, false, old, applied);
                return putResultImpl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public void forEach(BiConsumer<K, Object> action) {
            this.repo.forEach((? super K key, ? super V entry) -> action.accept(key, entry.getValue()));
        }

        @Override
        public void shutdown() {
            this.repo.clear();
        }

        @Override
        public int size() {
            return this.repo.size();
        }

        @Override
        public void clear() {
            this.repo.clear();
        }

        private static class Entry<K extends Comparable<?>> {
            private K key;
            private Object value;
            private long startMilli;
            private volatile long vcc;

            public K getKey() {
                return this.key;
            }

            public Object getValue() {
                return this.value;
            }

            public long getStartMilli() {
                return this.startMilli;
            }

            public long getVcc() {
                return this.vcc;
            }

            public void setKey(K key) {
                this.key = key;
            }

            public void setValue(Object value) {
                this.value = value;
            }

            public void setStartMilli(long startMilli) {
                this.startMilli = startMilli;
            }

            public void setVcc(long vcc) {
                this.vcc = vcc;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getStartMilli() != other.getStartMilli()) {
                    return false;
                }
                if (this.getVcc() != other.getVcc()) {
                    return false;
                }
                K this$key = this.getKey();
                K other$key = other.getKey();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                Object this$value = this.getValue();
                Object other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $startMilli = this.getStartMilli();
                result = result * 59 + (int)($startMilli >>> 32 ^ $startMilli);
                long $vcc = this.getVcc();
                result = result * 59 + (int)($vcc >>> 32 ^ $vcc);
                K $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                Object $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "CacheServiceV2.SimpleCacheServiceV2.Entry(key=" + this.getKey() + ", value=" + this.getValue() + ", startMilli=" + this.getStartMilli() + ", vcc=" + this.getVcc() + ")";
            }
        }
    }

    public static class PutResultImpl<V>
    implements PutResult<V> {
        final boolean updated;
        final boolean created;
        final V preValue;
        final V value;

        PutResultImpl(boolean updated, boolean created, V preValue, V value) {
            this.updated = updated;
            this.created = created;
            this.preValue = preValue;
            this.value = value;
        }

        @Override
        public boolean updated() {
            return this.updated;
        }

        @Override
        public boolean created() {
            return this.created;
        }

        @Override
        public V preValue() {
            return this.preValue;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    public static class GetResultImpl<V>
    implements GetResult<V> {
        final boolean exists;
        final V value;

        GetResultImpl(boolean exists, V value) {
            this.exists = exists;
            this.value = value;
        }

        @Override
        public boolean exists() {
            return this.exists;
        }

        @Override
        public V value() {
            return this.value;
        }
    }

    public static interface GetResult<V> {
        public boolean exists();

        public V value();
    }

    public static interface PutResult<V> {
        public boolean updated();

        public boolean created();

        public V preValue();

        public V value();
    }
}

