/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.kv;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.KeyLockLock;
import com.ovopark.kernel.shared.delay.DelayTask;
import com.ovopark.kernel.shared.delay.TimingWheel;
import com.ovopark.kernel.shared.kv.CacheServiceV2;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public interface TtlCacheServiceV2<K extends Comparable<?>>
extends CacheServiceV2<K> {
    public static <K extends Comparable<?>> TtlCacheServiceV2<K> impl() {
        return new SimpleTtlCacheServiceV2();
    }

    public static <K extends Comparable<?>> TtlCacheServiceV2<K> impl(int timeoutMs) {
        return new SimpleTtlCacheServiceV2(timeoutMs);
    }

    public static StringTtlCacheServiceV2 staticTtl() {
        return StringTtlCacheServiceV2.GLOBAL_IMPL;
    }

    public <V> V putIfAbsentAndGet(K var1, Supplier<V> var2, long var3, TimeUnit var5);

    public <V> V leaseAndGet(K var1, Function<V, V> var2, long var3, TimeUnit var5);

    public <V> V getAndLease(K var1, Function<V, V> var2, long var3, TimeUnit var5);

    public <V> CacheServiceV2.PutResult<V> putAndGet(K var1, Function<V, V> var2, long var3, TimeUnit var5);

    public TtlCacheServiceV2<K> subscribeTtl(Predicate<K> var1, TtlListener<K> var2);

    public static class SimpleTtlCacheServiceV2<K extends Comparable<?>>
    implements TtlCacheServiceV2<K>,
    Closeable {
        private static final Logger log = LoggerFactory.getLogger(SimpleTtlCacheServiceV2.class);
        private final Map<K, Entry<K>> repo = new ConcurrentHashMap<K, Entry<K>>();
        private final Map<Predicate<K>, TtlListener<K>> ttlCallBackMap = new ConcurrentHashMap<Predicate<K>, TtlListener<K>>();
        private final KeyLockLock keyLockLock = new KeyLockLock();
        private final TimingWheel timingWheel;
        private final ExecutorService breakDeadLock;

        private SimpleTtlCacheServiceV2() {
            this(1000);
        }

        private SimpleTtlCacheServiceV2(int timeoutMs) {
            this(timeoutMs, 1);
        }

        private SimpleTtlCacheServiceV2(int timeoutMs, int threadCount) {
            this.breakDeadLock = Util.defaultExecutorService("ttl-" + Util.uniqueFirstPart(), threadCount, threadCount, Integer.MAX_VALUE, new ThreadPoolExecutor.AbortPolicy());
            this.timingWheel = new TimingWheel(this.toString(), 1, 20, Math.max(timeoutMs, 100), null);
        }

        @Override
        public void close() {
            try {
                this.shutdown();
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException(e);
            }
        }

        private <V> V getAndCreateEntry0(K key, V object, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            long expired = time > 0L ? timeUnit.toMillis(time) : 0L;
            Entry entry = new Entry();
            entry.key = key;
            entry.value = object;
            entry.startMilli = System.currentTimeMillis();
            entry.expiredMilli = expired > 0L ? expired : Integer.MAX_VALUE;
            Entry old = this.repo.put(key, entry);
            if (expired > 0L) {
                TTLEntry ttlEntry = new TTLEntry(this, key, entry.startMilli + entry.expiredMilli, entry.expiredVcc);
                this.timingWheel.delay(ttlEntry);
            }
            return (V)(old == null ? null : old.value);
        }

        @Override
        public <V> V get(K key) {
            Entry<K> entry = this.repo.get(key);
            if (entry != null) {
                long now = System.currentTimeMillis();
                if (now - ((Entry)entry).startMilli > ((Entry)entry).expiredMilli) {
                    return null;
                }
                return (V)entry.getValue();
            }
            return null;
        }

        @Override
        public <V> CacheServiceV2.GetResult<V> checkExistsAndGet(K key) {
            Entry<K> entry = this.repo.get(key);
            if (entry != null) {
                long now = System.currentTimeMillis();
                if (now - ((Entry)entry).startMilli > ((Entry)entry).expiredMilli) {
                    return new CacheServiceV2.GetResultImpl<Object>(false, null);
                }
                return new CacheServiceV2.GetResultImpl<Object>(true, entry.getValue());
            }
            return new CacheServiceV2.GetResultImpl<Object>(false, null);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> V remove(K key) {
            Entry<K> entry = this.repo.get(key);
            if (entry == null) {
                return null;
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)entry.getKey());){
                entry = this.repo.remove(key);
                if (entry == null) return null;
                Object object = entry.getValue();
                return (V)object;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> CacheServiceV2.GetResult<V> checkExistsAndRemove(K key) {
            Entry<K> entry = this.repo.get(key);
            if (entry == null) {
                return new CacheServiceV2.GetResultImpl<Object>(false, null);
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)entry.getKey());){
                entry = this.repo.remove(key);
                if (entry != null) {
                    CacheServiceV2.GetResultImpl<Object> getResultImpl2 = new CacheServiceV2.GetResultImpl<Object>(true, entry.getValue());
                    return getResultImpl2;
                }
                CacheServiceV2.GetResultImpl<Object> getResultImpl = new CacheServiceV2.GetResultImpl<Object>(false, null);
                return getResultImpl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public boolean contains(K key) {
            return this.repo.containsKey(key);
        }

        @Override
        public boolean isEmpty() {
            return this.repo.isEmpty();
        }

        @Override
        public <V> V putIfAbsentAndGet(K key, Supplier<V> func) {
            return this.putIfAbsentAndGet(key, func, -1L, TimeUnit.SECONDS);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> V putIfAbsentAndGet(K key, Supplier<V> func, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            V v = this.get(key);
            if (v != null) {
                return v;
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                v = this.get(key);
                if (v != null) {
                    V v2 = v;
                    return v2;
                }
                V object = func.get();
                this.getAndCreateEntry0(key, object, time, timeUnit);
                V v3 = object;
                return v3;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> V leaseAndGet(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K> entry = this.repo.get(key);
                if (entry == null) {
                    V applied = func.apply(null);
                    this.getAndCreateEntry0(key, applied, time, timeUnit);
                    V v = applied;
                    return v;
                }
                entry.setValue(func.apply(entry.getValue()));
                entry.setStartMilli(System.currentTimeMillis());
                entry.setExpiredMilli(timeUnit.toMillis(time));
                ((Entry)entry).expiredVcc++;
                TTLEntry ttlEntry = new TTLEntry(this, key, ((Entry)entry).startMilli + ((Entry)entry).expiredMilli, ((Entry)entry).expiredVcc);
                this.timingWheel.delay(ttlEntry);
                Object object = entry.getValue();
                return (V)object;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> V getAndLease(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K> entry = this.repo.get(key);
                if (entry == null) {
                    V applied = func.apply(null);
                    this.getAndCreateEntry0(key, applied, time, timeUnit);
                    V v = null;
                    return v;
                }
                Object oldValue = entry.getValue();
                entry.setValue(func.apply(oldValue));
                entry.setStartMilli(System.currentTimeMillis());
                entry.setExpiredMilli(timeUnit.toMillis(time));
                ((Entry)entry).expiredVcc++;
                TTLEntry ttlEntry = new TTLEntry(this, key, ((Entry)entry).startMilli + ((Entry)entry).expiredMilli, ((Entry)entry).expiredVcc);
                this.timingWheel.delay(ttlEntry);
                Object object = oldValue;
                return (V)object;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public <V> CacheServiceV2.PutResult<V> putAndGet(K key, Function<V, V> func) {
            return this.putAndGet(key, func, -1L, TimeUnit.SECONDS);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> CacheServiceV2.PutResult<V> putAndGet(K key, Function<V, V> func, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                Entry<K> entry = this.repo.get(key);
                if (entry == null) {
                    V applied = func.apply(null);
                    this.getAndCreateEntry0(key, applied, time, timeUnit);
                    CacheServiceV2.PutResultImpl<Object> putResultImpl2 = new CacheServiceV2.PutResultImpl<Object>(false, true, null, applied);
                    return putResultImpl2;
                }
                Object old = entry.getValue();
                V applied = func.apply(entry.getValue());
                entry.setValue(applied);
                CacheServiceV2.PutResultImpl<Object> putResultImpl = new CacheServiceV2.PutResultImpl<Object>(true, false, old, applied);
                return putResultImpl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public SimpleTtlCacheServiceV2<K> subscribeTtl(Predicate<K> predicate, TtlListener<K> ttlListener) {
            this.ttlCallBackMap.put(predicate, ttlListener);
            return this;
        }

        @Override
        public void shutdown() {
            try {
                this.timingWheel.shutdown();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            try {
                if (this.breakDeadLock != null) {
                    this.breakDeadLock.shutdown();
                }
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
            }
            this.repo.clear();
        }

        @Override
        public int size() {
            return this.repo.size();
        }

        @Override
        public void clear() {
            this.repo.clear();
        }

        @Override
        public void forEach(BiConsumer<K, Object> action) {
            this.repo.forEach((? super K key, ? super V entry) -> action.accept(key, entry.getValue()));
        }

        private static class Entry<K extends Comparable<?>> {
            private K key;
            private Object value;
            private long startMilli;
            private long expiredMilli;
            private volatile long expiredVcc;

            public K getKey() {
                return this.key;
            }

            public Object getValue() {
                return this.value;
            }

            public long getStartMilli() {
                return this.startMilli;
            }

            public long getExpiredMilli() {
                return this.expiredMilli;
            }

            public long getExpiredVcc() {
                return this.expiredVcc;
            }

            public void setKey(K key) {
                this.key = key;
            }

            public void setValue(Object value) {
                this.value = value;
            }

            public void setStartMilli(long startMilli) {
                this.startMilli = startMilli;
            }

            public void setExpiredMilli(long expiredMilli) {
                this.expiredMilli = expiredMilli;
            }

            public void setExpiredVcc(long expiredVcc) {
                this.expiredVcc = expiredVcc;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getStartMilli() != other.getStartMilli()) {
                    return false;
                }
                if (this.getExpiredMilli() != other.getExpiredMilli()) {
                    return false;
                }
                if (this.getExpiredVcc() != other.getExpiredVcc()) {
                    return false;
                }
                K this$key = this.getKey();
                K other$key = other.getKey();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                Object this$value = this.getValue();
                Object other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $startMilli = this.getStartMilli();
                result = result * 59 + (int)($startMilli >>> 32 ^ $startMilli);
                long $expiredMilli = this.getExpiredMilli();
                result = result * 59 + (int)($expiredMilli >>> 32 ^ $expiredMilli);
                long $expiredVcc = this.getExpiredVcc();
                result = result * 59 + (int)($expiredVcc >>> 32 ^ $expiredVcc);
                K $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                Object $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "TtlCacheServiceV2.SimpleTtlCacheServiceV2.Entry(key=" + this.getKey() + ", value=" + this.getValue() + ", startMilli=" + this.getStartMilli() + ", expiredMilli=" + this.getExpiredMilli() + ", expiredVcc=" + this.getExpiredVcc() + ")";
            }
        }

        private class TTLEntry
        implements DelayTask {
            private final K key;
            private final long triggerTime;
            private final long vcc;
            final /* synthetic */ SimpleTtlCacheServiceV2 this$0;

            /*
             * WARNING - Possible parameter corruption
             * WARNING - void declaration
             */
            public TTLEntry(K vcc, long l2, long l3) {
                void key;
                this.this$0 = (SimpleTtlCacheServiceV2)l;
                this.key = key;
                this.triggerTime = triggerTime;
                this.vcc = (long)vcc;
            }

            @Override
            public long triggerTimeMs() {
                return this.triggerTime;
            }

            public K taskId() {
                return this.key;
            }

            @Override
            public Runnable task() {
                return new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TTLEntry.this.this$0.breakDeadLock.execute(Util.catchRunnable(() -> {
                                boolean removedFlag = false;
                                Entry entry = (Entry)TTLEntry.this.this$0.repo.get(TTLEntry.this.key);
                                if (entry != null && entry.expiredVcc == TTLEntry.this.vcc) {
                                    try (KeyLockLock.KeyLock lock = TTLEntry.this.this$0.keyLockLock.lock((Comparable<?>)entry.getKey());){
                                        entry = (Entry)TTLEntry.this.this$0.repo.get(TTLEntry.this.key);
                                        if (entry != null && entry.expiredVcc == TTLEntry.this.vcc) {
                                            TTLEntry.this.this$0.repo.remove(TTLEntry.this.key);
                                            removedFlag = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        throw Util.convert2RuntimeException(e);
                                    }
                                }
                                if (removedFlag && !TTLEntry.this.this$0.ttlCallBackMap.isEmpty()) {
                                    for (Map.Entry ttlCallBackEntry : TTLEntry.this.this$0.ttlCallBackMap.entrySet()) {
                                        Predicate predicate = (Predicate)ttlCallBackEntry.getKey();
                                        try {
                                            if (!predicate.test(entry.key)) continue;
                                            ((TtlListener)ttlCallBackEntry.getValue()).onTtl(entry.key, entry.value, entry.startMilli, entry.expiredMilli);
                                        }
                                        catch (Exception e) {
                                            log.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                }
                            }));
                        }
                        catch (RejectedExecutionException e) {
                            log.warn("ttl reject task id: " + TTLEntry.this.taskId() + ", trigger time: " + Util.formatTime(Util.dateTime(TTLEntry.this.triggerTime), new String[0]) + ", vcc: " + TTLEntry.this.vcc);
                        }
                    }
                };
            }
        }
    }

    public static class StringTtlCacheServiceV2
    extends SimpleTtlCacheServiceV2<String> {
        private static final StringTtlCacheServiceV2 GLOBAL_IMPL = new StringTtlCacheServiceV2();

        private StringTtlCacheServiceV2() {
            super(1000, 4);
        }
    }

    public static interface TtlListener<K extends Comparable<?>> {
        public void onTtl(K var1, Object var2, long var3, long var5);
    }
}

