/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared;

import com.ovopark.kernel.shared.Util;
import java.util.Comparator;
import java.util.PriorityQueue;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ShutdownManager {
    private static final Logger log = LoggerFactory.getLogger(ShutdownManager.class);
    private static final ShutdownManager INSTANCE = new ShutdownManager();
    private final PriorityQueue<ClearRunnable> list = new PriorityQueue<ClearRunnable>(Comparator.comparing(ClearRunnable::getPriority));
    private final AtomicBoolean registered = new AtomicBoolean(false);

    private ShutdownManager() {
    }

    public static ShutdownManager getOrCreate() {
        return INSTANCE;
    }

    public synchronized void register(String name, Util.CatchRunnable catchRunnable) {
        this.register(name, catchRunnable, 0);
    }

    public synchronized void register(String name, Util.CatchRunnable catchRunnable, int priority) {
        if (this.registered.get()) {
            throw new IllegalStateException("cannot register a new shutdown hook ,as we have already registered hook in JVM");
        }
        ClearRunnable clearRunnable = new ClearRunnable();
        clearRunnable.setPriority(priority);
        clearRunnable.setName(name);
        clearRunnable.setCatchRunnable(catchRunnable);
        this.list.add(clearRunnable);
    }

    public synchronized void register2JVMHook() {
        if (this.registered.compareAndSet(false, true)) {
            Runnable r = Util.catchRunnable(new Util.CatchRunnable(){

                @Override
                public void run() throws Exception {
                    int size = ShutdownManager.this.list.size();
                    ThreadPoolExecutor shutdownHookExecutor = new ThreadPoolExecutor(size, size, 600L, TimeUnit.SECONDS, new ArrayBlockingQueue<Runnable>(1), Util.newThreadFactory("shutdown-hook-shared"), Util.awaitThreadActive(10L));
                    log.info("to execute shutdown hook, count: " + size);
                    for (final ClearRunnable clearRunnable : ShutdownManager.this.list) {
                        if (!clearRunnable.done.compareAndSet(false, true)) continue;
                        shutdownHookExecutor.execute(Util.catchRunnable(new Util.CatchRunnable(){

                            @Override
                            public void run() throws Exception {
                                try {
                                    log.info("to execute shutdown hook: " + clearRunnable.getName());
                                    clearRunnable.getCatchRunnable().run();
                                    log.info("shutdown hook completed: " + clearRunnable.getName());
                                }
                                catch (Exception e) {
                                    log.error(e.getMessage(), (Throwable)e);
                                }
                            }
                        }));
                    }
                    log.info("all shutdown hooks are submitted to executor.");
                }
            });
            Thread thread = new Thread(r);
            Runtime.getRuntime().addShutdownHook(thread);
        } else {
            log.warn("already register hook in JVM");
        }
    }

    public void submitPerThread(Util.CatchRunnable catchRunnable) {
        Thread thread = new Thread(Util.catchRunnable(catchRunnable));
        thread.start();
    }

    public synchronized void shutdownAsync() {
        Runnable r = Util.catchRunnable(new Util.CatchRunnable(){

            @Override
            public void run() throws Exception {
                log.info("shutdownAsync: to execute shutdown hook");
                for (ClearRunnable clearRunnable : ShutdownManager.this.list) {
                    if (!clearRunnable.done.compareAndSet(false, true)) continue;
                    try {
                        log.info("shutdownAsync: to execute shutdown hook: " + clearRunnable.getName());
                        clearRunnable.getCatchRunnable().run();
                        log.info("shutdownAsync: shutdown hook completed: " + clearRunnable.getName());
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
                log.info("shutdownAsync: all shutdown hooks are completed.");
            }
        });
        Thread thread = new Thread(r);
        thread.start();
    }

    static class ClearRunnable {
        private String name;
        private int priority;
        private Util.CatchRunnable catchRunnable;
        private final AtomicBoolean done = new AtomicBoolean(false);

        public String getName() {
            return this.name;
        }

        public int getPriority() {
            return this.priority;
        }

        public Util.CatchRunnable getCatchRunnable() {
            return this.catchRunnable;
        }

        public AtomicBoolean getDone() {
            return this.done;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setPriority(int priority) {
            this.priority = priority;
        }

        public void setCatchRunnable(Util.CatchRunnable catchRunnable) {
            this.catchRunnable = catchRunnable;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ClearRunnable)) {
                return false;
            }
            ClearRunnable other = (ClearRunnable)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getPriority() != other.getPriority()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            Util.CatchRunnable this$catchRunnable = this.getCatchRunnable();
            Util.CatchRunnable other$catchRunnable = other.getCatchRunnable();
            if (this$catchRunnable == null ? other$catchRunnable != null : !this$catchRunnable.equals(other$catchRunnable)) {
                return false;
            }
            AtomicBoolean this$done = this.getDone();
            AtomicBoolean other$done = other.getDone();
            return !(this$done == null ? other$done != null : !this$done.equals(other$done));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ClearRunnable;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPriority();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            Util.CatchRunnable $catchRunnable = this.getCatchRunnable();
            result = result * 59 + ($catchRunnable == null ? 43 : $catchRunnable.hashCode());
            AtomicBoolean $done = this.getDone();
            result = result * 59 + ($done == null ? 43 : $done.hashCode());
            return result;
        }

        public String toString() {
            return "ShutdownManager.ClearRunnable(name=" + this.getName() + ", priority=" + this.getPriority() + ", catchRunnable=" + this.getCatchRunnable() + ", done=" + this.getDone() + ")";
        }
    }
}

