/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.concurrent;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.ListenerFuture;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.CancellationException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;

class ListenerFutureImpl<V>
implements ListenerFuture.ListenerFutureSetter<V> {
    private List<ListenerFuture.Listener<V>> listenerList;
    V value;
    private boolean cancelled;
    private boolean completed;
    private Throwable t;
    final ReentrantLock reentrantLock = new ReentrantLock();
    final Condition condition = this.reentrantLock.newCondition();

    ListenerFutureImpl() {
    }

    @Override
    public final void setValueAndNotify(V value, Throwable t) {
        this.reentrantLock.lock();
        try {
            if (this.cancelled || this.completed || this.t != null) {
                return;
            }
            this.value = value;
            this.t = t;
            this.completed = t == null;
            this.condition.signalAll();
            if (Util.isNotEmpty(this.listenerList)) {
                this.notifyAllListeners(value, t);
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public final void cancelAndNotify() {
        this.reentrantLock.lock();
        try {
            if (this.cancelled || this.completed || this.t != null) {
                return;
            }
            this.cancelled = true;
            this.condition.signalAll();
            if (Util.isNotEmpty(this.listenerList)) {
                this.notifyAllListeners(this.value, new CancellationException());
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    private void notifyAllListeners(V value, Throwable t) {
        for (ListenerFuture.Listener<V> listener : this.listenerList) {
            listener.onResult(value, t);
        }
    }

    @Override
    public final V get() throws InterruptedException, ExecutionException {
        this.reentrantLock.lock();
        try {
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.t != null) {
                throw new RuntimeException(this.t);
            }
            if (this.completed) {
                V v = this.value;
                return v;
            }
            this.condition.await();
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.t != null) {
                throw new RuntimeException(this.t);
            }
            if (this.completed) {
                V v = this.value;
                return v;
            }
            try {
                throw new IllegalStateException("unreachable code , error???");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public final V get(long timeout, TimeUnit timeUnit) throws InterruptedException, ExecutionException, TimeoutException {
        this.reentrantLock.lock();
        try {
            boolean f;
            if (this.cancelled) {
                throw new CancellationException();
            }
            if (this.t != null) {
                throw new RuntimeException(this.t);
            }
            if (this.completed) {
                V v = this.value;
                return v;
            }
            try {
                f = this.condition.await(timeout, timeUnit);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw e;
            }
            if (f) {
                if (this.cancelled) {
                    throw new CancellationException();
                }
                if (this.t != null) {
                    throw new RuntimeException(this.t);
                }
                if (this.completed) {
                    V v = this.value;
                    return v;
                }
                throw new IllegalStateException("unreachable code , error???");
            }
            throw new TimeoutException("timeout, ms: " + timeUnit.toSeconds(timeout));
        }
        finally {
            this.reentrantLock.unlock();
        }
    }

    @Override
    public final boolean isCancelled() {
        return this.cancelled;
    }

    @Override
    public boolean isDone() {
        return this.cancelled || this.completed || this.t != null;
    }

    @Override
    public final boolean cancel(boolean mayInterruptIfRunning) {
        this.cancelAndNotify();
        return true;
    }

    @Override
    public final void addListener(ListenerFuture.Listener<V> listener) {
        this.reentrantLock.lock();
        try {
            if (Util.isEmpty(this.listenerList)) {
                this.listenerList = new ArrayList<ListenerFuture.Listener<V>>();
            }
            this.listenerList.add(listener);
            if (this.cancelled) {
                if (Util.isNotEmpty(this.listenerList)) {
                    this.notifyAllListeners(this.value, new CancellationException());
                }
                return;
            }
            if (this.completed || this.t != null) {
                if (Util.isNotEmpty(this.listenerList)) {
                    this.notifyAllListeners(this.value, this.t);
                }
                return;
            }
        }
        finally {
            this.reentrantLock.unlock();
        }
    }
}

