/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared;

import com.ovopark.kernel.shared.CachedExecutors;
import com.ovopark.kernel.shared.Config;
import com.ovopark.kernel.shared.kv.CacheService;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Consumer;
import java.util.function.Function;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface Processing {
    public static final int trace_length = Config.ConfigPriority.option().getInt("shared.jdk8.module.processing.traceLength", 10);
    public static final int expiredTimeSec = Config.ConfigPriority.option().getInt("shared.jdk8.module.processing.expiredTimeSec", 180);

    public Processing tag(String var1);

    public String tag();

    public Processing link(Object var1);

    public Object link();

    public void trace(String var1);

    public void forEach(Consumer<String> var1);

    public static Processing start(String id, int expiredTimeSec) {
        return ProcessingImpl.from(id, trace_length, expiredTimeSec);
    }

    public static Processing start(String id) {
        return Processing.start(id, expiredTimeSec);
    }

    public static Processing get(String id) {
        return ProcessingImpl.get(id);
    }

    public static int count() {
        Map backend = (Map)ProcessingImpl.cache.backend();
        return backend.size();
    }

    public static class ProcessingImpl
    implements Processing {
        private static final Logger log = LoggerFactory.getLogger(ProcessingImpl.class);
        private final String id;
        private final int size;
        private final List<String> list;
        private final AtomicLong index = new AtomicLong(0L);
        private String tag;
        private Object link;
        private static final CacheService<String, ProcessingImpl> cache = new CacheService.MapCacheService<String, ProcessingImpl>(true, CachedExecutors.impl("processing", 1, 1), (entry, startTime, scanTime, expiredTime) -> log.info("processing is removed: " + entry.getKey()), 3);
        private final int expiredTimeSec;

        private ProcessingImpl(String id, int size, int expiredTimeSec) {
            this.id = id;
            this.size = size;
            this.expiredTimeSec = expiredTimeSec;
            this.list = new ArrayList<String>(size);
            for (int i = 0; i < size; ++i) {
                this.list.add(null);
            }
        }

        static ProcessingImpl from(String id, int size, int expiredTimeSec) {
            return cache.updateAndGet(id, processing -> new ProcessingImpl(id, size, expiredTimeSec), expiredTimeSec, TimeUnit.SECONDS);
        }

        static ProcessingImpl get(String id) {
            return cache.get(id);
        }

        @Override
        public void trace(final String content) {
            cache.getAndUpdate(this.id, new Function<ProcessingImpl, ProcessingImpl>(){

                @Override
                public ProcessingImpl apply(ProcessingImpl processing) {
                    if (processing == null) {
                        processing = this;
                    }
                    processing.list.set((int)(index.getAndIncrement() % (long)size), content);
                    return processing;
                }
            }, this.expiredTimeSec, TimeUnit.SECONDS, true);
        }

        @Override
        public void forEach(Consumer<String> consumer) {
            int i;
            int j;
            for (j = i = (int)(this.index.get() % (long)this.size); j < this.list.size(); ++j) {
                consumer.accept(this.list.get(j));
            }
            for (j = 0; j < i; ++j) {
                consumer.accept(this.list.get(j));
            }
        }

        @Override
        public Processing tag(final String tag) {
            cache.getAndUpdate(this.id, new Function<ProcessingImpl, ProcessingImpl>(){

                @Override
                public ProcessingImpl apply(ProcessingImpl processing) {
                    if (processing == null) {
                        processing = this;
                    }
                    processing.tag = tag;
                    return processing;
                }
            }, this.expiredTimeSec, TimeUnit.SECONDS, true);
            return this;
        }

        @Override
        public String tag() {
            return this.tag;
        }

        @Override
        public Processing link(final Object link) {
            cache.getAndUpdate(this.id, new Function<ProcessingImpl, ProcessingImpl>(){

                @Override
                public ProcessingImpl apply(ProcessingImpl processing) {
                    if (processing == null) {
                        processing = this;
                    }
                    processing.link = link;
                    return processing;
                }
            }, this.expiredTimeSec, TimeUnit.SECONDS, true);
            return this;
        }

        @Override
        public Object link() {
            return this.link;
        }
    }
}

