/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.stream.log;

import com.ovopark.kernel.shared.JSONAccessor;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.TextStream;
import com.ovopark.kernel.shared.stream.log.LogFileManager;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.time.LocalDateTime;
import java.util.Optional;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ThreadFactory;
import java.util.function.Consumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class LogWorker
implements AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(LogWorker.class);
    public static final int MAX_LINE_COUNT = 10000;
    private final String filePath;
    private final TextStream.NewLinePredicate newLinePredicate;
    private final TextStream.FileEntrySupplier.FileSyncConfFsync fileSyncConfFsync;
    private final TextStream.FileEntrySupplier.FileSyncConfFsyncListener fileSyncConfFsyncListener;
    private final LogFileManager logFileManager;
    private final ExecutorService executorService;

    public LogWorker(final String filePath, TextStream.NewLinePredicate newLinePredicate, TextStream.FileEntrySupplier.FileSyncConfFsync fileSyncConfFsync, TextStream.FileEntrySupplier.FileSyncConfFsyncListener fileSyncConfFsyncListener, LogFileManager logFileManager) {
        this.filePath = filePath;
        this.newLinePredicate = newLinePredicate;
        this.fileSyncConfFsync = fileSyncConfFsync;
        this.fileSyncConfFsyncListener = fileSyncConfFsyncListener;
        this.logFileManager = logFileManager;
        this.executorService = Executors.newFixedThreadPool(1, new ThreadFactory(){

            @Override
            public Thread newThread(Runnable r) {
                return new Thread(r, filePath);
            }
        });
    }

    public LogWorker(String filePath, TextStream.FileEntrySupplier.FileSyncConfFsync fileSyncConfFsync, TextStream.FileEntrySupplier.FileSyncConfFsyncListener fileSyncConfFsyncListener, LogFileManager logFileManager) {
        this(filePath, LogWorker.defaultNewLinePredicate(), fileSyncConfFsync, fileSyncConfFsyncListener, logFileManager);
    }

    private static TextStream.NewLinePredicate defaultNewLinePredicate() {
        return s -> true;
    }

    public void start(final Consumer<LogLine> consumer) {
        this.start(new CoreSubscriber<LogLine>(){

            @Override
            public void onNext(LogLine record) {
                consumer.accept(record);
            }
        });
    }

    public void start(CoreSubscriber<LogLine> subscriber) {
        TextStream textStream = null;
        if (this.filePath.endsWith(".gz")) {
            textStream = TextStream.fromGZIP(this.filePath, this.fileSyncConfFsync, this.fileSyncConfFsyncListener);
        } else {
            TextStream.ContinueGet continueGet = (lastGetCount, file, event) -> {
                if (event == TextStream.Event.EOF) {
                    return !this.logFileManager.isRollover(file);
                }
                return true;
            };
            textStream = TextStream.from(this.filePath, continueGet, this.fileSyncConfFsync, this.fileSyncConfFsyncListener);
        }
        ((TextStream)((TextStream)((TextStream)textStream.mergeLine(this.newLinePredicate, 10000).map(line -> {
            LogLine logLine = new LogLine();
            logLine.setLine((TextStream.Line)line);
            logLine.setFilePath(this.filePath);
            return logLine;
        })).onErrorStop()).subscribeOn(Util.wrap(this.executorService))).subscribe(subscriber);
    }

    @Override
    public void close() throws Exception {
        this.executorService.shutdown();
    }

    public boolean isClosed() {
        return this.executorService.isShutdown() || this.executorService.isTerminated();
    }

    public static class LogLine {
        private TextStream.Line line;
        private String filePath;

        public TextStream.Line getLine() {
            return this.line;
        }

        public String getFilePath() {
            return this.filePath;
        }

        public void setLine(TextStream.Line line) {
            this.line = line;
        }

        public void setFilePath(String filePath) {
            this.filePath = filePath;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof LogLine)) {
                return false;
            }
            LogLine other = (LogLine)o;
            if (!other.canEqual(this)) {
                return false;
            }
            TextStream.Line this$line = this.getLine();
            TextStream.Line other$line = other.getLine();
            if (this$line == null ? other$line != null : !((Object)this$line).equals(other$line)) {
                return false;
            }
            String this$filePath = this.getFilePath();
            String other$filePath = other.getFilePath();
            return !(this$filePath == null ? other$filePath != null : !this$filePath.equals(other$filePath));
        }

        protected boolean canEqual(Object other) {
            return other instanceof LogLine;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            TextStream.Line $line = this.getLine();
            result = result * 59 + ($line == null ? 43 : ((Object)$line).hashCode());
            String $filePath = this.getFilePath();
            result = result * 59 + ($filePath == null ? 43 : $filePath.hashCode());
            return result;
        }

        public String toString() {
            return "LogWorker.LogLine(line=" + this.getLine() + ", filePath=" + this.getFilePath() + ")";
        }
    }

    public static class FileSyncConfImpl
    implements TextStream.FileEntrySupplier.FileSyncConf {
        private String syncId;
        private String syncTime;
        private String syncPk;
        private long syncCount;
        private String syncStatus;
        private long syncPosition;
        private String syncFile;
        private String taskTime;
        private String syncText;
        private long lastModifiedTime;

        @Override
        public String syncId() {
            return this.syncId;
        }

        @Override
        public String syncTime() {
            return this.syncTime;
        }

        @Override
        public LocalDateTime taskTime() {
            return Util.dateTime(this.taskTime, new String[0]);
        }

        @Override
        public String syncText() {
            return this.syncText;
        }

        @Override
        public Long syncCount() {
            return this.syncCount;
        }

        @Override
        public String syncStatus() {
            return this.syncStatus;
        }

        @Override
        public long syncPosition() {
            return this.syncPosition;
        }

        @Override
        public long lastModifiedTime() {
            return this.lastModifiedTime;
        }

        @Override
        public String syncFile() {
            return this.syncFile;
        }

        public String getSyncId() {
            return this.syncId;
        }

        public String getSyncTime() {
            return this.syncTime;
        }

        public String getSyncPk() {
            return this.syncPk;
        }

        public long getSyncCount() {
            return this.syncCount;
        }

        public String getSyncStatus() {
            return this.syncStatus;
        }

        public long getSyncPosition() {
            return this.syncPosition;
        }

        public String getSyncFile() {
            return this.syncFile;
        }

        public String getTaskTime() {
            return this.taskTime;
        }

        public String getSyncText() {
            return this.syncText;
        }

        public long getLastModifiedTime() {
            return this.lastModifiedTime;
        }

        public void setSyncId(String syncId) {
            this.syncId = syncId;
        }

        public void setSyncTime(String syncTime) {
            this.syncTime = syncTime;
        }

        public void setSyncPk(String syncPk) {
            this.syncPk = syncPk;
        }

        public void setSyncCount(long syncCount) {
            this.syncCount = syncCount;
        }

        public void setSyncStatus(String syncStatus) {
            this.syncStatus = syncStatus;
        }

        public void setSyncPosition(long syncPosition) {
            this.syncPosition = syncPosition;
        }

        public void setSyncFile(String syncFile) {
            this.syncFile = syncFile;
        }

        public void setTaskTime(String taskTime) {
            this.taskTime = taskTime;
        }

        public void setSyncText(String syncText) {
            this.syncText = syncText;
        }

        public void setLastModifiedTime(long lastModifiedTime) {
            this.lastModifiedTime = lastModifiedTime;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileSyncConfImpl)) {
                return false;
            }
            FileSyncConfImpl other = (FileSyncConfImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getSyncCount() != other.getSyncCount()) {
                return false;
            }
            if (this.getSyncPosition() != other.getSyncPosition()) {
                return false;
            }
            if (this.getLastModifiedTime() != other.getLastModifiedTime()) {
                return false;
            }
            String this$syncId = this.getSyncId();
            String other$syncId = other.getSyncId();
            if (this$syncId == null ? other$syncId != null : !this$syncId.equals(other$syncId)) {
                return false;
            }
            String this$syncTime = this.getSyncTime();
            String other$syncTime = other.getSyncTime();
            if (this$syncTime == null ? other$syncTime != null : !this$syncTime.equals(other$syncTime)) {
                return false;
            }
            String this$syncPk = this.getSyncPk();
            String other$syncPk = other.getSyncPk();
            if (this$syncPk == null ? other$syncPk != null : !this$syncPk.equals(other$syncPk)) {
                return false;
            }
            String this$syncStatus = this.getSyncStatus();
            String other$syncStatus = other.getSyncStatus();
            if (this$syncStatus == null ? other$syncStatus != null : !this$syncStatus.equals(other$syncStatus)) {
                return false;
            }
            String this$syncFile = this.getSyncFile();
            String other$syncFile = other.getSyncFile();
            if (this$syncFile == null ? other$syncFile != null : !this$syncFile.equals(other$syncFile)) {
                return false;
            }
            String this$taskTime = this.getTaskTime();
            String other$taskTime = other.getTaskTime();
            if (this$taskTime == null ? other$taskTime != null : !this$taskTime.equals(other$taskTime)) {
                return false;
            }
            String this$syncText = this.getSyncText();
            String other$syncText = other.getSyncText();
            return !(this$syncText == null ? other$syncText != null : !this$syncText.equals(other$syncText));
        }

        protected boolean canEqual(Object other) {
            return other instanceof FileSyncConfImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            long $syncCount = this.getSyncCount();
            result = result * 59 + (int)($syncCount >>> 32 ^ $syncCount);
            long $syncPosition = this.getSyncPosition();
            result = result * 59 + (int)($syncPosition >>> 32 ^ $syncPosition);
            long $lastModifiedTime = this.getLastModifiedTime();
            result = result * 59 + (int)($lastModifiedTime >>> 32 ^ $lastModifiedTime);
            String $syncId = this.getSyncId();
            result = result * 59 + ($syncId == null ? 43 : $syncId.hashCode());
            String $syncTime = this.getSyncTime();
            result = result * 59 + ($syncTime == null ? 43 : $syncTime.hashCode());
            String $syncPk = this.getSyncPk();
            result = result * 59 + ($syncPk == null ? 43 : $syncPk.hashCode());
            String $syncStatus = this.getSyncStatus();
            result = result * 59 + ($syncStatus == null ? 43 : $syncStatus.hashCode());
            String $syncFile = this.getSyncFile();
            result = result * 59 + ($syncFile == null ? 43 : $syncFile.hashCode());
            String $taskTime = this.getTaskTime();
            result = result * 59 + ($taskTime == null ? 43 : $taskTime.hashCode());
            String $syncText = this.getSyncText();
            result = result * 59 + ($syncText == null ? 43 : $syncText.hashCode());
            return result;
        }

        public String toString() {
            return "LogWorker.FileSyncConfImpl(syncId=" + this.getSyncId() + ", syncTime=" + this.getSyncTime() + ", syncPk=" + this.getSyncPk() + ", syncCount=" + this.getSyncCount() + ", syncStatus=" + this.getSyncStatus() + ", syncPosition=" + this.getSyncPosition() + ", syncFile=" + this.getSyncFile() + ", taskTime=" + this.getTaskTime() + ", syncText=" + this.getSyncText() + ", lastModifiedTime=" + this.getLastModifiedTime() + ")";
        }
    }

    public static class FileSyncConfFsyncImpl
    implements TextStream.FileEntrySupplier.FileSyncConfFsync {
        private final String module;
        private final File syncInfoDir;
        private final Processed processed;

        public FileSyncConfFsyncImpl(String module, String localPath, Processed processed) {
            this.module = module;
            this.syncInfoDir = new File(localPath);
            this.processed = processed;
        }

        @Override
        public synchronized void fsync(String syncId, String syncTime, String syncPk, long syncCount, String syncStatus, long syncPosition, String syncFile) {
            FileSyncConfImpl fileSyncConf = new FileSyncConfImpl();
            fileSyncConf.setSyncId(syncId);
            fileSyncConf.setSyncTime(Util.formatTime(Optional.ofNullable(this.processed.maxTime(syncId)).orElse(LocalDateTime.now()), new String[0]));
            fileSyncConf.setSyncPk(syncPk);
            fileSyncConf.setSyncCount(syncCount);
            fileSyncConf.setSyncStatus(syncStatus);
            fileSyncConf.setSyncPosition(syncPosition);
            fileSyncConf.setSyncFile(syncFile);
            fileSyncConf.setTaskTime(Util.formatTime(LocalDateTime.now(), new String[0]));
            File localSyncFile = new File(syncFile);
            if (localSyncFile.exists()) {
                fileSyncConf.setLastModifiedTime(localSyncFile.lastModified());
            }
            File infoFile = new File(this.syncInfoDir, this.childFile(syncId));
            try {
                Util.writeAtomic(infoFile, JSONAccessor.impl().format(fileSyncConf).getBytes(StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw Util.convert2RuntimeException(e);
            }
        }

        public synchronized TextStream.FileEntrySupplier.FileSyncConf syncConf(String syncId) {
            File infoFile = new File(this.syncInfoDir, this.childFile(syncId));
            try {
                byte[] bytes = Util.read(infoFile);
                if (bytes == null || bytes.length == 0) {
                    return null;
                }
                return JSONAccessor.impl().read(new String(bytes, StandardCharsets.UTF_8), FileSyncConfImpl.class);
            }
            catch (IOException e) {
                return null;
            }
        }

        private String childFile(String syncId) {
            return this.module + "_" + new File(syncId).getName() + "_" + Util.md5(syncId) + "_.info";
        }

        @Override
        public synchronized String configPath(String syncId) {
            File infoFile = new File(this.syncInfoDir, this.childFile(syncId));
            return infoFile.exists() ? infoFile.getPath() : null;
        }

        public static interface Processed {
            public LocalDateTime maxTime(String var1);
        }
    }
}

