/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared;

import com.ovopark.kernel.shared.Model;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Deprecated
public interface CachedExecutors {
    public static CachedExecutors impl(String name) {
        return new DefaultCachedExecutors(name);
    }

    public static CachedExecutors impl(String name, int scheduleThreadCount, int executeThreadCount) {
        return new DefaultCachedExecutors(name, scheduleThreadCount, executeThreadCount);
    }

    default public ScheduledExecutorService scheduledExecutorService() {
        throw new UnsupportedOperationException();
    }

    default public ExecutorService executorService() {
        throw new UnsupportedOperationException();
    }

    public static final class DefaultCachedExecutors
    implements CachedExecutors {
        private static final Logger log = LoggerFactory.getLogger(DefaultCachedExecutors.class);
        private final String name;
        private final int scheduleThreadCount;
        private final int executeThreadCount;
        private ScheduledExecutorService scheduledExecutorService;
        private ExecutorService executorService;

        public DefaultCachedExecutors(String name, int scheduleThreadCount, int executeThreadCount) {
            this.name = name;
            this.scheduleThreadCount = scheduleThreadCount;
            this.executeThreadCount = executeThreadCount;
            this.initScheduledExecutor();
            this.initExecutor();
        }

        public DefaultCachedExecutors(String name) {
            this(name, 1, Runtime.getRuntime().availableProcessors());
        }

        private void initExecutor() {
            if (this.executeThreadCount < 1) {
                log.warn("cannot init execute: " + this.executeThreadCount);
            }
            ThreadConfig threadConfig = new ThreadConfig();
            threadConfig.setName(this.name + "-execute");
            threadConfig.setAliveCount(this.executeThreadCount);
            threadConfig.setMaxCount(this.executeThreadCount);
            threadConfig.setAliveTime(300L);
            threadConfig.setQueueSize(100000);
            threadConfig.setHandler(new ThreadPoolExecutor.CallerRunsPolicy());
            try {
                this.executorService = new SimpleThreadPoolExecutorFactory().factory(threadConfig);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        private void initScheduledExecutor() {
            if (this.scheduleThreadCount < 1) {
                log.warn("cannot init schedule: " + this.executeThreadCount);
            }
            ThreadConfig threadConfig = new ThreadConfig();
            threadConfig.setName(this.name + "-schedule");
            threadConfig.setAliveCount(1);
            threadConfig.setMaxCount(this.scheduleThreadCount);
            threadConfig.setAliveTime(300L);
            try {
                this.scheduledExecutorService = new SimpleScheduledThreadPoolExecutorFactory().factory(threadConfig);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }

        @Override
        public ScheduledExecutorService scheduledExecutorService() {
            return this.scheduledExecutorService;
        }

        @Override
        public ExecutorService executorService() {
            return this.executorService;
        }
    }

    public static final class SimpleThreadPoolExecutorFactory
    extends AbstractExecutorServiceFactory<ThreadPoolExecutor> {
        @Override
        public ThreadPoolExecutor factory(ThreadConfig threadConfig) {
            ThreadPoolExecutor executor = new ThreadPoolExecutor(threadConfig.getAliveCount(), threadConfig.getMaxCount(), threadConfig.getAliveTime(), TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(threadConfig.queueSize), this.threadFactory(threadConfig), threadConfig.getHandler() == null ? this.callerRunsIfLess() : threadConfig.getHandler());
            return executor;
        }
    }

    public static final class SimpleScheduledThreadPoolExecutorFactory
    extends AbstractExecutorServiceFactory<ScheduledThreadPoolExecutor> {
        @Override
        public ScheduledThreadPoolExecutor factory(ThreadConfig threadConfig) {
            ScheduledThreadPoolExecutor scheduledThreadPoolExecutor = new ScheduledThreadPoolExecutor(threadConfig.getAliveCount(), this.threadFactory(threadConfig), this.callerRunsIfLess());
            scheduledThreadPoolExecutor.setKeepAliveTime(threadConfig.getAliveTime(), TimeUnit.SECONDS);
            scheduledThreadPoolExecutor.allowCoreThreadTimeOut(true);
            return scheduledThreadPoolExecutor;
        }
    }

    public static abstract class AbstractExecutorServiceFactory<T extends ExecutorService>
    implements ExecutorServiceFactory<T> {
        protected ThreadFactory threadFactory(final ThreadConfig threadConfig) {
            return new ThreadFactory(){
                int index = 0;

                @Override
                public Thread newThread(Runnable r) {
                    Thread thread = new Thread(r, threadConfig.getName() + "-" + ++this.index);
                    thread.setDaemon(threadConfig.isDaemon());
                    return thread;
                }
            };
        }

        protected RejectedExecutionHandler abortIfLess() {
            return new ThreadPoolExecutor.AbortPolicy();
        }

        protected RejectedExecutionHandler callerRunsIfLess() {
            return new ThreadPoolExecutor.CallerRunsPolicy();
        }

        protected RejectedExecutionHandler discardOldestIfLess() {
            return new ThreadPoolExecutor.DiscardOldestPolicy();
        }

        protected RejectedExecutionHandler discardIfLess() {
            return new ThreadPoolExecutor.DiscardPolicy();
        }
    }

    public static interface ExecutorServiceFactory<T extends ExecutorService> {
        public T factory(ThreadConfig var1);
    }

    public static class ThreadConfig
    implements Model {
        private String name;
        private int aliveCount;
        private int maxCount;
        private long aliveTime;
        private boolean daemon = false;
        private RejectedExecutionHandler handler;
        private int queueSize = Integer.MAX_VALUE;

        public String getName() {
            return this.name;
        }

        public int getAliveCount() {
            return this.aliveCount;
        }

        public int getMaxCount() {
            return this.maxCount;
        }

        public long getAliveTime() {
            return this.aliveTime;
        }

        public boolean isDaemon() {
            return this.daemon;
        }

        public RejectedExecutionHandler getHandler() {
            return this.handler;
        }

        public int getQueueSize() {
            return this.queueSize;
        }

        public void setName(String name) {
            this.name = name;
        }

        public void setAliveCount(int aliveCount) {
            this.aliveCount = aliveCount;
        }

        public void setMaxCount(int maxCount) {
            this.maxCount = maxCount;
        }

        public void setAliveTime(long aliveTime) {
            this.aliveTime = aliveTime;
        }

        public void setDaemon(boolean daemon) {
            this.daemon = daemon;
        }

        public void setHandler(RejectedExecutionHandler handler) {
            this.handler = handler;
        }

        public void setQueueSize(int queueSize) {
            this.queueSize = queueSize;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ThreadConfig)) {
                return false;
            }
            ThreadConfig other = (ThreadConfig)o;
            if (!other.canEqual(this)) {
                return false;
            }
            if (this.getAliveCount() != other.getAliveCount()) {
                return false;
            }
            if (this.getMaxCount() != other.getMaxCount()) {
                return false;
            }
            if (this.getAliveTime() != other.getAliveTime()) {
                return false;
            }
            if (this.isDaemon() != other.isDaemon()) {
                return false;
            }
            if (this.getQueueSize() != other.getQueueSize()) {
                return false;
            }
            String this$name = this.getName();
            String other$name = other.getName();
            if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
                return false;
            }
            RejectedExecutionHandler this$handler = this.getHandler();
            RejectedExecutionHandler other$handler = other.getHandler();
            return !(this$handler == null ? other$handler != null : !this$handler.equals(other$handler));
        }

        protected boolean canEqual(Object other) {
            return other instanceof ThreadConfig;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getAliveCount();
            result = result * 59 + this.getMaxCount();
            long $aliveTime = this.getAliveTime();
            result = result * 59 + (int)($aliveTime >>> 32 ^ $aliveTime);
            result = result * 59 + (this.isDaemon() ? 79 : 97);
            result = result * 59 + this.getQueueSize();
            String $name = this.getName();
            result = result * 59 + ($name == null ? 43 : $name.hashCode());
            RejectedExecutionHandler $handler = this.getHandler();
            result = result * 59 + ($handler == null ? 43 : $handler.hashCode());
            return result;
        }

        public String toString() {
            return "CachedExecutors.ThreadConfig(name=" + this.getName() + ", aliveCount=" + this.getAliveCount() + ", maxCount=" + this.getMaxCount() + ", aliveTime=" + this.getAliveTime() + ", daemon=" + this.isDaemon() + ", handler=" + this.getHandler() + ", queueSize=" + this.getQueueSize() + ")";
        }
    }
}

