/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.stream.log;

import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.TextStream;
import com.ovopark.kernel.shared.stream.log.LogFileManager;
import com.ovopark.kernel.shared.stream.log.LogWorker;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Slf4JLogManager
implements LogFileManager {
    private static final Logger log = LoggerFactory.getLogger(Slf4JLogManager.class);
    private final String managerId;
    private final String module;
    private final String logPath;
    private final File logPathFile;
    private final TextStream.FileEntrySupplier.FileSyncConfFsync fileSyncConfFsync;
    private final TextStream.FileEntrySupplier.FileSyncConfFsyncListener fileSyncConfFsyncListener;
    private final Predicate<File> predicate;
    private final TextStream.NewLinePredicate newLinePredicate;
    private final LineHandler lineHandler;
    private final ErrorHandler errorHandler;
    private final CompleteHandler completeHandler;
    private final boolean concurrency;
    private final LogFileManager.Config config;
    private final Map<String, LogWorker> logWorkerMap = new ConcurrentHashMap<String, LogWorker>();
    private final ScheduledExecutorService scheduledExecutor = Executors.newSingleThreadScheduledExecutor(new ThreadFactory(){

        @Override
        public Thread newThread(Runnable r) {
            return new Thread(r, "log-monitor");
        }
    });
    public static final TextStream.NewLinePredicate YYYY_MM_DD_HH_MM_SS_SSS = new DateAsNewLine(24, "yyyy-MM-dd HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS][.SS]");
    public static final TextStream.NewLinePredicate YYYY_MM_DD_HH_MM_SS_SSS_1 = new DateAsNewLine(24, "yyyy-MM-dd HH:mm:ss[,SSSSSSSSS][,SSSSSS][,SSS][,SS]");

    public Slf4JLogManager(String module, String logPath, String configPath, Predicate<File> predicate, TextStream.NewLinePredicate newLinePredicate, LineHandler lineHandler, CompleteHandler completeHandler, ErrorHandler errorHandler, TextStream.FileEntrySupplier.FileSyncConfFsyncListener fileSyncConfFsyncListener, LogWorker.FileSyncConfFsyncImpl.Processed processed, LogFileManager.Config config) {
        this(module, logPath, configPath, predicate, newLinePredicate, lineHandler, completeHandler, errorHandler, fileSyncConfFsyncListener, processed, config, false);
    }

    public Slf4JLogManager(String module, String logPath, String configPath, Predicate<File> predicate, TextStream.NewLinePredicate newLinePredicate, LineHandler lineHandler, CompleteHandler completeHandler, ErrorHandler errorHandler, TextStream.FileEntrySupplier.FileSyncConfFsyncListener fileSyncConfFsyncListener, LogWorker.FileSyncConfFsyncImpl.Processed processed, LogFileManager.Config config, boolean concurrency) {
        this.module = module;
        this.logPath = logPath;
        this.logPathFile = new File(logPath);
        this.fileSyncConfFsync = new LogWorker.FileSyncConfFsyncImpl(module, configPath, processed);
        this.fileSyncConfFsyncListener = fileSyncConfFsyncListener;
        this.predicate = predicate;
        this.newLinePredicate = newLinePredicate;
        this.lineHandler = lineHandler;
        this.completeHandler = completeHandler;
        this.errorHandler = errorHandler;
        this.config = config;
        this.concurrency = concurrency;
        this.managerId = Util.md5(module + ":" + logPath);
    }

    @Override
    public String module() {
        return this.module;
    }

    @Override
    public String logPath() {
        return this.logPath;
    }

    @Override
    public boolean isRollover(File file) {
        int count = this.config.rolloverCheckCount();
        long modified = file.lastModified();
        long start = System.currentTimeMillis();
        while (count-- > 0) {
            try {
                TimeUnit.SECONDS.sleep(3L);
            }
            catch (InterruptedException e) {
                throw Util.convert2RuntimeException(e);
            }
            log.info("check the last modified time of file: " + file.getPath());
            long l = file.lastModified();
            if (l <= modified) continue;
            log.info("modified time changed: " + file.getPath());
            return false;
        }
        log.info("check modified time, timeout(" + Util.costTime(start) + "): " + file.getPath());
        return true;
    }

    @Override
    public void watch() {
        this.scheduledExecutor.scheduleWithFixedDelay(new Runnable(){

            @Override
            public void run() {
                for (File file : Slf4JLogManager.this.logPathFile.listFiles()) {
                    try {
                        if (!Slf4JLogManager.this.predicate.test(file)) continue;
                        for (Map.Entry workerEntry : Slf4JLogManager.this.logWorkerMap.entrySet()) {
                            if (!((LogWorker)workerEntry.getValue()).isClosed()) continue;
                            Slf4JLogManager.this.logWorkerMap.remove(workerEntry.getKey());
                            log.info("remove closed worker(unexpected): " + (String)workerEntry.getKey());
                        }
                        if (!Slf4JLogManager.this.concurrency && !Slf4JLogManager.this.logWorkerMap.isEmpty()) {
                            log.info("concurrency not supported!, ignore: " + file.getPath() + ",active: " + (String)Slf4JLogManager.this.logWorkerMap.keySet().iterator().next());
                            return;
                        }
                        Slf4JLogManager.this.schedule(file);
                    }
                    catch (Exception e) {
                        log.error(e.getMessage(), (Throwable)e);
                    }
                }
            }
        }, 0L, this.config.watchTimeSec(), TimeUnit.SECONDS);
    }

    private synchronized void schedule(final File file) {
        if (this.logWorkerMap.containsKey(file.getPath())) {
            log.info("cannot submit task,file is processing: " + file.getPath());
            return;
        }
        Object fileSyncConf = this.fileSyncConfFsync.syncConf(file.getPath());
        if (fileSyncConf != null && "complete".equals(fileSyncConf.syncStatus()) && file.lastModified() == fileSyncConf.lastModifiedTime()) {
            log.info("file done!,ignore: " + file.getPath() + ",config file: " + this.fileSyncConfFsync.configPath(file.getPath()));
            return;
        }
        final LogWorker logWorker = new LogWorker(file.getPath(), this.newLinePredicate, this.fileSyncConfFsync, this.fileSyncConfFsyncListener, this);
        logWorker.start(new CoreSubscriber<LogWorker.LogLine>(){

            @Override
            public void onNext(LogWorker.LogLine record) {
                try {
                    Slf4JLogManager.this.lineHandler.handle(record);
                }
                catch (Exception e) {
                    Slf4JLogManager.this.logWorkerMap.remove(file.getPath());
                    log.info("error, file: " + file.getPath());
                    try {
                        logWorker.close();
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        throw Util.convert2RuntimeException(e1);
                    }
                    finally {
                        super.cancel();
                    }
                    throw Util.convert2RuntimeException(e);
                }
            }

            @Override
            public void onError(Throwable t) {
                try {
                    Slf4JLogManager.this.errorHandler.handle(t);
                }
                catch (Exception e) {
                    Slf4JLogManager.this.logWorkerMap.remove(file.getPath());
                    log.info("error, file: " + file.getPath());
                    try {
                        logWorker.close();
                    }
                    catch (Exception e1) {
                        e1.addSuppressed(e);
                        throw Util.convert2RuntimeException(e1);
                    }
                    finally {
                        super.cancel();
                    }
                    throw Util.convert2RuntimeException(e);
                }
            }

            @Override
            public void onComplete() {
                try {
                    Slf4JLogManager.this.logWorkerMap.remove(file.getPath());
                    log.info("completed, file: " + file.getPath());
                    Slf4JLogManager.this.completeHandler.handle(file.getPath());
                }
                finally {
                    try {
                        logWorker.close();
                    }
                    catch (Exception e) {
                        throw Util.convert2RuntimeException(e);
                    }
                }
            }
        });
        this.logWorkerMap.put(file.getPath(), logWorker);
    }

    @Override
    public boolean submit(String fileName) {
        for (File file : this.logPathFile.listFiles()) {
            if (!file.getName().equals(fileName)) continue;
            this.schedule(file);
            return true;
        }
        return false;
    }

    @Override
    public List<String> inProcessingFiles() {
        return new ArrayList<String>(this.logWorkerMap.keySet());
    }

    @Override
    public boolean isProcessing(String filePath) {
        LogWorker logWorker = this.logWorkerMap.get(filePath);
        return logWorker != null && !logWorker.isClosed();
    }

    @Override
    public LogFileManager.Lag lag(String filePath) {
        Object syncConf = this.fileSyncConfFsync.syncConf(filePath);
        if (syncConf == null) {
            return null;
        }
        LogFileManager.Lag lag = new LogFileManager.Lag();
        File file = new File(filePath);
        long l = file.lastModified();
        String syncTime = syncConf.syncTime();
        if (Util.isNotEmpty(syncTime)) {
            long time = Util.dateTime(syncTime, new String[0]).toInstant(Util.GMT_08).toEpochMilli();
            lag.setTime(Math.max(l - time, 0L));
        }
        long length = file.length();
        lag.setBytes(Math.max(length - syncConf.syncPosition(), 0L));
        return lag;
    }

    @Override
    public LogFileManager.FileManagerStat managerStat() {
        LogFileManager.FileManagerStat fileManagerStat = new LogFileManager.FileManagerStat();
        fileManagerStat.setManagerId(this.managerId);
        ArrayList<LogFileManager.FileStat> allLogFiles = new ArrayList<LogFileManager.FileStat>();
        for (File file : this.logPathFile.listFiles()) {
            LogFileManager.FileStat fileStat = new LogFileManager.FileStat();
            fileStat.setFilePath(file.getPath());
            fileStat.setLastModifiedTime(file.lastModified());
            if (file.isDirectory()) {
                fileStat.setDir(true);
                fileStat.setWarning("sub-directory not supported, a slf4j-manager per directory.");
                allLogFiles.add(fileStat);
                continue;
            }
            fileStat.setFileSize(file.length());
            if (file.getName().endsWith(".gz") || this.predicate.test(file)) {
                fileStat.setSupport(true);
                fileStat.setManualScheduled(true);
            }
            fileStat.setAutoScheduled(this.predicate.test(file));
            LogFileManager.Lag lag = this.lag(file.getPath());
            fileStat.setTimeLag(lag == null ? -1L : lag.getTime());
            fileStat.setBytesLag(lag == null ? -1L : lag.getBytes());
            if (file.getName().endsWith(".gz")) {
                fileStat.setWarning("manually submit a task for GZ file, use HTTP???");
            }
            fileStat.setActive(this.isProcessing(file.getPath()));
            allLogFiles.add(fileStat);
        }
        fileManagerStat.setAllLogFiles(allLogFiles);
        fileManagerStat.setActiveLogFiles(this.inProcessingFiles());
        fileManagerStat.setLogFilePath(this.logPath);
        return fileManagerStat;
    }

    @Override
    public void close() throws Exception {
        this.scheduledExecutor.shutdown();
    }

    public static interface CompleteHandler {
        public void handle(String var1);
    }

    public static interface ErrorHandler {
        public void handle(Throwable var1);
    }

    public static interface LineHandler {
        public void handle(LogWorker.LogLine var1);
    }

    public static class DateAsNewLine
    implements TextStream.NewLinePredicate {
        private final int length;
        private final String format;

        public DateAsNewLine(int length, String format) {
            this.length = length;
            this.format = format;
        }

        @Override
        public boolean test(String s) {
            try {
                String substring = s.substring(0, this.length);
                Util.dateTime(substring.trim(), this.format);
                return true;
            }
            catch (Exception e) {
                return false;
            }
        }
    }
}

