/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.delay;

import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.Util;
import java.time.LocalDateTime;
import java.util.concurrent.Delayed;
import java.util.concurrent.TimeUnit;

public interface DelayTask
extends Delayed,
Model {
    public long triggerTimeMs();

    public Comparable taskId();

    @Override
    default public long getDelay(TimeUnit unit) {
        return unit.convert(this.triggerTimeMs() - LocalDateTime.now().toInstant(Util.GMT_08).toEpochMilli(), TimeUnit.MILLISECONDS);
    }

    @Override
    default public int compareTo(Delayed o) {
        if (!(o instanceof DelayTask)) {
            return -1;
        }
        return Long.valueOf(this.triggerTimeMs()).compareTo(((DelayTask)o).triggerTimeMs());
    }

    public Runnable task();
}

