/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared;

import java.util.concurrent.atomic.AtomicLong;

public interface CacheStat {
    public static CacheStat cacheStat() {
        return new CacheStatImpl();
    }

    public long hit(long var1);

    public long miss(long var1);

    public long hit();

    public long miss();

    public static class CacheStatImpl
    implements CacheStat {
        private final AtomicLong missCount = new AtomicLong(0L);
        private final AtomicLong hitCount = new AtomicLong(0L);

        @Override
        public long hit(long v) {
            return this.hitCount.addAndGet(v);
        }

        @Override
        public long miss(long v) {
            return this.missCount.addAndGet(v);
        }

        @Override
        public long hit() {
            return this.hit(1L);
        }

        @Override
        public long miss() {
            return this.miss(1L);
        }
    }
}

