/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.kv;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.concurrent.KeyLockLock;
import com.ovopark.kernel.shared.delay.DelayTask;
import com.ovopark.kernel.shared.delay.TimingWheel;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Publisher;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import com.ovopark.kernel.shared.stream.Subscription;
import java.io.IOException;
import java.util.Iterator;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Predicate;

public interface KVEngine {
    public static <K extends Comparable<?>> KeyLockFunc<K> temp() {
        return new KeyLockFuncImpl();
    }

    public static TtlFunc<String> ttl() {
        return MapImpl.global;
    }

    public static TtlFunc<String> newTtl(String name) {
        return new MapImpl<String>(name, 1);
    }

    public static class KeyLockFuncImpl<K extends Comparable<?>>
    implements KeyLockFunc<K> {
        final ShardImpl<K> shard = new ShardImpl(null);

        private KeyLockFuncImpl() {
        }

        @Override
        public <V> GetResult<K, V> get(K key) {
            return this.shard.get(key);
        }

        @Override
        public boolean contains(K key) {
            return this.shard.contains(key);
        }

        @Override
        public <V> PutResult<K, V> putIfAbsentAndGet(K key, Function<K, V> func) {
            return this.shard.putIfAbsentAndGet(key, func);
        }

        @Override
        public <V> PutResult<K, V> putAndGet(K key, Upset<K, V, V> func) {
            return this.shard.putAndGet(key, func);
        }

        @Override
        public <V> DeleteResult<K, V> delete(K key) {
            return this.shard.delete(key);
        }

        @Override
        public int size() {
            return this.shard.size();
        }

        @Override
        public void forEach(BiConsumer<K, Object> action) {
            this.shard.forEach(action);
        }

        @Override
        public void get(GetSubscriber<K> getSubscriber) {
            this.shard.get(getSubscriber);
        }
    }

    public static class MapImpl<K extends Comparable<?>>
    implements TtlFunc<K> {
        private static final int size = 1024;
        private final ShardImpl<K>[] shards = new ShardImpl[1024];
        private final TimingWheel timingWheel;
        private final ExecutorService breakDeadLock;
        private final Map<Predicate<K>, TtlListener<K>> ttlCallBackMap = new ConcurrentHashMap<Predicate<K>, TtlListener<K>>();
        static final MapImpl<String> global = new MapImpl();

        private MapImpl() {
            this("ttl-" + Util.uniqueFirstPart(), Runtime.getRuntime().availableProcessors());
        }

        private MapImpl(String name, int ttlThreadCount) {
            this.timingWheel = new TimingWheel(name + "-timing", 1, 20, 100);
            this.breakDeadLock = Util.defaultExecutorService(name + "-executor", ttlThreadCount, ttlThreadCount, Integer.MAX_VALUE, new ThreadPoolExecutor.AbortPolicy());
            for (int i = 0; i < 1024; ++i) {
                this.shards[i] = new ShardImpl(this);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private ShardImpl<K> shard(K key) {
            int i = 0x3FF & key.hashCode();
            ShardImpl<K> shard = this.shards[i];
            if (shard == null) {
                ShardImpl<K>[] shardImplArray = this.shards;
                synchronized (this.shards) {
                    this.shards[i] = new ShardImpl(this);
                    // ** MonitorExit[var4_4] (shouldn't be in output)
                    return this.shards[i];
                }
            }
            return shard;
        }

        @Override
        public <V> GetResult<K, V> get(K key) {
            return this.shard(key).get(key);
        }

        @Override
        public boolean contains(K key) {
            return this.shard(key).contains(key);
        }

        @Override
        public <V> PutResult<K, V> putIfAbsentAndGet(K key, Function<K, V> func) {
            return this.shard(key).putIfAbsentAndGet(key, func);
        }

        @Override
        public <V> PutResult<K, V> putAndGet(K key, Upset<K, V, V> func) {
            return this.shard(key).putAndGet(key, func);
        }

        @Override
        public <V> DeleteResult<K, V> delete(K key) {
            return this.shard(key).delete(key);
        }

        @Override
        public int size() {
            int size = 0;
            for (ShardImpl<K> shard : this.shards) {
                if (shard == null) continue;
                size += shard.size();
            }
            return size;
        }

        @Override
        public void forEach(BiConsumer<K, Object> action) {
            for (ShardImpl<K> shard : this.shards) {
                if (shard == null) continue;
                shard.forEach(action);
            }
        }

        @Override
        public void get(GetSubscriber<K> getSubscriber) {
            Stream.from(new GetPublisher(getSubscriber)).subscribe(getSubscriber);
        }

        @Override
        public TtlFunc<K> subscribeTtl(Predicate<K> predicate, TtlListener<K> ttlListener) {
            this.ttlCallBackMap.put(predicate, ttlListener);
            return this;
        }

        @Override
        public void shutdown() {
            Exception exception = null;
            try {
                this.timingWheel.shutdown();
            }
            catch (Exception e) {
                exception = e;
            }
            this.breakDeadLock.shutdown();
            if (exception != null) {
                throw Util.convert2RuntimeException(exception);
            }
        }

        @Override
        public <V> PutResult<K, V> putIfAbsentAndGet(K key, Function<K, V> func, TTL ttl) {
            return this.shard(key).putIfAbsentAndGet(key, func, ttl);
        }

        @Override
        public <V> PutResult<K, V> putAndGet(K key, Upset<K, V, V> func, TTL ttl) {
            return this.shard(key).putAndGet(key, func, ttl);
        }

        @Override
        public <V> PutResult<K, V> ttlAndGet(K key, Upset<K, V, V> func, TTL ttl) {
            return this.shard(key).ttlAndGet(key, func, ttl);
        }

        @Override
        public <V> GetResult<K, V> ttlAndGet(K key, long time, TimeUnit timeUnit) {
            return this.shard(key).ttlAndGet(key, time, timeUnit);
        }

        class GetPublisher
        implements Publisher<GetResult<K, ?>> {
            final GetSubscriber<K> getSubscriber;

            public GetPublisher(GetSubscriber<K> getSubscriber) {
                this.getSubscriber = getSubscriber;
            }

            @Override
            public void subscribe(final Subscriber<? super GetResult<K, ?>> subscriber) {
                Subscription subscription = new Subscription(){
                    volatile boolean cancelled;
                    volatile int shardIndex = 0;

                    @Override
                    public void request(long n) {
                        Iterator iterator = null;
                        for (long i = 0L; i < n; ++i) {
                            if (this.cancelled) {
                                return;
                            }
                            if (iterator == null) {
                                iterator = MapImpl.this.shards[this.shardIndex].repo.entrySet().iterator();
                            }
                            if (iterator.hasNext()) {
                                Map.Entry next = (Map.Entry)iterator.next();
                                GetResultImpl<Comparable, Object> getResult = new GetResultImpl<Comparable, Object>(true, (Comparable)next.getKey(), ((ShardImpl.Entry)next.getValue()).value, ((ShardImpl.Entry)next.getValue()).vcc);
                                GetPublisher.this.getSubscriber.onNext(getResult);
                                if (!this.cancelled) continue;
                                return;
                            }
                            if (++this.shardIndex >= MapImpl.this.shards.length) break;
                            iterator = null;
                        }
                        if (this.cancelled) {
                            return;
                        }
                        subscriber.onComplete();
                    }

                    @Override
                    public void cancel() {
                        this.cancelled = true;
                    }
                };
                subscriber.onSubscribe(subscription);
            }
        }

        static class TTLImpl
        implements TTL {
            static final TTLImpl notTtl = new TTLImpl(Long.MAX_VALUE, TimeUnit.MILLISECONDS);
            final long time;
            final TimeUnit timeUnit;

            public TTLImpl(long time, TimeUnit timeUnit) {
                this.time = time;
                this.timeUnit = timeUnit;
            }

            @Override
            public TimeUnit timeUnit() {
                return this.timeUnit;
            }

            @Override
            public long time() {
                return this.time;
            }
        }

        static class DeleteResultImpl<K extends Comparable<?>, V>
        implements DeleteResult<K, V> {
            final boolean exists;
            final K key;
            final V value;
            final long vcc;
            final boolean deleted;

            DeleteResultImpl(boolean exists, K key, V value, long vcc, boolean deleted) {
                this.exists = exists;
                this.key = key;
                this.value = value;
                this.vcc = vcc;
                this.deleted = deleted;
            }

            @Override
            public boolean exists() {
                return this.exists;
            }

            @Override
            public K key() {
                return this.key;
            }

            @Override
            public V value() {
                return this.value;
            }

            @Override
            public long vcc() {
                return this.vcc;
            }

            @Override
            public boolean deleted() {
                return this.deleted;
            }
        }

        static class PutResultImpl<K extends Comparable<?>, V>
        implements PutResult<K, V> {
            final long vcc;
            final boolean updated;
            final boolean created;
            final K key;
            final V preValue;
            final V value;

            PutResultImpl(boolean updated, boolean created, K key, V preValue, V value, long vcc) {
                this.updated = updated;
                this.created = created;
                this.key = key;
                this.preValue = preValue;
                this.value = value;
                this.vcc = vcc;
            }

            @Override
            public boolean updated() {
                return this.updated;
            }

            @Override
            public boolean created() {
                return this.created;
            }

            @Override
            public K key() {
                return this.key;
            }

            @Override
            public V preValue() {
                return this.preValue;
            }

            @Override
            public V value() {
                return this.value;
            }

            @Override
            public long vcc() {
                return this.vcc;
            }
        }

        static class GetResultImpl<K extends Comparable<?>, V>
        implements GetResult<K, V> {
            final boolean exists;
            final K key;
            final V value;
            final long vcc;

            GetResultImpl(boolean exists, K key, V value, long vcc) {
                this.exists = exists;
                this.key = key;
                this.value = value;
                this.vcc = vcc;
            }

            @Override
            public boolean exists() {
                return this.exists;
            }

            @Override
            public K key() {
                return this.key;
            }

            @Override
            public V value() {
                return this.value;
            }

            @Override
            public long vcc() {
                return this.vcc;
            }
        }
    }

    public static class ShardImpl<K extends Comparable<?>>
    implements TtlFunc<K> {
        private final Map<K, Entry> repo = new ConcurrentHashMap<K, Entry>();
        private final KeyLockLock keyLockLock = new KeyLockLock();
        private static final AtomicLong tx = new AtomicLong(0L);
        private static final AtomicLong globalExpiredVcc = new AtomicLong(0L);
        final MapImpl<K> mapImpl;

        private ShardImpl(MapImpl<K> mapImpl) {
            this.mapImpl = mapImpl;
        }

        @Override
        public <V> GetResult<K, V> get(K key) {
            Objects.requireNonNull(key);
            Entry entry = this.repo.get(key);
            if (entry != null) {
                if (entry.expiredMillis > 0L) {
                    long now = System.currentTimeMillis();
                    if (now - entry.startMillis < entry.expiredMillis) {
                        return new MapImpl.GetResultImpl<Comparable, Object>(true, entry.key, entry.value, entry.vcc);
                    }
                    return new MapImpl.GetResultImpl<Comparable, Object>(false, entry.key, null, -1L);
                }
                return new MapImpl.GetResultImpl<Comparable, Object>(true, entry.key, entry.value, entry.vcc);
            }
            return new MapImpl.GetResultImpl<K, Object>(false, key, null, -1L);
        }

        @Override
        public boolean contains(K key) {
            return this.get(key).exists();
        }

        @Override
        public <V> PutResult<K, V> putIfAbsentAndGet(K key, Function<K, V> func) {
            return this.putIfAbsentAndGet(key, func, MapImpl.TTLImpl.notTtl);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> PutResult<K, V> putIfAbsentAndGet(K key, Function<K, V> func, TTL ttl) {
            Objects.requireNonNull(key);
            Entry entry = this.repo.get(key);
            if (entry != null) {
                if (entry.expiredMillis <= 0L) return new MapImpl.PutResultImpl<Comparable, Object>(false, false, entry.key, entry.value, entry.value, entry.vcc);
                long now = System.currentTimeMillis();
                if (now - entry.startMillis < entry.expiredMillis) {
                    return new MapImpl.PutResultImpl<Comparable, Object>(false, false, entry.key, entry.value, entry.value, entry.vcc);
                }
            }
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                long time;
                entry = this.repo.get(key);
                if (entry != null) {
                    if (entry.expiredMillis <= 0L) {
                        MapImpl.PutResultImpl<Comparable, Object> now = new MapImpl.PutResultImpl<Comparable, Object>(false, false, entry.key, entry.value, entry.value, entry.vcc);
                        return now;
                    }
                    long now = System.currentTimeMillis();
                    if (now - entry.startMillis < entry.expiredMillis) {
                        MapImpl.PutResultImpl<Comparable, Object> putResultImpl = new MapImpl.PutResultImpl<Comparable, Object>(false, false, entry.key, entry.value, entry.value, entry.vcc);
                        return putResultImpl;
                    }
                }
                V object = func.apply(key);
                entry = new Entry();
                entry.key = key;
                entry.value = object;
                entry.vcc = ShardImpl.tx.incrementAndGet();
                if (ttl != MapImpl.TTLImpl.notTtl && (time = ttl.time()) > 0L) {
                    entry.startMillis = System.currentTimeMillis();
                    entry.expiredMillis = ttl.timeUnit().toMillis(time);
                    entry.expiredVcc = ShardImpl.globalExpiredVcc.incrementAndGet();
                    this.ttl(entry);
                }
                this.repo.put(key, entry);
                MapImpl.PutResultImpl<Comparable, Object> putResultImpl = new MapImpl.PutResultImpl<Comparable, Object>(false, true, entry.key, entry.value, entry.value, entry.vcc);
                return putResultImpl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        private void ttl(Entry entry) {
            TTLEntry ttlEntry = new TTLEntry(this, entry.key, entry.startMillis + entry.expiredMillis, entry.expiredVcc);
            ((MapImpl)this.mapImpl).timingWheel.delay(ttlEntry);
        }

        @Override
        public <V> PutResult<K, V> putAndGet(K key, Upset<K, V, V> func) {
            return this.putAndGet(key, func, MapImpl.TTLImpl.notTtl);
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> PutResult<K, V> putAndGet(K key, Upset<K, V, V> func, TTL ttl) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                MapImpl.GetResultImpl<K, Object> vGetResult;
                Entry entry = this.repo.get(key);
                MapImpl.GetResultImpl<Object, Object> getResultImpl = vGetResult = entry == null ? new MapImpl.GetResultImpl<K, Object>(false, key, null, -1L) : new MapImpl.GetResultImpl<Comparable, Object>(true, entry.key, entry.getValue(), entry.vcc);
                if (entry == null) {
                    long time23332;
                    Object object = func.apply(vGetResult);
                    entry = new Entry();
                    entry.key = key;
                    entry.value = object;
                    entry.vcc = ShardImpl.tx.incrementAndGet();
                    if (ttl != MapImpl.TTLImpl.notTtl && (time23332 = ttl.time()) > 0L) {
                        entry.startMillis = System.currentTimeMillis();
                        entry.expiredMillis = ttl.timeUnit().toMillis(time23332);
                        entry.expiredVcc = ShardImpl.globalExpiredVcc.incrementAndGet();
                        this.ttl(entry);
                    }
                    this.repo.put(key, entry);
                    MapImpl.PutResultImpl<Comparable, Object> time23332 = new MapImpl.PutResultImpl<Comparable, Object>(false, true, entry.key, vGetResult.value, entry.value, entry.vcc);
                    return time23332;
                }
                Object object = func.apply(vGetResult);
                Entry newEntry = new Entry();
                newEntry.key = key;
                newEntry.value = object;
                newEntry.vcc = ShardImpl.tx.incrementAndGet();
                newEntry.startMillis = entry.startMillis;
                newEntry.expiredMillis = entry.expiredMillis;
                newEntry.expiredVcc = entry.expiredVcc;
                this.repo.put(key, newEntry);
                MapImpl.PutResultImpl<Comparable, Object> putResultImpl = new MapImpl.PutResultImpl<Comparable, Object>(true, false, entry.key, vGetResult.value, newEntry.value, newEntry.vcc);
                return putResultImpl;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public <V> DeleteResult<K, V> delete(K key) {
            MapImpl.DeleteResultImpl<Object, Object> deleteResultImpl;
            block9: {
                Objects.requireNonNull(key);
                Entry entry = this.repo.get(key);
                if (entry == null) {
                    return new MapImpl.DeleteResultImpl<K, Object>(false, key, null, -1L, true);
                }
                KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);
                try {
                    entry = this.repo.remove(key);
                    MapImpl.DeleteResultImpl<Object, Object> deleteResultImpl2 = deleteResultImpl = entry == null ? new MapImpl.DeleteResultImpl<Object, Object>(false, null, null, -1L, true) : new MapImpl.DeleteResultImpl<Comparable, Object>(true, entry.key, entry.getValue(), entry.vcc, true);
                    if (lock == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw DBOpeException.from(e);
                    }
                }
                lock.close();
            }
            return deleteResultImpl;
        }

        @Override
        public int size() {
            return this.repo.size();
        }

        @Override
        public void forEach(BiConsumer<K, Object> action) {
            this.repo.forEach((? super K k, ? super V entry) -> action.accept(k, ((Entry)entry).value));
        }

        @Override
        public void get(GetSubscriber<K> getSubscriber) {
            this.onGet(getSubscriber);
        }

        void onGet(final GetSubscriber<K> getSubscriber) {
            Stream.from(this.repo.entrySet().iterator()).subscribe(new Subscriber<Map.Entry<K, Entry>>(){

                @Override
                public void onSubscribe(Subscription subscription) {
                    getSubscriber.onSubscribe(subscription);
                }

                @Override
                public void onNext(Map.Entry<K, Entry> record) {
                    MapImpl.GetResultImpl<Comparable, Object> getResult = new MapImpl.GetResultImpl<Comparable, Object>(true, (Comparable)record.getKey(), record.getValue().value, record.getValue().vcc);
                    getSubscriber.onNext(getResult);
                }
            });
        }

        @Override
        public <V> PutResult<K, V> ttlAndGet(K key, Upset<K, V, V> func, TTL ttl) {
            MapImpl.PutResultImpl putResultImpl;
            block9: {
                Objects.requireNonNull(key);
                KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);
                try {
                    Entry entry = this.repo.get(key);
                    MapImpl.GetResultImpl<K, Object> vGetResult = entry == null ? new MapImpl.GetResultImpl<K, Object>(false, key, null, -1L) : new MapImpl.GetResultImpl<Comparable, Object>(true, entry.key, entry.getValue(), entry.vcc);
                    V object = func.apply(vGetResult);
                    entry = new Entry();
                    entry.key = key;
                    entry.value = object;
                    entry.vcc = ShardImpl.tx.incrementAndGet();
                    long time = ttl.time();
                    if (time > 0L) {
                        entry.startMillis = System.currentTimeMillis();
                        entry.expiredMillis = ttl.timeUnit().toMillis(time);
                        entry.expiredVcc = ShardImpl.globalExpiredVcc.incrementAndGet();
                        this.ttl(entry);
                    }
                    this.repo.put(key, entry);
                    putResultImpl = new MapImpl.PutResultImpl(vGetResult.exists, !vGetResult.exists, vGetResult.key, vGetResult.value, entry.value, entry.vcc);
                    if (lock == null) break block9;
                }
                catch (Throwable throwable) {
                    try {
                        if (lock != null) {
                            try {
                                lock.close();
                            }
                            catch (Throwable throwable2) {
                                throwable.addSuppressed(throwable2);
                            }
                        }
                        throw throwable;
                    }
                    catch (IOException e) {
                        throw DBOpeException.from(e);
                    }
                }
                lock.close();
            }
            return putResultImpl;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        @Override
        public <V> GetResult<K, V> ttlAndGet(K key, long time, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock((Comparable<?>)key);){
                MapImpl.GetResultImpl<K, Object> vGetResult;
                Entry entry = this.repo.get(key);
                MapImpl.GetResultImpl<Object, Object> getResultImpl = vGetResult = entry == null ? new MapImpl.GetResultImpl<K, Object>(false, key, null, -1L) : new MapImpl.GetResultImpl<Comparable, Object>(true, entry.key, entry.getValue(), entry.vcc);
                if (!vGetResult.exists()) {
                    MapImpl.GetResultImpl<K, Object> getResultImpl2 = vGetResult;
                    return getResultImpl2;
                }
                PutResult<K, Object> putResult = this.ttlAndGet(key, GetResult::value, time, timeUnit);
                MapImpl.GetResultImpl<K, Object> getResultImpl2 = new MapImpl.GetResultImpl<K, Object>(true, key, putResult.value(), putResult.vcc());
                return getResultImpl2;
            }
            catch (IOException e) {
                throw DBOpeException.from(e);
            }
        }

        @Override
        public TtlFunc<K> subscribeTtl(Predicate<K> predicate, TtlListener<K> ttlListener) {
            return this;
        }

        @Override
        public void shutdown() {
        }

        private class Entry {
            private K key;
            private Object value;
            private long startMillis;
            private long expiredMillis;
            private volatile long vcc;
            private volatile long expiredVcc;

            public K getKey() {
                return this.key;
            }

            public Object getValue() {
                return this.value;
            }

            public long getStartMillis() {
                return this.startMillis;
            }

            public long getExpiredMillis() {
                return this.expiredMillis;
            }

            public long getVcc() {
                return this.vcc;
            }

            public long getExpiredVcc() {
                return this.expiredVcc;
            }

            public void setKey(K key) {
                this.key = key;
            }

            public void setValue(Object value) {
                this.value = value;
            }

            public void setStartMillis(long startMillis) {
                this.startMillis = startMillis;
            }

            public void setExpiredMillis(long expiredMillis) {
                this.expiredMillis = expiredMillis;
            }

            public void setVcc(long vcc) {
                this.vcc = vcc;
            }

            public void setExpiredVcc(long expiredVcc) {
                this.expiredVcc = expiredVcc;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getStartMillis() != other.getStartMillis()) {
                    return false;
                }
                if (this.getExpiredMillis() != other.getExpiredMillis()) {
                    return false;
                }
                if (this.getVcc() != other.getVcc()) {
                    return false;
                }
                if (this.getExpiredVcc() != other.getExpiredVcc()) {
                    return false;
                }
                Object this$key = this.getKey();
                Object other$key = other.getKey();
                if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                    return false;
                }
                Object this$value = this.getValue();
                Object other$value = other.getValue();
                return !(this$value == null ? other$value != null : !this$value.equals(other$value));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                long $startMillis = this.getStartMillis();
                result = result * 59 + (int)($startMillis >>> 32 ^ $startMillis);
                long $expiredMillis = this.getExpiredMillis();
                result = result * 59 + (int)($expiredMillis >>> 32 ^ $expiredMillis);
                long $vcc = this.getVcc();
                result = result * 59 + (int)($vcc >>> 32 ^ $vcc);
                long $expiredVcc = this.getExpiredVcc();
                result = result * 59 + (int)($expiredVcc >>> 32 ^ $expiredVcc);
                Object $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                Object $value = this.getValue();
                result = result * 59 + ($value == null ? 43 : $value.hashCode());
                return result;
            }

            public String toString() {
                return "KVEngine.ShardImpl.Entry(key=" + this.getKey() + ", value=" + this.getValue() + ", startMillis=" + this.getStartMillis() + ", expiredMillis=" + this.getExpiredMillis() + ", vcc=" + this.getVcc() + ", expiredVcc=" + this.getExpiredVcc() + ")";
            }
        }

        private class TTLEntry
        implements DelayTask {
            private final K key;
            private final long triggerTime;
            private final long expiredVcc;
            final /* synthetic */ ShardImpl this$0;

            /*
             * WARNING - Possible parameter corruption
             * WARNING - void declaration
             */
            public TTLEntry(K expiredVcc, long l2, long l3) {
                void key;
                this.this$0 = (ShardImpl)l;
                this.key = key;
                this.triggerTime = triggerTime;
                this.expiredVcc = (long)expiredVcc;
            }

            @Override
            public long triggerTimeMs() {
                return this.triggerTime;
            }

            public K taskId() {
                return this.key;
            }

            @Override
            public Runnable task() {
                return new Runnable(){

                    @Override
                    public void run() {
                        try {
                            TTLEntry.this.this$0.mapImpl.breakDeadLock.execute(Util.catchRunnable(() -> {
                                boolean removedFlag = false;
                                Entry entry = (Entry)TTLEntry.this.this$0.repo.get(TTLEntry.this.key);
                                if (entry != null && entry.expiredVcc == TTLEntry.this.expiredVcc) {
                                    try (KeyLockLock.KeyLock lock = TTLEntry.this.this$0.keyLockLock.lock((Comparable<?>)entry.getKey());){
                                        entry = (Entry)TTLEntry.this.this$0.repo.get(TTLEntry.this.key);
                                        if (entry != null && entry.expiredVcc == TTLEntry.this.expiredVcc) {
                                            TTLEntry.this.this$0.repo.remove(TTLEntry.this.key);
                                            removedFlag = true;
                                        }
                                    }
                                    catch (Exception e) {
                                        throw Util.convert2RuntimeException(e);
                                    }
                                }
                                if (removedFlag && !TTLEntry.this.this$0.mapImpl.ttlCallBackMap.isEmpty()) {
                                    for (Map.Entry ttlCallBackEntry : TTLEntry.this.this$0.mapImpl.ttlCallBackMap.entrySet()) {
                                        Predicate predicate = (Predicate)ttlCallBackEntry.getKey();
                                        try {
                                            if (!predicate.test(entry.key)) continue;
                                            ((TtlListener)ttlCallBackEntry.getValue()).onTtl(new MapImpl.GetResultImpl<Comparable, Object>(true, entry.key, entry.value, entry.vcc), entry.startMillis, entry.expiredMillis);
                                        }
                                        catch (Exception e) {
                                            Util.log.error(e.getMessage(), (Throwable)e);
                                        }
                                    }
                                }
                            }));
                        }
                        catch (RejectedExecutionException e) {
                            Util.log.warn("ttl reject task id: " + TTLEntry.this.taskId() + ", trigger time: " + Util.formatTime(Util.dateTime(TTLEntry.this.triggerTime), new String[0]) + ", vcc: " + TTLEntry.this.expiredVcc);
                        }
                    }
                };
            }
        }
    }

    public static interface TtlListener<K extends Comparable<?>> {
        public void onTtl(GetResult<K, ?> var1, long var2, long var4);
    }

    public static interface DeleteResult<K extends Comparable<?>, V> {
        public boolean exists();

        public boolean deleted();

        public K key();

        public V value();

        public long vcc();
    }

    public static interface GetResult<K extends Comparable<?>, V> {
        public boolean exists();

        public K key();

        public V value();

        public long vcc();
    }

    public static interface PutResult<K extends Comparable<?>, V> {
        public boolean updated();

        public boolean created();

        public K key();

        public V preValue();

        public V value();

        public long vcc();
    }

    public static interface TTL {
        public long time();

        public TimeUnit timeUnit();

        public static TTL fromMillis(long millis) {
            return TTL.from(millis, TimeUnit.MILLISECONDS);
        }

        public static TTL fromSecond(long second) {
            return TTL.from(second, TimeUnit.SECONDS);
        }

        public static TTL fromMinute(long minute) {
            return TTL.from(minute, TimeUnit.SECONDS);
        }

        public static TTL from(long time, TimeUnit timeUnit) {
            return new MapImpl.TTLImpl(time, timeUnit);
        }
    }

    public static interface Upset<K extends Comparable<?>, V, R> {
        public R apply(GetResult<K, V> var1);
    }

    public static abstract class GetSubscriber<K extends Comparable<?>>
    extends CoreSubscriber<GetResult<K, ?>> {
    }

    public static interface TtlFunc<K extends Comparable<?>>
    extends KeyLockFunc<K> {
        public <V> PutResult<K, V> putIfAbsentAndGet(K var1, Function<K, V> var2, TTL var3);

        default public <V> PutResult<K, V> putIfAbsentAndGet(K key, Function<K, V> func, long time, TimeUnit timeUnit) {
            return this.putIfAbsentAndGet(key, func, TTL.from(time, timeUnit));
        }

        public <V> PutResult<K, V> putAndGet(K var1, Upset<K, V, V> var2, TTL var3);

        default public <V> PutResult<K, V> putAndGet(K key, Upset<K, V, V> func, long time, TimeUnit timeUnit) {
            return this.putAndGet(key, func, TTL.from(time, timeUnit));
        }

        default public <V> V putAndGet(K key, final Function<V, V> func, long time, TimeUnit timeUnit) {
            return this.putAndGet(key, new Upset<K, V, V>(){

                @Override
                public V apply(GetResult<K, V> getResult) {
                    return func.apply(getResult.value());
                }
            }, time, timeUnit).value();
        }

        public <V> PutResult<K, V> ttlAndGet(K var1, Upset<K, V, V> var2, TTL var3);

        default public <V> PutResult<K, V> ttlAndGet(K key, Upset<K, V, V> func, long time, TimeUnit timeUnit) {
            return this.ttlAndGet(key, func, TTL.from(time, timeUnit));
        }

        public <V> GetResult<K, V> ttlAndGet(K var1, long var2, TimeUnit var4);

        public TtlFunc<K> subscribeTtl(Predicate<K> var1, TtlListener<K> var2);

        default public <V> V ttlAndGet(K key, long time, TimeUnit timeUnit, final Function<V, V> func) {
            return this.ttlAndGet(key, new Upset<K, V, V>(){

                @Override
                public V apply(GetResult<K, V> getResult) {
                    return func.apply(getResult.value());
                }
            }, time, timeUnit).value();
        }

        public void shutdown();
    }

    public static interface KeyLockFunc<K extends Comparable<?>> {
        public <V> GetResult<K, V> get(K var1);

        public boolean contains(K var1);

        public <V> PutResult<K, V> putIfAbsentAndGet(K var1, Function<K, V> var2);

        public <V> PutResult<K, V> putAndGet(K var1, Upset<K, V, V> var2);

        public <V> DeleteResult<K, V> delete(K var1);

        public int size();

        public void forEach(BiConsumer<K, Object> var1);

        default public <V> V putAndGet(K key, final Function<V, V> func) {
            return this.putAndGet(key, new Upset<K, V, V>(){

                @Override
                public V apply(GetResult<K, V> getResult) {
                    return func.apply(getResult.value());
                }
            }).value();
        }

        public void get(GetSubscriber<K> var1);
    }
}

