/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared;

import java.util.Collections;
import java.util.List;

public class PageModel<T> {
    private long pageNumber;
    private int pageSize;
    private long total;
    private List<T> data = Collections.emptyList();

    public static <T> PageModel<T> empty(long pageNumber, int pageSize, long total) {
        PageModel<T> pageModel = new PageModel<T>();
        pageModel.setPageNumber(pageNumber);
        pageModel.setPageSize(pageSize);
        pageModel.setTotal(total);
        return pageModel;
    }

    public static <T> PageModel<T> from(long pageNumber, int pageSize, long total, List<T> data) {
        PageModel<T> pageModel = new PageModel<T>();
        pageModel.setPageNumber(pageNumber);
        pageModel.setPageSize(pageSize);
        pageModel.setTotal(total);
        pageModel.setData(data);
        return pageModel;
    }

    public long getPageNumber() {
        return this.pageNumber;
    }

    public int getPageSize() {
        return this.pageSize;
    }

    public long getTotal() {
        return this.total;
    }

    public List<T> getData() {
        return this.data;
    }

    public void setPageNumber(long pageNumber) {
        this.pageNumber = pageNumber;
    }

    public void setPageSize(int pageSize) {
        this.pageSize = pageSize;
    }

    public void setTotal(long total) {
        this.total = total;
    }

    public void setData(List<T> data) {
        this.data = data;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof PageModel)) {
            return false;
        }
        PageModel other = (PageModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getPageNumber() != other.getPageNumber()) {
            return false;
        }
        if (this.getPageSize() != other.getPageSize()) {
            return false;
        }
        if (this.getTotal() != other.getTotal()) {
            return false;
        }
        List<T> this$data = this.getData();
        List<T> other$data = other.getData();
        return !(this$data == null ? other$data != null : !((Object)this$data).equals(other$data));
    }

    protected boolean canEqual(Object other) {
        return other instanceof PageModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        long $pageNumber = this.getPageNumber();
        result = result * 59 + (int)($pageNumber >>> 32 ^ $pageNumber);
        result = result * 59 + this.getPageSize();
        long $total = this.getTotal();
        result = result * 59 + (int)($total >>> 32 ^ $total);
        List<T> $data = this.getData();
        result = result * 59 + ($data == null ? 43 : ((Object)$data).hashCode());
        return result;
    }

    public String toString() {
        return "PageModel(pageNumber=" + this.getPageNumber() + ", pageSize=" + this.getPageSize() + ", total=" + this.getTotal() + ", data=" + this.getData() + ")";
    }
}

