/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.config;

import com.ovopark.kernel.shared.IVal;
import com.ovopark.kernel.shared.Util;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

public class GroupConfigFile {
    private final Map<String, GroupConfig> map = new ConcurrentHashMap<String, GroupConfig>();
    private final String filePath;
    private static final GroupConfig EMPTY = new GroupConfig();

    public GroupConfigFile(String filePath) {
        this.filePath = filePath;
        try {
            this.load();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void load() throws IOException {
        File dataFile = new File(this.filePath);
        if (!dataFile.exists()) {
            return;
        }
        String tag = null;
        try (BufferedReader fileReader = new BufferedReader(new FileReader(dataFile));){
            String line;
            while ((line = fileReader.readLine()) != null) {
                int p;
                if ((line = line.trim()).startsWith("#")) continue;
                if (line.startsWith("[") && line.endsWith("]")) {
                    tag = line.substring(1, line.length() - 1);
                    continue;
                }
                if (!Util.isNotEmpty(tag) || (p = line.indexOf("=")) == -1) continue;
                String key = line.substring(0, p);
                String value = line.substring(p + 1);
                GroupConfig groupConfig = this.map.get(tag);
                if (groupConfig == null) {
                    groupConfig = new GroupConfig();
                    this.map.put(tag, groupConfig);
                }
                groupConfig.put(key, value);
            }
        }
    }

    public IVal group(String tag) {
        GroupConfig groupConfig = this.map.get(tag);
        return groupConfig == null ? EMPTY : groupConfig;
    }

    public GroupConfigFile refresh() {
        GroupConfigFile groupConfigFile = new GroupConfigFile(this.filePath);
        return groupConfigFile;
    }

    private static class GroupConfig
    extends ConcurrentHashMap<String, String>
    implements IVal {
        private GroupConfig() {
        }

        @Override
        public boolean contains(String key) {
            return this.containsKey(key);
        }

        @Override
        public Object getObject(String key, Object object) {
            String v = (String)this.get(key);
            return v == null ? object : v;
        }
    }
}

