/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.module.shared;

import com.ovopark.kernel.shared.Config;
import org.slf4j.MDC;

public class BaseResult<T> {
    public static final String _module_static_ = Config.ConfigPriority.option().getString("shared.jdk8.module", Config.ConfigPriority.option().getString("spring.application.name", "unnamed"));
    public static final String _ver_static_ = "5.5." + Config.ConfigPriority.option().getString("SELF_MODULE_VER", "unknown");
    private Boolean isError;
    private T data;
    private String code;
    private String message;
    private String requestId = MDC.get((String)"requestId");
    private String _module_ = _module_static_;
    private String _ver_ = _ver_static_;

    public BaseResult(Boolean isError, T data, String code, String message) {
        this.isError = isError;
        this.data = data;
        this.code = code;
        this.message = message;
    }

    public static <T> BaseResult<T> success(T data) {
        return new BaseResult<T>(false, data, "0", "SUCCESS");
    }

    public static <T> BaseResult<T> error(T data) {
        return new BaseResult<T>(true, data, "1", "ERROR");
    }

    public static <T> BaseResult<T> error(T data, String message) {
        return new BaseResult<T>(true, data, "1", message);
    }

    public static <T> BaseResult<T> error(T data, String code, String message) {
        return new BaseResult<T>(true, data, code, message);
    }

    public static <T> BaseResult<T> invalidToken() {
        return new BaseResult<Object>(true, null, "9990001", "TOKEN_NOT_EXIST");
    }

    public static <T> BaseResult<T> expiredToken() {
        return new BaseResult<Object>(true, null, "9990002", "TOKEN_EXPIRATION");
    }

    public static <T> BaseResult<T> refreshExpiredToken() {
        return new BaseResult<Object>(true, null, "9990003", "TOKEN_REFRESH_EXPIRATION");
    }

    public static <T> BaseResult<T> paramError() {
        return new BaseResult<Object>(true, null, "20001", "\u8bf7\u6c42\u53c2\u6570\u4f20\u9012\u9519\u8bef");
    }

    public static <T> BaseResult<T> noPrivilege() {
        return new BaseResult<Object>(true, null, "99990001", "NO_PRIVILEGE");
    }

    public BaseResult() {
    }

    public Boolean getIsError() {
        return this.isError;
    }

    public T getData() {
        return this.data;
    }

    public String getCode() {
        return this.code;
    }

    public String getMessage() {
        return this.message;
    }

    public String getRequestId() {
        return this.requestId;
    }

    public String get_module_() {
        return this._module_;
    }

    public String get_ver_() {
        return this._ver_;
    }

    public void setIsError(Boolean isError) {
        this.isError = isError;
    }

    public void setData(T data) {
        this.data = data;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setRequestId(String requestId) {
        this.requestId = requestId;
    }

    public void set_module_(String _module_) {
        this._module_ = _module_;
    }

    public void set_ver_(String _ver_) {
        this._ver_ = _ver_;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BaseResult)) {
            return false;
        }
        BaseResult other = (BaseResult)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Boolean this$isError = this.getIsError();
        Boolean other$isError = other.getIsError();
        if (this$isError == null ? other$isError != null : !((Object)this$isError).equals(other$isError)) {
            return false;
        }
        T this$data = this.getData();
        T other$data = other.getData();
        if (this$data == null ? other$data != null : !this$data.equals(other$data)) {
            return false;
        }
        String this$code = this.getCode();
        String other$code = other.getCode();
        if (this$code == null ? other$code != null : !this$code.equals(other$code)) {
            return false;
        }
        String this$message = this.getMessage();
        String other$message = other.getMessage();
        if (this$message == null ? other$message != null : !this$message.equals(other$message)) {
            return false;
        }
        String this$requestId = this.getRequestId();
        String other$requestId = other.getRequestId();
        if (this$requestId == null ? other$requestId != null : !this$requestId.equals(other$requestId)) {
            return false;
        }
        String this$_module_ = this.get_module_();
        String other$_module_ = other.get_module_();
        if (this$_module_ == null ? other$_module_ != null : !this$_module_.equals(other$_module_)) {
            return false;
        }
        String this$_ver_ = this.get_ver_();
        String other$_ver_ = other.get_ver_();
        return !(this$_ver_ == null ? other$_ver_ != null : !this$_ver_.equals(other$_ver_));
    }

    protected boolean canEqual(Object other) {
        return other instanceof BaseResult;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Boolean $isError = this.getIsError();
        result = result * 59 + ($isError == null ? 43 : ((Object)$isError).hashCode());
        T $data = this.getData();
        result = result * 59 + ($data == null ? 43 : $data.hashCode());
        String $code = this.getCode();
        result = result * 59 + ($code == null ? 43 : $code.hashCode());
        String $message = this.getMessage();
        result = result * 59 + ($message == null ? 43 : $message.hashCode());
        String $requestId = this.getRequestId();
        result = result * 59 + ($requestId == null ? 43 : $requestId.hashCode());
        String $_module_ = this.get_module_();
        result = result * 59 + ($_module_ == null ? 43 : $_module_.hashCode());
        String $_ver_ = this.get_ver_();
        result = result * 59 + ($_ver_ == null ? 43 : $_ver_.hashCode());
        return result;
    }

    public String toString() {
        return "BaseResult(isError=" + this.getIsError() + ", data=" + this.getData() + ", code=" + this.getCode() + ", message=" + this.getMessage() + ", requestId=" + this.getRequestId() + ", _module_=" + this.get_module_() + ", _ver_=" + this.get_ver_() + ")";
    }
}

