/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.concurrent;

import com.ovopark.kernel.shared.DBOpeException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.PriorityQueue;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KeyCountDownLock<T extends Comparable<T>> {
    private static final Logger log = LoggerFactory.getLogger(KeyCountDownLock.class);
    private final Map<T, KeyCountDown> locks = new ConcurrentHashMap<T, KeyCountDown>();

    public KeyCountDown lock(T id, int count) {
        KeyCountDown keyCountDown;
        do {
            if ((keyCountDown = this.locks.get(id)) == null) continue;
            return keyCountDown;
        } while (this.locks.putIfAbsent(id, keyCountDown = new KeyCountDown(this, id, count)) != null);
        return keyCountDown;
    }

    public KeyCountDown get(T id) {
        return this.locks.get(id);
    }

    public void notifyWait(T id) {
        KeyCountDown countDownLatch = this.locks.get(id);
        if (countDownLatch != null) {
            try {
                countDownLatch.notifyWait();
            }
            finally {
                this.locks.remove(id);
            }
        } else {
            log.debug("cannot find id: " + id + ", count: " + this.locks.size());
        }
    }

    public class KeyCountDown {
        private final T id;
        final CountDownLatch countDownLatch;
        final /* synthetic */ KeyCountDownLock this$0;

        /*
         * WARNING - Possible parameter corruption
         */
        public KeyCountDown(T id, int count) {
            this.this$0 = (KeyCountDownLock)this$0;
            this.id = id;
            this.countDownLatch = new CountDownLatch(count);
        }

        public void await(long timeout, TimeUnit unit) throws DBOpeException {
            try {
                if (!this.countDownLatch.await(timeout, unit)) {
                    throw DBOpeException.from(TimeUnit.SECONDS.convert(timeout, unit) + " seconds");
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw DBOpeException.from(e);
            }
            catch (Exception e) {
                throw DBOpeException.from(e);
            }
            finally {
                this.this$0.locks.remove(this.id);
            }
        }

        public boolean awaitIf(long timeout, TimeUnit unit) throws DBOpeException {
            try {
                boolean bl = this.countDownLatch.await(timeout, unit);
                return bl;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                throw DBOpeException.from(e);
            }
            finally {
                this.this$0.locks.remove(this.id);
            }
        }

        private void notifyWait() {
            this.countDownLatch.countDown();
        }

        public T getId() {
            return this.id;
        }
    }

    public static class RepeatedKeyCountDownLock<T extends Comparable<T>> {
        final KeyCountDownLock<String> keyCountDownLocks = new KeyCountDownLock();
        final PriorityQueue<Entry> keyCountDowns;
        final Map<T, Entry> entryMap = new ConcurrentHashMap<T, Entry>();
        final int concurrency;

        public RepeatedKeyCountDownLock(int concurrency) {
            this.keyCountDowns = new PriorityQueue(concurrency);
            this.concurrency = concurrency;
        }

        public synchronized KeyCountDown lock(T id, int count) {
            Entry entry = this.entryMap.get(id);
            if (entry == null) {
                if (this.keyCountDowns.size() == this.concurrency) {
                    throw DBOpeException.from("exceed max concurrency: " + this.concurrency);
                }
                entry = new Entry(this, id);
                this.entryMap.put(id, entry);
            }
            String seq = UUID.randomUUID().toString();
            KeyCountDown countDown = this.keyCountDownLocks.lock(seq, count);
            entry.seqList.add((String)countDown.getId());
            this.keyCountDowns.offer(entry);
            return countDown;
        }

        public synchronized void notifyWait(T id) {
            Entry entry = this.entryMap.get(id);
            if (entry == null) {
                return;
            }
            this.notifyWait0(entry);
        }

        public synchronized void notifyWaitBefore(T id, boolean include) {
            while (true) {
                Entry peeked;
                if ((peeked = this.keyCountDowns.peek()) == null) {
                    return;
                }
                if (peeked.id.compareTo(id) >= 0 && (!include || peeked.id.compareTo(id) != 0)) break;
                this.notifyWait0(peeked);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyWait0(Entry peeked) {
            try {
                for (String seq : peeked.seqList) {
                    this.keyCountDownLocks.notifyWait(seq);
                }
            }
            finally {
                this.entryMap.remove(peeked.id);
                this.keyCountDowns.poll();
            }
        }

        static class Entry
        implements Comparable<Entry> {
            final T id;
            final List<String> seqList = new ArrayList<String>();
            final /* synthetic */ RepeatedKeyCountDownLock this$0;

            public Entry(T id) {
                this.this$0 = this$0;
                this.id = id;
            }

            @Override
            public int compareTo(Entry o) {
                return this.id.compareTo(o.id);
            }

            public T getId() {
                return this.id;
            }

            public List<String> getSeqList() {
                return this.seqList;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof Entry)) {
                    return false;
                }
                Entry other = (Entry)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                Object this$id = this.getId();
                Object other$id = other.getId();
                if (this$id == null ? other$id != null : !this$id.equals(other$id)) {
                    return false;
                }
                List<String> this$seqList = this.getSeqList();
                List<String> other$seqList = other.getSeqList();
                return !(this$seqList == null ? other$seqList != null : !((Object)this$seqList).equals(other$seqList));
            }

            protected boolean canEqual(Object other) {
                return other instanceof Entry;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                Object $id = this.getId();
                result = result * 59 + ($id == null ? 43 : $id.hashCode());
                List<String> $seqList = this.getSeqList();
                result = result * 59 + ($seqList == null ? 43 : ((Object)$seqList).hashCode());
                return result;
            }

            public String toString() {
                return "KeyCountDownLock.RepeatedKeyCountDownLock.Entry(id=" + this.getId() + ", seqList=" + this.getSeqList() + ")";
            }
        }
    }
}

