/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.concurrent;

import com.ovopark.kernel.shared.Util;
import java.io.Closeable;
import java.io.IOException;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.ReentrantLock;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class KeyLockLock {
    private static final Logger log = LoggerFactory.getLogger(KeyLockLock.class);
    private final Map<Comparable<?>, KeyLock> keyLockMap = new ConcurrentHashMap();

    public KeyLock lock(Comparable<?> key) {
        KeyLock keyLock;
        Util.assertTrue(key != null, "key cannot be null");
        while (true) {
            if ((keyLock = this.keyLockMap.get(key)) == null) {
                keyLock = new KeyLock(key);
                keyLock.lock();
                keyLock.ref.incrementAndGet();
                if (this.keyLockMap.putIfAbsent(key, keyLock) != null) continue;
                return keyLock;
            }
            int view = keyLock.ref.get();
            if (view > 0 && keyLock.ref.compareAndSet(view, view + 1)) break;
        }
        keyLock.lock();
        return keyLock;
    }

    public KeyLock lock(Comparable<?> key, long timeout, TimeUnit timeUnit) throws InterruptedException, TimeoutException {
        boolean b;
        KeyLock keyLock;
        Util.assertTrue(key != null, "key cannot be null");
        while (true) {
            if ((keyLock = this.keyLockMap.get(key)) == null) {
                keyLock = new KeyLock(key);
                boolean b2 = keyLock.tryLock(timeout, timeUnit);
                if (!b2) {
                    throw new TimeoutException(key + ", timeout(sec): " + TimeUnit.SECONDS.convert(timeout, timeUnit));
                }
                keyLock.ref.incrementAndGet();
                if (this.keyLockMap.putIfAbsent(key, keyLock) != null) continue;
                return keyLock;
            }
            int view = keyLock.ref.get();
            if (view > 0 && keyLock.ref.compareAndSet(view, view + 1)) break;
        }
        try {
            b = keyLock.tryLock(timeout, timeUnit);
        }
        catch (InterruptedException e) {
            keyLock.ref.decrementAndGet();
            Thread.currentThread().interrupt();
            throw e;
        }
        if (!b) {
            keyLock.ref.decrementAndGet();
            keyLock.printWhenClosed = true;
            Thread lockOwner = keyLock.getOwner();
            throw new TimeoutException(key + ", timeout(sec): " + TimeUnit.SECONDS.convert(timeout, timeUnit) + ", created at : " + Util.formatTime(Util.dateTime(keyLock.start), new String[0]) + "(" + keyLock.createdThread + "), locked by : " + (lockOwner == null ? "" : lockOwner.getName()) + ", locks size: " + this.keyLockMap.size());
        }
        return keyLock;
    }

    public class KeyLock
    extends ReentrantLock
    implements Closeable {
        private final Comparable<?> key;
        private final AtomicInteger ref = new AtomicInteger(0);
        private final long start;
        private final String createdThread;
        private transient boolean printWhenClosed;

        public KeyLock(Comparable<?> key) {
            this.key = key;
            this.start = System.currentTimeMillis();
            this.createdThread = Thread.currentThread().getName() + "@" + Thread.currentThread().hashCode();
        }

        @Override
        public void close() throws IOException {
            boolean f;
            Thread owner = this.getOwner();
            this.unlock();
            boolean bl = f = this.ref.decrementAndGet() == 0;
            if (f) {
                KeyLockLock.this.keyLockMap.remove(this.key);
            }
            if (f && this.printWhenClosed) {
                log.warn(this.key + ", created at : " + Util.formatTime(Util.dateTime(this.start), new String[0]) + "(" + this.createdThread + ")(hold by " + owner.getName() + ") released by " + Thread.currentThread().getName());
            }
        }

        @Override
        protected Thread getOwner() {
            return super.getOwner();
        }
    }
}

