/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared.kv;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.IVal;
import com.ovopark.kernel.shared.Util;
import com.ovopark.kernel.shared.kv.CacheService;
import java.io.BufferedReader;
import java.io.Closeable;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.nio.channels.FileChannel;
import java.nio.channels.FileLock;
import java.nio.file.Paths;
import java.nio.file.StandardOpenOption;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class PlainKV
implements IVal,
CacheService<String, Object>,
Closeable {
    private static final Logger log = LoggerFactory.getLogger(PlainKV.class);
    private final CacheService<String, Object> cacheService = CacheService.map();
    private final String filePath;
    public static final String WRITE_LOCK = "write.lock";
    private final ScheduledExecutorService scheduledExecutorService = Executors.newScheduledThreadPool(1);
    private final AtomicLong putCount = new AtomicLong();
    private FileLock writeLockFileLock;
    private FileChannel writeLockFileChannel;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PlainKV(String filePath) {
        if (!filePath.endsWith("/")) {
            throw new IllegalArgumentException("file path must be a directory/end with slash : " + filePath);
        }
        this.filePath = filePath;
        Class<PlainKV> clazz = PlainKV.class;
        synchronized (PlainKV.class) {
            File dataFile = new File(filePath);
            if (!dataFile.exists() && !dataFile.mkdirs()) {
                throw new IllegalArgumentException("data directory is missing: " + filePath);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            try {
                this.ensureWriteLock();
            }
            catch (Exception e) {
                log.error(e.getMessage(), (Throwable)e);
                throw Util.convert2RuntimeException(e);
            }
            try {
                this.load();
                this.scheduled();
            }
            catch (Throwable t) {
                try {
                    this.close();
                }
                finally {
                    throw Util.convert2RuntimeException(t);
                }
            }
            return;
        }
    }

    private void ensureWriteLock() throws Exception {
        block5: {
            FileLock lock = null;
            try {
                FileChannel channel = FileChannel.open(Paths.get(this.filePath + "/" + WRITE_LOCK, new String[0]), StandardOpenOption.CREATE, StandardOpenOption.WRITE);
                lock = channel.tryLock();
                if (lock != null) {
                    log.info("got lock: " + this.filePath + "/" + WRITE_LOCK);
                    this.writeLockFileLock = lock;
                    this.writeLockFileChannel = channel;
                    break block5;
                }
                log.error("Lock held by another program: " + this.filePath + "/" + WRITE_LOCK);
                throw DBOpeException.from("Lock held by another program: " + this.filePath + "/" + WRITE_LOCK);
            }
            finally {
                if (lock == null) {
                    throw DBOpeException.from("cannot obtain lock , cannot create KV, path: " + this.filePath);
                }
            }
        }
    }

    @Override
    public void close() throws IOException {
        this.writeLockFileLock.close();
        this.writeLockFileChannel.close();
    }

    public static PlainKV from(String filePath) {
        PlainKV plainKV = new PlainKV(filePath);
        return plainKV;
    }

    private String dataFilePath() {
        return this.filePath + "kv.data";
    }

    private void load() throws IOException {
        File dataFile = new File(this.dataFilePath());
        if (!dataFile.exists()) {
            return;
        }
        try (BufferedReader fileReader = new BufferedReader(new FileReader(dataFile));){
            String line;
            while ((line = fileReader.readLine()) != null) {
                int p = line.indexOf("=");
                if (p == -1) continue;
                String key = line.substring(0, p);
                String value = line.substring(p + 1);
                this.cacheService.expire(key, value);
            }
        }
    }

    private void scheduled() {
        this.scheduledExecutorService.scheduleWithFixedDelay(this::fsyncTask, 0L, 1L, TimeUnit.SECONDS);
    }

    private void fsyncTask() {
        long l = this.putCount.get();
        if (l > 0L) {
            KVFsyncImpl kvFsync = new KVFsyncImpl();
            try {
                kvFsync.fsync();
            }
            catch (Throwable e) {
                log.error(e.getMessage(), e);
            }
            this.putCount.getAndAdd(-l);
        }
    }

    @Override
    public Object expire(String key, Object object, long time, TimeUnit timeUnit) {
        this.putCount.incrementAndGet();
        return this.cacheService.expire(key, object, time, timeUnit);
    }

    @Override
    public Object expire(String key, Object object) {
        this.putCount.incrementAndGet();
        return this.cacheService.expire(key, object);
    }

    @Override
    public Object get(String key) {
        return this.cacheService.get(key);
    }

    @Override
    public Object remove(String key) {
        this.putCount.incrementAndGet();
        return this.cacheService.remove(key);
    }

    @Override
    public boolean contains(String key) {
        return this.cacheService.contains(key);
    }

    @Override
    public Object getObject(String key, Object object) {
        Object o = this.cacheService.get(key);
        return o == null ? object : o;
    }

    @Override
    public void forEach(BiConsumer<? super String, ? super Object> action) {
        this.cacheService.forEach(action);
    }

    @Override
    public boolean expire(String key, long time, TimeUnit timeUnit) {
        this.putCount.incrementAndGet();
        return this.cacheService.expire(key, time, timeUnit);
    }

    @Override
    public void shutdown() throws Exception {
    }

    private class KVFsyncImpl
    implements KVFsync {
        private KVFsyncImpl() {
        }

        @Override
        public void fsync() throws IOException {
            final StringBuffer stringBuffer = new StringBuffer();
            PlainKV.this.cacheService.forEach(new BiConsumer<String, Object>(){

                @Override
                public void accept(String s, Object o) {
                    stringBuffer.append(s + "=" + o + "\n");
                }
            });
            Util.writeAtomic(new File(PlainKV.this.dataFilePath()), Util.utf8(stringBuffer.toString()));
        }
    }

    static interface KVFsync {
        public void fsync() throws IOException;
    }
}

