/*
 * Decompiled with CFR 0.152.
 */
package com.ovopark.kernel.shared;

import com.ovopark.kernel.shared.DBOpeException;
import com.ovopark.kernel.shared.Model;
import com.ovopark.kernel.shared.OnlyPrivate;
import com.ovopark.kernel.shared.concurrent.KeyLockLock;
import com.ovopark.kernel.shared.kv.TtlCacheServiceV2;
import com.ovopark.kernel.shared.stream.CoreSubscriber;
import com.ovopark.kernel.shared.stream.Stream;
import com.ovopark.kernel.shared.stream.Subscriber;
import java.io.BufferedReader;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.StringReader;
import java.io.StringWriter;
import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.math.BigDecimal;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.nio.file.Files;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoField;
import java.time.temporal.TemporalAccessor;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Stack;
import java.util.UUID;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.RejectedExecutionHandler;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.zip.Deflater;
import java.util.zip.Inflater;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public interface Util {
    public static final Logger log = LoggerFactory.getLogger(Util.class);
    public static final ZoneOffset GMT_08 = ZoneOffset.of("+08:00");
    public static final String HH_MM_SS = "HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS][.SS]";
    public static final String YYYY_MM_DD_HH_MM_SS = "yyyy-MM-dd HH:mm:ss";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS = "yyyy-MM-dd HH:mm:ss[.SSSSSSSSS][.SSSSSS][.SSS][.SS]";
    public static final String YYYY_MM_DD_HH_MM_SS_SSS_1 = "yyyy-MM-dd HH:mm:ss[,SSSSSSSSS][,SSSSSS][,SSS][,SS]";
    public static final String YYYY_MM_DD = "yyyy-MM-dd";
    public static final String yyyyMMddHHmmss = "yyyyMMddHHmmss";
    public static final int MILLI = 1;
    public static final int SEC = 1000;
    public static final int MINUTE = 60000;
    public static final int HOUR = 3600000;
    public static final Map<Class<?>, Clazz> C = new ConcurrentHashMap();

    public static int compare2(Comparable a, Comparable b) {
        if (a != null && b == null) {
            return 1;
        }
        if (a == null && b != null) {
            return -1;
        }
        if (a == null && b == null) {
            return 0;
        }
        return a.compareTo(b);
    }

    public static int asc(Object a, Object b) {
        return -1;
    }

    public static int desc(Object a, Object b) {
        return 1;
    }

    public static String formatTime(Date localDateTime, String ... format) {
        return Util.formatTime(Util.dateTime(localDateTime), format);
    }

    public static LocalDateTime nowPlus(int field, int time) {
        Calendar calendar = Calendar.getInstance();
        calendar.add(field, time);
        long timeInMillis = calendar.getTimeInMillis();
        LocalDateTime localDateTime = LocalDateTime.ofInstant(Instant.ofEpochMilli(timeInMillis), GMT_08);
        return localDateTime;
    }

    public static String formatTime(LocalDateTime localDateTime, String ... format) {
        if (format.length > 0) {
            for (String f : format) {
                try {
                    return localDateTime.format(DateTimeFormatter.ofPattern(f));
                }
                catch (Exception exception) {
                }
            }
            throw new RuntimeException("date time format error:");
        }
        return localDateTime.format(DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS));
    }

    public static LocalDateTime dateTime(String localDateTime, String ... format) {
        if (format.length > 0) {
            Exception out = null;
            for (String f : format) {
                try {
                    TemporalAccessor temporalAccessor = DateTimeFormatter.ofPattern(f).parse(localDateTime);
                    if (temporalAccessor.isSupported(ChronoField.HOUR_OF_DAY)) {
                        return LocalDateTime.from(temporalAccessor);
                    }
                    return LocalDate.from(temporalAccessor).atTime(LocalTime.MIDNIGHT);
                }
                catch (Exception e) {
                    out = e;
                }
            }
            throw new RuntimeException(out);
        }
        return LocalDateTime.from(DateTimeFormatter.ofPattern(YYYY_MM_DD_HH_MM_SS).parse(localDateTime));
    }

    public static LocalDateTime zeroTime() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(0L), GMT_08);
    }

    public static LocalDate zeroDate() {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(0L), GMT_08).toLocalDate();
    }

    public static LocalDateTime dateTime(long time) {
        return LocalDateTime.ofInstant(Instant.ofEpochMilli(time), GMT_08);
    }

    public static LocalDate date(long time) {
        LocalDateTime localDateTime = Util.dateTime(time);
        return localDateTime.toLocalDate();
    }

    public static String formatTime(LocalDate localDate, String ... format) {
        if (format.length > 0) {
            for (String f : format) {
                try {
                    return localDate.format(DateTimeFormatter.ofPattern(f));
                }
                catch (Exception exception) {
                }
            }
            throw new RuntimeException("date format error:");
        }
        return localDate.format(DateTimeFormatter.ofPattern(YYYY_MM_DD));
    }

    public static LocalDate date(String localDate, String ... format) {
        if (format.length > 0) {
            for (String f : format) {
                try {
                    return LocalDate.from(DateTimeFormatter.ofPattern(f).parse(localDate));
                }
                catch (Exception exception) {
                }
            }
            throw new RuntimeException("date time format error:");
        }
        return LocalDate.from(DateTimeFormatter.ofPattern(YYYY_MM_DD).parse(localDate));
    }

    public static LocalDateTime dateTime(Date date) {
        if (date == null) {
            return null;
        }
        return Util.dateTime(date.getTime());
    }

    public static LocalDateTime dateTime(LocalDate date, String time) {
        if (date == null) {
            return null;
        }
        return date.atTime(LocalTime.parse(time));
    }

    public static LocalDate date(Date date) {
        if (date == null) {
            return null;
        }
        return Util.date(date.getTime());
    }

    public static Date date(LocalDate date, ZoneId zoneId) {
        if (date == null) {
            return null;
        }
        return Date.from(LocalDateTime.of(date, LocalTime.MIDNIGHT).atZone(zoneId == null ? GMT_08 : zoneId).toInstant());
    }

    public static Date date(LocalDateTime dateTime, ZoneId zoneId, ZoneId target) {
        return Date.from(LocalDateTime.ofInstant(dateTime.atZone(zoneId).toInstant(), target).atZone(ZoneId.systemDefault()).toInstant());
    }

    public static Date date(LocalDate date) {
        return Util.date(date, GMT_08);
    }

    public static Date date(LocalDateTime dateTime) {
        if (dateTime == null) {
            return null;
        }
        return Date.from(dateTime.toInstant(GMT_08));
    }

    public static String formatTime(int timeMilli) {
        int rest = timeMilli;
        int hourPart = rest / 3600000;
        int minutePart = (rest -= hourPart * 3600000) / 60000;
        int secPart = (rest -= minutePart * 60000) / 1000;
        return Util.leftPad(hourPart, 2) + ":" + Util.leftPad(minutePart, 2) + ":" + Util.leftPad(secPart, 2) + "." + Util.leftPad(rest -= secPart * 1000, 3);
    }

    public static String formatTime(int timeMilli, int numPad, String hourUnit, String minuteUnit, String secondUnit) {
        int rest = timeMilli;
        int hourPart = rest / 3600000;
        int minutePart = (rest -= hourPart * 3600000) / 60000;
        int secPart = (rest -= minutePart * 60000) / 1000;
        rest -= secPart * 1000;
        return Util.leftPad(hourPart, numPad) + hourUnit + Util.leftPad(minutePart, numPad) + minuteUnit + Util.leftPad(secPart, numPad) + secondUnit;
    }

    public static String costTime(long startTime) {
        return Util.formatTime((int)(System.currentTimeMillis() - startTime));
    }

    public static boolean isBefore(LocalDateTime a, LocalDateTime b) {
        if (a == null && b == null) {
            return false;
        }
        if (a == null) {
            return true;
        }
        if (b == null) {
            return false;
        }
        return a.compareTo(b) < 0;
    }

    public static boolean diff(Comparable a, Comparable b) {
        if (a == null && b == null) {
            return false;
        }
        if (a != null && b != null) {
            return a.compareTo(b) != 0;
        }
        return true;
    }

    public static byte[] utf8(String string) {
        return string.getBytes(Charset.forName("utf-8"));
    }

    public static String utf8(byte[] data) {
        return new String(data, Charset.forName("utf-8"));
    }

    public static String utf8(byte[] data, int off, int len) {
        return new String(data, off, len, Charset.forName("utf-8"));
    }

    public static boolean isNotEmpty(CharSequence cs) {
        return !Util.isEmpty(cs);
    }

    public static boolean isEmpty(CharSequence cs) {
        return cs == null || cs.length() == 0;
    }

    public static Byte convert2Byte(String val, Byte defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Byte.valueOf(val);
    }

    public static Byte convert2Byte(Integer val, Byte defVal) {
        if (val == null) {
            return defVal;
        }
        return val.byteValue();
    }

    public static Short convert2Short(String val, Short defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Short.valueOf(val);
    }

    public static Short convert2Short(Integer val, Short defVal) {
        if (val == null) {
            return defVal;
        }
        return val.shortValue();
    }

    public static Integer convert2Int(String val, Integer defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Integer.valueOf(val);
    }

    public static Integer convert2Int(Long val, Integer defVal) {
        if (val == null) {
            return defVal;
        }
        return val.intValue();
    }

    public static Long convert2Long(String val, Long defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Long.valueOf(val);
    }

    public static Boolean convert2Boolean(String val, Boolean defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Boolean.valueOf(val);
    }

    public static <T> T convert2Self(T val, T defVal) {
        if (val == null) {
            return defVal;
        }
        return val;
    }

    public static Long convert2Long(Integer val, Long defVal) {
        if (val == null) {
            return defVal;
        }
        return val.longValue();
    }

    public static Float convert2Float(String val, Float defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Float.valueOf(val);
    }

    public static Float convert2Float(Integer val, Float defVal) {
        if (val == null) {
            return defVal;
        }
        return Float.valueOf(val.floatValue());
    }

    public static Float convert2Float(Double val, Float defVal) {
        if (val == null) {
            return defVal;
        }
        return Float.valueOf(val.floatValue());
    }

    public static Float convert2Float(Long val, Float defVal) {
        if (val == null) {
            return defVal;
        }
        return Float.valueOf(val.floatValue());
    }

    public static Double convert2Double(String val, Double defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Double.valueOf(val);
    }

    public static Double convert2Double(Integer val, Double defVal) {
        if (val == null) {
            return defVal;
        }
        return val.doubleValue();
    }

    public static Double convert2Double(Long val, Double defVal) {
        if (val == null) {
            return defVal;
        }
        return val.doubleValue();
    }

    public static BigDecimal convert2BigDecimal(String val, BigDecimal defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return new BigDecimal(val);
    }

    public static LocalDateTime convert2DateTime(String val, LocalDateTime defVal, String ... format) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Util.dateTime(val, format);
    }

    public static LocalDate convert2Date(String val, LocalDate defVal) {
        if (Util.isEmpty(val)) {
            return defVal;
        }
        return Util.date(val, new String[0]);
    }

    public static String convert2String(Object val, String defVal) {
        if (val == null) {
            return defVal;
        }
        return String.valueOf(val);
    }

    public static String convert2String(Object val) {
        if (val == null) {
            return null;
        }
        return String.valueOf(val);
    }

    public static Exception convert2Exception(Throwable t) {
        if (t instanceof Exception) {
            return (Exception)t;
        }
        return new Exception(t);
    }

    public static RuntimeException convert2RuntimeException(Throwable t) {
        if (t instanceof RuntimeException) {
            return (RuntimeException)t;
        }
        return new RuntimeException(t);
    }

    public static void writeAtomic(File file, byte[] bytes) throws IOException {
        String finalFilePath = file.getPath();
        String pendingFilePath = file.getPath() + ".pending";
        try (FileOutputStream pendingOut = new FileOutputStream(pendingFilePath);){
            pendingOut.getChannel().write(ByteBuffer.wrap(bytes));
            pendingOut.flush();
        }
        Files.move(new File(pendingFilePath).toPath(), new File(finalFilePath).toPath(), StandardCopyOption.REPLACE_EXISTING);
    }

    public static byte[] read(File file) throws IOException {
        try (FileInputStream fileInputStream = new FileInputStream(file);){
            byte[] byArray = Util.getBytes(fileInputStream);
            return byArray;
        }
    }

    public static void readLine(File file, CoreSubscriber<String> subscriber) {
        try (BufferedReader br = new BufferedReader(new FileReader(file));){
            Enclosure.readLine0(br, subscriber);
        }
        catch (Exception e) {
            throw Util.convert2RuntimeException(e);
        }
    }

    public static void readLine(String content, CoreSubscriber<String> subscriber) {
        try (BufferedReader br = new BufferedReader(new StringReader(content));){
            Enclosure.readLine0(br, subscriber);
        }
        catch (Exception e) {
            throw Util.convert2RuntimeException(e);
        }
    }

    public static byte[] getBytes(InputStream input) throws IOException {
        try (ByteArrayOutputStream output = new ByteArrayOutputStream();){
            byte[] buffer = new byte[4096];
            int n = 0;
            while (-1 != (n = input.read(buffer))) {
                output.write(buffer, 0, n);
            }
            output.flush();
            byte[] byArray = output.toByteArray();
            return byArray;
        }
    }

    public static String read(Reader input) throws IOException {
        StringBuilder s = new StringBuilder();
        char[] buffer = new char[4096];
        int n = 0;
        while (-1 != (n = input.read(buffer))) {
            s.append(buffer, 0, n);
        }
        return s.toString();
    }

    public static String leftPad(long value, int length) {
        String finalString = String.valueOf(value);
        while (finalString.length() < length) {
            finalString = "0".concat(finalString);
        }
        return finalString;
    }

    public static Runnable catchRunnable(final CatchRunnable catchRunnable) {
        return new Runnable(){
            final String traceId = MDC.get((String)"traceId");
            final String requestId = MDC.get((String)"requestId");

            @Override
            public void run() {
                MDC.put((String)"traceId", (String)this.traceId);
                MDC.put((String)"requestId", (String)this.requestId);
                try {
                    catchRunnable.run();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                    throw Util.convert2RuntimeException(e);
                }
                finally {
                    MDC.remove((String)"traceId");
                    MDC.remove((String)"requestId");
                }
            }
        };
    }

    public static Runnable ignoreErrorRunnable(final CatchRunnable catchRunnable) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    catchRunnable.run();
                }
                catch (Exception e) {
                    log.error(e.getMessage(), (Throwable)e);
                }
            }
        };
    }

    public static Stream.StreamExecutor noopOnShutdown(final ExecutorService executorService) {
        return new Stream.StreamExecutor(){

            @Override
            public void shutdown() {
                log.info("proxy(ignore shutdown()): " + executorService.toString());
            }

            @Override
            public Future<?> submit(Runnable task) {
                return executorService.submit(task);
            }

            @Override
            public void execute(Runnable command) {
                executorService.execute(command);
            }
        };
    }

    public static Stream.StreamExecutor wrap(final ExecutorService executorService) {
        return new Stream.StreamExecutor(){

            @Override
            public void shutdown() {
                executorService.shutdown();
            }

            @Override
            public Future<?> submit(Runnable task) {
                return executorService.submit(task);
            }

            @Override
            public void execute(Runnable command) {
                executorService.execute(command);
            }
        };
    }

    public static String uniqueFirstPart() {
        return UUID.randomUUID().toString().substring(0, 8);
    }

    public static String md5(String str) {
        return Util.md5(Util.utf8(str));
    }

    public static String md5(byte[] bytes) {
        MessageDigest md;
        try {
            md = MessageDigest.getInstance("MD5");
        }
        catch (NoSuchAlgorithmException e) {
            throw Util.convert2RuntimeException(e);
        }
        byte[] destBytes = md.digest(bytes);
        return Util.toHex(destBytes);
    }

    public static String toHex(byte[] bytes) {
        char[] HEX_DIGITS = "0123456789ABCDEF".toCharArray();
        StringBuilder ret = new StringBuilder(bytes.length * 2);
        for (int i = 0; i < bytes.length; ++i) {
            ret.append(HEX_DIGITS[bytes[i] >> 4 & 0xF]);
            ret.append(HEX_DIGITS[bytes[i] & 0xF]);
        }
        return ret.toString();
    }

    public static void assertTrue(boolean expression, String message) {
        if (!expression) {
            throw new IllegalArgumentException(message);
        }
    }

    public static boolean isNotEmpty(Collection<?> collection) {
        return collection != null && !collection.isEmpty();
    }

    public static boolean isEmpty(Collection<?> collection) {
        return collection == null || collection.isEmpty();
    }

    public static boolean isNotEmpty(Map<?, ?> map) {
        return map != null && !map.isEmpty();
    }

    public static boolean isEmpty(Map<?, ?> map) {
        return map == null || map.isEmpty();
    }

    public static Long comparable2Long(Comparable<?> c) {
        if (c instanceof Long) {
            return (Long)c;
        }
        if (c instanceof Integer) {
            return ((Integer)c).longValue();
        }
        if (c instanceof String) {
            return Long.valueOf((String)((Object)c));
        }
        if (c == null) {
            return null;
        }
        return Long.valueOf(String.valueOf(c));
    }

    public static Integer comparable2Int(Comparable<?> c) {
        if (c instanceof Integer) {
            return (Integer)c;
        }
        if (c instanceof String) {
            return Integer.valueOf((String)((Object)c));
        }
        if (c == null) {
            return null;
        }
        return Integer.valueOf(String.valueOf(c));
    }

    public static String comparable2String(Comparable<?> c) {
        if (c instanceof String) {
            return (String)((Object)c);
        }
        if (c == null) {
            return null;
        }
        return String.valueOf(c);
    }

    public static Boolean comparable2Bool(Comparable<?> c) {
        if (c instanceof Boolean) {
            return (Boolean)c;
        }
        if (c == null) {
            return null;
        }
        return Boolean.valueOf(String.valueOf(c));
    }

    public static void schedule(ScheduledExecutorService scheduled, CatchRunnable r, long delay, TimeUnit unit, Predicate<Throwable> handler, Supplier<Boolean> next) {
        Util.schedule(scheduled, r, () -> delay, unit, handler, next);
    }

    public static void schedule(final ScheduledExecutorService scheduled, final CatchRunnable r, final Supplier<Long> delay, final TimeUnit unit, final Predicate<Throwable> handler, final Supplier<Boolean> next) {
        scheduled.schedule(new Runnable(){

            @Override
            public void run() {
                boolean nextFlag = true;
                try {
                    r.run();
                    boolean bl = nextFlag = nextFlag && (Boolean)next.get() != false;
                }
                catch (Throwable e) {
                    try {
                        nextFlag = nextFlag && handler.test(e);
                        boolean bl = nextFlag = nextFlag && (Boolean)next.get() != false;
                    }
                    catch (Throwable throwable) {
                        boolean bl = nextFlag = nextFlag && (Boolean)next.get() != false;
                        if (nextFlag) {
                            scheduled.schedule(this, (long)((Long)delay.get()), unit);
                        }
                        throw throwable;
                    }
                    if (nextFlag) {
                        scheduled.schedule(this, (long)((Long)delay.get()), unit);
                    }
                }
                if (nextFlag) {
                    scheduled.schedule(this, (long)((Long)delay.get()), unit);
                }
            }
        }, (long)delay.get(), unit);
    }

    public static ThreadFactory newThreadFactory(String name) {
        AtomicInteger index = new AtomicInteger(0);
        return r -> new Thread(r, name + "-" + index.incrementAndGet());
    }

    public static <T> T newInstance(Class<T> clazz) {
        try {
            return clazz.getDeclaredConstructor(new Class[0]).newInstance(new Object[0]);
        }
        catch (IllegalAccessException | InstantiationException | NoSuchMethodException | InvocationTargetException e) {
            throw Util.convert2RuntimeException(e);
        }
    }

    public static boolean validateTreeCycle(List<Serializable> nodeLines, Node<? extends Serializable, ? extends Node.NodeRef<?>, ? extends Node<?, ?, ?>> node) {
        if (node.parent() == null) {
            return true;
        }
        if (nodeLines.contains(node.parent().parentId())) {
            return false;
        }
        nodeLines.add(node.id());
        return Util.validateTreeCycle(nodeLines, node.parent());
    }

    public static <ID extends Serializable, R extends Node.NodeRef<ID>, N extends Node<ID, R, N>> List<N> constructTree(List<R> nodeRefList, Class<N> clazz) {
        Map<Serializable, Node> map = nodeRefList.stream().map(idNodeRef -> {
            Node node = (Node)Util.newInstance(clazz);
            node.nodeRef(idNodeRef);
            node.id((Serializable)idNodeRef.id());
            node.parentId((Serializable)idNodeRef.parent());
            return node;
        }).collect(Collectors.toMap(Node::id, v -> v));
        for (Node node2 : map.values()) {
            Object parentId = node2.parentId();
            if (parentId == null) continue;
            Node ref = map.get(parentId);
            if (ref == null) {
                throw new IllegalArgumentException("invalid data struct: " + parentId);
            }
            ref.children().add(node2);
            node2.parent(ref);
        }
        map.values().forEach(node -> {
            if (!Util.validateTreeCycle(new ArrayList<Serializable>(), node)) {
                throw DBOpeException.from("invalid tree: " + node.id() + ", parent: " + node.parentId());
            }
        });
        List list = map.values().stream().filter(node -> node.parent() == null).collect(Collectors.toList());
        for (Node n : list) {
            n.walk(new Consumer<N>(){

                @Override
                public void accept(N n) {
                    if (n.parentId() == null) {
                        n.level(0);
                    } else {
                        n.level(n.parent().level() + 1);
                    }
                }
            });
        }
        return list;
    }

    public static <T> T lock(Comparable<?> key, Callable<T> callable) {
        return GroupLock.DEFAULT_GROUP_LOCK.lock(key, callable);
    }

    public static <T> T lock(Comparable<?> key, Callable<T> callable, long timeout, TimeUnit timeUnit) {
        return GroupLock.DEFAULT_GROUP_LOCK.lock(key, callable, timeout, timeUnit);
    }

    public static GroupLock groupLock(String group) {
        if (Util.isEmpty(group)) {
            throw DBOpeException.from("empty group: " + group);
        }
        return GroupLock.from(group);
    }

    public static <T> List<List<T>> partition(List<T> list, int partition) {
        int toIndex;
        if (partition <= 0) {
            throw DBOpeException.from("partition is positive?: " + partition);
        }
        ArrayList<List<T>> r = new ArrayList<List<T>>();
        if (Util.isEmpty(list)) {
            return r;
        }
        int i = 0;
        do {
            if ((toIndex = i + partition) >= list.size()) {
                toIndex = list.size();
            }
            r.add(list.subList(i, toIndex));
        } while ((i = toIndex) < list.size());
        return r;
    }

    public static RejectedExecutionHandler awaitThreadActive() {
        return Util.awaitThreadActive(10L);
    }

    public static RejectedExecutionHandler awaitThreadActive(final long awaitTimeMs) {
        final ReentrantLock reentrantLock = new ReentrantLock();
        final Condition condition = reentrantLock.newCondition();
        return new RejectedExecutionHandler(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void rejectedExecution(Runnable r, ThreadPoolExecutor executor) {
                while (!executor.getQueue().offer(r)) {
                    reentrantLock.lock();
                    try {
                        condition.await(awaitTimeMs, TimeUnit.MILLISECONDS);
                    }
                    catch (InterruptedException interruptedException) {}
                    continue;
                    finally {
                        reentrantLock.unlock();
                    }
                }
            }
        };
    }

    public static ExecutorService defaultExecutorService(String name, int maximumPoolSize, int queueSize) {
        return Util.defaultExecutorService(name, maximumPoolSize, queueSize, new ThreadPoolExecutor.CallerRunsPolicy());
    }

    public static ExecutorService defaultExecutorService(String name, int maximumPoolSize, int queueSize, RejectedExecutionHandler handler) {
        return Util.defaultExecutorService(name, Math.min(Runtime.getRuntime().availableProcessors(), maximumPoolSize), maximumPoolSize, queueSize, handler);
    }

    public static ExecutorService defaultExecutorService(String name, int coreSize, int maximumPoolSize, int queueSize, RejectedExecutionHandler handler) {
        return new ThreadPoolExecutor(coreSize, maximumPoolSize, 300L, TimeUnit.SECONDS, new LinkedBlockingQueue<Runnable>(queueSize), Util.newThreadFactory(name), handler);
    }

    public static List<String> flatPropertyName(Class<?> cls) {
        return new ArrayList<String>(ClassCompute.flatProperty0(cls, "", field -> true).keySet());
    }

    public static Map<String, Field> flatProperty(Class<?> cls) {
        return ClassCompute.flatProperty0(cls, "", field -> true);
    }

    public static List<String> flatPropertyName(Class<?> cls, Predicate<Field> predicate) {
        return new ArrayList<String>(ClassCompute.flatProperty0(cls, "", predicate).keySet());
    }

    public static Map<String, Field> flatProperty(Class<?> cls, Predicate<Field> predicate) {
        return ClassCompute.flatProperty0(cls, "", predicate);
    }

    public static TtlCacheServiceV2.StringTtlCacheServiceV2 globalTtl() {
        return TtlCacheServiceV2.staticTtl();
    }

    public static SysStat sysStat() {
        SysStatImpl sysStat = new SysStatImpl();
        try {
            MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
            MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
            sysStat.setHeapCommitted(heapMemoryUsage.getCommitted() / 0x100000L + " MB");
            MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
            sysStat.setNonHeapCommitted(nonHeapMemoryUsage.getCommitted() / 0x100000L + " MB");
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return sysStat;
    }

    public static byte[] compress(byte[] data) {
        return Util.compress(data, 0, data.length);
    }

    public static byte[] compress(byte[] data, int off, int len) {
        byte[] byArray;
        Deflater deflater = new Deflater(9);
        deflater.setInput(data, off, len);
        deflater.finish();
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(len);
        try {
            while (!deflater.finished()) {
                int compressedDataLength = deflater.deflate(buffer);
                outputStream.write(buffer, 0, compressedDataLength);
            }
            deflater.end();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException e) {
                throw Util.convert2RuntimeException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    public static byte[] decompress(byte[] data) {
        return Util.decompress(data, 0, data.length);
    }

    public static byte[] decompress(byte[] data, int off, int len) {
        byte[] byArray;
        Inflater inflater = new Inflater();
        inflater.setInput(data, off, len);
        byte[] buffer = new byte[1024];
        ByteArrayOutputStream outputStream = new ByteArrayOutputStream(len);
        try {
            while (!inflater.finished()) {
                int decompressedDataLength = inflater.inflate(buffer);
                outputStream.write(buffer, 0, decompressedDataLength);
            }
            inflater.end();
            byArray = outputStream.toByteArray();
        }
        catch (Throwable throwable) {
            try {
                try {
                    outputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException(e);
            }
        }
        outputStream.close();
        return byArray;
    }

    public static LogLink logLink(String content) {
        return Util.logLink(content, null);
    }

    public static LogLink logLink(String content, Throwable t) {
        return LogLink.from(content, t);
    }

    public static int shard(String key, int shardSize) {
        int f = key.hashCode();
        return (f == Integer.MIN_VALUE ? 0 : (f < 0 ? -f : f)) % shardSize;
    }

    public static String errorStack(Throwable t) {
        StringWriter sw = new StringWriter();
        PrintWriter pw = new PrintWriter(sw);
        t.printStackTrace(pw);
        return sw.toString();
    }

    public static List<String> errorStackList(Throwable t) {
        String stack = Util.errorStack(t);
        String[] ss = stack.split("\\n");
        ArrayList<String> list = new ArrayList<String>(ss.length);
        Collections.addAll(list, ss);
        return list;
    }

    public static JSONMapAccessor.GetResult jsonGet(Map<String, Object> map, String key) {
        return JSONMapAccessorImpl.JSON_MAP_ACCESSOR.get(map, key, null);
    }

    public static JSONMapAccessor.GetResult jsonGet(Map<String, Object> map, String key, Function<String, JSONMapAccessor.MapPath> pathFunction) {
        return JSONMapAccessorImpl.JSON_MAP_ACCESSOR.get(map, key, pathFunction);
    }

    public static JSONMapAccessor.PutResult jsonPut(Map<String, Object> map, String key, Object data) {
        return JSONMapAccessorImpl.JSON_MAP_ACCESSOR.put(map, key, data, null);
    }

    public static JSONMapAccessor.PutResult jsonPut(Map<String, Object> map, String key, Object data, Function<String, JSONMapAccessor.MapPath> pathFunction) {
        return JSONMapAccessorImpl.JSON_MAP_ACCESSOR.put(map, key, data, pathFunction);
    }

    public static JSONMapAccessor.DeleteResult jsonDelete(Map<String, Object> map, String key) {
        return JSONMapAccessorImpl.JSON_MAP_ACCESSOR.delete(map, key, null);
    }

    public static JSONMapAccessor.DeleteResult jsonDelete(Map<String, Object> map, String key, Function<String, JSONMapAccessor.MapPath> pathFunction) {
        return JSONMapAccessorImpl.JSON_MAP_ACCESSOR.delete(map, key, pathFunction);
    }

    public static Stream<String> lineFrom(InputStream inputStream) {
        final BufferedReader br = new BufferedReader(new InputStreamReader(inputStream));
        return Stream.from(new Iterator<String>(){
            String line = null;

            @Override
            public boolean hasNext() {
                try {
                    this.line = br.readLine();
                }
                catch (IOException e) {
                    throw Util.convert2RuntimeException(e);
                }
                return this.line != null;
            }

            @Override
            public String next() {
                return this.line;
            }
        }).doFinally(new Stream.DoFinally(){

            @Override
            public void runFinally(String type) {
                try {
                    br.close();
                }
                catch (IOException e) {
                    throw Util.convert2RuntimeException(e);
                }
            }
        });
    }

    public static Stream<String> lineFrom(File file) {
        try {
            return Util.lineFrom(new FileInputStream(file));
        }
        catch (FileNotFoundException e) {
            throw Util.convert2RuntimeException(e);
        }
    }

    public static LineOperation lineOperation(String file) {
        return LineOperation.from(file);
    }

    public static LineOperation lineOperation(File file) {
        return LineOperation.from(file);
    }

    public static LineOperation lineOperationFromClassPath(String file) {
        return LineOperation.fromClassPath(file);
    }

    @OnlyPrivate
    public static abstract class Enclosure {
        private Enclosure() {
        }

        private static void readLine0(final BufferedReader br, CoreSubscriber<String> subscriber) {
            try {
                Stream.from(new Iterator<String>(){
                    String line = null;

                    @Override
                    public boolean hasNext() {
                        try {
                            this.line = br.readLine();
                        }
                        catch (IOException e) {
                            throw Util.convert2RuntimeException(e);
                        }
                        return this.line != null;
                    }

                    @Override
                    public String next() {
                        return this.line;
                    }
                }).subscribe(subscriber);
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException(e);
            }
        }
    }

    public static interface CatchRunnable {
        public void run() throws Exception;
    }

    public static interface Node<ID extends Serializable, R extends NodeRef<ID>, E extends Node<ID, R, E>> {
        public ID id();

        public void id(ID var1);

        public ID parentId();

        public void parentId(ID var1);

        public E parent();

        public void parent(E var1);

        public List<E> children();

        public R nodeRef();

        public void nodeRef(R var1);

        public int level();

        public void level(int var1);

        public boolean leaf();

        default public void walk(Consumer<E> consumer) {
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                Node next = (Node)iterator.next();
                consumer.accept(next);
            }
        }

        default public <K extends NodeRef<? extends Serializable>> K map(NodeRefMap<R, K> nodeRefMap) {
            HashMap<ID, NodeRef> tempMap = new HashMap<ID, NodeRef>();
            NodeRef root = null;
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                Node next = (Node)iterator.next();
                R r = next.nodeRef();
                NodeRef parent = (NodeRef)tempMap.get(next.parentId());
                NodeRef applied = nodeRefMap.apply(r, parent);
                if (root == null) {
                    root = applied;
                }
                tempMap.put(next.id(), applied);
            }
            return (K)root;
        }

        default public Iterator<E> fromLeaf() {
            final Stack<Node> stack = new Stack<Node>();
            stack.push(this);
            return new Iterator<E>(){
                private E current;
                private boolean pushStack = false;

                private void add2Stack(E node) {
                    List children = node.children();
                    if (Util.isNotEmpty(children)) {
                        for (int i = children.size() - 1; i >= 0; --i) {
                            stack.push((Node)children.get(i));
                        }
                        this.add2Stack((Node)this.children().get(0));
                    }
                }

                @Override
                public boolean hasNext() {
                    if (!this.pushStack) {
                        this.add2Stack((Node)stack.peek());
                        this.pushStack = true;
                    }
                    if (stack.empty()) {
                        this.current = null;
                        return false;
                    }
                    this.current = (Node)stack.pop();
                    return this.current != null;
                }

                @Override
                public E next() {
                    return this.current;
                }
            };
        }

        default public Iterator<E> iterator() {
            final Stack<Node> stack = new Stack<Node>();
            stack.push(this);
            return new Iterator<E>(){
                private E current;

                @Override
                public boolean hasNext() {
                    if (stack.empty()) {
                        this.current = null;
                        return false;
                    }
                    this.current = (Node)stack.pop();
                    List children = this.current.children();
                    if (children != null && !children.isEmpty()) {
                        for (int i = children.size() - 1; i >= 0; --i) {
                            stack.push((Node)children.get(i));
                        }
                    }
                    return this.current != null;
                }

                @Override
                public E next() {
                    return this.current;
                }
            };
        }

        default public E getFromId(Predicate<ID> test) {
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                Node next = (Node)iterator.next();
                if (!test.test(next.id())) continue;
                return (E)next;
            }
            return null;
        }

        default public E get(Predicate<E> test) {
            Iterator<E> iterator = this.iterator();
            while (iterator.hasNext()) {
                Node next = (Node)iterator.next();
                if (!test.test(next)) continue;
                return (E)next;
            }
            return null;
        }

        public static interface NodeRef<ID> {
            public ID parent();

            public ID id();
        }

        public static interface NodeRefMap<T extends NodeRef<? extends Serializable>, K extends NodeRef<? extends Serializable>> {
            public K apply(T var1, K var2);
        }
    }

    public static class GroupLock {
        static final Map<String, GroupLock> groupLockMap = new ConcurrentHashMap<String, GroupLock>();
        final String group;
        final KeyLockLock keyLockLock = new KeyLockLock();
        static final GroupLock DEFAULT_GROUP_LOCK = GroupLock.from(Util.class.getName());

        public GroupLock(String group) {
            this.group = group;
        }

        static GroupLock from(String group) {
            GroupLock groupLock = new GroupLock(group);
            GroupLock g = groupLockMap.putIfAbsent(group, groupLock);
            return g == null ? groupLock : g;
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <T> T lock(Comparable<?> key, Callable<T> callable) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock(key);){
                T t = callable.call();
                return t;
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException(e);
            }
        }

        /*
         * Enabled aggressive block sorting
         * Enabled unnecessary exception pruning
         * Enabled aggressive exception aggregation
         */
        public <T> T lock(Comparable<?> key, Callable<T> callable, long timeout, TimeUnit timeUnit) {
            Objects.requireNonNull(key);
            try (KeyLockLock.KeyLock lock = this.keyLockLock.lock(key, timeout, timeUnit);){
                T t = callable.call();
                return t;
            }
            catch (Exception e) {
                throw Util.convert2RuntimeException(e);
            }
        }
    }

    public static class ClassCompute {
        static Clazz clazz(final Class<?> cls) {
            return C.computeIfAbsent(cls, new Function<Class<?>, Clazz>(){

                @Override
                public Clazz apply(Class<?> aClass) {
                    Clazz clazz = new Clazz();
                    clazz.setFieldList(Arrays.asList(cls.getDeclaredFields()));
                    return clazz;
                }
            });
        }

        static Map<String, Field> flatProperty0(Class<?> cls, String prefix, Predicate<Field> predicate) {
            Clazz clazz = ClassCompute.clazz(cls);
            LinkedHashMap<String, Field> c = new LinkedHashMap<String, Field>();
            for (Field declaredField : clazz.fieldList) {
                if (declaredField.isSynthetic() || !predicate.test(declaredField)) continue;
                Class<?> type = declaredField.getType();
                String name = declaredField.getName();
                String prefix0 = Util.isNotEmpty(prefix) ? prefix + "." + name : name;
                c.put(prefix0, declaredField);
                if (!Model.class.isAssignableFrom(type)) continue;
                Map<String, Field> fieldMap = ClassCompute.flatProperty0(type, prefix0, predicate);
                c.putAll(fieldMap);
            }
            return c;
        }
    }

    public static class SysStatImpl
    implements SysStat {
        private static int cpu;
        private static String maxHeap;
        private String heapCommitted;
        private static String maxNonHeap;
        private String nonHeapCommitted;

        private SysStatImpl() {
        }

        @Override
        public int cpu() {
            return cpu;
        }

        @Override
        public String maxHeap() {
            return maxHeap;
        }

        @Override
        public String heapCommitted() {
            return this.heapCommitted;
        }

        @Override
        public String maxNonHeap() {
            return maxNonHeap;
        }

        @Override
        public String nonHeapCommitted() {
            return this.nonHeapCommitted;
        }

        public String getHeapCommitted() {
            return this.heapCommitted;
        }

        public String getNonHeapCommitted() {
            return this.nonHeapCommitted;
        }

        public void setHeapCommitted(String heapCommitted) {
            this.heapCommitted = heapCommitted;
        }

        public void setNonHeapCommitted(String nonHeapCommitted) {
            this.nonHeapCommitted = nonHeapCommitted;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof SysStatImpl)) {
                return false;
            }
            SysStatImpl other = (SysStatImpl)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$heapCommitted = this.getHeapCommitted();
            String other$heapCommitted = other.getHeapCommitted();
            if (this$heapCommitted == null ? other$heapCommitted != null : !this$heapCommitted.equals(other$heapCommitted)) {
                return false;
            }
            String this$nonHeapCommitted = this.getNonHeapCommitted();
            String other$nonHeapCommitted = other.getNonHeapCommitted();
            return !(this$nonHeapCommitted == null ? other$nonHeapCommitted != null : !this$nonHeapCommitted.equals(other$nonHeapCommitted));
        }

        protected boolean canEqual(Object other) {
            return other instanceof SysStatImpl;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $heapCommitted = this.getHeapCommitted();
            result = result * 59 + ($heapCommitted == null ? 43 : $heapCommitted.hashCode());
            String $nonHeapCommitted = this.getNonHeapCommitted();
            result = result * 59 + ($nonHeapCommitted == null ? 43 : $nonHeapCommitted.hashCode());
            return result;
        }

        public String toString() {
            return "Util.SysStatImpl(heapCommitted=" + this.getHeapCommitted() + ", nonHeapCommitted=" + this.getNonHeapCommitted() + ")";
        }

        static {
            try {
                cpu = Runtime.getRuntime().availableProcessors();
                MemoryMXBean memoryMXBean = ManagementFactory.getMemoryMXBean();
                MemoryUsage heapMemoryUsage = memoryMXBean.getHeapMemoryUsage();
                maxHeap = heapMemoryUsage.getMax() / 0x100000L + " MB";
                MemoryUsage nonHeapMemoryUsage = memoryMXBean.getNonHeapMemoryUsage();
                long nonHeapMemoryUsageMax = nonHeapMemoryUsage.getMax();
                maxNonHeap = nonHeapMemoryUsageMax == -1L ? "infinite" : nonHeapMemoryUsageMax / 0x100000L + " MB";
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
    }

    public static final class LogLink {
        private final String content;
        private final Throwable t;

        private LogLink(String content, Throwable t) {
            this.content = content;
            this.t = t;
        }

        public static LogLink from(String content, Throwable t) {
            return new LogLink(content, t);
        }

        public LogLink log(Consumer<String> consumer) {
            consumer.accept(this.content);
            return this;
        }

        public LogLink logError(BiConsumer<String, Throwable> consumer) {
            consumer.accept(this.content, this.t);
            return this;
        }
    }

    public static class JSONMapAccessorImpl
    implements JSONMapAccessor {
        static final JSONMapAccessorImpl JSON_MAP_ACCESSOR = new JSONMapAccessorImpl();
        static final Pattern p = Pattern.compile("(\\S+)\\[(\\d)]$");

        @Override
        public JSONMapAccessor.GetResult get(Map<String, Object> map, String key, Function<String, JSONMapAccessor.MapPath> pathFunction) {
            JSONMapAccessor.MapPath mapPath = this.compile2MapPath(key, pathFunction);
            JSONMapAccessor.PathPart[] pathPartList = mapPath.pathPartList;
            return this.getResult0(map, key, pathPartList, 0, pathPartList.length);
        }

        private GetResultImpl getResult0(Map<String, Object> map, String key, JSONMapAccessor.PathPart[] pathPartList, int from, int to) {
            Map<String, Object> pathMap = map;
            Object result = pathMap;
            for (int i = from; i < to; ++i) {
                JSONMapAccessor.PathPart pathPart = pathPartList[i];
                String k = pathPart.key;
                int arrayIndex = pathPart.arrayIndex;
                if (!(result instanceof Map)) {
                    return new GetResultImpl(false, key, null);
                }
                pathMap = result;
                Object temp = pathMap.get(k);
                if (temp == null) {
                    return new GetResultImpl(false, key, null);
                }
                if (arrayIndex == -1) {
                    result = temp;
                    continue;
                }
                if (temp instanceof List) {
                    List list = (List)temp;
                    if (arrayIndex < list.size()) {
                        result = list.get(arrayIndex);
                        continue;
                    }
                    return new GetResultImpl(false, key, null);
                }
                if (!temp.getClass().isArray()) continue;
                int length = Array.getLength(temp);
                if (arrayIndex < length) {
                    result = Array.get(temp, arrayIndex);
                    continue;
                }
                return new GetResultImpl(false, key, null);
            }
            return new GetResultImpl(true, key, result);
        }

        private JSONMapAccessor.MapPath compile2MapPath(String key, Function<String, JSONMapAccessor.MapPath> pathFunction) {
            if (pathFunction == null) {
                return JSONMapAccessor.compile(key);
            }
            return pathFunction.apply(key);
        }

        @Override
        public JSONMapAccessor.PutResult put(Map<String, Object> map, String key, Object data, Function<String, JSONMapAccessor.MapPath> pathFunction) {
            JSONMapAccessor.MapPath mapPath = this.compile2MapPath(key, pathFunction);
            GetResultImpl getResult = this.getResult0(map, key, mapPath.pathPartList, 0, mapPath.pathPartList.length - 1);
            if (!getResult.exists) {
                return new PutResultImpl(key, false, false);
            }
            Object result = getResult.value;
            JSONMapAccessor.PathPart lastPathPart = mapPath.pathPartList[mapPath.pathPartList.length - 1];
            String k = lastPathPart.key;
            int arrayIndex = lastPathPart.arrayIndex;
            if (arrayIndex == -1) {
                if (result instanceof Map) {
                    Map pathMap = (Map)result;
                    boolean f = pathMap.containsKey(k);
                    pathMap.put(k, data);
                    return new PutResultImpl(key, f, !f);
                }
                return new PutResultImpl(key, false, false);
            }
            if (result instanceof List) {
                List list = (List)result;
                boolean f = arrayIndex < list.size() && list.get(arrayIndex) != null;
                list.set(arrayIndex, data);
                return new PutResultImpl(key, f, !f);
            }
            if (result.getClass().isArray()) {
                int length = Array.getLength(result);
                if (arrayIndex < length) {
                    boolean f = Array.get(result, arrayIndex) != null;
                    Array.set(result, arrayIndex, data);
                    return new PutResultImpl(key, f, !f);
                }
                return new PutResultImpl(key, false, false);
            }
            return new PutResultImpl(key, false, false);
        }

        @Override
        public JSONMapAccessor.DeleteResult delete(Map<String, Object> map, String key, Function<String, JSONMapAccessor.MapPath> pathFunction) {
            JSONMapAccessor.MapPath mapPath = this.compile2MapPath(key, pathFunction);
            GetResultImpl getResult = this.getResult0(map, key, mapPath.pathPartList, 0, mapPath.pathPartList.length - 1);
            if (!getResult.exists) {
                return new DeleteResultImpl(false, false, key);
            }
            Object result = getResult.value;
            JSONMapAccessor.PathPart lastPathPart = mapPath.pathPartList[mapPath.pathPartList.length - 1];
            String k = lastPathPart.key;
            int arrayIndex = lastPathPart.arrayIndex;
            if (arrayIndex == -1) {
                if (result instanceof Map) {
                    Map pathMap = (Map)result;
                    Object removed = pathMap.remove(k);
                    return new DeleteResultImpl(removed != null, true, key);
                }
                return new DeleteResultImpl(false, false, key);
            }
            if (result instanceof List) {
                List list = (List)result;
                if (arrayIndex < list.size()) {
                    Object removed = list.remove(arrayIndex);
                    return new DeleteResultImpl(removed != null, true, key);
                }
                return new DeleteResultImpl(false, true, key);
            }
            if (result.getClass().isArray()) {
                int length = Array.getLength(result);
                if (arrayIndex < length) {
                    boolean f;
                    boolean bl = f = Array.get(result, arrayIndex) != null;
                    if (f) {
                        Array.set(result, arrayIndex, null);
                        return new DeleteResultImpl(true, true, key);
                    }
                    return new DeleteResultImpl(false, true, key);
                }
                return new DeleteResultImpl(false, false, key);
            }
            return new DeleteResultImpl(false, false, key);
        }

        static class GetResultImpl
        implements JSONMapAccessor.GetResult {
            final boolean exists;
            final String key;
            final Object value;

            public GetResultImpl(boolean exists, String key, Object value) {
                this.exists = exists;
                this.key = key;
                this.value = value;
            }

            @Override
            public boolean exists() {
                return this.exists;
            }

            @Override
            public String key() {
                return this.key;
            }

            @Override
            public Object value() {
                return this.value;
            }
        }

        static class PutResultImpl
        implements JSONMapAccessor.PutResult {
            final String key;
            final boolean updated;
            final boolean created;

            public PutResultImpl(String key, boolean updated, boolean created) {
                this.key = key;
                this.updated = updated;
                this.created = created;
            }

            @Override
            public boolean updated() {
                return this.updated;
            }

            @Override
            public boolean created() {
                return this.created;
            }

            @Override
            public String key() {
                return this.key;
            }
        }

        static class DeleteResultImpl
        implements JSONMapAccessor.DeleteResult {
            final boolean exists;
            final boolean deleted;
            final String key;

            public DeleteResultImpl(boolean exists, boolean deleted, String key) {
                this.exists = exists;
                this.deleted = deleted;
                this.key = key;
            }

            @Override
            public boolean exists() {
                return this.exists;
            }

            @Override
            public boolean deleted() {
                return this.deleted;
            }

            @Override
            public String key() {
                return this.key;
            }
        }
    }

    public static interface JSONMapAccessor {
        public static MapPath compile(String key) {
            String[] keys = key.split("\\.");
            MapPath mapPath = new MapPath();
            PathPart[] pathPartList = new PathPart[keys.length];
            for (int i = 0; i < keys.length; ++i) {
                PathPart pathPart;
                String k = keys[i];
                Matcher matcher = JSONMapAccessorImpl.p.matcher(k);
                String ky = k;
                int arrayIndex = -1;
                if (matcher.matches()) {
                    ky = matcher.group(1);
                    arrayIndex = Util.convert2Int(matcher.group(2), (Integer)-1);
                }
                pathPartList[i] = pathPart = new PathPart(ky, arrayIndex);
            }
            mapPath.setPathPartList(pathPartList);
            return mapPath;
        }

        public GetResult get(Map<String, Object> var1, String var2, Function<String, MapPath> var3);

        public PutResult put(Map<String, Object> var1, String var2, Object var3, Function<String, MapPath> var4);

        public DeleteResult delete(Map<String, Object> var1, String var2, Function<String, MapPath> var3);

        public static class MapPath {
            PathPart[] pathPartList;

            public PathPart[] getPathPartList() {
                return this.pathPartList;
            }

            public void setPathPartList(PathPart[] pathPartList) {
                this.pathPartList = pathPartList;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof MapPath)) {
                    return false;
                }
                MapPath other = (MapPath)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                return Arrays.deepEquals(this.getPathPartList(), other.getPathPartList());
            }

            protected boolean canEqual(Object other) {
                return other instanceof MapPath;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + Arrays.deepHashCode(this.getPathPartList());
                return result;
            }

            public String toString() {
                return "Util.JSONMapAccessor.MapPath(pathPartList=" + Arrays.deepToString(this.getPathPartList()) + ")";
            }
        }

        public static class PathPart {
            final String key;
            private final int arrayIndex;

            public PathPart(String key, int arrayIndex) {
                this.key = key;
                this.arrayIndex = arrayIndex;
            }

            public String getKey() {
                return this.key;
            }

            public int getArrayIndex() {
                return this.arrayIndex;
            }

            public boolean equals(Object o) {
                if (o == this) {
                    return true;
                }
                if (!(o instanceof PathPart)) {
                    return false;
                }
                PathPart other = (PathPart)o;
                if (!other.canEqual(this)) {
                    return false;
                }
                if (this.getArrayIndex() != other.getArrayIndex()) {
                    return false;
                }
                String this$key = this.getKey();
                String other$key = other.getKey();
                return !(this$key == null ? other$key != null : !this$key.equals(other$key));
            }

            protected boolean canEqual(Object other) {
                return other instanceof PathPart;
            }

            public int hashCode() {
                int PRIME = 59;
                int result = 1;
                result = result * 59 + this.getArrayIndex();
                String $key = this.getKey();
                result = result * 59 + ($key == null ? 43 : $key.hashCode());
                return result;
            }

            public String toString() {
                return "Util.JSONMapAccessor.PathPart(key=" + this.getKey() + ", arrayIndex=" + this.getArrayIndex() + ")";
            }
        }

        public static interface PutResult {
            public boolean updated();

            public boolean created();

            public String key();
        }

        public static interface DeleteResult {
            public boolean exists();

            public boolean deleted();

            public String key();
        }

        public static interface GetResult {
            public boolean exists();

            public String key();

            public Object value();
        }
    }

    public static class LineOperation {
        Stream<String> stream;

        private LineOperation(Stream<String> stream) {
            this.stream = stream;
        }

        private static LineOperation from(InputStream inputStream) {
            return new LineOperation(Util.lineFrom(inputStream));
        }

        private static LineOperation fromClassPath(String file) {
            return new LineOperation(Util.lineFrom(Util.class.getClassLoader().getResourceAsStream(file)));
        }

        private static LineOperation from(String file) {
            return new LineOperation(Util.lineFrom(new File(file)));
        }

        private static LineOperation from(File file) {
            return new LineOperation(Util.lineFrom(file));
        }

        public LineOperation filter(Predicate<String> predicate) {
            this.stream = this.stream.filter(predicate);
            return this;
        }

        public LineOperation includeOnPrefix(String ... prefix) {
            return this.onPrefix(prefix, true);
        }

        private LineOperation onPrefix(String[] prefix, boolean include) {
            return this.filter(t -> {
                for (String p : prefix) {
                    if (!t.startsWith(p)) continue;
                    return include;
                }
                return !include;
            });
        }

        public LineOperation excludeOnPrefix(String ... prefix) {
            return this.onPrefix(prefix, false);
        }

        public LineOperation includeOnRegex(String ... regex) {
            return this.onRegex(regex, true);
        }

        private LineOperation onRegex(String[] regex, boolean include) {
            ArrayList<Pattern> patternList = new ArrayList<Pattern>();
            for (String r : regex) {
                patternList.add(Pattern.compile(r));
            }
            return this.filter(t -> {
                for (Pattern pattern : patternList) {
                    if (!pattern.matcher((CharSequence)t).matches()) continue;
                    return include;
                }
                return !include;
            });
        }

        public LineOperation excludeOnRegex(String ... regex) {
            return this.onRegex(regex, false);
        }

        public LineOperation addPrefixOnLine(String prefix) {
            this.stream = this.stream.map((? super T t) -> prefix + t);
            return this;
        }

        public LineOperation map(Function<String, String> function) {
            this.stream = this.stream.map(function);
            return this;
        }

        public List<String> toList() {
            final ArrayList<String> list = new ArrayList<String>();
            this.stream.subscribe((Subscriber<String>)new CoreSubscriber<String>(){

                @Override
                public void onNext(String record) {
                    list.add(record);
                }
            });
            return list;
        }

        public Map<String, String> toMap(final String split) {
            final LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
            this.stream.subscribe((Subscriber<String>)new CoreSubscriber<String>(){

                @Override
                public void onNext(String record) {
                    int i = record.indexOf(split);
                    if (i == -1) {
                        map.put(record, "");
                    } else {
                        map.put(record.substring(0, i), record.substring(i + split.length()));
                    }
                }
            });
            return map;
        }
    }

    public static interface SysStat {
        public int cpu();

        public String maxHeap();

        public String heapCommitted();

        public String maxNonHeap();

        public String nonHeapCommitted();
    }

    public static enum ByteSizeUnit {
        B{

            @Override
            ByteSizeUnit next() {
                return M;
            }

            @Override
            ByteSizeUnit pre() {
                return null;
            }
        }
        ,
        K{

            @Override
            ByteSizeUnit next() {
                return M;
            }

            @Override
            ByteSizeUnit pre() {
                return B;
            }
        }
        ,
        M{

            @Override
            ByteSizeUnit next() {
                return G;
            }

            @Override
            ByteSizeUnit pre() {
                return K;
            }
        }
        ,
        G{

            @Override
            ByteSizeUnit next() {
                return T;
            }

            @Override
            ByteSizeUnit pre() {
                return M;
            }
        }
        ,
        T{

            @Override
            ByteSizeUnit next() {
                return null;
            }

            @Override
            ByteSizeUnit pre() {
                return G;
            }
        };


        abstract ByteSizeUnit next();

        abstract ByteSizeUnit pre();

        public static String formatScale(long capacity, ByteSizeUnit b, int scale) {
            ByteSizeUnit next = b;
            double v = capacity;
            while (!(v < 1024.0) && next.next() != null) {
                next = next.next();
                v = new BigDecimal(v).divide(new BigDecimal(1024), scale, 4).doubleValue();
            }
            return v + next.name();
        }

        public String format(long capacity, ByteSizeUnit b, int scale, boolean unitAppend) {
            ByteSizeUnit t = this;
            if (t.ordinal() > b.ordinal()) {
                BigDecimal bigDecimal = new BigDecimal(Math.pow(1024.0, t.ordinal() - b.ordinal()));
                BigDecimal decimal = new BigDecimal(capacity).divide(bigDecimal, scale, 4);
                return decimal.stripTrailingZeros().toPlainString() + (unitAppend ? t.name() : "");
            }
            return (double)capacity * Math.pow(1024.0, b.ordinal() - t.ordinal()) + (unitAppend ? t.name() : "");
        }

        public String format(long capacity, ByteSizeUnit b, int scale) {
            return this.format(capacity, b, scale, true);
        }

        public double from(long capacity, ByteSizeUnit b, int scale) {
            ByteSizeUnit t = this;
            if (t.ordinal() > b.ordinal()) {
                BigDecimal bigDecimal = new BigDecimal(Math.pow(1024.0, t.ordinal() - b.ordinal()));
                double v = new BigDecimal(capacity).divide(bigDecimal, scale, 4).doubleValue();
                return v;
            }
            return (double)capacity * Math.pow(1024.0, b.ordinal() - t.ordinal());
        }

        public static String numPartOf(String str) {
            if (Util.isEmpty(str)) {
                return null;
            }
            if (str.length() == 1) {
                return null;
            }
            return str.substring(0, str.length() - 1);
        }
    }

    public static class Clazz {
        private List<Field> fieldList;

        public List<Field> getFieldList() {
            return this.fieldList;
        }

        public void setFieldList(List<Field> fieldList) {
            this.fieldList = fieldList;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Clazz)) {
                return false;
            }
            Clazz other = (Clazz)o;
            if (!other.canEqual(this)) {
                return false;
            }
            List<Field> this$fieldList = this.getFieldList();
            List<Field> other$fieldList = other.getFieldList();
            return !(this$fieldList == null ? other$fieldList != null : !((Object)this$fieldList).equals(other$fieldList));
        }

        protected boolean canEqual(Object other) {
            return other instanceof Clazz;
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            List<Field> $fieldList = this.getFieldList();
            result = result * 59 + ($fieldList == null ? 43 : ((Object)$fieldList).hashCode());
            return result;
        }

        public String toString() {
            return "Util.Clazz(fieldList=" + this.getFieldList() + ")";
        }
    }

    public static abstract class NodeImpl<ID extends Serializable, R extends Node.NodeRef<ID>, E extends Node<ID, R, E>>
    implements Node<ID, R, E> {
        private ID id;
        private ID parentId;
        private E parent;
        private List<E> children = new ArrayList();
        private R nodeRef;
        private int level;

        @Override
        public ID id() {
            return this.id;
        }

        @Override
        public void id(ID id) {
            this.id = id;
        }

        @Override
        public ID parentId() {
            return this.parentId;
        }

        @Override
        public void parentId(ID id) {
            this.parentId = id;
        }

        @Override
        public E parent() {
            return this.parent;
        }

        @Override
        public void parent(E node) {
            this.parent = node;
        }

        @Override
        public List<E> children() {
            return this.children;
        }

        @Override
        public R nodeRef() {
            return this.nodeRef;
        }

        @Override
        public void nodeRef(R nodeRef) {
            this.nodeRef = nodeRef;
        }

        @Override
        public int level() {
            return this.level;
        }

        @Override
        public void level(int level) {
            this.level = level;
        }

        @Override
        public boolean leaf() {
            return Util.isEmpty(this.children);
        }
    }
}

